"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PersistentSessionsManager = void 0;
var faro_core_1 = require("@grafana/faro-core");
var utils_1 = require("../../../utils");
var webStorage_1 = require("../../../utils/webStorage");
var sessionConstants_1 = require("./sessionConstants");
var sessionManagerUtils_1 = require("./sessionManagerUtils");
var PersistentSessionsManager = /** @class */ (function () {
    function PersistentSessionsManager() {
        var _this = this;
        this.updateSession = (0, utils_1.throttle)(function () { return _this.updateUserSession(); }, sessionConstants_1.STORAGE_UPDATE_DELAY);
        this.updateUserSession = (0, sessionManagerUtils_1.getUserSessionUpdater)({
            fetchUserSession: PersistentSessionsManager.fetchUserSession,
            storeUserSession: PersistentSessionsManager.storeUserSession,
        });
        this.init();
    }
    PersistentSessionsManager.removeUserSession = function () {
        (0, webStorage_1.removeItem)(sessionConstants_1.STORAGE_KEY, PersistentSessionsManager.storageTypeLocal);
    };
    PersistentSessionsManager.storeUserSession = function (session) {
        (0, webStorage_1.setItem)(sessionConstants_1.STORAGE_KEY, (0, faro_core_1.stringifyExternalJson)(session), PersistentSessionsManager.storageTypeLocal);
    };
    PersistentSessionsManager.fetchUserSession = function () {
        var storedSession = (0, webStorage_1.getItem)(sessionConstants_1.STORAGE_KEY, PersistentSessionsManager.storageTypeLocal);
        if (storedSession) {
            return JSON.parse(storedSession);
        }
        return null;
    };
    PersistentSessionsManager.prototype.init = function () {
        var _this = this;
        document.addEventListener('visibilitychange', function () {
            if (document.visibilityState === 'visible') {
                _this.updateSession();
            }
        });
        // Users can call the setSession() method, so we need to sync this with the local storage session
        faro_core_1.faro.metas.addListener((0, sessionManagerUtils_1.getSessionMetaUpdateHandler)({
            fetchUserSession: PersistentSessionsManager.fetchUserSession,
            storeUserSession: PersistentSessionsManager.storeUserSession,
        }));
    };
    PersistentSessionsManager.storageTypeLocal = webStorage_1.webStorageType.local;
    return PersistentSessionsManager;
}());
exports.PersistentSessionsManager = PersistentSessionsManager;
//# sourceMappingURL=PersistentSessionsManager.js.map