"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeCoreConfig = void 0;
var faro_core_1 = require("@grafana/faro-core");
var consts_1 = require("../consts");
var instrumentations_1 = require("../instrumentations");
var session_1 = require("../instrumentations/session");
var metas_1 = require("../metas");
var k6_1 = require("../metas/k6");
var page_1 = require("../metas/page");
var transports_1 = require("../transports");
var getWebInstrumentations_1 = require("./getWebInstrumentations");
function makeCoreConfig(browserConfig) {
    var _a;
    var transports = [];
    var internalLogger = (0, faro_core_1.createInternalLogger)(browserConfig.unpatchedConsole, browserConfig.internalLoggerLevel);
    if (browserConfig.transports) {
        if (browserConfig.url || browserConfig.apiKey) {
            internalLogger.error('if "transports" is defined, "url" and "apiKey" should not be defined');
        }
        transports.push.apply(transports, browserConfig.transports);
    }
    else if (browserConfig.url) {
        transports.push(new transports_1.FetchTransport({
            url: browserConfig.url,
            apiKey: browserConfig.apiKey,
        }));
    }
    else {
        internalLogger.error('either "url" or "transports" must be defined');
    }
    var app = browserConfig.app, batching = browserConfig.batching, beforeSend = browserConfig.beforeSend, consoleInstrumentation = browserConfig.consoleInstrumentation, ignoreErrors = browserConfig.ignoreErrors, sessionTracking = browserConfig.sessionTracking, trackResources = browserConfig.trackResources, trackWebVitalsAttribution = browserConfig.trackWebVitalsAttribution, user = browserConfig.user, view = browserConfig.view, geoLocationTracking = browserConfig.geoLocationTracking, 
    // properties with default values
    _b = browserConfig.dedupe, 
    // properties with default values
    dedupe = _b === void 0 ? true : _b, _c = browserConfig.eventDomain, eventDomain = _c === void 0 ? consts_1.defaultEventDomain : _c, _d = browserConfig.globalObjectKey, globalObjectKey = _d === void 0 ? faro_core_1.defaultGlobalObjectKey : _d, _e = browserConfig.instrumentations, instrumentations = _e === void 0 ? (0, getWebInstrumentations_1.getWebInstrumentations)() : _e, _f = browserConfig.internalLoggerLevel, internalLoggerLevel = _f === void 0 ? faro_core_1.defaultInternalLoggerLevel : _f, _g = browserConfig.isolate, isolate = _g === void 0 ? false : _g, _h = browserConfig.logArgsSerializer, logArgsSerializer = _h === void 0 ? faro_core_1.defaultLogArgsSerializer : _h, _j = browserConfig.metas, metas = _j === void 0 ? createDefaultMetas(browserConfig) : _j, _k = browserConfig.paused, paused = _k === void 0 ? false : _k, _l = browserConfig.preventGlobalExposure, preventGlobalExposure = _l === void 0 ? false : _l, _m = browserConfig.unpatchedConsole, unpatchedConsole = _m === void 0 ? faro_core_1.defaultUnpatchedConsole : _m, webVitalsInstrumentation = browserConfig.webVitalsInstrumentation;
    return {
        app: app,
        batching: __assign(__assign({}, faro_core_1.defaultBatchingConfig), batching),
        dedupe: dedupe,
        globalObjectKey: globalObjectKey,
        instrumentations: instrumentations,
        internalLoggerLevel: internalLoggerLevel,
        isolate: isolate,
        logArgsSerializer: logArgsSerializer,
        metas: metas,
        parseStacktrace: instrumentations_1.parseStacktrace,
        paused: paused,
        preventGlobalExposure: preventGlobalExposure,
        transports: transports,
        unpatchedConsole: unpatchedConsole,
        beforeSend: beforeSend,
        eventDomain: eventDomain,
        ignoreErrors: ignoreErrors,
        // ignore cloud collector urls by default. These are URLs ending with /collect or /collect/ followed by alphanumeric characters.
        ignoreUrls: ((_a = browserConfig.ignoreUrls) !== null && _a !== void 0 ? _a : []).concat([/\/collect(?:\/[\w]*)?$/]),
        sessionTracking: __assign(__assign(__assign({}, session_1.defaultSessionTrackingConfig), sessionTracking), crateSessionMeta({ geoLocationTracking: geoLocationTracking, sessionTracking: sessionTracking })),
        user: user,
        view: view,
        trackResources: trackResources,
        trackWebVitalsAttribution: trackWebVitalsAttribution,
        consoleInstrumentation: consoleInstrumentation,
        webVitalsInstrumentation: webVitalsInstrumentation,
    };
}
exports.makeCoreConfig = makeCoreConfig;
function createDefaultMetas(browserConfig) {
    var _a, _b;
    var _c = (_a = browserConfig === null || browserConfig === void 0 ? void 0 : browserConfig.pageTracking) !== null && _a !== void 0 ? _a : {}, page = _c.page, generatePageId = _c.generatePageId;
    var initialMetas = __spreadArray([
        metas_1.browserMeta,
        (0, page_1.createPageMeta)({ generatePageId: generatePageId, initialPageMeta: page })
    ], ((_b = browserConfig.metas) !== null && _b !== void 0 ? _b : []), true);
    var isK6BrowserSession = (0, faro_core_1.isObject)(window.k6);
    if (isK6BrowserSession) {
        return __spreadArray(__spreadArray([], initialMetas, true), [k6_1.k6Meta], false);
    }
    return initialMetas;
}
function crateSessionMeta(_a) {
    var _b;
    var geoLocationTracking = _a.geoLocationTracking, sessionTracking = _a.sessionTracking;
    var overrides = {};
    if ((geoLocationTracking === null || geoLocationTracking === void 0 ? void 0 : geoLocationTracking.enabled) != null) {
        overrides.geoLocationTrackingEnabled = geoLocationTracking.enabled;
    }
    if ((0, faro_core_1.isEmpty)(overrides)) {
        return {};
    }
    return {
        session: __assign(__assign({}, ((_b = sessionTracking === null || sessionTracking === void 0 ? void 0 : sessionTracking.session) !== null && _b !== void 0 ? _b : {})), { overrides: overrides }),
    };
}
//# sourceMappingURL=makeCoreConfig.js.map