"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var deepEqual_1 = require("./deepEqual");
describe('deepEqual', function () {
    it('correctly checks null and undefined', function () {
        expect((0, deepEqual_1.deepEqual)(null, null)).toBe(true);
        expect((0, deepEqual_1.deepEqual)(undefined, undefined)).toBe(true);
        expect((0, deepEqual_1.deepEqual)(null, undefined)).toBe(false);
        expect((0, deepEqual_1.deepEqual)(undefined, null)).toBe(false);
        expect((0, deepEqual_1.deepEqual)(undefined, '')).toBe(false);
        expect((0, deepEqual_1.deepEqual)(null, '')).toBe(false);
        expect((0, deepEqual_1.deepEqual)(undefined, 0)).toBe(false);
        expect((0, deepEqual_1.deepEqual)(null, 0)).toBe(false);
        expect((0, deepEqual_1.deepEqual)(undefined, false)).toBe(false);
        expect((0, deepEqual_1.deepEqual)(null, false)).toBe(false);
        expect((0, deepEqual_1.deepEqual)(undefined, {})).toBe(false);
        expect((0, deepEqual_1.deepEqual)(null, {})).toBe(false);
        expect((0, deepEqual_1.deepEqual)(undefined, [])).toBe(false);
        expect((0, deepEqual_1.deepEqual)(null, [])).toBe(false);
    });
    it('correctly checks numbers', function () {
        expect((0, deepEqual_1.deepEqual)(1, 1)).toBe(true);
        expect((0, deepEqual_1.deepEqual)(1, 2)).toBe(false);
        expect((0, deepEqual_1.deepEqual)(1, null)).toBe(false);
        expect((0, deepEqual_1.deepEqual)(1, undefined)).toBe(false);
        expect((0, deepEqual_1.deepEqual)(NaN, NaN)).toBe(true);
        expect((0, deepEqual_1.deepEqual)(1, NaN)).toBe(false);
        expect((0, deepEqual_1.deepEqual)(0, null)).toBe(false);
        expect((0, deepEqual_1.deepEqual)(0, undefined)).toBe(false);
        expect((0, deepEqual_1.deepEqual)(1, true)).toBe(false);
        expect((0, deepEqual_1.deepEqual)(0, false)).toBe(false);
        expect((0, deepEqual_1.deepEqual)(0, -0)).toBe(true);
        expect((0, deepEqual_1.deepEqual)(Infinity, Infinity)).toBe(true);
        expect((0, deepEqual_1.deepEqual)(Infinity, -Infinity)).toBe(false);
    });
    it('correctly checks strings', function () {
        expect((0, deepEqual_1.deepEqual)('1', '1')).toBe(true);
        expect((0, deepEqual_1.deepEqual)('1', '2')).toBe(false);
        expect((0, deepEqual_1.deepEqual)('', null)).toBe(false);
        expect((0, deepEqual_1.deepEqual)('', undefined)).toBe(false);
        expect((0, deepEqual_1.deepEqual)('1', true)).toBe(false);
        expect((0, deepEqual_1.deepEqual)('', false)).toBe(false);
    });
    it('correctly checks booleans', function () {
        expect((0, deepEqual_1.deepEqual)(true, true)).toBe(true);
        expect((0, deepEqual_1.deepEqual)(false, false)).toBe(true);
        expect((0, deepEqual_1.deepEqual)(true, false)).toBe(false);
        expect((0, deepEqual_1.deepEqual)(false, null)).toBe(false);
        expect((0, deepEqual_1.deepEqual)(false, undefined)).toBe(false);
    });
    it('correctly checks arrays', function () {
        expect((0, deepEqual_1.deepEqual)([], [])).toBe(true);
        expect((0, deepEqual_1.deepEqual)([1, 2, 3], [1, 2, 3])).toBe(true);
        expect((0, deepEqual_1.deepEqual)([1, 2, 3], [1, 2, 4])).toBe(false);
        expect((0, deepEqual_1.deepEqual)([1, 2, 3], [1, 2])).toBe(false);
        expect((0, deepEqual_1.deepEqual)([{ a: 'a' }, { b: 'b' }], [{ a: 'a' }, { b: 'b' }])).toBe(true);
        expect((0, deepEqual_1.deepEqual)([{ a: 'a' }, { b: 'b' }], [{ a: 'a' }, { b: 'c' }])).toBe(false);
        expect((0, deepEqual_1.deepEqual)({ '0': 0, '1': 1, length: 2 }, [0, 1])).toBe(false);
    });
    it('correctly checks objects', function () {
        expect((0, deepEqual_1.deepEqual)({}, {})).toBe(true);
        expect((0, deepEqual_1.deepEqual)({ a: 1, b: '2' }, { a: 1, b: '2' })).toBe(true);
        expect((0, deepEqual_1.deepEqual)({ a: 1, b: '2' }, { b: '2', a: 1 })).toBe(true);
        expect((0, deepEqual_1.deepEqual)({ a: 1, b: '2' }, { a: 1, b: '2', c: [] })).toBe(false);
        expect((0, deepEqual_1.deepEqual)({ a: 1, b: '2', c: 3 }, { a: 1, b: '2', c: 4 })).toBe(false);
        expect((0, deepEqual_1.deepEqual)({ a: 1, b: '2', c: 3 }, { a: 1, b: '2', d: 3 })).toBe(false);
        expect((0, deepEqual_1.deepEqual)({ a: [{ b: 'c' }] }, { a: [{ b: 'c' }] })).toBe(true);
        expect((0, deepEqual_1.deepEqual)({ a: [{ b: 'c' }] }, { a: [{ b: 'd' }] })).toBe(false);
        expect((0, deepEqual_1.deepEqual)({ a: [{ b: 'c' }] }, { a: [{ c: 'c' }] })).toBe(false);
        expect((0, deepEqual_1.deepEqual)({}, [])).toBe(false);
        expect((0, deepEqual_1.deepEqual)({}, { foo: undefined })).toBe(false);
        expect((0, deepEqual_1.deepEqual)({ foo: undefined }, {})).toBe(false);
        expect((0, deepEqual_1.deepEqual)({ foo: undefined }, { bar: undefined })).toBe(false);
    });
    it('correctly checks complex objects', function () {
        expect((0, deepEqual_1.deepEqual)({
            prop1: 'value1',
            prop2: 'value2',
            prop3: 'value3',
            prop4: {
                subProp1: 'sub value1',
                subProp2: {
                    subSubProp1: 'sub sub value1',
                    subSubProp2: [1, 2, { prop2: 1, prop: 2 }, 4, 5],
                },
            },
            prop5: 1000,
        }, {
            prop5: 1000,
            prop3: 'value3',
            prop1: 'value1',
            prop2: 'value2',
            prop4: {
                subProp2: {
                    subSubProp1: 'sub sub value1',
                    subSubProp2: [1, 2, { prop2: 1, prop: 2 }, 4, 5],
                },
                subProp1: 'sub value1',
            },
        })).toBe(true);
    });
});
//# sourceMappingURL=deepEqual.test.js.map