/*
 * Copyright (c) 2015, 2025, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License, version 2.0, as published by
 * the Free Software Foundation.
 *
 * This program is designed to work with certain software that is licensed under separate terms, as designated in a particular file or component or in
 * included license documentation. The authors of MySQL hereby grant you an additional permission to link the program and your derivative works with the
 * separately licensed software that they have either included with the program or referenced in the documentation.
 *
 * Without limiting anything contained in the foregoing, this file, which is part of MySQL Connector/J, is also subject to the Universal FOSS Exception,
 * version 1.0, a copy of which can be found at http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

package com.mysql.cj.x.protobuf;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: mysqlx_notice.proto
// Protobuf Java Version: 4.29.0

public final class MysqlxNotice {
  private MysqlxNotice() {}
  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
      com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
      /* major= */ 4,
      /* minor= */ 29,
      /* patch= */ 0,
      /* suffix= */ "",
      MysqlxNotice.class.getName());
  }
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  public interface FrameOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Notice.Frame)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * * the type of the payload 
     * </pre>
     *
     * <code>required uint32 type = 1;</code>
     * @return Whether the type field is set.
     */
    boolean hasType();
    /**
     * <pre>
     * * the type of the payload 
     * </pre>
     *
     * <code>required uint32 type = 1;</code>
     * @return The type.
     */
    int getType();

    /**
     * <pre>
     * * global or local notification 
     * </pre>
     *
     * <code>optional .Mysqlx.Notice.Frame.Scope scope = 2 [default = GLOBAL];</code>
     * @return Whether the scope field is set.
     */
    boolean hasScope();
    /**
     * <pre>
     * * global or local notification 
     * </pre>
     *
     * <code>optional .Mysqlx.Notice.Frame.Scope scope = 2 [default = GLOBAL];</code>
     * @return The scope.
     */
    com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope getScope();

    /**
     * <pre>
     * * the payload of the notification 
     * </pre>
     *
     * <code>optional bytes payload = 3;</code>
     * @return Whether the payload field is set.
     */
    boolean hasPayload();
    /**
     * <pre>
     * * the payload of the notification 
     * </pre>
     *
     * <code>optional bytes payload = 3;</code>
     * @return The payload.
     */
    com.google.protobuf.ByteString getPayload();
  }
  /**
   * <pre>
   * *
   * Common frame for all notices
   *
   * | ``.type``                                         | Value |
   * |---------------------------------------------------|------ |
   * | &#64;ref Mysqlx::Notice::Warning                      | 1     |
   * | &#64;ref Mysqlx::Notice::SessionVariableChanged       | 2     |
   * | &#64;ref Mysqlx::Notice::SessionStateChanged          | 3     |
   * | &#64;ref Mysqlx::Notice::GroupReplicationStateChanged | 4     |
   * | &#64;ref Mysqlx::Notice::ServerHello                  | 5     |
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Notice.Frame}
   */
  public static final class Frame extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Notice.Frame)
      FrameOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        Frame.class.getName());
    }
    // Use Frame.newBuilder() to construct.
    private Frame(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Frame() {
      scope_ = 1;
      payload_ = com.google.protobuf.ByteString.EMPTY;
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Frame_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Frame_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxNotice.Frame.class, com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Builder.class);
    }

    /**
     * <pre>
     * * scope of notice 
     * </pre>
     *
     * Protobuf enum {@code Mysqlx.Notice.Frame.Scope}
     */
    public enum Scope
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>GLOBAL = 1;</code>
       */
      GLOBAL(1),
      /**
       * <code>LOCAL = 2;</code>
       */
      LOCAL(2),
      ;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 29,
          /* patch= */ 0,
          /* suffix= */ "",
          Scope.class.getName());
      }
      /**
       * <code>GLOBAL = 1;</code>
       */
      public static final int GLOBAL_VALUE = 1;
      /**
       * <code>LOCAL = 2;</code>
       */
      public static final int LOCAL_VALUE = 2;


      public final int getNumber() {
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Scope valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Scope forNumber(int value) {
        switch (value) {
          case 1: return GLOBAL;
          case 2: return LOCAL;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Scope>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Scope> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Scope>() {
              public Scope findValueByNumber(int number) {
                return Scope.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.Frame.getDescriptor().getEnumTypes().get(0);
      }

      private static final Scope[] VALUES = values();

      public static Scope valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Scope(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Notice.Frame.Scope)
    }

    /**
     * <pre>
     * * type of notice payload
     * </pre>
     *
     * Protobuf enum {@code Mysqlx.Notice.Frame.Type}
     */
    public enum Type
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>WARNING = 1;</code>
       */
      WARNING(1),
      /**
       * <code>SESSION_VARIABLE_CHANGED = 2;</code>
       */
      SESSION_VARIABLE_CHANGED(2),
      /**
       * <code>SESSION_STATE_CHANGED = 3;</code>
       */
      SESSION_STATE_CHANGED(3),
      /**
       * <code>GROUP_REPLICATION_STATE_CHANGED = 4;</code>
       */
      GROUP_REPLICATION_STATE_CHANGED(4),
      /**
       * <code>SERVER_HELLO = 5;</code>
       */
      SERVER_HELLO(5),
      ;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 29,
          /* patch= */ 0,
          /* suffix= */ "",
          Type.class.getName());
      }
      /**
       * <code>WARNING = 1;</code>
       */
      public static final int WARNING_VALUE = 1;
      /**
       * <code>SESSION_VARIABLE_CHANGED = 2;</code>
       */
      public static final int SESSION_VARIABLE_CHANGED_VALUE = 2;
      /**
       * <code>SESSION_STATE_CHANGED = 3;</code>
       */
      public static final int SESSION_STATE_CHANGED_VALUE = 3;
      /**
       * <code>GROUP_REPLICATION_STATE_CHANGED = 4;</code>
       */
      public static final int GROUP_REPLICATION_STATE_CHANGED_VALUE = 4;
      /**
       * <code>SERVER_HELLO = 5;</code>
       */
      public static final int SERVER_HELLO_VALUE = 5;


      public final int getNumber() {
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Type valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Type forNumber(int value) {
        switch (value) {
          case 1: return WARNING;
          case 2: return SESSION_VARIABLE_CHANGED;
          case 3: return SESSION_STATE_CHANGED;
          case 4: return GROUP_REPLICATION_STATE_CHANGED;
          case 5: return SERVER_HELLO;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Type> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Type>() {
              public Type findValueByNumber(int number) {
                return Type.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.Frame.getDescriptor().getEnumTypes().get(1);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Type(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Notice.Frame.Type)
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_ = 0;
    /**
     * <pre>
     * * the type of the payload 
     * </pre>
     *
     * <code>required uint32 type = 1;</code>
     * @return Whether the type field is set.
     */
    @java.lang.Override
    public boolean hasType() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * * the type of the payload 
     * </pre>
     *
     * <code>required uint32 type = 1;</code>
     * @return The type.
     */
    @java.lang.Override
    public int getType() {
      return type_;
    }

    public static final int SCOPE_FIELD_NUMBER = 2;
    private int scope_ = 1;
    /**
     * <pre>
     * * global or local notification 
     * </pre>
     *
     * <code>optional .Mysqlx.Notice.Frame.Scope scope = 2 [default = GLOBAL];</code>
     * @return Whether the scope field is set.
     */
    @java.lang.Override public boolean hasScope() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * * global or local notification 
     * </pre>
     *
     * <code>optional .Mysqlx.Notice.Frame.Scope scope = 2 [default = GLOBAL];</code>
     * @return The scope.
     */
    @java.lang.Override public com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope getScope() {
      com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope result = com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope.forNumber(scope_);
      return result == null ? com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope.GLOBAL : result;
    }

    public static final int PAYLOAD_FIELD_NUMBER = 3;
    private com.google.protobuf.ByteString payload_ = com.google.protobuf.ByteString.EMPTY;
    /**
     * <pre>
     * * the payload of the notification 
     * </pre>
     *
     * <code>optional bytes payload = 3;</code>
     * @return Whether the payload field is set.
     */
    @java.lang.Override
    public boolean hasPayload() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * * the payload of the notification 
     * </pre>
     *
     * <code>optional bytes payload = 3;</code>
     * @return The payload.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPayload() {
      return payload_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasType()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeUInt32(1, type_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeEnum(2, scope_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeBytes(3, payload_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, type_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(2, scope_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(3, payload_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxNotice.Frame)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxNotice.Frame other = (com.mysql.cj.x.protobuf.MysqlxNotice.Frame) obj;

      if (hasType() != other.hasType()) return false;
      if (hasType()) {
        if (getType()
            != other.getType()) return false;
      }
      if (hasScope() != other.hasScope()) return false;
      if (hasScope()) {
        if (scope_ != other.scope_) return false;
      }
      if (hasPayload() != other.hasPayload()) return false;
      if (hasPayload()) {
        if (!getPayload()
            .equals(other.getPayload())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getType();
      }
      if (hasScope()) {
        hash = (37 * hash) + SCOPE_FIELD_NUMBER;
        hash = (53 * hash) + scope_;
      }
      if (hasPayload()) {
        hash = (37 * hash) + PAYLOAD_FIELD_NUMBER;
        hash = (53 * hash) + getPayload().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxNotice.Frame prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Common frame for all notices
     *
     * | ``.type``                                         | Value |
     * |---------------------------------------------------|------ |
     * | &#64;ref Mysqlx::Notice::Warning                      | 1     |
     * | &#64;ref Mysqlx::Notice::SessionVariableChanged       | 2     |
     * | &#64;ref Mysqlx::Notice::SessionStateChanged          | 3     |
     * | &#64;ref Mysqlx::Notice::GroupReplicationStateChanged | 4     |
     * | &#64;ref Mysqlx::Notice::ServerHello                  | 5     |
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Notice.Frame}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Notice.Frame)
        com.mysql.cj.x.protobuf.MysqlxNotice.FrameOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Frame_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Frame_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxNotice.Frame.class, com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxNotice.Frame.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = 0;
        scope_ = 1;
        payload_ = com.google.protobuf.ByteString.EMPTY;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Frame_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.Frame getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.Frame.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.Frame build() {
        com.mysql.cj.x.protobuf.MysqlxNotice.Frame result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.Frame buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxNotice.Frame result = new com.mysql.cj.x.protobuf.MysqlxNotice.Frame(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxNotice.Frame result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.scope_ = scope_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.payload_ = payload_;
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxNotice.Frame) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxNotice.Frame)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxNotice.Frame other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxNotice.Frame.getDefaultInstance()) return this;
        if (other.hasType()) {
          setType(other.getType());
        }
        if (other.hasScope()) {
          setScope(other.getScope());
        }
        if (other.hasPayload()) {
          setPayload(other.getPayload());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasType()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                type_ = input.readUInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              case 16: {
                int tmpRaw = input.readEnum();
                com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope tmpValue =
                    com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(2, tmpRaw);
                } else {
                  scope_ = tmpRaw;
                  bitField0_ |= 0x00000002;
                }
                break;
              } // case 16
              case 26: {
                payload_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int type_ ;
      /**
       * <pre>
       * * the type of the payload 
       * </pre>
       *
       * <code>required uint32 type = 1;</code>
       * @return Whether the type field is set.
       */
      @java.lang.Override
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * * the type of the payload 
       * </pre>
       *
       * <code>required uint32 type = 1;</code>
       * @return The type.
       */
      @java.lang.Override
      public int getType() {
        return type_;
      }
      /**
       * <pre>
       * * the type of the payload 
       * </pre>
       *
       * <code>required uint32 type = 1;</code>
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(int value) {

        type_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * the type of the payload 
       * </pre>
       *
       * <code>required uint32 type = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 0;
        onChanged();
        return this;
      }

      private int scope_ = 1;
      /**
       * <pre>
       * * global or local notification 
       * </pre>
       *
       * <code>optional .Mysqlx.Notice.Frame.Scope scope = 2 [default = GLOBAL];</code>
       * @return Whether the scope field is set.
       */
      @java.lang.Override public boolean hasScope() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * * global or local notification 
       * </pre>
       *
       * <code>optional .Mysqlx.Notice.Frame.Scope scope = 2 [default = GLOBAL];</code>
       * @return The scope.
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope getScope() {
        com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope result = com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope.forNumber(scope_);
        return result == null ? com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope.GLOBAL : result;
      }
      /**
       * <pre>
       * * global or local notification 
       * </pre>
       *
       * <code>optional .Mysqlx.Notice.Frame.Scope scope = 2 [default = GLOBAL];</code>
       * @param value The scope to set.
       * @return This builder for chaining.
       */
      public Builder setScope(com.mysql.cj.x.protobuf.MysqlxNotice.Frame.Scope value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        scope_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * global or local notification 
       * </pre>
       *
       * <code>optional .Mysqlx.Notice.Frame.Scope scope = 2 [default = GLOBAL];</code>
       * @return This builder for chaining.
       */
      public Builder clearScope() {
        bitField0_ = (bitField0_ & ~0x00000002);
        scope_ = 1;
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString payload_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <pre>
       * * the payload of the notification 
       * </pre>
       *
       * <code>optional bytes payload = 3;</code>
       * @return Whether the payload field is set.
       */
      @java.lang.Override
      public boolean hasPayload() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * * the payload of the notification 
       * </pre>
       *
       * <code>optional bytes payload = 3;</code>
       * @return The payload.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getPayload() {
        return payload_;
      }
      /**
       * <pre>
       * * the payload of the notification 
       * </pre>
       *
       * <code>optional bytes payload = 3;</code>
       * @param value The payload to set.
       * @return This builder for chaining.
       */
      public Builder setPayload(com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        payload_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * the payload of the notification 
       * </pre>
       *
       * <code>optional bytes payload = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearPayload() {
        bitField0_ = (bitField0_ & ~0x00000004);
        payload_ = getDefaultInstance().getPayload();
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Notice.Frame)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Notice.Frame)
    private static final com.mysql.cj.x.protobuf.MysqlxNotice.Frame DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxNotice.Frame();
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.Frame getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Frame>
        PARSER = new com.google.protobuf.AbstractParser<Frame>() {
      @java.lang.Override
      public Frame parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Frame> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Frame> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxNotice.Frame getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface WarningOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Notice.Warning)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * * Note or Warning 
     * </pre>
     *
     * <code>optional .Mysqlx.Notice.Warning.Level level = 1 [default = WARNING];</code>
     * @return Whether the level field is set.
     */
    boolean hasLevel();
    /**
     * <pre>
     * * Note or Warning 
     * </pre>
     *
     * <code>optional .Mysqlx.Notice.Warning.Level level = 1 [default = WARNING];</code>
     * @return The level.
     */
    com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level getLevel();

    /**
     * <pre>
     * * warning code 
     * </pre>
     *
     * <code>required uint32 code = 2;</code>
     * @return Whether the code field is set.
     */
    boolean hasCode();
    /**
     * <pre>
     * * warning code 
     * </pre>
     *
     * <code>required uint32 code = 2;</code>
     * @return The code.
     */
    int getCode();

    /**
     * <pre>
     * * warning message 
     * </pre>
     *
     * <code>required string msg = 3;</code>
     * @return Whether the msg field is set.
     */
    boolean hasMsg();
    /**
     * <pre>
     * * warning message 
     * </pre>
     *
     * <code>required string msg = 3;</code>
     * @return The msg.
     */
    java.lang.String getMsg();
    /**
     * <pre>
     * * warning message 
     * </pre>
     *
     * <code>required string msg = 3;</code>
     * @return The bytes for msg.
     */
    com.google.protobuf.ByteString
        getMsgBytes();
  }
  /**
   * <pre>
   * *
   * Server-side warnings and notes
   *
   * &#64;par ``.scope`` == ``local``
   * ``.level``, ``.code`` and ``.msg`` map the content of:
   * &#64;code{sql}
   * SHOW WARNINGS
   * &#64;endcode
   *
   * &#64;par ``.scope`` == ``global``
   * (undefined) Will be used for global, unstructured messages like:
   * -  server is shutting down
   * -  a node disconnected from group
   * -  schema or table dropped
   *
   * | &#64;ref Mysqlx::Notice::Frame Field  | Value                   |
   * |-----------------------------------|-------------------------|
   * | ``.type``                         | 1                       |
   * | ``.scope``                        | ``local`` or ``global`` |
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Notice.Warning}
   */
  public static final class Warning extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Notice.Warning)
      WarningOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        Warning.class.getName());
    }
    // Use Warning.newBuilder() to construct.
    private Warning(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Warning() {
      level_ = 2;
      msg_ = "";
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Warning_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Warning_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxNotice.Warning.class, com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Builder.class);
    }

    /**
     * Protobuf enum {@code Mysqlx.Notice.Warning.Level}
     */
    public enum Level
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>NOTE = 1;</code>
       */
      NOTE(1),
      /**
       * <code>WARNING = 2;</code>
       */
      WARNING(2),
      /**
       * <code>ERROR = 3;</code>
       */
      ERROR(3),
      ;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 29,
          /* patch= */ 0,
          /* suffix= */ "",
          Level.class.getName());
      }
      /**
       * <code>NOTE = 1;</code>
       */
      public static final int NOTE_VALUE = 1;
      /**
       * <code>WARNING = 2;</code>
       */
      public static final int WARNING_VALUE = 2;
      /**
       * <code>ERROR = 3;</code>
       */
      public static final int ERROR_VALUE = 3;


      public final int getNumber() {
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Level valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Level forNumber(int value) {
        switch (value) {
          case 1: return NOTE;
          case 2: return WARNING;
          case 3: return ERROR;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Level>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Level> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Level>() {
              public Level findValueByNumber(int number) {
                return Level.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.Warning.getDescriptor().getEnumTypes().get(0);
      }

      private static final Level[] VALUES = values();

      public static Level valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Level(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Notice.Warning.Level)
    }

    private int bitField0_;
    public static final int LEVEL_FIELD_NUMBER = 1;
    private int level_ = 2;
    /**
     * <pre>
     * * Note or Warning 
     * </pre>
     *
     * <code>optional .Mysqlx.Notice.Warning.Level level = 1 [default = WARNING];</code>
     * @return Whether the level field is set.
     */
    @java.lang.Override public boolean hasLevel() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * * Note or Warning 
     * </pre>
     *
     * <code>optional .Mysqlx.Notice.Warning.Level level = 1 [default = WARNING];</code>
     * @return The level.
     */
    @java.lang.Override public com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level getLevel() {
      com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level result = com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level.forNumber(level_);
      return result == null ? com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level.WARNING : result;
    }

    public static final int CODE_FIELD_NUMBER = 2;
    private int code_ = 0;
    /**
     * <pre>
     * * warning code 
     * </pre>
     *
     * <code>required uint32 code = 2;</code>
     * @return Whether the code field is set.
     */
    @java.lang.Override
    public boolean hasCode() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * * warning code 
     * </pre>
     *
     * <code>required uint32 code = 2;</code>
     * @return The code.
     */
    @java.lang.Override
    public int getCode() {
      return code_;
    }

    public static final int MSG_FIELD_NUMBER = 3;
    @SuppressWarnings("serial")
    private volatile java.lang.Object msg_ = "";
    /**
     * <pre>
     * * warning message 
     * </pre>
     *
     * <code>required string msg = 3;</code>
     * @return Whether the msg field is set.
     */
    @java.lang.Override
    public boolean hasMsg() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * * warning message 
     * </pre>
     *
     * <code>required string msg = 3;</code>
     * @return The msg.
     */
    @java.lang.Override
    public java.lang.String getMsg() {
      java.lang.Object ref = msg_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          msg_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * * warning message 
     * </pre>
     *
     * <code>required string msg = 3;</code>
     * @return The bytes for msg.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getMsgBytes() {
      java.lang.Object ref = msg_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        msg_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasCode()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasMsg()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, level_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeUInt32(2, code_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 3, msg_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, level_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(2, code_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(3, msg_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxNotice.Warning)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxNotice.Warning other = (com.mysql.cj.x.protobuf.MysqlxNotice.Warning) obj;

      if (hasLevel() != other.hasLevel()) return false;
      if (hasLevel()) {
        if (level_ != other.level_) return false;
      }
      if (hasCode() != other.hasCode()) return false;
      if (hasCode()) {
        if (getCode()
            != other.getCode()) return false;
      }
      if (hasMsg() != other.hasMsg()) return false;
      if (hasMsg()) {
        if (!getMsg()
            .equals(other.getMsg())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasLevel()) {
        hash = (37 * hash) + LEVEL_FIELD_NUMBER;
        hash = (53 * hash) + level_;
      }
      if (hasCode()) {
        hash = (37 * hash) + CODE_FIELD_NUMBER;
        hash = (53 * hash) + getCode();
      }
      if (hasMsg()) {
        hash = (37 * hash) + MSG_FIELD_NUMBER;
        hash = (53 * hash) + getMsg().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxNotice.Warning prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Server-side warnings and notes
     *
     * &#64;par ``.scope`` == ``local``
     * ``.level``, ``.code`` and ``.msg`` map the content of:
     * &#64;code{sql}
     * SHOW WARNINGS
     * &#64;endcode
     *
     * &#64;par ``.scope`` == ``global``
     * (undefined) Will be used for global, unstructured messages like:
     * -  server is shutting down
     * -  a node disconnected from group
     * -  schema or table dropped
     *
     * | &#64;ref Mysqlx::Notice::Frame Field  | Value                   |
     * |-----------------------------------|-------------------------|
     * | ``.type``                         | 1                       |
     * | ``.scope``                        | ``local`` or ``global`` |
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Notice.Warning}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Notice.Warning)
        com.mysql.cj.x.protobuf.MysqlxNotice.WarningOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Warning_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Warning_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxNotice.Warning.class, com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxNotice.Warning.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        level_ = 2;
        code_ = 0;
        msg_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_Warning_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.Warning getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.Warning.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.Warning build() {
        com.mysql.cj.x.protobuf.MysqlxNotice.Warning result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.Warning buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxNotice.Warning result = new com.mysql.cj.x.protobuf.MysqlxNotice.Warning(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxNotice.Warning result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.level_ = level_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.code_ = code_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.msg_ = msg_;
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxNotice.Warning) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxNotice.Warning)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxNotice.Warning other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxNotice.Warning.getDefaultInstance()) return this;
        if (other.hasLevel()) {
          setLevel(other.getLevel());
        }
        if (other.hasCode()) {
          setCode(other.getCode());
        }
        if (other.hasMsg()) {
          msg_ = other.msg_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasCode()) {
          return false;
        }
        if (!hasMsg()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                int tmpRaw = input.readEnum();
                com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level tmpValue =
                    com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(1, tmpRaw);
                } else {
                  level_ = tmpRaw;
                  bitField0_ |= 0x00000001;
                }
                break;
              } // case 8
              case 16: {
                code_ = input.readUInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
              case 26: {
                msg_ = input.readBytes();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int level_ = 2;
      /**
       * <pre>
       * * Note or Warning 
       * </pre>
       *
       * <code>optional .Mysqlx.Notice.Warning.Level level = 1 [default = WARNING];</code>
       * @return Whether the level field is set.
       */
      @java.lang.Override public boolean hasLevel() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * * Note or Warning 
       * </pre>
       *
       * <code>optional .Mysqlx.Notice.Warning.Level level = 1 [default = WARNING];</code>
       * @return The level.
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level getLevel() {
        com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level result = com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level.forNumber(level_);
        return result == null ? com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level.WARNING : result;
      }
      /**
       * <pre>
       * * Note or Warning 
       * </pre>
       *
       * <code>optional .Mysqlx.Notice.Warning.Level level = 1 [default = WARNING];</code>
       * @param value The level to set.
       * @return This builder for chaining.
       */
      public Builder setLevel(com.mysql.cj.x.protobuf.MysqlxNotice.Warning.Level value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        level_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * Note or Warning 
       * </pre>
       *
       * <code>optional .Mysqlx.Notice.Warning.Level level = 1 [default = WARNING];</code>
       * @return This builder for chaining.
       */
      public Builder clearLevel() {
        bitField0_ = (bitField0_ & ~0x00000001);
        level_ = 2;
        onChanged();
        return this;
      }

      private int code_ ;
      /**
       * <pre>
       * * warning code 
       * </pre>
       *
       * <code>required uint32 code = 2;</code>
       * @return Whether the code field is set.
       */
      @java.lang.Override
      public boolean hasCode() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * * warning code 
       * </pre>
       *
       * <code>required uint32 code = 2;</code>
       * @return The code.
       */
      @java.lang.Override
      public int getCode() {
        return code_;
      }
      /**
       * <pre>
       * * warning code 
       * </pre>
       *
       * <code>required uint32 code = 2;</code>
       * @param value The code to set.
       * @return This builder for chaining.
       */
      public Builder setCode(int value) {

        code_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * warning code 
       * </pre>
       *
       * <code>required uint32 code = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearCode() {
        bitField0_ = (bitField0_ & ~0x00000002);
        code_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object msg_ = "";
      /**
       * <pre>
       * * warning message 
       * </pre>
       *
       * <code>required string msg = 3;</code>
       * @return Whether the msg field is set.
       */
      public boolean hasMsg() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * * warning message 
       * </pre>
       *
       * <code>required string msg = 3;</code>
       * @return The msg.
       */
      public java.lang.String getMsg() {
        java.lang.Object ref = msg_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            msg_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * * warning message 
       * </pre>
       *
       * <code>required string msg = 3;</code>
       * @return The bytes for msg.
       */
      public com.google.protobuf.ByteString
          getMsgBytes() {
        java.lang.Object ref = msg_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          msg_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * * warning message 
       * </pre>
       *
       * <code>required string msg = 3;</code>
       * @param value The msg to set.
       * @return This builder for chaining.
       */
      public Builder setMsg(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        msg_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * warning message 
       * </pre>
       *
       * <code>required string msg = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearMsg() {
        msg_ = getDefaultInstance().getMsg();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * warning message 
       * </pre>
       *
       * <code>required string msg = 3;</code>
       * @param value The bytes for msg to set.
       * @return This builder for chaining.
       */
      public Builder setMsgBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        msg_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Notice.Warning)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Notice.Warning)
    private static final com.mysql.cj.x.protobuf.MysqlxNotice.Warning DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxNotice.Warning();
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.Warning getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Warning>
        PARSER = new com.google.protobuf.AbstractParser<Warning>() {
      @java.lang.Override
      public Warning parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Warning> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Warning> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxNotice.Warning getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface SessionVariableChangedOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Notice.SessionVariableChanged)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * * name of the variable 
     * </pre>
     *
     * <code>required string param = 1;</code>
     * @return Whether the param field is set.
     */
    boolean hasParam();
    /**
     * <pre>
     * * name of the variable 
     * </pre>
     *
     * <code>required string param = 1;</code>
     * @return The param.
     */
    java.lang.String getParam();
    /**
     * <pre>
     * * name of the variable 
     * </pre>
     *
     * <code>required string param = 1;</code>
     * @return The bytes for param.
     */
    com.google.protobuf.ByteString
        getParamBytes();

    /**
     * <pre>
     * * the changed value of param 
     * </pre>
     *
     * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
     * @return Whether the value field is set.
     */
    boolean hasValue();
    /**
     * <pre>
     * * the changed value of param 
     * </pre>
     *
     * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
     * @return The value.
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getValue();
    /**
     * <pre>
     * * the changed value of param 
     * </pre>
     *
     * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getValueOrBuilder();
  }
  /**
   * <pre>
   * *
   * Notify clients about changes to the current session variables.
   *
   * Every change to a variable that is accessible through:
   *
   * &#64;code{sql}
   * SHOW SESSION VARIABLES
   * &#64;endcode
   *
   * | &#64;ref Mysqlx::Notice::Frame  Field | Value    |
   * |-----------------------------------|----------|
   * | ``.type``                         | 2        |
   * | ``.scope``                        | ``local``|
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Notice.SessionVariableChanged}
   */
  public static final class SessionVariableChanged extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Notice.SessionVariableChanged)
      SessionVariableChangedOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        SessionVariableChanged.class.getName());
    }
    // Use SessionVariableChanged.newBuilder() to construct.
    private SessionVariableChanged(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private SessionVariableChanged() {
      param_ = "";
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionVariableChanged_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionVariableChanged_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged.class, com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged.Builder.class);
    }

    private int bitField0_;
    public static final int PARAM_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private volatile java.lang.Object param_ = "";
    /**
     * <pre>
     * * name of the variable 
     * </pre>
     *
     * <code>required string param = 1;</code>
     * @return Whether the param field is set.
     */
    @java.lang.Override
    public boolean hasParam() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * * name of the variable 
     * </pre>
     *
     * <code>required string param = 1;</code>
     * @return The param.
     */
    @java.lang.Override
    public java.lang.String getParam() {
      java.lang.Object ref = param_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          param_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * * name of the variable 
     * </pre>
     *
     * <code>required string param = 1;</code>
     * @return The bytes for param.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getParamBytes() {
      java.lang.Object ref = param_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        param_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value_;
    /**
     * <pre>
     * * the changed value of param 
     * </pre>
     *
     * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
     * @return Whether the value field is set.
     */
    @java.lang.Override
    public boolean hasValue() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * * the changed value of param 
     * </pre>
     *
     * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
     * @return The value.
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getValue() {
      return value_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance() : value_;
    }
    /**
     * <pre>
     * * the changed value of param 
     * </pre>
     *
     * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getValueOrBuilder() {
      return value_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance() : value_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasParam()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasValue()) {
        if (!getValue().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 1, param_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getValue());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(1, param_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getValue());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged other = (com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged) obj;

      if (hasParam() != other.hasParam()) return false;
      if (hasParam()) {
        if (!getParam()
            .equals(other.getParam())) return false;
      }
      if (hasValue() != other.hasValue()) return false;
      if (hasValue()) {
        if (!getValue()
            .equals(other.getValue())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasParam()) {
        hash = (37 * hash) + PARAM_FIELD_NUMBER;
        hash = (53 * hash) + getParam().hashCode();
      }
      if (hasValue()) {
        hash = (37 * hash) + VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getValue().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Notify clients about changes to the current session variables.
     *
     * Every change to a variable that is accessible through:
     *
     * &#64;code{sql}
     * SHOW SESSION VARIABLES
     * &#64;endcode
     *
     * | &#64;ref Mysqlx::Notice::Frame  Field | Value    |
     * |-----------------------------------|----------|
     * | ``.type``                         | 2        |
     * | ``.scope``                        | ``local``|
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Notice.SessionVariableChanged}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Notice.SessionVariableChanged)
        com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChangedOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionVariableChanged_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionVariableChanged_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged.class, com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage
                .alwaysUseFieldBuilders) {
          getValueFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        param_ = "";
        value_ = null;
        if (valueBuilder_ != null) {
          valueBuilder_.dispose();
          valueBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionVariableChanged_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged build() {
        com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged result = new com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.param_ = param_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.value_ = valueBuilder_ == null
              ? value_
              : valueBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged.getDefaultInstance()) return this;
        if (other.hasParam()) {
          param_ = other.param_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.hasValue()) {
          mergeValue(other.getValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasParam()) {
          return false;
        }
        if (hasValue()) {
          if (!getValue().isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                param_ = input.readBytes();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
              case 18: {
                input.readMessage(
                    getValueFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.lang.Object param_ = "";
      /**
       * <pre>
       * * name of the variable 
       * </pre>
       *
       * <code>required string param = 1;</code>
       * @return Whether the param field is set.
       */
      public boolean hasParam() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * * name of the variable 
       * </pre>
       *
       * <code>required string param = 1;</code>
       * @return The param.
       */
      public java.lang.String getParam() {
        java.lang.Object ref = param_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            param_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * * name of the variable 
       * </pre>
       *
       * <code>required string param = 1;</code>
       * @return The bytes for param.
       */
      public com.google.protobuf.ByteString
          getParamBytes() {
        java.lang.Object ref = param_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          param_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * * name of the variable 
       * </pre>
       *
       * <code>required string param = 1;</code>
       * @param value The param to set.
       * @return This builder for chaining.
       */
      public Builder setParam(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        param_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * name of the variable 
       * </pre>
       *
       * <code>required string param = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearParam() {
        param_ = getDefaultInstance().getParam();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * name of the variable 
       * </pre>
       *
       * <code>required string param = 1;</code>
       * @param value The bytes for param to set.
       * @return This builder for chaining.
       */
      public Builder setParamBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        param_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value_;
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> valueBuilder_;
      /**
       * <pre>
       * * the changed value of param 
       * </pre>
       *
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       * @return Whether the value field is set.
       */
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * * the changed value of param 
       * </pre>
       *
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       * @return The value.
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getValue() {
        if (valueBuilder_ == null) {
          return value_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance() : value_;
        } else {
          return valueBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * * the changed value of param 
       * </pre>
       *
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder setValue(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          value_ = value;
        } else {
          valueBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * the changed value of param 
       * </pre>
       *
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder setValue(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (valueBuilder_ == null) {
          value_ = builderForValue.build();
        } else {
          valueBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * the changed value of param 
       * </pre>
       *
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder mergeValue(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (valueBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            value_ != null &&
            value_ != com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance()) {
            getValueBuilder().mergeFrom(value);
          } else {
            value_ = value;
          }
        } else {
          valueBuilder_.mergeFrom(value);
        }
        if (value_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * * the changed value of param 
       * </pre>
       *
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder clearValue() {
        bitField0_ = (bitField0_ & ~0x00000002);
        value_ = null;
        if (valueBuilder_ != null) {
          valueBuilder_.dispose();
          valueBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * the changed value of param 
       * </pre>
       *
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder getValueBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getValueFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * * the changed value of param 
       * </pre>
       *
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getValueOrBuilder() {
        if (valueBuilder_ != null) {
          return valueBuilder_.getMessageOrBuilder();
        } else {
          return value_ == null ?
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance() : value_;
        }
      }
      /**
       * <pre>
       * * the changed value of param 
       * </pre>
       *
       * <code>optional .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
          getValueFieldBuilder() {
        if (valueBuilder_ == null) {
          valueBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder>(
                  getValue(),
                  getParentForChildren(),
                  isClean());
          value_ = null;
        }
        return valueBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Notice.SessionVariableChanged)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Notice.SessionVariableChanged)
    private static final com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged();
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SessionVariableChanged>
        PARSER = new com.google.protobuf.AbstractParser<SessionVariableChanged>() {
      @java.lang.Override
      public SessionVariableChanged parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<SessionVariableChanged> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SessionVariableChanged> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxNotice.SessionVariableChanged getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface SessionStateChangedOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Notice.SessionStateChanged)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * * parameter key 
     * </pre>
     *
     * <code>required .Mysqlx.Notice.SessionStateChanged.Parameter param = 1;</code>
     * @return Whether the param field is set.
     */
    boolean hasParam();
    /**
     * <pre>
     * * parameter key 
     * </pre>
     *
     * <code>required .Mysqlx.Notice.SessionStateChanged.Parameter param = 1;</code>
     * @return The param.
     */
    com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter getParam();

    /**
     * <pre>
     * * updated value 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> 
        getValueList();
    /**
     * <pre>
     * * updated value 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getValue(int index);
    /**
     * <pre>
     * * updated value 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    int getValueCount();
    /**
     * <pre>
     * * updated value 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
        getValueOrBuilderList();
    /**
     * <pre>
     * * updated value 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getValueOrBuilder(
        int index);
  }
  /**
   * Protobuf type {@code Mysqlx.Notice.SessionStateChanged}
   */
  public static final class SessionStateChanged extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Notice.SessionStateChanged)
      SessionStateChangedOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        SessionStateChanged.class.getName());
    }
    // Use SessionStateChanged.newBuilder() to construct.
    private SessionStateChanged(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private SessionStateChanged() {
      param_ = 1;
      value_ = java.util.Collections.emptyList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionStateChanged_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionStateChanged_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.class, com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Builder.class);
    }

    /**
     * Protobuf enum {@code Mysqlx.Notice.SessionStateChanged.Parameter}
     */
    public enum Parameter
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>CURRENT_SCHEMA = 1;</code>
       */
      CURRENT_SCHEMA(1),
      /**
       * <code>ACCOUNT_EXPIRED = 2;</code>
       */
      ACCOUNT_EXPIRED(2),
      /**
       * <code>GENERATED_INSERT_ID = 3;</code>
       */
      GENERATED_INSERT_ID(3),
      /**
       * <code>ROWS_AFFECTED = 4;</code>
       */
      ROWS_AFFECTED(4),
      /**
       * <code>ROWS_FOUND = 5;</code>
       */
      ROWS_FOUND(5),
      /**
       * <code>ROWS_MATCHED = 6;</code>
       */
      ROWS_MATCHED(6),
      /**
       * <code>TRX_COMMITTED = 7;</code>
       */
      TRX_COMMITTED(7),
      /**
       * <code>TRX_ROLLEDBACK = 9;</code>
       */
      TRX_ROLLEDBACK(9),
      /**
       * <code>PRODUCED_MESSAGE = 10;</code>
       */
      PRODUCED_MESSAGE(10),
      /**
       * <code>CLIENT_ID_ASSIGNED = 11;</code>
       */
      CLIENT_ID_ASSIGNED(11),
      /**
       * <pre>
       * .. more to be added
       * </pre>
       *
       * <code>GENERATED_DOCUMENT_IDS = 12;</code>
       */
      GENERATED_DOCUMENT_IDS(12),
      ;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 29,
          /* patch= */ 0,
          /* suffix= */ "",
          Parameter.class.getName());
      }
      /**
       * <code>CURRENT_SCHEMA = 1;</code>
       */
      public static final int CURRENT_SCHEMA_VALUE = 1;
      /**
       * <code>ACCOUNT_EXPIRED = 2;</code>
       */
      public static final int ACCOUNT_EXPIRED_VALUE = 2;
      /**
       * <code>GENERATED_INSERT_ID = 3;</code>
       */
      public static final int GENERATED_INSERT_ID_VALUE = 3;
      /**
       * <code>ROWS_AFFECTED = 4;</code>
       */
      public static final int ROWS_AFFECTED_VALUE = 4;
      /**
       * <code>ROWS_FOUND = 5;</code>
       */
      public static final int ROWS_FOUND_VALUE = 5;
      /**
       * <code>ROWS_MATCHED = 6;</code>
       */
      public static final int ROWS_MATCHED_VALUE = 6;
      /**
       * <code>TRX_COMMITTED = 7;</code>
       */
      public static final int TRX_COMMITTED_VALUE = 7;
      /**
       * <code>TRX_ROLLEDBACK = 9;</code>
       */
      public static final int TRX_ROLLEDBACK_VALUE = 9;
      /**
       * <code>PRODUCED_MESSAGE = 10;</code>
       */
      public static final int PRODUCED_MESSAGE_VALUE = 10;
      /**
       * <code>CLIENT_ID_ASSIGNED = 11;</code>
       */
      public static final int CLIENT_ID_ASSIGNED_VALUE = 11;
      /**
       * <pre>
       * .. more to be added
       * </pre>
       *
       * <code>GENERATED_DOCUMENT_IDS = 12;</code>
       */
      public static final int GENERATED_DOCUMENT_IDS_VALUE = 12;


      public final int getNumber() {
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Parameter valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Parameter forNumber(int value) {
        switch (value) {
          case 1: return CURRENT_SCHEMA;
          case 2: return ACCOUNT_EXPIRED;
          case 3: return GENERATED_INSERT_ID;
          case 4: return ROWS_AFFECTED;
          case 5: return ROWS_FOUND;
          case 6: return ROWS_MATCHED;
          case 7: return TRX_COMMITTED;
          case 9: return TRX_ROLLEDBACK;
          case 10: return PRODUCED_MESSAGE;
          case 11: return CLIENT_ID_ASSIGNED;
          case 12: return GENERATED_DOCUMENT_IDS;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Parameter>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Parameter> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Parameter>() {
              public Parameter findValueByNumber(int number) {
                return Parameter.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.getDescriptor().getEnumTypes().get(0);
      }

      private static final Parameter[] VALUES = values();

      public static Parameter valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Parameter(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Notice.SessionStateChanged.Parameter)
    }

    private int bitField0_;
    public static final int PARAM_FIELD_NUMBER = 1;
    private int param_ = 1;
    /**
     * <pre>
     * * parameter key 
     * </pre>
     *
     * <code>required .Mysqlx.Notice.SessionStateChanged.Parameter param = 1;</code>
     * @return Whether the param field is set.
     */
    @java.lang.Override public boolean hasParam() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * * parameter key 
     * </pre>
     *
     * <code>required .Mysqlx.Notice.SessionStateChanged.Parameter param = 1;</code>
     * @return The param.
     */
    @java.lang.Override public com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter getParam() {
      com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter result = com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter.forNumber(param_);
      return result == null ? com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter.CURRENT_SCHEMA : result;
    }

    public static final int VALUE_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> value_;
    /**
     * <pre>
     * * updated value 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> getValueList() {
      return value_;
    }
    /**
     * <pre>
     * * updated value 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
        getValueOrBuilderList() {
      return value_;
    }
    /**
     * <pre>
     * * updated value 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    @java.lang.Override
    public int getValueCount() {
      return value_.size();
    }
    /**
     * <pre>
     * * updated value 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getValue(int index) {
      return value_.get(index);
    }
    /**
     * <pre>
     * * updated value 
     * </pre>
     *
     * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getValueOrBuilder(
        int index) {
      return value_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasParam()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getValueCount(); i++) {
        if (!getValue(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, param_);
      }
      for (int i = 0; i < value_.size(); i++) {
        output.writeMessage(2, value_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, param_);
      }
      for (int i = 0; i < value_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, value_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged other = (com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged) obj;

      if (hasParam() != other.hasParam()) return false;
      if (hasParam()) {
        if (param_ != other.param_) return false;
      }
      if (!getValueList()
          .equals(other.getValueList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasParam()) {
        hash = (37 * hash) + PARAM_FIELD_NUMBER;
        hash = (53 * hash) + param_;
      }
      if (getValueCount() > 0) {
        hash = (37 * hash) + VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getValueList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code Mysqlx.Notice.SessionStateChanged}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Notice.SessionStateChanged)
        com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChangedOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionStateChanged_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionStateChanged_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.class, com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        param_ = 1;
        if (valueBuilder_ == null) {
          value_ = java.util.Collections.emptyList();
        } else {
          value_ = null;
          valueBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_SessionStateChanged_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged build() {
        com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged result = new com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged result) {
        if (valueBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            value_ = java.util.Collections.unmodifiableList(value_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.value_ = value_;
        } else {
          result.value_ = valueBuilder_.build();
        }
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.param_ = param_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.getDefaultInstance()) return this;
        if (other.hasParam()) {
          setParam(other.getParam());
        }
        if (valueBuilder_ == null) {
          if (!other.value_.isEmpty()) {
            if (value_.isEmpty()) {
              value_ = other.value_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureValueIsMutable();
              value_.addAll(other.value_);
            }
            onChanged();
          }
        } else {
          if (!other.value_.isEmpty()) {
            if (valueBuilder_.isEmpty()) {
              valueBuilder_.dispose();
              valueBuilder_ = null;
              value_ = other.value_;
              bitField0_ = (bitField0_ & ~0x00000002);
              valueBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getValueFieldBuilder() : null;
            } else {
              valueBuilder_.addAllMessages(other.value_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasParam()) {
          return false;
        }
        for (int i = 0; i < getValueCount(); i++) {
          if (!getValue(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                int tmpRaw = input.readEnum();
                com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter tmpValue =
                    com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(1, tmpRaw);
                } else {
                  param_ = tmpRaw;
                  bitField0_ |= 0x00000001;
                }
                break;
              } // case 8
              case 18: {
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar m =
                    input.readMessage(
                        com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.parser(),
                        extensionRegistry);
                if (valueBuilder_ == null) {
                  ensureValueIsMutable();
                  value_.add(m);
                } else {
                  valueBuilder_.addMessage(m);
                }
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int param_ = 1;
      /**
       * <pre>
       * * parameter key 
       * </pre>
       *
       * <code>required .Mysqlx.Notice.SessionStateChanged.Parameter param = 1;</code>
       * @return Whether the param field is set.
       */
      @java.lang.Override public boolean hasParam() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * * parameter key 
       * </pre>
       *
       * <code>required .Mysqlx.Notice.SessionStateChanged.Parameter param = 1;</code>
       * @return The param.
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter getParam() {
        com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter result = com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter.forNumber(param_);
        return result == null ? com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter.CURRENT_SCHEMA : result;
      }
      /**
       * <pre>
       * * parameter key 
       * </pre>
       *
       * <code>required .Mysqlx.Notice.SessionStateChanged.Parameter param = 1;</code>
       * @param value The param to set.
       * @return This builder for chaining.
       */
      public Builder setParam(com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged.Parameter value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        param_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * parameter key 
       * </pre>
       *
       * <code>required .Mysqlx.Notice.SessionStateChanged.Parameter param = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearParam() {
        bitField0_ = (bitField0_ & ~0x00000001);
        param_ = 1;
        onChanged();
        return this;
      }

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> value_ =
        java.util.Collections.emptyList();
      private void ensureValueIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          value_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar>(value_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> valueBuilder_;

      /**
       * <pre>
       * * updated value 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> getValueList() {
        if (valueBuilder_ == null) {
          return java.util.Collections.unmodifiableList(value_);
        } else {
          return valueBuilder_.getMessageList();
        }
      }
      /**
       * <pre>
       * * updated value 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public int getValueCount() {
        if (valueBuilder_ == null) {
          return value_.size();
        } else {
          return valueBuilder_.getCount();
        }
      }
      /**
       * <pre>
       * * updated value 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getValue(int index) {
        if (valueBuilder_ == null) {
          return value_.get(index);
        } else {
          return valueBuilder_.getMessage(index);
        }
      }
      /**
       * <pre>
       * * updated value 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder setValue(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.set(index, value);
          onChanged();
        } else {
          valueBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * * updated value 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder setValue(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.set(index, builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * updated value 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder addValue(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.add(value);
          onChanged();
        } else {
          valueBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <pre>
       * * updated value 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder addValue(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.add(index, value);
          onChanged();
        } else {
          valueBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <pre>
       * * updated value 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder addValue(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.add(builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * updated value 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder addValue(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.add(index, builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <pre>
       * * updated value 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder addAllValue(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar> values) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, value_);
          onChanged();
        } else {
          valueBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <pre>
       * * updated value 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder clearValue() {
        if (valueBuilder_ == null) {
          value_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          valueBuilder_.clear();
        }
        return this;
      }
      /**
       * <pre>
       * * updated value 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public Builder removeValue(int index) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.remove(index);
          onChanged();
        } else {
          valueBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <pre>
       * * updated value 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder getValueBuilder(
          int index) {
        return getValueFieldBuilder().getBuilder(index);
      }
      /**
       * <pre>
       * * updated value 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getValueOrBuilder(
          int index) {
        if (valueBuilder_ == null) {
          return value_.get(index);  } else {
          return valueBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <pre>
       * * updated value 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
           getValueOrBuilderList() {
        if (valueBuilder_ != null) {
          return valueBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(value_);
        }
      }
      /**
       * <pre>
       * * updated value 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder addValueBuilder() {
        return getValueFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance());
      }
      /**
       * <pre>
       * * updated value 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder addValueBuilder(
          int index) {
        return getValueFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance());
      }
      /**
       * <pre>
       * * updated value 
       * </pre>
       *
       * <code>repeated .Mysqlx.Datatypes.Scalar value = 2;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder> 
           getValueBuilderList() {
        return getValueFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
          getValueFieldBuilder() {
        if (valueBuilder_ == null) {
          valueBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder>(
                  value_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          value_ = null;
        }
        return valueBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Notice.SessionStateChanged)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Notice.SessionStateChanged)
    private static final com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged();
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SessionStateChanged>
        PARSER = new com.google.protobuf.AbstractParser<SessionStateChanged>() {
      @java.lang.Override
      public SessionStateChanged parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<SessionStateChanged> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SessionStateChanged> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxNotice.SessionStateChanged getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface GroupReplicationStateChangedOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Notice.GroupReplicationStateChanged)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * * type of group replication event 
     * </pre>
     *
     * <code>required uint32 type = 1;</code>
     * @return Whether the type field is set.
     */
    boolean hasType();
    /**
     * <pre>
     * * type of group replication event 
     * </pre>
     *
     * <code>required uint32 type = 1;</code>
     * @return The type.
     */
    int getType();

    /**
     * <pre>
     * * view identifier 
     * </pre>
     *
     * <code>optional string view_id = 2;</code>
     * @return Whether the viewId field is set.
     */
    boolean hasViewId();
    /**
     * <pre>
     * * view identifier 
     * </pre>
     *
     * <code>optional string view_id = 2;</code>
     * @return The viewId.
     */
    java.lang.String getViewId();
    /**
     * <pre>
     * * view identifier 
     * </pre>
     *
     * <code>optional string view_id = 2;</code>
     * @return The bytes for viewId.
     */
    com.google.protobuf.ByteString
        getViewIdBytes();
  }
  /**
   * <pre>
   * *
   * Notify clients about group replication state changes
   *
   * | &#64;ref Mysqlx::Notice::Frame Field  | Value      |
   * |-----------------------------------|------------|
   * |``.type``                          | 4          |
   * |``.scope``                         | ``global`` |
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Notice.GroupReplicationStateChanged}
   */
  public static final class GroupReplicationStateChanged extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Notice.GroupReplicationStateChanged)
      GroupReplicationStateChangedOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        GroupReplicationStateChanged.class.getName());
    }
    // Use GroupReplicationStateChanged.newBuilder() to construct.
    private GroupReplicationStateChanged(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private GroupReplicationStateChanged() {
      viewId_ = "";
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_GroupReplicationStateChanged_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_GroupReplicationStateChanged_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged.class, com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged.Builder.class);
    }

    /**
     * Protobuf enum {@code Mysqlx.Notice.GroupReplicationStateChanged.Type}
     */
    public enum Type
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>MEMBERSHIP_QUORUM_LOSS = 1;</code>
       */
      MEMBERSHIP_QUORUM_LOSS(1),
      /**
       * <code>MEMBERSHIP_VIEW_CHANGE = 2;</code>
       */
      MEMBERSHIP_VIEW_CHANGE(2),
      /**
       * <code>MEMBER_ROLE_CHANGE = 3;</code>
       */
      MEMBER_ROLE_CHANGE(3),
      /**
       * <code>MEMBER_STATE_CHANGE = 4;</code>
       */
      MEMBER_STATE_CHANGE(4),
      ;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 29,
          /* patch= */ 0,
          /* suffix= */ "",
          Type.class.getName());
      }
      /**
       * <code>MEMBERSHIP_QUORUM_LOSS = 1;</code>
       */
      public static final int MEMBERSHIP_QUORUM_LOSS_VALUE = 1;
      /**
       * <code>MEMBERSHIP_VIEW_CHANGE = 2;</code>
       */
      public static final int MEMBERSHIP_VIEW_CHANGE_VALUE = 2;
      /**
       * <code>MEMBER_ROLE_CHANGE = 3;</code>
       */
      public static final int MEMBER_ROLE_CHANGE_VALUE = 3;
      /**
       * <code>MEMBER_STATE_CHANGE = 4;</code>
       */
      public static final int MEMBER_STATE_CHANGE_VALUE = 4;


      public final int getNumber() {
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Type valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Type forNumber(int value) {
        switch (value) {
          case 1: return MEMBERSHIP_QUORUM_LOSS;
          case 2: return MEMBERSHIP_VIEW_CHANGE;
          case 3: return MEMBER_ROLE_CHANGE;
          case 4: return MEMBER_STATE_CHANGE;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Type> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Type>() {
              public Type findValueByNumber(int number) {
                return Type.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged.getDescriptor().getEnumTypes().get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Type(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Notice.GroupReplicationStateChanged.Type)
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_ = 0;
    /**
     * <pre>
     * * type of group replication event 
     * </pre>
     *
     * <code>required uint32 type = 1;</code>
     * @return Whether the type field is set.
     */
    @java.lang.Override
    public boolean hasType() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * * type of group replication event 
     * </pre>
     *
     * <code>required uint32 type = 1;</code>
     * @return The type.
     */
    @java.lang.Override
    public int getType() {
      return type_;
    }

    public static final int VIEW_ID_FIELD_NUMBER = 2;
    @SuppressWarnings("serial")
    private volatile java.lang.Object viewId_ = "";
    /**
     * <pre>
     * * view identifier 
     * </pre>
     *
     * <code>optional string view_id = 2;</code>
     * @return Whether the viewId field is set.
     */
    @java.lang.Override
    public boolean hasViewId() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * * view identifier 
     * </pre>
     *
     * <code>optional string view_id = 2;</code>
     * @return The viewId.
     */
    @java.lang.Override
    public java.lang.String getViewId() {
      java.lang.Object ref = viewId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          viewId_ = s;
        }
        return s;
      }
    }
    /**
     * <pre>
     * * view identifier 
     * </pre>
     *
     * <code>optional string view_id = 2;</code>
     * @return The bytes for viewId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString
        getViewIdBytes() {
      java.lang.Object ref = viewId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        viewId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasType()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeUInt32(1, type_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        com.google.protobuf.GeneratedMessage.writeString(output, 2, viewId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, type_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.GeneratedMessage.computeStringSize(2, viewId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged other = (com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged) obj;

      if (hasType() != other.hasType()) return false;
      if (hasType()) {
        if (getType()
            != other.getType()) return false;
      }
      if (hasViewId() != other.hasViewId()) return false;
      if (hasViewId()) {
        if (!getViewId()
            .equals(other.getViewId())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + getType();
      }
      if (hasViewId()) {
        hash = (37 * hash) + VIEW_ID_FIELD_NUMBER;
        hash = (53 * hash) + getViewId().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Notify clients about group replication state changes
     *
     * | &#64;ref Mysqlx::Notice::Frame Field  | Value      |
     * |-----------------------------------|------------|
     * |``.type``                          | 4          |
     * |``.scope``                         | ``global`` |
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Notice.GroupReplicationStateChanged}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Notice.GroupReplicationStateChanged)
        com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChangedOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_GroupReplicationStateChanged_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_GroupReplicationStateChanged_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged.class, com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = 0;
        viewId_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_GroupReplicationStateChanged_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged build() {
        com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged result = new com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.viewId_ = viewId_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged.getDefaultInstance()) return this;
        if (other.hasType()) {
          setType(other.getType());
        }
        if (other.hasViewId()) {
          viewId_ = other.viewId_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasType()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                type_ = input.readUInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              case 18: {
                viewId_ = input.readBytes();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int type_ ;
      /**
       * <pre>
       * * type of group replication event 
       * </pre>
       *
       * <code>required uint32 type = 1;</code>
       * @return Whether the type field is set.
       */
      @java.lang.Override
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * * type of group replication event 
       * </pre>
       *
       * <code>required uint32 type = 1;</code>
       * @return The type.
       */
      @java.lang.Override
      public int getType() {
        return type_;
      }
      /**
       * <pre>
       * * type of group replication event 
       * </pre>
       *
       * <code>required uint32 type = 1;</code>
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(int value) {

        type_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * type of group replication event 
       * </pre>
       *
       * <code>required uint32 type = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object viewId_ = "";
      /**
       * <pre>
       * * view identifier 
       * </pre>
       *
       * <code>optional string view_id = 2;</code>
       * @return Whether the viewId field is set.
       */
      public boolean hasViewId() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * * view identifier 
       * </pre>
       *
       * <code>optional string view_id = 2;</code>
       * @return The viewId.
       */
      public java.lang.String getViewId() {
        java.lang.Object ref = viewId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs =
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            viewId_ = s;
          }
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <pre>
       * * view identifier 
       * </pre>
       *
       * <code>optional string view_id = 2;</code>
       * @return The bytes for viewId.
       */
      public com.google.protobuf.ByteString
          getViewIdBytes() {
        java.lang.Object ref = viewId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          viewId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <pre>
       * * view identifier 
       * </pre>
       *
       * <code>optional string view_id = 2;</code>
       * @param value The viewId to set.
       * @return This builder for chaining.
       */
      public Builder setViewId(
          java.lang.String value) {
        if (value == null) { throw new NullPointerException(); }
        viewId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * view identifier 
       * </pre>
       *
       * <code>optional string view_id = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearViewId() {
        viewId_ = getDefaultInstance().getViewId();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * view identifier 
       * </pre>
       *
       * <code>optional string view_id = 2;</code>
       * @param value The bytes for viewId to set.
       * @return This builder for chaining.
       */
      public Builder setViewIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) { throw new NullPointerException(); }
        viewId_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Notice.GroupReplicationStateChanged)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Notice.GroupReplicationStateChanged)
    private static final com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged();
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GroupReplicationStateChanged>
        PARSER = new com.google.protobuf.AbstractParser<GroupReplicationStateChanged>() {
      @java.lang.Override
      public GroupReplicationStateChanged parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<GroupReplicationStateChanged> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GroupReplicationStateChanged> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxNotice.GroupReplicationStateChanged getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ServerHelloOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Notice.ServerHello)
      com.google.protobuf.MessageOrBuilder {
  }
  /**
   * <pre>
   * *
   * Notify clients about connection to X Protocol server
   *
   * | &#64;ref Mysqlx::Notice::Frame Field  | Value      |
   * |-----------------------------------|------------|
   * |``.type``                          | 5          |
   * |``.scope``                         | ``global`` |
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Notice.ServerHello}
   */
  public static final class ServerHello extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Notice.ServerHello)
      ServerHelloOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        ServerHello.class.getName());
    }
    // Use ServerHello.newBuilder() to construct.
    private ServerHello(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private ServerHello() {
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_ServerHello_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_ServerHello_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello.class, com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello.Builder.class);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello other = (com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello) obj;

      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Notify clients about connection to X Protocol server
     *
     * | &#64;ref Mysqlx::Notice::Frame Field  | Value      |
     * |-----------------------------------|------------|
     * |``.type``                          | 5          |
     * |``.scope``                         | ``global`` |
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Notice.ServerHello}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Notice.ServerHello)
        com.mysql.cj.x.protobuf.MysqlxNotice.ServerHelloOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_ServerHello_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_ServerHello_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello.class, com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.internal_static_Mysqlx_Notice_ServerHello_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello build() {
        com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello result = new com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello(this);
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello.getDefaultInstance()) return this;
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Notice.ServerHello)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Notice.ServerHello)
    private static final com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello();
    }

    public static com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ServerHello>
        PARSER = new com.google.protobuf.AbstractParser<ServerHello>() {
      @java.lang.Override
      public ServerHello parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<ServerHello> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ServerHello> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxNotice.ServerHello getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Notice_Frame_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Notice_Frame_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Notice_Warning_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Notice_Warning_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Notice_SessionVariableChanged_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Notice_SessionVariableChanged_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Notice_SessionStateChanged_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Notice_SessionStateChanged_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Notice_GroupReplicationStateChanged_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Notice_GroupReplicationStateChanged_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Notice_ServerHello_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Notice_ServerHello_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\023mysqlx_notice.proto\022\rMysqlx.Notice\032\014my" +
      "sqlx.proto\032\026mysqlx_datatypes.proto\"\205\002\n\005F" +
      "rame\022\014\n\004type\030\001 \002(\r\0221\n\005scope\030\002 \001(\0162\032.Mysq" +
      "lx.Notice.Frame.Scope:\006GLOBAL\022\017\n\007payload" +
      "\030\003 \001(\014\"\036\n\005Scope\022\n\n\006GLOBAL\020\001\022\t\n\005LOCAL\020\002\"\203" +
      "\001\n\004Type\022\013\n\007WARNING\020\001\022\034\n\030SESSION_VARIABLE" +
      "_CHANGED\020\002\022\031\n\025SESSION_STATE_CHANGED\020\003\022#\n" +
      "\037GROUP_REPLICATION_STATE_CHANGED\020\004\022\020\n\014SE" +
      "RVER_HELLO\020\005:\004\220\3520\013\"\205\001\n\007Warning\0224\n\005level\030" +
      "\001 \001(\0162\034.Mysqlx.Notice.Warning.Level:\007WAR" +
      "NING\022\014\n\004code\030\002 \002(\r\022\013\n\003msg\030\003 \002(\t\")\n\005Level" +
      "\022\010\n\004NOTE\020\001\022\013\n\007WARNING\020\002\022\t\n\005ERROR\020\003\"P\n\026Se" +
      "ssionVariableChanged\022\r\n\005param\030\001 \002(\t\022\'\n\005v" +
      "alue\030\002 \001(\0132\030.Mysqlx.Datatypes.Scalar\"\361\002\n" +
      "\023SessionStateChanged\022;\n\005param\030\001 \002(\0162,.My" +
      "sqlx.Notice.SessionStateChanged.Paramete" +
      "r\022\'\n\005value\030\002 \003(\0132\030.Mysqlx.Datatypes.Scal" +
      "ar\"\363\001\n\tParameter\022\022\n\016CURRENT_SCHEMA\020\001\022\023\n\017" +
      "ACCOUNT_EXPIRED\020\002\022\027\n\023GENERATED_INSERT_ID" +
      "\020\003\022\021\n\rROWS_AFFECTED\020\004\022\016\n\nROWS_FOUND\020\005\022\020\n" +
      "\014ROWS_MATCHED\020\006\022\021\n\rTRX_COMMITTED\020\007\022\022\n\016TR" +
      "X_ROLLEDBACK\020\t\022\024\n\020PRODUCED_MESSAGE\020\n\022\026\n\022" +
      "CLIENT_ID_ASSIGNED\020\013\022\032\n\026GENERATED_DOCUME" +
      "NT_IDS\020\014\"\256\001\n\034GroupReplicationStateChange" +
      "d\022\014\n\004type\030\001 \002(\r\022\017\n\007view_id\030\002 \001(\t\"o\n\004Type" +
      "\022\032\n\026MEMBERSHIP_QUORUM_LOSS\020\001\022\032\n\026MEMBERSH" +
      "IP_VIEW_CHANGE\020\002\022\026\n\022MEMBER_ROLE_CHANGE\020\003" +
      "\022\027\n\023MEMBER_STATE_CHANGE\020\004\"\r\n\013ServerHello" +
      "B\031\n\027com.mysql.cj.x.protobuf"
    };
    descriptor = com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          com.mysql.cj.x.protobuf.Mysqlx.getDescriptor(),
          com.mysql.cj.x.protobuf.MysqlxDatatypes.getDescriptor(),
        });
    internal_static_Mysqlx_Notice_Frame_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Mysqlx_Notice_Frame_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Notice_Frame_descriptor,
        new java.lang.String[] { "Type", "Scope", "Payload", });
    internal_static_Mysqlx_Notice_Warning_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Mysqlx_Notice_Warning_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Notice_Warning_descriptor,
        new java.lang.String[] { "Level", "Code", "Msg", });
    internal_static_Mysqlx_Notice_SessionVariableChanged_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_Mysqlx_Notice_SessionVariableChanged_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Notice_SessionVariableChanged_descriptor,
        new java.lang.String[] { "Param", "Value", });
    internal_static_Mysqlx_Notice_SessionStateChanged_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_Mysqlx_Notice_SessionStateChanged_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Notice_SessionStateChanged_descriptor,
        new java.lang.String[] { "Param", "Value", });
    internal_static_Mysqlx_Notice_GroupReplicationStateChanged_descriptor =
      getDescriptor().getMessageTypes().get(4);
    internal_static_Mysqlx_Notice_GroupReplicationStateChanged_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Notice_GroupReplicationStateChanged_descriptor,
        new java.lang.String[] { "Type", "ViewId", });
    internal_static_Mysqlx_Notice_ServerHello_descriptor =
      getDescriptor().getMessageTypes().get(5);
    internal_static_Mysqlx_Notice_ServerHello_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Notice_ServerHello_descriptor,
        new java.lang.String[] { });
    descriptor.resolveAllFeaturesImmutable();
    com.mysql.cj.x.protobuf.Mysqlx.getDescriptor();
    com.mysql.cj.x.protobuf.MysqlxDatatypes.getDescriptor();
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(com.mysql.cj.x.protobuf.Mysqlx.serverMessageId);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
  }

  // @@protoc_insertion_point(outer_class_scope)
}
