/*
 * Copyright (c) 2015, 2025, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License, version 2.0, as published by
 * the Free Software Foundation.
 *
 * This program is designed to work with certain software that is licensed under separate terms, as designated in a particular file or component or in
 * included license documentation. The authors of MySQL hereby grant you an additional permission to link the program and your derivative works with the
 * separately licensed software that they have either included with the program or referenced in the documentation.
 *
 * Without limiting anything contained in the foregoing, this file, which is part of MySQL Connector/J, is also subject to the Universal FOSS Exception,
 * version 1.0, a copy of which can be found at http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

package com.mysql.cj.x.protobuf;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: mysqlx_cursor.proto
// Protobuf Java Version: 4.29.0

public final class MysqlxCursor {
  private MysqlxCursor() {}
  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
      com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
      /* major= */ 4,
      /* minor= */ 29,
      /* patch= */ 0,
      /* suffix= */ "",
      MysqlxCursor.class.getName());
  }
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  public interface OpenOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Cursor.Open)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * * client-side assigned cursor ID; the ID is going to represent
     * the new cursor and assigned to it the statement 
     * </pre>
     *
     * <code>required uint32 cursor_id = 1;</code>
     * @return Whether the cursorId field is set.
     */
    boolean hasCursorId();
    /**
     * <pre>
     * * client-side assigned cursor ID; the ID is going to represent
     * the new cursor and assigned to it the statement 
     * </pre>
     *
     * <code>required uint32 cursor_id = 1;</code>
     * @return The cursorId.
     */
    int getCursorId();

    /**
     * <pre>
     * * statement for which the resultset is going to be iterated through by the cursor 
     * </pre>
     *
     * <code>required .Mysqlx.Cursor.Open.OneOfMessage stmt = 4;</code>
     * @return Whether the stmt field is set.
     */
    boolean hasStmt();
    /**
     * <pre>
     * * statement for which the resultset is going to be iterated through by the cursor 
     * </pre>
     *
     * <code>required .Mysqlx.Cursor.Open.OneOfMessage stmt = 4;</code>
     * @return The stmt.
     */
    com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage getStmt();
    /**
     * <pre>
     * * statement for which the resultset is going to be iterated through by the cursor 
     * </pre>
     *
     * <code>required .Mysqlx.Cursor.Open.OneOfMessage stmt = 4;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessageOrBuilder getStmtOrBuilder();

    /**
     * <pre>
     * * number of rows that should be retrieved from sequential cursor 
     * </pre>
     *
     * <code>optional uint64 fetch_rows = 5;</code>
     * @return Whether the fetchRows field is set.
     */
    boolean hasFetchRows();
    /**
     * <pre>
     * * number of rows that should be retrieved from sequential cursor 
     * </pre>
     *
     * <code>optional uint64 fetch_rows = 5;</code>
     * @return The fetchRows.
     */
    long getFetchRows();
  }
  /**
   * <pre>
   * *
   * Open a cursor
   *
   * &#64;startuml
   * client -&gt; server: Open
   * alt Success
   * ... none or partial Resultsets or full Resultsets ...
   * client &lt;- server: StmtExecuteOk
   * else Failure
   * client &lt;- server: Error
   * end alt
   * &#64;enduml
   *
   * &#64;returns &#64;ref Mysqlx::Ok
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Cursor.Open}
   */
  public static final class Open extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Cursor.Open)
      OpenOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        Open.class.getName());
    }
    // Use Open.newBuilder() to construct.
    private Open(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Open() {
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Open_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Open_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxCursor.Open.class, com.mysql.cj.x.protobuf.MysqlxCursor.Open.Builder.class);
    }

    public interface OneOfMessageOrBuilder extends
        // @@protoc_insertion_point(interface_extends:Mysqlx.Cursor.Open.OneOfMessage)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <code>required .Mysqlx.Cursor.Open.OneOfMessage.Type type = 1;</code>
       * @return Whether the type field is set.
       */
      boolean hasType();
      /**
       * <code>required .Mysqlx.Cursor.Open.OneOfMessage.Type type = 1;</code>
       * @return The type.
       */
      com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Type getType();

      /**
       * <code>optional .Mysqlx.Prepare.Execute prepare_execute = 2;</code>
       * @return Whether the prepareExecute field is set.
       */
      boolean hasPrepareExecute();
      /**
       * <code>optional .Mysqlx.Prepare.Execute prepare_execute = 2;</code>
       * @return The prepareExecute.
       */
      com.mysql.cj.x.protobuf.MysqlxPrepare.Execute getPrepareExecute();
      /**
       * <code>optional .Mysqlx.Prepare.Execute prepare_execute = 2;</code>
       */
      com.mysql.cj.x.protobuf.MysqlxPrepare.ExecuteOrBuilder getPrepareExecuteOrBuilder();
    }
    /**
     * Protobuf type {@code Mysqlx.Cursor.Open.OneOfMessage}
     */
    public static final class OneOfMessage extends
        com.google.protobuf.GeneratedMessage implements
        // @@protoc_insertion_point(message_implements:Mysqlx.Cursor.Open.OneOfMessage)
        OneOfMessageOrBuilder {
    private static final long serialVersionUID = 0L;
      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 29,
          /* patch= */ 0,
          /* suffix= */ "",
          OneOfMessage.class.getName());
      }
      // Use OneOfMessage.newBuilder() to construct.
      private OneOfMessage(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }
      private OneOfMessage() {
        type_ = 0;
      }

      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Open_OneOfMessage_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Open_OneOfMessage_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.class, com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Builder.class);
      }

      /**
       * Protobuf enum {@code Mysqlx.Cursor.Open.OneOfMessage.Type}
       */
      public enum Type
          implements com.google.protobuf.ProtocolMessageEnum {
        /**
         * <code>PREPARE_EXECUTE = 0;</code>
         */
        PREPARE_EXECUTE(0),
        ;

        static {
          com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
            com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
            /* major= */ 4,
            /* minor= */ 29,
            /* patch= */ 0,
            /* suffix= */ "",
            Type.class.getName());
        }
        /**
         * <code>PREPARE_EXECUTE = 0;</code>
         */
        public static final int PREPARE_EXECUTE_VALUE = 0;


        public final int getNumber() {
          return value;
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static Type valueOf(int value) {
          return forNumber(value);
        }

        /**
         * @param value The numeric wire value of the corresponding enum entry.
         * @return The enum associated with the given numeric wire value.
         */
        public static Type forNumber(int value) {
          switch (value) {
            case 0: return PREPARE_EXECUTE;
            default: return null;
          }
        }

        public static com.google.protobuf.Internal.EnumLiteMap<Type>
            internalGetValueMap() {
          return internalValueMap;
        }
        private static final com.google.protobuf.Internal.EnumLiteMap<
            Type> internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<Type>() {
                public Type findValueByNumber(int number) {
                  return Type.forNumber(number);
                }
              };

        public final com.google.protobuf.Descriptors.EnumValueDescriptor
            getValueDescriptor() {
          return getDescriptor().getValues().get(ordinal());
        }
        public final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptorForType() {
          return getDescriptor();
        }
        public static final com.google.protobuf.Descriptors.EnumDescriptor
            getDescriptor() {
          return com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.getDescriptor().getEnumTypes().get(0);
        }

        private static final Type[] VALUES = values();

        public static Type valueOf(
            com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
          if (desc.getType() != getDescriptor()) {
            throw new java.lang.IllegalArgumentException(
              "EnumValueDescriptor is not for this type.");
          }
          return VALUES[desc.getIndex()];
        }

        private final int value;

        private Type(int value) {
          this.value = value;
        }

        // @@protoc_insertion_point(enum_scope:Mysqlx.Cursor.Open.OneOfMessage.Type)
      }

      private int bitField0_;
      public static final int TYPE_FIELD_NUMBER = 1;
      private int type_ = 0;
      /**
       * <code>required .Mysqlx.Cursor.Open.OneOfMessage.Type type = 1;</code>
       * @return Whether the type field is set.
       */
      @java.lang.Override public boolean hasType() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .Mysqlx.Cursor.Open.OneOfMessage.Type type = 1;</code>
       * @return The type.
       */
      @java.lang.Override public com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Type getType() {
        com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Type result = com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Type.forNumber(type_);
        return result == null ? com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Type.PREPARE_EXECUTE : result;
      }

      public static final int PREPARE_EXECUTE_FIELD_NUMBER = 2;
      private com.mysql.cj.x.protobuf.MysqlxPrepare.Execute prepareExecute_;
      /**
       * <code>optional .Mysqlx.Prepare.Execute prepare_execute = 2;</code>
       * @return Whether the prepareExecute field is set.
       */
      @java.lang.Override
      public boolean hasPrepareExecute() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional .Mysqlx.Prepare.Execute prepare_execute = 2;</code>
       * @return The prepareExecute.
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxPrepare.Execute getPrepareExecute() {
        return prepareExecute_ == null ? com.mysql.cj.x.protobuf.MysqlxPrepare.Execute.getDefaultInstance() : prepareExecute_;
      }
      /**
       * <code>optional .Mysqlx.Prepare.Execute prepare_execute = 2;</code>
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxPrepare.ExecuteOrBuilder getPrepareExecuteOrBuilder() {
        return prepareExecute_ == null ? com.mysql.cj.x.protobuf.MysqlxPrepare.Execute.getDefaultInstance() : prepareExecute_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasType()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (hasPrepareExecute()) {
          if (!getPrepareExecute().isInitialized()) {
            memoizedIsInitialized = 0;
            return false;
          }
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeEnum(1, type_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getPrepareExecute());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeEnumSize(1, type_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, getPrepareExecute());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage)) {
          return super.equals(obj);
        }
        com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage other = (com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage) obj;

        if (hasType() != other.hasType()) return false;
        if (hasType()) {
          if (type_ != other.type_) return false;
        }
        if (hasPrepareExecute() != other.hasPrepareExecute()) return false;
        if (hasPrepareExecute()) {
          if (!getPrepareExecute()
              .equals(other.getPrepareExecute())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasType()) {
          hash = (37 * hash) + TYPE_FIELD_NUMBER;
          hash = (53 * hash) + type_;
        }
        if (hasPrepareExecute()) {
          hash = (37 * hash) + PREPARE_EXECUTE_FIELD_NUMBER;
          hash = (53 * hash) + getPrepareExecute().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public static com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseDelimitedWithIOException(PARSER, input);
      }

      public static com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code Mysqlx.Cursor.Open.OneOfMessage}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessage.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:Mysqlx.Cursor.Open.OneOfMessage)
          com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessageOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Open_OneOfMessage_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Open_OneOfMessage_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.class, com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Builder.class);
        }

        // Construct using com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessage
                  .alwaysUseFieldBuilders) {
            getPrepareExecuteFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          type_ = 0;
          prepareExecute_ = null;
          if (prepareExecuteBuilder_ != null) {
            prepareExecuteBuilder_.dispose();
            prepareExecuteBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Open_OneOfMessage_descriptor;
        }

        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage getDefaultInstanceForType() {
          return com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.getDefaultInstance();
        }

        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage build() {
          com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage buildPartial() {
          com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage result = new com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage(this);
          if (bitField0_ != 0) { buildPartial0(result); }
          onBuilt();
          return result;
        }

        private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.type_ = type_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.prepareExecute_ = prepareExecuteBuilder_ == null
                ? prepareExecute_
                : prepareExecuteBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage) {
            return mergeFrom((com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage other) {
          if (other == com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.getDefaultInstance()) return this;
          if (other.hasType()) {
            setType(other.getType());
          }
          if (other.hasPrepareExecute()) {
            mergePrepareExecute(other.getPrepareExecute());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (!hasType()) {
            return false;
          }
          if (hasPrepareExecute()) {
            if (!getPrepareExecute().isInitialized()) {
              return false;
            }
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8: {
                  int tmpRaw = input.readEnum();
                  com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Type tmpValue =
                      com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Type.forNumber(tmpRaw);
                  if (tmpValue == null) {
                    mergeUnknownVarintField(1, tmpRaw);
                  } else {
                    type_ = tmpRaw;
                    bitField0_ |= 0x00000001;
                  }
                  break;
                } // case 8
                case 18: {
                  input.readMessage(
                      getPrepareExecuteFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        private int bitField0_;

        private int type_ = 0;
        /**
         * <code>required .Mysqlx.Cursor.Open.OneOfMessage.Type type = 1;</code>
         * @return Whether the type field is set.
         */
        @java.lang.Override public boolean hasType() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>required .Mysqlx.Cursor.Open.OneOfMessage.Type type = 1;</code>
         * @return The type.
         */
        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Type getType() {
          com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Type result = com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Type.forNumber(type_);
          return result == null ? com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Type.PREPARE_EXECUTE : result;
        }
        /**
         * <code>required .Mysqlx.Cursor.Open.OneOfMessage.Type type = 1;</code>
         * @param value The type to set.
         * @return This builder for chaining.
         */
        public Builder setType(com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Type value) {
          if (value == null) {
            throw new NullPointerException();
          }
          bitField0_ |= 0x00000001;
          type_ = value.getNumber();
          onChanged();
          return this;
        }
        /**
         * <code>required .Mysqlx.Cursor.Open.OneOfMessage.Type type = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearType() {
          bitField0_ = (bitField0_ & ~0x00000001);
          type_ = 0;
          onChanged();
          return this;
        }

        private com.mysql.cj.x.protobuf.MysqlxPrepare.Execute prepareExecute_;
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxPrepare.Execute, com.mysql.cj.x.protobuf.MysqlxPrepare.Execute.Builder, com.mysql.cj.x.protobuf.MysqlxPrepare.ExecuteOrBuilder> prepareExecuteBuilder_;
        /**
         * <code>optional .Mysqlx.Prepare.Execute prepare_execute = 2;</code>
         * @return Whether the prepareExecute field is set.
         */
        public boolean hasPrepareExecute() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>optional .Mysqlx.Prepare.Execute prepare_execute = 2;</code>
         * @return The prepareExecute.
         */
        public com.mysql.cj.x.protobuf.MysqlxPrepare.Execute getPrepareExecute() {
          if (prepareExecuteBuilder_ == null) {
            return prepareExecute_ == null ? com.mysql.cj.x.protobuf.MysqlxPrepare.Execute.getDefaultInstance() : prepareExecute_;
          } else {
            return prepareExecuteBuilder_.getMessage();
          }
        }
        /**
         * <code>optional .Mysqlx.Prepare.Execute prepare_execute = 2;</code>
         */
        public Builder setPrepareExecute(com.mysql.cj.x.protobuf.MysqlxPrepare.Execute value) {
          if (prepareExecuteBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            prepareExecute_ = value;
          } else {
            prepareExecuteBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Prepare.Execute prepare_execute = 2;</code>
         */
        public Builder setPrepareExecute(
            com.mysql.cj.x.protobuf.MysqlxPrepare.Execute.Builder builderForValue) {
          if (prepareExecuteBuilder_ == null) {
            prepareExecute_ = builderForValue.build();
          } else {
            prepareExecuteBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Prepare.Execute prepare_execute = 2;</code>
         */
        public Builder mergePrepareExecute(com.mysql.cj.x.protobuf.MysqlxPrepare.Execute value) {
          if (prepareExecuteBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0) &&
              prepareExecute_ != null &&
              prepareExecute_ != com.mysql.cj.x.protobuf.MysqlxPrepare.Execute.getDefaultInstance()) {
              getPrepareExecuteBuilder().mergeFrom(value);
            } else {
              prepareExecute_ = value;
            }
          } else {
            prepareExecuteBuilder_.mergeFrom(value);
          }
          if (prepareExecute_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         * <code>optional .Mysqlx.Prepare.Execute prepare_execute = 2;</code>
         */
        public Builder clearPrepareExecute() {
          bitField0_ = (bitField0_ & ~0x00000002);
          prepareExecute_ = null;
          if (prepareExecuteBuilder_ != null) {
            prepareExecuteBuilder_.dispose();
            prepareExecuteBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>optional .Mysqlx.Prepare.Execute prepare_execute = 2;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxPrepare.Execute.Builder getPrepareExecuteBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getPrepareExecuteFieldBuilder().getBuilder();
        }
        /**
         * <code>optional .Mysqlx.Prepare.Execute prepare_execute = 2;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxPrepare.ExecuteOrBuilder getPrepareExecuteOrBuilder() {
          if (prepareExecuteBuilder_ != null) {
            return prepareExecuteBuilder_.getMessageOrBuilder();
          } else {
            return prepareExecute_ == null ?
                com.mysql.cj.x.protobuf.MysqlxPrepare.Execute.getDefaultInstance() : prepareExecute_;
          }
        }
        /**
         * <code>optional .Mysqlx.Prepare.Execute prepare_execute = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxPrepare.Execute, com.mysql.cj.x.protobuf.MysqlxPrepare.Execute.Builder, com.mysql.cj.x.protobuf.MysqlxPrepare.ExecuteOrBuilder> 
            getPrepareExecuteFieldBuilder() {
          if (prepareExecuteBuilder_ == null) {
            prepareExecuteBuilder_ = new com.google.protobuf.SingleFieldBuilder<
                com.mysql.cj.x.protobuf.MysqlxPrepare.Execute, com.mysql.cj.x.protobuf.MysqlxPrepare.Execute.Builder, com.mysql.cj.x.protobuf.MysqlxPrepare.ExecuteOrBuilder>(
                    getPrepareExecute(),
                    getParentForChildren(),
                    isClean());
            prepareExecute_ = null;
          }
          return prepareExecuteBuilder_;
        }

        // @@protoc_insertion_point(builder_scope:Mysqlx.Cursor.Open.OneOfMessage)
      }

      // @@protoc_insertion_point(class_scope:Mysqlx.Cursor.Open.OneOfMessage)
      private static final com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage();
      }

      public static com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<OneOfMessage>
          PARSER = new com.google.protobuf.AbstractParser<OneOfMessage>() {
        @java.lang.Override
        public OneOfMessage parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static com.google.protobuf.Parser<OneOfMessage> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<OneOfMessage> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int CURSOR_ID_FIELD_NUMBER = 1;
    private int cursorId_ = 0;
    /**
     * <pre>
     * * client-side assigned cursor ID; the ID is going to represent
     * the new cursor and assigned to it the statement 
     * </pre>
     *
     * <code>required uint32 cursor_id = 1;</code>
     * @return Whether the cursorId field is set.
     */
    @java.lang.Override
    public boolean hasCursorId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * * client-side assigned cursor ID; the ID is going to represent
     * the new cursor and assigned to it the statement 
     * </pre>
     *
     * <code>required uint32 cursor_id = 1;</code>
     * @return The cursorId.
     */
    @java.lang.Override
    public int getCursorId() {
      return cursorId_;
    }

    public static final int STMT_FIELD_NUMBER = 4;
    private com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage stmt_;
    /**
     * <pre>
     * * statement for which the resultset is going to be iterated through by the cursor 
     * </pre>
     *
     * <code>required .Mysqlx.Cursor.Open.OneOfMessage stmt = 4;</code>
     * @return Whether the stmt field is set.
     */
    @java.lang.Override
    public boolean hasStmt() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * * statement for which the resultset is going to be iterated through by the cursor 
     * </pre>
     *
     * <code>required .Mysqlx.Cursor.Open.OneOfMessage stmt = 4;</code>
     * @return The stmt.
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage getStmt() {
      return stmt_ == null ? com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.getDefaultInstance() : stmt_;
    }
    /**
     * <pre>
     * * statement for which the resultset is going to be iterated through by the cursor 
     * </pre>
     *
     * <code>required .Mysqlx.Cursor.Open.OneOfMessage stmt = 4;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessageOrBuilder getStmtOrBuilder() {
      return stmt_ == null ? com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.getDefaultInstance() : stmt_;
    }

    public static final int FETCH_ROWS_FIELD_NUMBER = 5;
    private long fetchRows_ = 0L;
    /**
     * <pre>
     * * number of rows that should be retrieved from sequential cursor 
     * </pre>
     *
     * <code>optional uint64 fetch_rows = 5;</code>
     * @return Whether the fetchRows field is set.
     */
    @java.lang.Override
    public boolean hasFetchRows() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * * number of rows that should be retrieved from sequential cursor 
     * </pre>
     *
     * <code>optional uint64 fetch_rows = 5;</code>
     * @return The fetchRows.
     */
    @java.lang.Override
    public long getFetchRows() {
      return fetchRows_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasCursorId()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasStmt()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!getStmt().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeUInt32(1, cursorId_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(4, getStmt());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeUInt64(5, fetchRows_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, cursorId_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getStmt());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(5, fetchRows_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxCursor.Open)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxCursor.Open other = (com.mysql.cj.x.protobuf.MysqlxCursor.Open) obj;

      if (hasCursorId() != other.hasCursorId()) return false;
      if (hasCursorId()) {
        if (getCursorId()
            != other.getCursorId()) return false;
      }
      if (hasStmt() != other.hasStmt()) return false;
      if (hasStmt()) {
        if (!getStmt()
            .equals(other.getStmt())) return false;
      }
      if (hasFetchRows() != other.hasFetchRows()) return false;
      if (hasFetchRows()) {
        if (getFetchRows()
            != other.getFetchRows()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCursorId()) {
        hash = (37 * hash) + CURSOR_ID_FIELD_NUMBER;
        hash = (53 * hash) + getCursorId();
      }
      if (hasStmt()) {
        hash = (37 * hash) + STMT_FIELD_NUMBER;
        hash = (53 * hash) + getStmt().hashCode();
      }
      if (hasFetchRows()) {
        hash = (37 * hash) + FETCH_ROWS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getFetchRows());
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxCursor.Open parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Open parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Open parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Open parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Open parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Open parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Open parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Open parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxCursor.Open parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxCursor.Open parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Open parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Open parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxCursor.Open prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Open a cursor
     *
     * &#64;startuml
     * client -&gt; server: Open
     * alt Success
     * ... none or partial Resultsets or full Resultsets ...
     * client &lt;- server: StmtExecuteOk
     * else Failure
     * client &lt;- server: Error
     * end alt
     * &#64;enduml
     *
     * &#64;returns &#64;ref Mysqlx::Ok
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Cursor.Open}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Cursor.Open)
        com.mysql.cj.x.protobuf.MysqlxCursor.OpenOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Open_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Open_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxCursor.Open.class, com.mysql.cj.x.protobuf.MysqlxCursor.Open.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxCursor.Open.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage
                .alwaysUseFieldBuilders) {
          getStmtFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        cursorId_ = 0;
        stmt_ = null;
        if (stmtBuilder_ != null) {
          stmtBuilder_.dispose();
          stmtBuilder_ = null;
        }
        fetchRows_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Open_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxCursor.Open getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxCursor.Open.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxCursor.Open build() {
        com.mysql.cj.x.protobuf.MysqlxCursor.Open result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxCursor.Open buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxCursor.Open result = new com.mysql.cj.x.protobuf.MysqlxCursor.Open(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxCursor.Open result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.cursorId_ = cursorId_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.stmt_ = stmtBuilder_ == null
              ? stmt_
              : stmtBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.fetchRows_ = fetchRows_;
          to_bitField0_ |= 0x00000004;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxCursor.Open) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxCursor.Open)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxCursor.Open other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxCursor.Open.getDefaultInstance()) return this;
        if (other.hasCursorId()) {
          setCursorId(other.getCursorId());
        }
        if (other.hasStmt()) {
          mergeStmt(other.getStmt());
        }
        if (other.hasFetchRows()) {
          setFetchRows(other.getFetchRows());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasCursorId()) {
          return false;
        }
        if (!hasStmt()) {
          return false;
        }
        if (!getStmt().isInitialized()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                cursorId_ = input.readUInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              case 34: {
                input.readMessage(
                    getStmtFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 34
              case 40: {
                fetchRows_ = input.readUInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 40
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int cursorId_ ;
      /**
       * <pre>
       * * client-side assigned cursor ID; the ID is going to represent
       * the new cursor and assigned to it the statement 
       * </pre>
       *
       * <code>required uint32 cursor_id = 1;</code>
       * @return Whether the cursorId field is set.
       */
      @java.lang.Override
      public boolean hasCursorId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * * client-side assigned cursor ID; the ID is going to represent
       * the new cursor and assigned to it the statement 
       * </pre>
       *
       * <code>required uint32 cursor_id = 1;</code>
       * @return The cursorId.
       */
      @java.lang.Override
      public int getCursorId() {
        return cursorId_;
      }
      /**
       * <pre>
       * * client-side assigned cursor ID; the ID is going to represent
       * the new cursor and assigned to it the statement 
       * </pre>
       *
       * <code>required uint32 cursor_id = 1;</code>
       * @param value The cursorId to set.
       * @return This builder for chaining.
       */
      public Builder setCursorId(int value) {

        cursorId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * client-side assigned cursor ID; the ID is going to represent
       * the new cursor and assigned to it the statement 
       * </pre>
       *
       * <code>required uint32 cursor_id = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearCursorId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        cursorId_ = 0;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage stmt_;
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage, com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Builder, com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessageOrBuilder> stmtBuilder_;
      /**
       * <pre>
       * * statement for which the resultset is going to be iterated through by the cursor 
       * </pre>
       *
       * <code>required .Mysqlx.Cursor.Open.OneOfMessage stmt = 4;</code>
       * @return Whether the stmt field is set.
       */
      public boolean hasStmt() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * * statement for which the resultset is going to be iterated through by the cursor 
       * </pre>
       *
       * <code>required .Mysqlx.Cursor.Open.OneOfMessage stmt = 4;</code>
       * @return The stmt.
       */
      public com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage getStmt() {
        if (stmtBuilder_ == null) {
          return stmt_ == null ? com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.getDefaultInstance() : stmt_;
        } else {
          return stmtBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * * statement for which the resultset is going to be iterated through by the cursor 
       * </pre>
       *
       * <code>required .Mysqlx.Cursor.Open.OneOfMessage stmt = 4;</code>
       */
      public Builder setStmt(com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage value) {
        if (stmtBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          stmt_ = value;
        } else {
          stmtBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * statement for which the resultset is going to be iterated through by the cursor 
       * </pre>
       *
       * <code>required .Mysqlx.Cursor.Open.OneOfMessage stmt = 4;</code>
       */
      public Builder setStmt(
          com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Builder builderForValue) {
        if (stmtBuilder_ == null) {
          stmt_ = builderForValue.build();
        } else {
          stmtBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * statement for which the resultset is going to be iterated through by the cursor 
       * </pre>
       *
       * <code>required .Mysqlx.Cursor.Open.OneOfMessage stmt = 4;</code>
       */
      public Builder mergeStmt(com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage value) {
        if (stmtBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            stmt_ != null &&
            stmt_ != com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.getDefaultInstance()) {
            getStmtBuilder().mergeFrom(value);
          } else {
            stmt_ = value;
          }
        } else {
          stmtBuilder_.mergeFrom(value);
        }
        if (stmt_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * * statement for which the resultset is going to be iterated through by the cursor 
       * </pre>
       *
       * <code>required .Mysqlx.Cursor.Open.OneOfMessage stmt = 4;</code>
       */
      public Builder clearStmt() {
        bitField0_ = (bitField0_ & ~0x00000002);
        stmt_ = null;
        if (stmtBuilder_ != null) {
          stmtBuilder_.dispose();
          stmtBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * statement for which the resultset is going to be iterated through by the cursor 
       * </pre>
       *
       * <code>required .Mysqlx.Cursor.Open.OneOfMessage stmt = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Builder getStmtBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getStmtFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * * statement for which the resultset is going to be iterated through by the cursor 
       * </pre>
       *
       * <code>required .Mysqlx.Cursor.Open.OneOfMessage stmt = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessageOrBuilder getStmtOrBuilder() {
        if (stmtBuilder_ != null) {
          return stmtBuilder_.getMessageOrBuilder();
        } else {
          return stmt_ == null ?
              com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.getDefaultInstance() : stmt_;
        }
      }
      /**
       * <pre>
       * * statement for which the resultset is going to be iterated through by the cursor 
       * </pre>
       *
       * <code>required .Mysqlx.Cursor.Open.OneOfMessage stmt = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage, com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Builder, com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessageOrBuilder> 
          getStmtFieldBuilder() {
        if (stmtBuilder_ == null) {
          stmtBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage, com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessage.Builder, com.mysql.cj.x.protobuf.MysqlxCursor.Open.OneOfMessageOrBuilder>(
                  getStmt(),
                  getParentForChildren(),
                  isClean());
          stmt_ = null;
        }
        return stmtBuilder_;
      }

      private long fetchRows_ ;
      /**
       * <pre>
       * * number of rows that should be retrieved from sequential cursor 
       * </pre>
       *
       * <code>optional uint64 fetch_rows = 5;</code>
       * @return Whether the fetchRows field is set.
       */
      @java.lang.Override
      public boolean hasFetchRows() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <pre>
       * * number of rows that should be retrieved from sequential cursor 
       * </pre>
       *
       * <code>optional uint64 fetch_rows = 5;</code>
       * @return The fetchRows.
       */
      @java.lang.Override
      public long getFetchRows() {
        return fetchRows_;
      }
      /**
       * <pre>
       * * number of rows that should be retrieved from sequential cursor 
       * </pre>
       *
       * <code>optional uint64 fetch_rows = 5;</code>
       * @param value The fetchRows to set.
       * @return This builder for chaining.
       */
      public Builder setFetchRows(long value) {

        fetchRows_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * number of rows that should be retrieved from sequential cursor 
       * </pre>
       *
       * <code>optional uint64 fetch_rows = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearFetchRows() {
        bitField0_ = (bitField0_ & ~0x00000004);
        fetchRows_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Cursor.Open)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Cursor.Open)
    private static final com.mysql.cj.x.protobuf.MysqlxCursor.Open DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxCursor.Open();
    }

    public static com.mysql.cj.x.protobuf.MysqlxCursor.Open getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Open>
        PARSER = new com.google.protobuf.AbstractParser<Open>() {
      @java.lang.Override
      public Open parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Open> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Open> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxCursor.Open getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface FetchOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Cursor.Fetch)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * * client-side assigned cursor ID; must be already open 
     * </pre>
     *
     * <code>required uint32 cursor_id = 1;</code>
     * @return Whether the cursorId field is set.
     */
    boolean hasCursorId();
    /**
     * <pre>
     * * client-side assigned cursor ID; must be already open 
     * </pre>
     *
     * <code>required uint32 cursor_id = 1;</code>
     * @return The cursorId.
     */
    int getCursorId();

    /**
     * <pre>
     * * number of rows that should be retrieved from sequential cursor 
     * </pre>
     *
     * <code>optional uint64 fetch_rows = 5;</code>
     * @return Whether the fetchRows field is set.
     */
    boolean hasFetchRows();
    /**
     * <pre>
     * * number of rows that should be retrieved from sequential cursor 
     * </pre>
     *
     * <code>optional uint64 fetch_rows = 5;</code>
     * @return The fetchRows.
     */
    long getFetchRows();
  }
  /**
   * <pre>
   * *
   * Fetch next portion of data from a cursor
   *
   * &#64;startuml
   * client -&gt; server: Fetch
   * alt Success
   * ... none or partial Resultsets or full Resultsets ...
   * client &lt;- server: StmtExecuteOk
   * else
   * client &lt;- server: Error
   * end
   * &#64;enduml
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Cursor.Fetch}
   */
  public static final class Fetch extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Cursor.Fetch)
      FetchOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        Fetch.class.getName());
    }
    // Use Fetch.newBuilder() to construct.
    private Fetch(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Fetch() {
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Fetch_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Fetch_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxCursor.Fetch.class, com.mysql.cj.x.protobuf.MysqlxCursor.Fetch.Builder.class);
    }

    private int bitField0_;
    public static final int CURSOR_ID_FIELD_NUMBER = 1;
    private int cursorId_ = 0;
    /**
     * <pre>
     * * client-side assigned cursor ID; must be already open 
     * </pre>
     *
     * <code>required uint32 cursor_id = 1;</code>
     * @return Whether the cursorId field is set.
     */
    @java.lang.Override
    public boolean hasCursorId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * * client-side assigned cursor ID; must be already open 
     * </pre>
     *
     * <code>required uint32 cursor_id = 1;</code>
     * @return The cursorId.
     */
    @java.lang.Override
    public int getCursorId() {
      return cursorId_;
    }

    public static final int FETCH_ROWS_FIELD_NUMBER = 5;
    private long fetchRows_ = 0L;
    /**
     * <pre>
     * * number of rows that should be retrieved from sequential cursor 
     * </pre>
     *
     * <code>optional uint64 fetch_rows = 5;</code>
     * @return Whether the fetchRows field is set.
     */
    @java.lang.Override
    public boolean hasFetchRows() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * * number of rows that should be retrieved from sequential cursor 
     * </pre>
     *
     * <code>optional uint64 fetch_rows = 5;</code>
     * @return The fetchRows.
     */
    @java.lang.Override
    public long getFetchRows() {
      return fetchRows_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasCursorId()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeUInt32(1, cursorId_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeUInt64(5, fetchRows_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, cursorId_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(5, fetchRows_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxCursor.Fetch)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxCursor.Fetch other = (com.mysql.cj.x.protobuf.MysqlxCursor.Fetch) obj;

      if (hasCursorId() != other.hasCursorId()) return false;
      if (hasCursorId()) {
        if (getCursorId()
            != other.getCursorId()) return false;
      }
      if (hasFetchRows() != other.hasFetchRows()) return false;
      if (hasFetchRows()) {
        if (getFetchRows()
            != other.getFetchRows()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCursorId()) {
        hash = (37 * hash) + CURSOR_ID_FIELD_NUMBER;
        hash = (53 * hash) + getCursorId();
      }
      if (hasFetchRows()) {
        hash = (37 * hash) + FETCH_ROWS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getFetchRows());
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxCursor.Fetch parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Fetch parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Fetch parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Fetch parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Fetch parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Fetch parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Fetch parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Fetch parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxCursor.Fetch parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxCursor.Fetch parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Fetch parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Fetch parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxCursor.Fetch prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Fetch next portion of data from a cursor
     *
     * &#64;startuml
     * client -&gt; server: Fetch
     * alt Success
     * ... none or partial Resultsets or full Resultsets ...
     * client &lt;- server: StmtExecuteOk
     * else
     * client &lt;- server: Error
     * end
     * &#64;enduml
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Cursor.Fetch}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Cursor.Fetch)
        com.mysql.cj.x.protobuf.MysqlxCursor.FetchOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Fetch_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Fetch_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxCursor.Fetch.class, com.mysql.cj.x.protobuf.MysqlxCursor.Fetch.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxCursor.Fetch.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        cursorId_ = 0;
        fetchRows_ = 0L;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Fetch_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxCursor.Fetch getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxCursor.Fetch.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxCursor.Fetch build() {
        com.mysql.cj.x.protobuf.MysqlxCursor.Fetch result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxCursor.Fetch buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxCursor.Fetch result = new com.mysql.cj.x.protobuf.MysqlxCursor.Fetch(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxCursor.Fetch result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.cursorId_ = cursorId_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.fetchRows_ = fetchRows_;
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxCursor.Fetch) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxCursor.Fetch)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxCursor.Fetch other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxCursor.Fetch.getDefaultInstance()) return this;
        if (other.hasCursorId()) {
          setCursorId(other.getCursorId());
        }
        if (other.hasFetchRows()) {
          setFetchRows(other.getFetchRows());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasCursorId()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                cursorId_ = input.readUInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              case 40: {
                fetchRows_ = input.readUInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 40
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int cursorId_ ;
      /**
       * <pre>
       * * client-side assigned cursor ID; must be already open 
       * </pre>
       *
       * <code>required uint32 cursor_id = 1;</code>
       * @return Whether the cursorId field is set.
       */
      @java.lang.Override
      public boolean hasCursorId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * * client-side assigned cursor ID; must be already open 
       * </pre>
       *
       * <code>required uint32 cursor_id = 1;</code>
       * @return The cursorId.
       */
      @java.lang.Override
      public int getCursorId() {
        return cursorId_;
      }
      /**
       * <pre>
       * * client-side assigned cursor ID; must be already open 
       * </pre>
       *
       * <code>required uint32 cursor_id = 1;</code>
       * @param value The cursorId to set.
       * @return This builder for chaining.
       */
      public Builder setCursorId(int value) {

        cursorId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * client-side assigned cursor ID; must be already open 
       * </pre>
       *
       * <code>required uint32 cursor_id = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearCursorId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        cursorId_ = 0;
        onChanged();
        return this;
      }

      private long fetchRows_ ;
      /**
       * <pre>
       * * number of rows that should be retrieved from sequential cursor 
       * </pre>
       *
       * <code>optional uint64 fetch_rows = 5;</code>
       * @return Whether the fetchRows field is set.
       */
      @java.lang.Override
      public boolean hasFetchRows() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <pre>
       * * number of rows that should be retrieved from sequential cursor 
       * </pre>
       *
       * <code>optional uint64 fetch_rows = 5;</code>
       * @return The fetchRows.
       */
      @java.lang.Override
      public long getFetchRows() {
        return fetchRows_;
      }
      /**
       * <pre>
       * * number of rows that should be retrieved from sequential cursor 
       * </pre>
       *
       * <code>optional uint64 fetch_rows = 5;</code>
       * @param value The fetchRows to set.
       * @return This builder for chaining.
       */
      public Builder setFetchRows(long value) {

        fetchRows_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * number of rows that should be retrieved from sequential cursor 
       * </pre>
       *
       * <code>optional uint64 fetch_rows = 5;</code>
       * @return This builder for chaining.
       */
      public Builder clearFetchRows() {
        bitField0_ = (bitField0_ & ~0x00000002);
        fetchRows_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Cursor.Fetch)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Cursor.Fetch)
    private static final com.mysql.cj.x.protobuf.MysqlxCursor.Fetch DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxCursor.Fetch();
    }

    public static com.mysql.cj.x.protobuf.MysqlxCursor.Fetch getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Fetch>
        PARSER = new com.google.protobuf.AbstractParser<Fetch>() {
      @java.lang.Override
      public Fetch parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Fetch> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Fetch> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxCursor.Fetch getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface CloseOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Cursor.Close)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <pre>
     * * client-side assigned cursor ID; must be allocated/open 
     * </pre>
     *
     * <code>required uint32 cursor_id = 1;</code>
     * @return Whether the cursorId field is set.
     */
    boolean hasCursorId();
    /**
     * <pre>
     * * client-side assigned cursor ID; must be allocated/open 
     * </pre>
     *
     * <code>required uint32 cursor_id = 1;</code>
     * @return The cursorId.
     */
    int getCursorId();
  }
  /**
   * <pre>
   * *
   * Close cursor
   *
   * &#64;startuml
   * client -&gt; server: Close
   * alt Success
   * client &lt;- server: Ok
   * else Failure
   * client &lt;- server: Error
   * end
   * &#64;enduml
   *
   * &#64;returns &#64;ref Mysqlx::Ok or &#64;ref Mysqlx::Error
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Cursor.Close}
   */
  public static final class Close extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Cursor.Close)
      CloseOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        Close.class.getName());
    }
    // Use Close.newBuilder() to construct.
    private Close(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Close() {
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Close_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Close_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxCursor.Close.class, com.mysql.cj.x.protobuf.MysqlxCursor.Close.Builder.class);
    }

    private int bitField0_;
    public static final int CURSOR_ID_FIELD_NUMBER = 1;
    private int cursorId_ = 0;
    /**
     * <pre>
     * * client-side assigned cursor ID; must be allocated/open 
     * </pre>
     *
     * <code>required uint32 cursor_id = 1;</code>
     * @return Whether the cursorId field is set.
     */
    @java.lang.Override
    public boolean hasCursorId() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <pre>
     * * client-side assigned cursor ID; must be allocated/open 
     * </pre>
     *
     * <code>required uint32 cursor_id = 1;</code>
     * @return The cursorId.
     */
    @java.lang.Override
    public int getCursorId() {
      return cursorId_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasCursorId()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeUInt32(1, cursorId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, cursorId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxCursor.Close)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxCursor.Close other = (com.mysql.cj.x.protobuf.MysqlxCursor.Close) obj;

      if (hasCursorId() != other.hasCursorId()) return false;
      if (hasCursorId()) {
        if (getCursorId()
            != other.getCursorId()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCursorId()) {
        hash = (37 * hash) + CURSOR_ID_FIELD_NUMBER;
        hash = (53 * hash) + getCursorId();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxCursor.Close parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Close parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Close parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Close parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Close parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Close parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Close parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Close parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxCursor.Close parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxCursor.Close parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Close parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxCursor.Close parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxCursor.Close prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * Close cursor
     *
     * &#64;startuml
     * client -&gt; server: Close
     * alt Success
     * client &lt;- server: Ok
     * else Failure
     * client &lt;- server: Error
     * end
     * &#64;enduml
     *
     * &#64;returns &#64;ref Mysqlx::Ok or &#64;ref Mysqlx::Error
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Cursor.Close}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Cursor.Close)
        com.mysql.cj.x.protobuf.MysqlxCursor.CloseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Close_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Close_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxCursor.Close.class, com.mysql.cj.x.protobuf.MysqlxCursor.Close.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxCursor.Close.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        cursorId_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxCursor.internal_static_Mysqlx_Cursor_Close_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxCursor.Close getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxCursor.Close.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxCursor.Close build() {
        com.mysql.cj.x.protobuf.MysqlxCursor.Close result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxCursor.Close buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxCursor.Close result = new com.mysql.cj.x.protobuf.MysqlxCursor.Close(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxCursor.Close result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.cursorId_ = cursorId_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxCursor.Close) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxCursor.Close)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxCursor.Close other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxCursor.Close.getDefaultInstance()) return this;
        if (other.hasCursorId()) {
          setCursorId(other.getCursorId());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasCursorId()) {
          return false;
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                cursorId_ = input.readUInt32();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int cursorId_ ;
      /**
       * <pre>
       * * client-side assigned cursor ID; must be allocated/open 
       * </pre>
       *
       * <code>required uint32 cursor_id = 1;</code>
       * @return Whether the cursorId field is set.
       */
      @java.lang.Override
      public boolean hasCursorId() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <pre>
       * * client-side assigned cursor ID; must be allocated/open 
       * </pre>
       *
       * <code>required uint32 cursor_id = 1;</code>
       * @return The cursorId.
       */
      @java.lang.Override
      public int getCursorId() {
        return cursorId_;
      }
      /**
       * <pre>
       * * client-side assigned cursor ID; must be allocated/open 
       * </pre>
       *
       * <code>required uint32 cursor_id = 1;</code>
       * @param value The cursorId to set.
       * @return This builder for chaining.
       */
      public Builder setCursorId(int value) {

        cursorId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * * client-side assigned cursor ID; must be allocated/open 
       * </pre>
       *
       * <code>required uint32 cursor_id = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearCursorId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        cursorId_ = 0;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Cursor.Close)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Cursor.Close)
    private static final com.mysql.cj.x.protobuf.MysqlxCursor.Close DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxCursor.Close();
    }

    public static com.mysql.cj.x.protobuf.MysqlxCursor.Close getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Close>
        PARSER = new com.google.protobuf.AbstractParser<Close>() {
      @java.lang.Override
      public Close parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Close> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Close> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxCursor.Close getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Cursor_Open_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Cursor_Open_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Cursor_Open_OneOfMessage_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Cursor_Open_OneOfMessage_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Cursor_Fetch_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Cursor_Fetch_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Cursor_Close_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Cursor_Close_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\023mysqlx_cursor.proto\022\rMysqlx.Cursor\032\014my" +
      "sqlx.proto\032\024mysqlx_prepare.proto\"\370\001\n\004Ope" +
      "n\022\021\n\tcursor_id\030\001 \002(\r\022.\n\004stmt\030\004 \002(\0132 .Mys" +
      "qlx.Cursor.Open.OneOfMessage\022\022\n\nfetch_ro" +
      "ws\030\005 \001(\004\032\222\001\n\014OneOfMessage\0223\n\004type\030\001 \002(\0162" +
      "%.Mysqlx.Cursor.Open.OneOfMessage.Type\0220" +
      "\n\017prepare_execute\030\002 \001(\0132\027.Mysqlx.Prepare" +
      ".Execute\"\033\n\004Type\022\023\n\017PREPARE_EXECUTE\020\000:\004\210" +
      "\3520+\"4\n\005Fetch\022\021\n\tcursor_id\030\001 \002(\r\022\022\n\nfetch" +
      "_rows\030\005 \001(\004:\004\210\3520-\" \n\005Close\022\021\n\tcursor_id\030" +
      "\001 \002(\r:\004\210\3520,B\031\n\027com.mysql.cj.x.protobuf"
    };
    descriptor = com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
          com.mysql.cj.x.protobuf.Mysqlx.getDescriptor(),
          com.mysql.cj.x.protobuf.MysqlxPrepare.getDescriptor(),
        });
    internal_static_Mysqlx_Cursor_Open_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Mysqlx_Cursor_Open_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Cursor_Open_descriptor,
        new java.lang.String[] { "CursorId", "Stmt", "FetchRows", });
    internal_static_Mysqlx_Cursor_Open_OneOfMessage_descriptor =
      internal_static_Mysqlx_Cursor_Open_descriptor.getNestedTypes().get(0);
    internal_static_Mysqlx_Cursor_Open_OneOfMessage_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Cursor_Open_OneOfMessage_descriptor,
        new java.lang.String[] { "Type", "PrepareExecute", });
    internal_static_Mysqlx_Cursor_Fetch_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Mysqlx_Cursor_Fetch_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Cursor_Fetch_descriptor,
        new java.lang.String[] { "CursorId", "FetchRows", });
    internal_static_Mysqlx_Cursor_Close_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_Mysqlx_Cursor_Close_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Cursor_Close_descriptor,
        new java.lang.String[] { "CursorId", });
    descriptor.resolveAllFeaturesImmutable();
    com.mysql.cj.x.protobuf.Mysqlx.getDescriptor();
    com.mysql.cj.x.protobuf.MysqlxPrepare.getDescriptor();
    com.google.protobuf.ExtensionRegistry registry =
        com.google.protobuf.ExtensionRegistry.newInstance();
    registry.add(com.mysql.cj.x.protobuf.Mysqlx.clientMessageId);
    com.google.protobuf.Descriptors.FileDescriptor
        .internalUpdateFileDescriptor(descriptor, registry);
  }

  // @@protoc_insertion_point(outer_class_scope)
}
