/*
 * Copyright (c) 2015, 2024, Oracle and/or its affiliates.
 *
 * This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License, version 2.0, as published by
 * the Free Software Foundation.
 *
 * This program is designed to work with certain software that is licensed under separate terms, as designated in a particular file or component or in
 * included license documentation. The authors of MySQL hereby grant you an additional permission to link the program and your derivative works with the
 * separately licensed software that they have either included with the program or referenced in the documentation.
 *
 * Without limiting anything contained in the foregoing, this file, which is part of MySQL Connector/J, is also subject to the Universal FOSS Exception,
 * version 1.0, a copy of which can be found at http://oss.oracle.com/licenses/universal-foss-exception.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License, version 2.0, for more details.
 *
 * You should have received a copy of the GNU General Public License along with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

package com.mysql.cj.x.protobuf;

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: mysqlx_datatypes.proto
// Protobuf Java Version: 4.29.0

public final class MysqlxDatatypes {
  private MysqlxDatatypes() {}
  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
      com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
      /* major= */ 4,
      /* minor= */ 29,
      /* patch= */ 0,
      /* suffix= */ "",
      MysqlxDatatypes.class.getName());
  }
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistryLite registry) {
  }

  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
    registerAllExtensions(
        (com.google.protobuf.ExtensionRegistryLite) registry);
  }
  public interface ScalarOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Datatypes.Scalar)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Datatypes.Scalar.Type type = 1;</code>
     * @return Whether the type field is set.
     */
    boolean hasType();
    /**
     * <code>required .Mysqlx.Datatypes.Scalar.Type type = 1;</code>
     * @return The type.
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type getType();

    /**
     * <code>optional sint64 v_signed_int = 2;</code>
     * @return Whether the vSignedInt field is set.
     */
    boolean hasVSignedInt();
    /**
     * <code>optional sint64 v_signed_int = 2;</code>
     * @return The vSignedInt.
     */
    long getVSignedInt();

    /**
     * <code>optional uint64 v_unsigned_int = 3;</code>
     * @return Whether the vUnsignedInt field is set.
     */
    boolean hasVUnsignedInt();
    /**
     * <code>optional uint64 v_unsigned_int = 3;</code>
     * @return The vUnsignedInt.
     */
    long getVUnsignedInt();

    /**
     * <pre>
     * 4 is unused, was Null which doesn't have a storage anymore
     * </pre>
     *
     * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
     * @return Whether the vOctets field is set.
     */
    boolean hasVOctets();
    /**
     * <pre>
     * 4 is unused, was Null which doesn't have a storage anymore
     * </pre>
     *
     * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
     * @return The vOctets.
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets getVOctets();
    /**
     * <pre>
     * 4 is unused, was Null which doesn't have a storage anymore
     * </pre>
     *
     * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.OctetsOrBuilder getVOctetsOrBuilder();

    /**
     * <code>optional double v_double = 6;</code>
     * @return Whether the vDouble field is set.
     */
    boolean hasVDouble();
    /**
     * <code>optional double v_double = 6;</code>
     * @return The vDouble.
     */
    double getVDouble();

    /**
     * <code>optional float v_float = 7;</code>
     * @return Whether the vFloat field is set.
     */
    boolean hasVFloat();
    /**
     * <code>optional float v_float = 7;</code>
     * @return The vFloat.
     */
    float getVFloat();

    /**
     * <code>optional bool v_bool = 8;</code>
     * @return Whether the vBool field is set.
     */
    boolean hasVBool();
    /**
     * <code>optional bool v_bool = 8;</code>
     * @return The vBool.
     */
    boolean getVBool();

    /**
     * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
     * @return Whether the vString field is set.
     */
    boolean hasVString();
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
     * @return The vString.
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String getVString();
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.StringOrBuilder getVStringOrBuilder();
  }
  /**
   * <pre>
   * a scalar
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Datatypes.Scalar}
   */
  public static final class Scalar extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Datatypes.Scalar)
      ScalarOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        Scalar.class.getName());
    }
    // Use Scalar.newBuilder() to construct.
    private Scalar(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Scalar() {
      type_ = 1;
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder.class);
    }

    /**
     * Protobuf enum {@code Mysqlx.Datatypes.Scalar.Type}
     */
    public enum Type
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>V_SINT = 1;</code>
       */
      V_SINT(1),
      /**
       * <code>V_UINT = 2;</code>
       */
      V_UINT(2),
      /**
       * <code>V_NULL = 3;</code>
       */
      V_NULL(3),
      /**
       * <code>V_OCTETS = 4;</code>
       */
      V_OCTETS(4),
      /**
       * <code>V_DOUBLE = 5;</code>
       */
      V_DOUBLE(5),
      /**
       * <code>V_FLOAT = 6;</code>
       */
      V_FLOAT(6),
      /**
       * <code>V_BOOL = 7;</code>
       */
      V_BOOL(7),
      /**
       * <code>V_STRING = 8;</code>
       */
      V_STRING(8),
      ;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 29,
          /* patch= */ 0,
          /* suffix= */ "",
          Type.class.getName());
      }
      /**
       * <code>V_SINT = 1;</code>
       */
      public static final int V_SINT_VALUE = 1;
      /**
       * <code>V_UINT = 2;</code>
       */
      public static final int V_UINT_VALUE = 2;
      /**
       * <code>V_NULL = 3;</code>
       */
      public static final int V_NULL_VALUE = 3;
      /**
       * <code>V_OCTETS = 4;</code>
       */
      public static final int V_OCTETS_VALUE = 4;
      /**
       * <code>V_DOUBLE = 5;</code>
       */
      public static final int V_DOUBLE_VALUE = 5;
      /**
       * <code>V_FLOAT = 6;</code>
       */
      public static final int V_FLOAT_VALUE = 6;
      /**
       * <code>V_BOOL = 7;</code>
       */
      public static final int V_BOOL_VALUE = 7;
      /**
       * <code>V_STRING = 8;</code>
       */
      public static final int V_STRING_VALUE = 8;


      public final int getNumber() {
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Type valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Type forNumber(int value) {
        switch (value) {
          case 1: return V_SINT;
          case 2: return V_UINT;
          case 3: return V_NULL;
          case 4: return V_OCTETS;
          case 5: return V_DOUBLE;
          case 6: return V_FLOAT;
          case 7: return V_BOOL;
          case 8: return V_STRING;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Type> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Type>() {
              public Type findValueByNumber(int number) {
                return Type.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDescriptor().getEnumTypes().get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Type(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Datatypes.Scalar.Type)
    }

    public interface StringOrBuilder extends
        // @@protoc_insertion_point(interface_extends:Mysqlx.Datatypes.Scalar.String)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <code>required bytes value = 1;</code>
       * @return Whether the value field is set.
       */
      boolean hasValue();
      /**
       * <code>required bytes value = 1;</code>
       * @return The value.
       */
      com.google.protobuf.ByteString getValue();

      /**
       * <code>optional uint64 collation = 2;</code>
       * @return Whether the collation field is set.
       */
      boolean hasCollation();
      /**
       * <code>optional uint64 collation = 2;</code>
       * @return The collation.
       */
      long getCollation();
    }
    /**
     * <pre>
     * * a string with a charset/collation 
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Datatypes.Scalar.String}
     */
    public static final class String extends
        com.google.protobuf.GeneratedMessage implements
        // @@protoc_insertion_point(message_implements:Mysqlx.Datatypes.Scalar.String)
        StringOrBuilder {
    private static final long serialVersionUID = 0L;
      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 29,
          /* patch= */ 0,
          /* suffix= */ "",
          String.class.getName());
      }
      // Use String.newBuilder() to construct.
      private String(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }
      private String() {
        value_ = com.google.protobuf.ByteString.EMPTY;
      }

      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_String_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_String_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.Builder.class);
      }

      private int bitField0_;
      public static final int VALUE_FIELD_NUMBER = 1;
      private com.google.protobuf.ByteString value_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>required bytes value = 1;</code>
       * @return Whether the value field is set.
       */
      @java.lang.Override
      public boolean hasValue() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required bytes value = 1;</code>
       * @return The value.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getValue() {
        return value_;
      }

      public static final int COLLATION_FIELD_NUMBER = 2;
      private long collation_ = 0L;
      /**
       * <code>optional uint64 collation = 2;</code>
       * @return Whether the collation field is set.
       */
      @java.lang.Override
      public boolean hasCollation() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional uint64 collation = 2;</code>
       * @return The collation.
       */
      @java.lang.Override
      public long getCollation() {
        return collation_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasValue()) {
          memoizedIsInitialized = 0;
          return false;
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeBytes(1, value_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeUInt64(2, collation_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeBytesSize(1, value_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeUInt64Size(2, collation_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String)) {
          return super.equals(obj);
        }
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String other = (com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String) obj;

        if (hasValue() != other.hasValue()) return false;
        if (hasValue()) {
          if (!getValue()
              .equals(other.getValue())) return false;
        }
        if (hasCollation() != other.hasCollation()) return false;
        if (hasCollation()) {
          if (getCollation()
              != other.getCollation()) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasValue()) {
          hash = (37 * hash) + VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getValue().hashCode();
        }
        if (hasCollation()) {
          hash = (37 * hash) + COLLATION_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
              getCollation());
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseDelimitedWithIOException(PARSER, input);
      }

      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * * a string with a charset/collation 
       * </pre>
       *
       * Protobuf type {@code Mysqlx.Datatypes.Scalar.String}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessage.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:Mysqlx.Datatypes.Scalar.String)
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.StringOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_String_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_String_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.Builder.class);
        }

        // Construct using com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.newBuilder()
        private Builder() {

        }

        private Builder(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);

        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          value_ = com.google.protobuf.ByteString.EMPTY;
          collation_ = 0L;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_String_descriptor;
        }

        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String getDefaultInstanceForType() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.getDefaultInstance();
        }

        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String build() {
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String buildPartial() {
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String result = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String(this);
          if (bitField0_ != 0) { buildPartial0(result); }
          onBuilt();
          return result;
        }

        private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.value_ = value_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.collation_ = collation_;
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String) {
            return mergeFrom((com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String other) {
          if (other == com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.getDefaultInstance()) return this;
          if (other.hasValue()) {
            setValue(other.getValue());
          }
          if (other.hasCollation()) {
            setCollation(other.getCollation());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (!hasValue()) {
            return false;
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10: {
                  value_ = input.readBytes();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
                case 16: {
                  collation_ = input.readUInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        private int bitField0_;

        private com.google.protobuf.ByteString value_ = com.google.protobuf.ByteString.EMPTY;
        /**
         * <code>required bytes value = 1;</code>
         * @return Whether the value field is set.
         */
        @java.lang.Override
        public boolean hasValue() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>required bytes value = 1;</code>
         * @return The value.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getValue() {
          return value_;
        }
        /**
         * <code>required bytes value = 1;</code>
         * @param value The value to set.
         * @return This builder for chaining.
         */
        public Builder setValue(com.google.protobuf.ByteString value) {
          if (value == null) { throw new NullPointerException(); }
          value_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         * <code>required bytes value = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearValue() {
          bitField0_ = (bitField0_ & ~0x00000001);
          value_ = getDefaultInstance().getValue();
          onChanged();
          return this;
        }

        private long collation_ ;
        /**
         * <code>optional uint64 collation = 2;</code>
         * @return Whether the collation field is set.
         */
        @java.lang.Override
        public boolean hasCollation() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>optional uint64 collation = 2;</code>
         * @return The collation.
         */
        @java.lang.Override
        public long getCollation() {
          return collation_;
        }
        /**
         * <code>optional uint64 collation = 2;</code>
         * @param value The collation to set.
         * @return This builder for chaining.
         */
        public Builder setCollation(long value) {

          collation_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>optional uint64 collation = 2;</code>
         * @return This builder for chaining.
         */
        public Builder clearCollation() {
          bitField0_ = (bitField0_ & ~0x00000002);
          collation_ = 0L;
          onChanged();
          return this;
        }

        // @@protoc_insertion_point(builder_scope:Mysqlx.Datatypes.Scalar.String)
      }

      // @@protoc_insertion_point(class_scope:Mysqlx.Datatypes.Scalar.String)
      private static final com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String();
      }

      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<String>
          PARSER = new com.google.protobuf.AbstractParser<String>() {
        @java.lang.Override
        public String parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static com.google.protobuf.Parser<String> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<String> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public interface OctetsOrBuilder extends
        // @@protoc_insertion_point(interface_extends:Mysqlx.Datatypes.Scalar.Octets)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <code>required bytes value = 1;</code>
       * @return Whether the value field is set.
       */
      boolean hasValue();
      /**
       * <code>required bytes value = 1;</code>
       * @return The value.
       */
      com.google.protobuf.ByteString getValue();

      /**
       * <code>optional uint32 content_type = 2;</code>
       * @return Whether the contentType field is set.
       */
      boolean hasContentType();
      /**
       * <code>optional uint32 content_type = 2;</code>
       * @return The contentType.
       */
      int getContentType();
    }
    /**
     * <pre>
     * * an opaque octet sequence, with an optional content_type
     * See &#64;ref Mysqlx::Resultset::ContentType_BYTES for list of known values. 
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Datatypes.Scalar.Octets}
     */
    public static final class Octets extends
        com.google.protobuf.GeneratedMessage implements
        // @@protoc_insertion_point(message_implements:Mysqlx.Datatypes.Scalar.Octets)
        OctetsOrBuilder {
    private static final long serialVersionUID = 0L;
      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 29,
          /* patch= */ 0,
          /* suffix= */ "",
          Octets.class.getName());
      }
      // Use Octets.newBuilder() to construct.
      private Octets(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }
      private Octets() {
        value_ = com.google.protobuf.ByteString.EMPTY;
      }

      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_Octets_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_Octets_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.Builder.class);
      }

      private int bitField0_;
      public static final int VALUE_FIELD_NUMBER = 1;
      private com.google.protobuf.ByteString value_ = com.google.protobuf.ByteString.EMPTY;
      /**
       * <code>required bytes value = 1;</code>
       * @return Whether the value field is set.
       */
      @java.lang.Override
      public boolean hasValue() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required bytes value = 1;</code>
       * @return The value.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getValue() {
        return value_;
      }

      public static final int CONTENT_TYPE_FIELD_NUMBER = 2;
      private int contentType_ = 0;
      /**
       * <code>optional uint32 content_type = 2;</code>
       * @return Whether the contentType field is set.
       */
      @java.lang.Override
      public boolean hasContentType() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional uint32 content_type = 2;</code>
       * @return The contentType.
       */
      @java.lang.Override
      public int getContentType() {
        return contentType_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasValue()) {
          memoizedIsInitialized = 0;
          return false;
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeBytes(1, value_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeUInt32(2, contentType_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeBytesSize(1, value_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeUInt32Size(2, contentType_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets)) {
          return super.equals(obj);
        }
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets other = (com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets) obj;

        if (hasValue() != other.hasValue()) return false;
        if (hasValue()) {
          if (!getValue()
              .equals(other.getValue())) return false;
        }
        if (hasContentType() != other.hasContentType()) return false;
        if (hasContentType()) {
          if (getContentType()
              != other.getContentType()) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasValue()) {
          hash = (37 * hash) + VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getValue().hashCode();
        }
        if (hasContentType()) {
          hash = (37 * hash) + CONTENT_TYPE_FIELD_NUMBER;
          hash = (53 * hash) + getContentType();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseDelimitedWithIOException(PARSER, input);
      }

      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * <pre>
       * * an opaque octet sequence, with an optional content_type
       * See &#64;ref Mysqlx::Resultset::ContentType_BYTES for list of known values. 
       * </pre>
       *
       * Protobuf type {@code Mysqlx.Datatypes.Scalar.Octets}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessage.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:Mysqlx.Datatypes.Scalar.Octets)
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.OctetsOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_Octets_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_Octets_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.Builder.class);
        }

        // Construct using com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.newBuilder()
        private Builder() {

        }

        private Builder(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);

        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          value_ = com.google.protobuf.ByteString.EMPTY;
          contentType_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_Octets_descriptor;
        }

        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets getDefaultInstanceForType() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.getDefaultInstance();
        }

        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets build() {
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets buildPartial() {
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets result = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets(this);
          if (bitField0_ != 0) { buildPartial0(result); }
          onBuilt();
          return result;
        }

        private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.value_ = value_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.contentType_ = contentType_;
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets) {
            return mergeFrom((com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets other) {
          if (other == com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.getDefaultInstance()) return this;
          if (other.hasValue()) {
            setValue(other.getValue());
          }
          if (other.hasContentType()) {
            setContentType(other.getContentType());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (!hasValue()) {
            return false;
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10: {
                  value_ = input.readBytes();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
                case 16: {
                  contentType_ = input.readUInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        private int bitField0_;

        private com.google.protobuf.ByteString value_ = com.google.protobuf.ByteString.EMPTY;
        /**
         * <code>required bytes value = 1;</code>
         * @return Whether the value field is set.
         */
        @java.lang.Override
        public boolean hasValue() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>required bytes value = 1;</code>
         * @return The value.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getValue() {
          return value_;
        }
        /**
         * <code>required bytes value = 1;</code>
         * @param value The value to set.
         * @return This builder for chaining.
         */
        public Builder setValue(com.google.protobuf.ByteString value) {
          if (value == null) { throw new NullPointerException(); }
          value_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         * <code>required bytes value = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearValue() {
          bitField0_ = (bitField0_ & ~0x00000001);
          value_ = getDefaultInstance().getValue();
          onChanged();
          return this;
        }

        private int contentType_ ;
        /**
         * <code>optional uint32 content_type = 2;</code>
         * @return Whether the contentType field is set.
         */
        @java.lang.Override
        public boolean hasContentType() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>optional uint32 content_type = 2;</code>
         * @return The contentType.
         */
        @java.lang.Override
        public int getContentType() {
          return contentType_;
        }
        /**
         * <code>optional uint32 content_type = 2;</code>
         * @param value The contentType to set.
         * @return This builder for chaining.
         */
        public Builder setContentType(int value) {

          contentType_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>optional uint32 content_type = 2;</code>
         * @return This builder for chaining.
         */
        public Builder clearContentType() {
          bitField0_ = (bitField0_ & ~0x00000002);
          contentType_ = 0;
          onChanged();
          return this;
        }

        // @@protoc_insertion_point(builder_scope:Mysqlx.Datatypes.Scalar.Octets)
      }

      // @@protoc_insertion_point(class_scope:Mysqlx.Datatypes.Scalar.Octets)
      private static final com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets();
      }

      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Octets>
          PARSER = new com.google.protobuf.AbstractParser<Octets>() {
        @java.lang.Override
        public Octets parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static com.google.protobuf.Parser<Octets> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Octets> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_ = 1;
    /**
     * <code>required .Mysqlx.Datatypes.Scalar.Type type = 1;</code>
     * @return Whether the type field is set.
     */
    @java.lang.Override public boolean hasType() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .Mysqlx.Datatypes.Scalar.Type type = 1;</code>
     * @return The type.
     */
    @java.lang.Override public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type getType() {
      com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type result = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type.forNumber(type_);
      return result == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type.V_SINT : result;
    }

    public static final int V_SIGNED_INT_FIELD_NUMBER = 2;
    private long vSignedInt_ = 0L;
    /**
     * <code>optional sint64 v_signed_int = 2;</code>
     * @return Whether the vSignedInt field is set.
     */
    @java.lang.Override
    public boolean hasVSignedInt() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional sint64 v_signed_int = 2;</code>
     * @return The vSignedInt.
     */
    @java.lang.Override
    public long getVSignedInt() {
      return vSignedInt_;
    }

    public static final int V_UNSIGNED_INT_FIELD_NUMBER = 3;
    private long vUnsignedInt_ = 0L;
    /**
     * <code>optional uint64 v_unsigned_int = 3;</code>
     * @return Whether the vUnsignedInt field is set.
     */
    @java.lang.Override
    public boolean hasVUnsignedInt() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional uint64 v_unsigned_int = 3;</code>
     * @return The vUnsignedInt.
     */
    @java.lang.Override
    public long getVUnsignedInt() {
      return vUnsignedInt_;
    }

    public static final int V_OCTETS_FIELD_NUMBER = 5;
    private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets vOctets_;
    /**
     * <pre>
     * 4 is unused, was Null which doesn't have a storage anymore
     * </pre>
     *
     * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
     * @return Whether the vOctets field is set.
     */
    @java.lang.Override
    public boolean hasVOctets() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * 4 is unused, was Null which doesn't have a storage anymore
     * </pre>
     *
     * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
     * @return The vOctets.
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets getVOctets() {
      return vOctets_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.getDefaultInstance() : vOctets_;
    }
    /**
     * <pre>
     * 4 is unused, was Null which doesn't have a storage anymore
     * </pre>
     *
     * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.OctetsOrBuilder getVOctetsOrBuilder() {
      return vOctets_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.getDefaultInstance() : vOctets_;
    }

    public static final int V_DOUBLE_FIELD_NUMBER = 6;
    private double vDouble_ = 0D;
    /**
     * <code>optional double v_double = 6;</code>
     * @return Whether the vDouble field is set.
     */
    @java.lang.Override
    public boolean hasVDouble() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <code>optional double v_double = 6;</code>
     * @return The vDouble.
     */
    @java.lang.Override
    public double getVDouble() {
      return vDouble_;
    }

    public static final int V_FLOAT_FIELD_NUMBER = 7;
    private float vFloat_ = 0F;
    /**
     * <code>optional float v_float = 7;</code>
     * @return Whether the vFloat field is set.
     */
    @java.lang.Override
    public boolean hasVFloat() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <code>optional float v_float = 7;</code>
     * @return The vFloat.
     */
    @java.lang.Override
    public float getVFloat() {
      return vFloat_;
    }

    public static final int V_BOOL_FIELD_NUMBER = 8;
    private boolean vBool_ = false;
    /**
     * <code>optional bool v_bool = 8;</code>
     * @return Whether the vBool field is set.
     */
    @java.lang.Override
    public boolean hasVBool() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <code>optional bool v_bool = 8;</code>
     * @return The vBool.
     */
    @java.lang.Override
    public boolean getVBool() {
      return vBool_;
    }

    public static final int V_STRING_FIELD_NUMBER = 9;
    private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String vString_;
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
     * @return Whether the vString field is set.
     */
    @java.lang.Override
    public boolean hasVString() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
     * @return The vString.
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String getVString() {
      return vString_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.getDefaultInstance() : vString_;
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.StringOrBuilder getVStringOrBuilder() {
      return vString_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.getDefaultInstance() : vString_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasType()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasVOctets()) {
        if (!getVOctets().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasVString()) {
        if (!getVString().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, type_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeSInt64(2, vSignedInt_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeUInt64(3, vUnsignedInt_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(5, getVOctets());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        output.writeDouble(6, vDouble_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        output.writeFloat(7, vFloat_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        output.writeBool(8, vBool_);
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        output.writeMessage(9, getVString());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, type_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeSInt64Size(2, vSignedInt_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(3, vUnsignedInt_);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(5, getVOctets());
      }
      if (((bitField0_ & 0x00000010) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeDoubleSize(6, vDouble_);
      }
      if (((bitField0_ & 0x00000020) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeFloatSize(7, vFloat_);
      }
      if (((bitField0_ & 0x00000040) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBoolSize(8, vBool_);
      }
      if (((bitField0_ & 0x00000080) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(9, getVString());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar other = (com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar) obj;

      if (hasType() != other.hasType()) return false;
      if (hasType()) {
        if (type_ != other.type_) return false;
      }
      if (hasVSignedInt() != other.hasVSignedInt()) return false;
      if (hasVSignedInt()) {
        if (getVSignedInt()
            != other.getVSignedInt()) return false;
      }
      if (hasVUnsignedInt() != other.hasVUnsignedInt()) return false;
      if (hasVUnsignedInt()) {
        if (getVUnsignedInt()
            != other.getVUnsignedInt()) return false;
      }
      if (hasVOctets() != other.hasVOctets()) return false;
      if (hasVOctets()) {
        if (!getVOctets()
            .equals(other.getVOctets())) return false;
      }
      if (hasVDouble() != other.hasVDouble()) return false;
      if (hasVDouble()) {
        if (java.lang.Double.doubleToLongBits(getVDouble())
            != java.lang.Double.doubleToLongBits(
                other.getVDouble())) return false;
      }
      if (hasVFloat() != other.hasVFloat()) return false;
      if (hasVFloat()) {
        if (java.lang.Float.floatToIntBits(getVFloat())
            != java.lang.Float.floatToIntBits(
                other.getVFloat())) return false;
      }
      if (hasVBool() != other.hasVBool()) return false;
      if (hasVBool()) {
        if (getVBool()
            != other.getVBool()) return false;
      }
      if (hasVString() != other.hasVString()) return false;
      if (hasVString()) {
        if (!getVString()
            .equals(other.getVString())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + type_;
      }
      if (hasVSignedInt()) {
        hash = (37 * hash) + V_SIGNED_INT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getVSignedInt());
      }
      if (hasVUnsignedInt()) {
        hash = (37 * hash) + V_UNSIGNED_INT_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            getVUnsignedInt());
      }
      if (hasVOctets()) {
        hash = (37 * hash) + V_OCTETS_FIELD_NUMBER;
        hash = (53 * hash) + getVOctets().hashCode();
      }
      if (hasVDouble()) {
        hash = (37 * hash) + V_DOUBLE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
            java.lang.Double.doubleToLongBits(getVDouble()));
      }
      if (hasVFloat()) {
        hash = (37 * hash) + V_FLOAT_FIELD_NUMBER;
        hash = (53 * hash) + java.lang.Float.floatToIntBits(
            getVFloat());
      }
      if (hasVBool()) {
        hash = (37 * hash) + V_BOOL_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
            getVBool());
      }
      if (hasVString()) {
        hash = (37 * hash) + V_STRING_FIELD_NUMBER;
        hash = (53 * hash) + getVString().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * a scalar
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Datatypes.Scalar}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Datatypes.Scalar)
        com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage
                .alwaysUseFieldBuilders) {
          getVOctetsFieldBuilder();
          getVStringFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = 1;
        vSignedInt_ = 0L;
        vUnsignedInt_ = 0L;
        vOctets_ = null;
        if (vOctetsBuilder_ != null) {
          vOctetsBuilder_.dispose();
          vOctetsBuilder_ = null;
        }
        vDouble_ = 0D;
        vFloat_ = 0F;
        vBool_ = false;
        vString_ = null;
        if (vStringBuilder_ != null) {
          vStringBuilder_.dispose();
          vStringBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Scalar_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar build() {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar result = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.vSignedInt_ = vSignedInt_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.vUnsignedInt_ = vUnsignedInt_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.vOctets_ = vOctetsBuilder_ == null
              ? vOctets_
              : vOctetsBuilder_.build();
          to_bitField0_ |= 0x00000008;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.vDouble_ = vDouble_;
          to_bitField0_ |= 0x00000010;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.vFloat_ = vFloat_;
          to_bitField0_ |= 0x00000020;
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.vBool_ = vBool_;
          to_bitField0_ |= 0x00000040;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.vString_ = vStringBuilder_ == null
              ? vString_
              : vStringBuilder_.build();
          to_bitField0_ |= 0x00000080;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance()) return this;
        if (other.hasType()) {
          setType(other.getType());
        }
        if (other.hasVSignedInt()) {
          setVSignedInt(other.getVSignedInt());
        }
        if (other.hasVUnsignedInt()) {
          setVUnsignedInt(other.getVUnsignedInt());
        }
        if (other.hasVOctets()) {
          mergeVOctets(other.getVOctets());
        }
        if (other.hasVDouble()) {
          setVDouble(other.getVDouble());
        }
        if (other.hasVFloat()) {
          setVFloat(other.getVFloat());
        }
        if (other.hasVBool()) {
          setVBool(other.getVBool());
        }
        if (other.hasVString()) {
          mergeVString(other.getVString());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasType()) {
          return false;
        }
        if (hasVOctets()) {
          if (!getVOctets().isInitialized()) {
            return false;
          }
        }
        if (hasVString()) {
          if (!getVString().isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                int tmpRaw = input.readEnum();
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type tmpValue =
                    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(1, tmpRaw);
                } else {
                  type_ = tmpRaw;
                  bitField0_ |= 0x00000001;
                }
                break;
              } // case 8
              case 16: {
                vSignedInt_ = input.readSInt64();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
              case 24: {
                vUnsignedInt_ = input.readUInt64();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
              case 42: {
                input.readMessage(
                    getVOctetsFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
              case 49: {
                vDouble_ = input.readDouble();
                bitField0_ |= 0x00000010;
                break;
              } // case 49
              case 61: {
                vFloat_ = input.readFloat();
                bitField0_ |= 0x00000020;
                break;
              } // case 61
              case 64: {
                vBool_ = input.readBool();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
              case 74: {
                input.readMessage(
                    getVStringFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int type_ = 1;
      /**
       * <code>required .Mysqlx.Datatypes.Scalar.Type type = 1;</code>
       * @return Whether the type field is set.
       */
      @java.lang.Override public boolean hasType() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .Mysqlx.Datatypes.Scalar.Type type = 1;</code>
       * @return The type.
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type getType() {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type result = com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type.forNumber(type_);
        return result == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type.V_SINT : result;
      }
      /**
       * <code>required .Mysqlx.Datatypes.Scalar.Type type = 1;</code>
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>required .Mysqlx.Datatypes.Scalar.Type type = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 1;
        onChanged();
        return this;
      }

      private long vSignedInt_ ;
      /**
       * <code>optional sint64 v_signed_int = 2;</code>
       * @return Whether the vSignedInt field is set.
       */
      @java.lang.Override
      public boolean hasVSignedInt() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional sint64 v_signed_int = 2;</code>
       * @return The vSignedInt.
       */
      @java.lang.Override
      public long getVSignedInt() {
        return vSignedInt_;
      }
      /**
       * <code>optional sint64 v_signed_int = 2;</code>
       * @param value The vSignedInt to set.
       * @return This builder for chaining.
       */
      public Builder setVSignedInt(long value) {

        vSignedInt_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>optional sint64 v_signed_int = 2;</code>
       * @return This builder for chaining.
       */
      public Builder clearVSignedInt() {
        bitField0_ = (bitField0_ & ~0x00000002);
        vSignedInt_ = 0L;
        onChanged();
        return this;
      }

      private long vUnsignedInt_ ;
      /**
       * <code>optional uint64 v_unsigned_int = 3;</code>
       * @return Whether the vUnsignedInt field is set.
       */
      @java.lang.Override
      public boolean hasVUnsignedInt() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional uint64 v_unsigned_int = 3;</code>
       * @return The vUnsignedInt.
       */
      @java.lang.Override
      public long getVUnsignedInt() {
        return vUnsignedInt_;
      }
      /**
       * <code>optional uint64 v_unsigned_int = 3;</code>
       * @param value The vUnsignedInt to set.
       * @return This builder for chaining.
       */
      public Builder setVUnsignedInt(long value) {

        vUnsignedInt_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint64 v_unsigned_int = 3;</code>
       * @return This builder for chaining.
       */
      public Builder clearVUnsignedInt() {
        bitField0_ = (bitField0_ & ~0x00000004);
        vUnsignedInt_ = 0L;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets vOctets_;
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.OctetsOrBuilder> vOctetsBuilder_;
      /**
       * <pre>
       * 4 is unused, was Null which doesn't have a storage anymore
       * </pre>
       *
       * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
       * @return Whether the vOctets field is set.
       */
      public boolean hasVOctets() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <pre>
       * 4 is unused, was Null which doesn't have a storage anymore
       * </pre>
       *
       * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
       * @return The vOctets.
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets getVOctets() {
        if (vOctetsBuilder_ == null) {
          return vOctets_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.getDefaultInstance() : vOctets_;
        } else {
          return vOctetsBuilder_.getMessage();
        }
      }
      /**
       * <pre>
       * 4 is unused, was Null which doesn't have a storage anymore
       * </pre>
       *
       * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
       */
      public Builder setVOctets(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets value) {
        if (vOctetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          vOctets_ = value;
        } else {
          vOctetsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * 4 is unused, was Null which doesn't have a storage anymore
       * </pre>
       *
       * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
       */
      public Builder setVOctets(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.Builder builderForValue) {
        if (vOctetsBuilder_ == null) {
          vOctets_ = builderForValue.build();
        } else {
          vOctetsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <pre>
       * 4 is unused, was Null which doesn't have a storage anymore
       * </pre>
       *
       * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
       */
      public Builder mergeVOctets(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets value) {
        if (vOctetsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0) &&
            vOctets_ != null &&
            vOctets_ != com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.getDefaultInstance()) {
            getVOctetsBuilder().mergeFrom(value);
          } else {
            vOctets_ = value;
          }
        } else {
          vOctetsBuilder_.mergeFrom(value);
        }
        if (vOctets_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       * <pre>
       * 4 is unused, was Null which doesn't have a storage anymore
       * </pre>
       *
       * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
       */
      public Builder clearVOctets() {
        bitField0_ = (bitField0_ & ~0x00000008);
        vOctets_ = null;
        if (vOctetsBuilder_ != null) {
          vOctetsBuilder_.dispose();
          vOctetsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <pre>
       * 4 is unused, was Null which doesn't have a storage anymore
       * </pre>
       *
       * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.Builder getVOctetsBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getVOctetsFieldBuilder().getBuilder();
      }
      /**
       * <pre>
       * 4 is unused, was Null which doesn't have a storage anymore
       * </pre>
       *
       * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.OctetsOrBuilder getVOctetsOrBuilder() {
        if (vOctetsBuilder_ != null) {
          return vOctetsBuilder_.getMessageOrBuilder();
        } else {
          return vOctets_ == null ?
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.getDefaultInstance() : vOctets_;
        }
      }
      /**
       * <pre>
       * 4 is unused, was Null which doesn't have a storage anymore
       * </pre>
       *
       * <code>optional .Mysqlx.Datatypes.Scalar.Octets v_octets = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.OctetsOrBuilder> 
          getVOctetsFieldBuilder() {
        if (vOctetsBuilder_ == null) {
          vOctetsBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Octets.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.OctetsOrBuilder>(
                  getVOctets(),
                  getParentForChildren(),
                  isClean());
          vOctets_ = null;
        }
        return vOctetsBuilder_;
      }

      private double vDouble_ ;
      /**
       * <code>optional double v_double = 6;</code>
       * @return Whether the vDouble field is set.
       */
      @java.lang.Override
      public boolean hasVDouble() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       * <code>optional double v_double = 6;</code>
       * @return The vDouble.
       */
      @java.lang.Override
      public double getVDouble() {
        return vDouble_;
      }
      /**
       * <code>optional double v_double = 6;</code>
       * @param value The vDouble to set.
       * @return This builder for chaining.
       */
      public Builder setVDouble(double value) {

        vDouble_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       * <code>optional double v_double = 6;</code>
       * @return This builder for chaining.
       */
      public Builder clearVDouble() {
        bitField0_ = (bitField0_ & ~0x00000010);
        vDouble_ = 0D;
        onChanged();
        return this;
      }

      private float vFloat_ ;
      /**
       * <code>optional float v_float = 7;</code>
       * @return Whether the vFloat field is set.
       */
      @java.lang.Override
      public boolean hasVFloat() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       * <code>optional float v_float = 7;</code>
       * @return The vFloat.
       */
      @java.lang.Override
      public float getVFloat() {
        return vFloat_;
      }
      /**
       * <code>optional float v_float = 7;</code>
       * @param value The vFloat to set.
       * @return This builder for chaining.
       */
      public Builder setVFloat(float value) {

        vFloat_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       * <code>optional float v_float = 7;</code>
       * @return This builder for chaining.
       */
      public Builder clearVFloat() {
        bitField0_ = (bitField0_ & ~0x00000020);
        vFloat_ = 0F;
        onChanged();
        return this;
      }

      private boolean vBool_ ;
      /**
       * <code>optional bool v_bool = 8;</code>
       * @return Whether the vBool field is set.
       */
      @java.lang.Override
      public boolean hasVBool() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       * <code>optional bool v_bool = 8;</code>
       * @return The vBool.
       */
      @java.lang.Override
      public boolean getVBool() {
        return vBool_;
      }
      /**
       * <code>optional bool v_bool = 8;</code>
       * @param value The vBool to set.
       * @return This builder for chaining.
       */
      public Builder setVBool(boolean value) {

        vBool_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       * <code>optional bool v_bool = 8;</code>
       * @return This builder for chaining.
       */
      public Builder clearVBool() {
        bitField0_ = (bitField0_ & ~0x00000040);
        vBool_ = false;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String vString_;
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.StringOrBuilder> vStringBuilder_;
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
       * @return Whether the vString field is set.
       */
      public boolean hasVString() {
        return ((bitField0_ & 0x00000080) != 0);
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
       * @return The vString.
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String getVString() {
        if (vStringBuilder_ == null) {
          return vString_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.getDefaultInstance() : vString_;
        } else {
          return vStringBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
       */
      public Builder setVString(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String value) {
        if (vStringBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          vString_ = value;
        } else {
          vStringBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
       */
      public Builder setVString(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.Builder builderForValue) {
        if (vStringBuilder_ == null) {
          vString_ = builderForValue.build();
        } else {
          vStringBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
       */
      public Builder mergeVString(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String value) {
        if (vStringBuilder_ == null) {
          if (((bitField0_ & 0x00000080) != 0) &&
            vString_ != null &&
            vString_ != com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.getDefaultInstance()) {
            getVStringBuilder().mergeFrom(value);
          } else {
            vString_ = value;
          }
        } else {
          vStringBuilder_.mergeFrom(value);
        }
        if (vString_ != null) {
          bitField0_ |= 0x00000080;
          onChanged();
        }
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
       */
      public Builder clearVString() {
        bitField0_ = (bitField0_ & ~0x00000080);
        vString_ = null;
        if (vStringBuilder_ != null) {
          vStringBuilder_.dispose();
          vStringBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.Builder getVStringBuilder() {
        bitField0_ |= 0x00000080;
        onChanged();
        return getVStringFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.StringOrBuilder getVStringOrBuilder() {
        if (vStringBuilder_ != null) {
          return vStringBuilder_.getMessageOrBuilder();
        } else {
          return vString_ == null ?
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.getDefaultInstance() : vString_;
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar.String v_string = 9;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.StringOrBuilder> 
          getVStringFieldBuilder() {
        if (vStringBuilder_ == null) {
          vStringBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.String.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.StringOrBuilder>(
                  getVString(),
                  getParentForChildren(),
                  isClean());
          vString_ = null;
        }
        return vStringBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Datatypes.Scalar)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Datatypes.Scalar)
    private static final com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar();
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Scalar>
        PARSER = new com.google.protobuf.AbstractParser<Scalar>() {
      @java.lang.Override
      public Scalar parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Scalar> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Scalar> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ObjectOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Datatypes.Object)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField> 
        getFldList();
    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField getFld(int index);
    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    int getFldCount();
    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder> 
        getFldOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder getFldOrBuilder(
        int index);
  }
  /**
   * <pre>
   * *
   * An object
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Datatypes.Object}
   */
  public static final class Object extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Datatypes.Object)
      ObjectOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        Object.class.getName());
    }
    // Use Object.newBuilder() to construct.
    private Object(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Object() {
      fld_ = java.util.Collections.emptyList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.Builder.class);
    }

    public interface ObjectFieldOrBuilder extends
        // @@protoc_insertion_point(interface_extends:Mysqlx.Datatypes.Object.ObjectField)
        com.google.protobuf.MessageOrBuilder {

      /**
       * <code>required string key = 1;</code>
       * @return Whether the key field is set.
       */
      boolean hasKey();
      /**
       * <code>required string key = 1;</code>
       * @return The key.
       */
      java.lang.String getKey();
      /**
       * <code>required string key = 1;</code>
       * @return The bytes for key.
       */
      com.google.protobuf.ByteString
          getKeyBytes();

      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       * @return Whether the value field is set.
       */
      boolean hasValue();
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       * @return The value.
       */
      com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getValue();
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       */
      com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder getValueOrBuilder();
    }
    /**
     * Protobuf type {@code Mysqlx.Datatypes.Object.ObjectField}
     */
    public static final class ObjectField extends
        com.google.protobuf.GeneratedMessage implements
        // @@protoc_insertion_point(message_implements:Mysqlx.Datatypes.Object.ObjectField)
        ObjectFieldOrBuilder {
    private static final long serialVersionUID = 0L;
      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 29,
          /* patch= */ 0,
          /* suffix= */ "",
          ObjectField.class.getName());
      }
      // Use ObjectField.newBuilder() to construct.
      private ObjectField(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
        super(builder);
      }
      private ObjectField() {
        key_ = "";
      }

      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_ObjectField_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_ObjectField_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder.class);
      }

      private int bitField0_;
      public static final int KEY_FIELD_NUMBER = 1;
      @SuppressWarnings("serial")
      private volatile java.lang.Object key_ = "";
      /**
       * <code>required string key = 1;</code>
       * @return Whether the key field is set.
       */
      @java.lang.Override
      public boolean hasKey() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required string key = 1;</code>
       * @return The key.
       */
      @java.lang.Override
      public java.lang.String getKey() {
        java.lang.Object ref = key_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = 
              (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          if (bs.isValidUtf8()) {
            key_ = s;
          }
          return s;
        }
      }
      /**
       * <code>required string key = 1;</code>
       * @return The bytes for key.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString
          getKeyBytes() {
        java.lang.Object ref = key_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          key_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int VALUE_FIELD_NUMBER = 2;
      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value_;
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       * @return Whether the value field is set.
       */
      @java.lang.Override
      public boolean hasValue() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       * @return The value.
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getValue() {
        return value_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance() : value_;
      }
      /**
       * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder getValueOrBuilder() {
        return value_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance() : value_;
      }

      private byte memoizedIsInitialized = -1;
      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        if (!hasKey()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!hasValue()) {
          memoizedIsInitialized = 0;
          return false;
        }
        if (!getValue().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output)
                          throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessage.writeString(output, 1, key_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          output.writeMessage(2, getValue());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessage.computeStringSize(1, key_);
        }
        if (((bitField0_ & 0x00000002) != 0)) {
          size += com.google.protobuf.CodedOutputStream
            .computeMessageSize(2, getValue());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
         return true;
        }
        if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField)) {
          return super.equals(obj);
        }
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField other = (com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField) obj;

        if (hasKey() != other.hasKey()) return false;
        if (hasKey()) {
          if (!getKey()
              .equals(other.getKey())) return false;
        }
        if (hasValue() != other.hasValue()) return false;
        if (hasValue()) {
          if (!getValue()
              .equals(other.getValue())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasKey()) {
          hash = (37 * hash) + KEY_FIELD_NUMBER;
          hash = (53 * hash) + getKey().hashCode();
        }
        if (hasValue()) {
          hash = (37 * hash) + VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getValue().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseFrom(
          java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseFrom(
          java.nio.ByteBuffer data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseFrom(byte[] data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseFrom(
          byte[] data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseDelimitedFrom(java.io.InputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseDelimitedWithIOException(PARSER, input);
      }

      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseDelimitedFrom(
          java.io.InputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseFrom(
          com.google.protobuf.CodedInputStream input)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input);
      }
      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessage
            .parseWithIOException(PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() { return newBuilder(); }
      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }
      public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }
      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE
            ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       * Protobuf type {@code Mysqlx.Datatypes.Object.ObjectField}
       */
      public static final class Builder extends
          com.google.protobuf.GeneratedMessage.Builder<Builder> implements
          // @@protoc_insertion_point(builder_implements:Mysqlx.Datatypes.Object.ObjectField)
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor
            getDescriptor() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_ObjectField_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_ObjectField_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder.class);
        }

        // Construct using com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(
            com.google.protobuf.GeneratedMessage.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }
        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessage
                  .alwaysUseFieldBuilders) {
            getValueFieldBuilder();
          }
        }
        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          key_ = "";
          value_ = null;
          if (valueBuilder_ != null) {
            valueBuilder_.dispose();
            valueBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor
            getDescriptorForType() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_ObjectField_descriptor;
        }

        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField getDefaultInstanceForType() {
          return com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.getDefaultInstance();
        }

        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField build() {
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField buildPartial() {
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField result = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField(this);
          if (bitField0_ != 0) { buildPartial0(result); }
          onBuilt();
          return result;
        }

        private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.key_ = key_;
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.value_ = valueBuilder_ == null
                ? value_
                : valueBuilder_.build();
            to_bitField0_ |= 0x00000002;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField) {
            return mergeFrom((com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField)other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField other) {
          if (other == com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.getDefaultInstance()) return this;
          if (other.hasKey()) {
            key_ = other.key_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasValue()) {
            mergeValue(other.getValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          if (!hasKey()) {
            return false;
          }
          if (!hasValue()) {
            return false;
          }
          if (!getValue().isInitialized()) {
            return false;
          }
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10: {
                  key_ = input.readBytes();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
                case 18: {
                  input.readMessage(
                      getValueFieldBuilder().getBuilder(),
                      extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
                default: {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }
        private int bitField0_;

        private java.lang.Object key_ = "";
        /**
         * <code>required string key = 1;</code>
         * @return Whether the key field is set.
         */
        public boolean hasKey() {
          return ((bitField0_ & 0x00000001) != 0);
        }
        /**
         * <code>required string key = 1;</code>
         * @return The key.
         */
        public java.lang.String getKey() {
          java.lang.Object ref = key_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs =
                (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            if (bs.isValidUtf8()) {
              key_ = s;
            }
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         * <code>required string key = 1;</code>
         * @return The bytes for key.
         */
        public com.google.protobuf.ByteString
            getKeyBytes() {
          java.lang.Object ref = key_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b = 
                com.google.protobuf.ByteString.copyFromUtf8(
                    (java.lang.String) ref);
            key_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         * <code>required string key = 1;</code>
         * @param value The key to set.
         * @return This builder for chaining.
         */
        public Builder setKey(
            java.lang.String value) {
          if (value == null) { throw new NullPointerException(); }
          key_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         * <code>required string key = 1;</code>
         * @return This builder for chaining.
         */
        public Builder clearKey() {
          key_ = getDefaultInstance().getKey();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }
        /**
         * <code>required string key = 1;</code>
         * @param value The bytes for key to set.
         * @return This builder for chaining.
         */
        public Builder setKeyBytes(
            com.google.protobuf.ByteString value) {
          if (value == null) { throw new NullPointerException(); }
          key_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value_;
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxDatatypes.Any, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> valueBuilder_;
        /**
         * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
         * @return Whether the value field is set.
         */
        public boolean hasValue() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
         * @return The value.
         */
        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getValue() {
          if (valueBuilder_ == null) {
            return value_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance() : value_;
          } else {
            return valueBuilder_.getMessage();
          }
        }
        /**
         * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
         */
        public Builder setValue(com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value) {
          if (valueBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            value_ = value;
          } else {
            valueBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
         */
        public Builder setValue(
            com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder builderForValue) {
          if (valueBuilder_ == null) {
            value_ = builderForValue.build();
          } else {
            valueBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
         */
        public Builder mergeValue(com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value) {
          if (valueBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0) &&
              value_ != null &&
              value_ != com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance()) {
              getValueBuilder().mergeFrom(value);
            } else {
              value_ = value;
            }
          } else {
            valueBuilder_.mergeFrom(value);
          }
          if (value_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }
        /**
         * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
         */
        public Builder clearValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          value_ = null;
          if (valueBuilder_ != null) {
            valueBuilder_.dispose();
            valueBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder getValueBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getValueFieldBuilder().getBuilder();
        }
        /**
         * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
         */
        public com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder getValueOrBuilder() {
          if (valueBuilder_ != null) {
            return valueBuilder_.getMessageOrBuilder();
          } else {
            return value_ == null ?
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance() : value_;
          }
        }
        /**
         * <code>required .Mysqlx.Datatypes.Any value = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilder<
            com.mysql.cj.x.protobuf.MysqlxDatatypes.Any, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> 
            getValueFieldBuilder() {
          if (valueBuilder_ == null) {
            valueBuilder_ = new com.google.protobuf.SingleFieldBuilder<
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Any, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder>(
                    getValue(),
                    getParentForChildren(),
                    isClean());
            value_ = null;
          }
          return valueBuilder_;
        }

        // @@protoc_insertion_point(builder_scope:Mysqlx.Datatypes.Object.ObjectField)
      }

      // @@protoc_insertion_point(class_scope:Mysqlx.Datatypes.Object.ObjectField)
      private static final com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField DEFAULT_INSTANCE;
      static {
        DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField();
      }

      public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ObjectField>
          PARSER = new com.google.protobuf.AbstractParser<ObjectField>() {
        @java.lang.Override
        public ObjectField parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

      public static com.google.protobuf.Parser<ObjectField> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ObjectField> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }

    }

    public static final int FLD_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField> fld_;
    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField> getFldList() {
      return fld_;
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder> 
        getFldOrBuilderList() {
      return fld_;
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    @java.lang.Override
    public int getFldCount() {
      return fld_.size();
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField getFld(int index) {
      return fld_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder getFldOrBuilder(
        int index) {
      return fld_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getFldCount(); i++) {
        if (!getFld(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < fld_.size(); i++) {
        output.writeMessage(1, fld_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < fld_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, fld_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Object)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxDatatypes.Object other = (com.mysql.cj.x.protobuf.MysqlxDatatypes.Object) obj;

      if (!getFldList()
          .equals(other.getFldList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getFldCount() > 0) {
        hash = (37 * hash) + FLD_FIELD_NUMBER;
        hash = (53 * hash) + getFldList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * An object
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Datatypes.Object}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Datatypes.Object)
        com.mysql.cj.x.protobuf.MysqlxDatatypes.ObjectOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (fldBuilder_ == null) {
          fld_ = java.util.Collections.emptyList();
        } else {
          fld_ = null;
          fldBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Object_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object build() {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Object result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Object result = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Object(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object result) {
        if (fldBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            fld_ = java.util.Collections.unmodifiableList(fld_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.fld_ = fld_;
        } else {
          result.fld_ = fldBuilder_.build();
        }
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Object) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxDatatypes.Object)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.getDefaultInstance()) return this;
        if (fldBuilder_ == null) {
          if (!other.fld_.isEmpty()) {
            if (fld_.isEmpty()) {
              fld_ = other.fld_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureFldIsMutable();
              fld_.addAll(other.fld_);
            }
            onChanged();
          }
        } else {
          if (!other.fld_.isEmpty()) {
            if (fldBuilder_.isEmpty()) {
              fldBuilder_.dispose();
              fldBuilder_ = null;
              fld_ = other.fld_;
              bitField0_ = (bitField0_ & ~0x00000001);
              fldBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getFldFieldBuilder() : null;
            } else {
              fldBuilder_.addAllMessages(other.fld_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        for (int i = 0; i < getFldCount(); i++) {
          if (!getFld(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField m =
                    input.readMessage(
                        com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.parser(),
                        extensionRegistry);
                if (fldBuilder_ == null) {
                  ensureFldIsMutable();
                  fld_.add(m);
                } else {
                  fldBuilder_.addMessage(m);
                }
                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField> fld_ =
        java.util.Collections.emptyList();
      private void ensureFldIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          fld_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField>(fld_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder> fldBuilder_;

      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField> getFldList() {
        if (fldBuilder_ == null) {
          return java.util.Collections.unmodifiableList(fld_);
        } else {
          return fldBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public int getFldCount() {
        if (fldBuilder_ == null) {
          return fld_.size();
        } else {
          return fldBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField getFld(int index) {
        if (fldBuilder_ == null) {
          return fld_.get(index);
        } else {
          return fldBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public Builder setFld(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField value) {
        if (fldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFldIsMutable();
          fld_.set(index, value);
          onChanged();
        } else {
          fldBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public Builder setFld(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder builderForValue) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          fld_.set(index, builderForValue.build());
          onChanged();
        } else {
          fldBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public Builder addFld(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField value) {
        if (fldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFldIsMutable();
          fld_.add(value);
          onChanged();
        } else {
          fldBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public Builder addFld(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField value) {
        if (fldBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFldIsMutable();
          fld_.add(index, value);
          onChanged();
        } else {
          fldBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public Builder addFld(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder builderForValue) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          fld_.add(builderForValue.build());
          onChanged();
        } else {
          fldBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public Builder addFld(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder builderForValue) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          fld_.add(index, builderForValue.build());
          onChanged();
        } else {
          fldBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public Builder addAllFld(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField> values) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, fld_);
          onChanged();
        } else {
          fldBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public Builder clearFld() {
        if (fldBuilder_ == null) {
          fld_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          fldBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public Builder removeFld(int index) {
        if (fldBuilder_ == null) {
          ensureFldIsMutable();
          fld_.remove(index);
          onChanged();
        } else {
          fldBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder getFldBuilder(
          int index) {
        return getFldFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder getFldOrBuilder(
          int index) {
        if (fldBuilder_ == null) {
          return fld_.get(index);  } else {
          return fldBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder> 
           getFldOrBuilderList() {
        if (fldBuilder_ != null) {
          return fldBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(fld_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder addFldBuilder() {
        return getFldFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder addFldBuilder(
          int index) {
        return getFldFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Object.ObjectField fld = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder> 
           getFldBuilderList() {
        return getFldFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder> 
          getFldFieldBuilder() {
        if (fldBuilder_ == null) {
          fldBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectField.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.ObjectFieldOrBuilder>(
                  fld_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          fld_ = null;
        }
        return fldBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Datatypes.Object)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Datatypes.Object)
    private static final com.mysql.cj.x.protobuf.MysqlxDatatypes.Object DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Object();
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Object getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Object>
        PARSER = new com.google.protobuf.AbstractParser<Object>() {
      @java.lang.Override
      public Object parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Object> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Object> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface ArrayOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Datatypes.Array)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> 
        getValueList();
    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getValue(int index);
    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    int getValueCount();
    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> 
        getValueOrBuilderList();
    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder getValueOrBuilder(
        int index);
  }
  /**
   * <pre>
   * *
   * An Array
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Datatypes.Array}
   */
  public static final class Array extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Datatypes.Array)
      ArrayOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        Array.class.getName());
    }
    // Use Array.newBuilder() to construct.
    private Array(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Array() {
      value_ = java.util.Collections.emptyList();
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Array_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Array_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.Builder.class);
    }

    public static final int VALUE_FIELD_NUMBER = 1;
    @SuppressWarnings("serial")
    private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> value_;
    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> getValueList() {
      return value_;
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> 
        getValueOrBuilderList() {
      return value_;
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    @java.lang.Override
    public int getValueCount() {
      return value_.size();
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getValue(int index) {
      return value_.get(index);
    }
    /**
     * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder getValueOrBuilder(
        int index) {
      return value_.get(index);
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      for (int i = 0; i < getValueCount(); i++) {
        if (!getValue(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      for (int i = 0; i < value_.size(); i++) {
        output.writeMessage(1, value_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < value_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(1, value_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Array)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxDatatypes.Array other = (com.mysql.cj.x.protobuf.MysqlxDatatypes.Array) obj;

      if (!getValueList()
          .equals(other.getValueList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getValueCount() > 0) {
        hash = (37 * hash) + VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getValueList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxDatatypes.Array prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * An Array
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Datatypes.Array}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Datatypes.Array)
        com.mysql.cj.x.protobuf.MysqlxDatatypes.ArrayOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Array_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Array_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.newBuilder()
      private Builder() {

      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);

      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (valueBuilder_ == null) {
          value_ = java.util.Collections.emptyList();
        } else {
          value_ = null;
          valueBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Array_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Array getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Array build() {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Array result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Array buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Array result = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Array(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(com.mysql.cj.x.protobuf.MysqlxDatatypes.Array result) {
        if (valueBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            value_ = java.util.Collections.unmodifiableList(value_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.value_ = value_;
        } else {
          result.value_ = valueBuilder_.build();
        }
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxDatatypes.Array result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Array) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxDatatypes.Array)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxDatatypes.Array other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.getDefaultInstance()) return this;
        if (valueBuilder_ == null) {
          if (!other.value_.isEmpty()) {
            if (value_.isEmpty()) {
              value_ = other.value_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureValueIsMutable();
              value_.addAll(other.value_);
            }
            onChanged();
          }
        } else {
          if (!other.value_.isEmpty()) {
            if (valueBuilder_.isEmpty()) {
              valueBuilder_.dispose();
              valueBuilder_ = null;
              value_ = other.value_;
              bitField0_ = (bitField0_ & ~0x00000001);
              valueBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getValueFieldBuilder() : null;
            } else {
              valueBuilder_.addAllMessages(other.value_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        for (int i = 0; i < getValueCount(); i++) {
          if (!getValue(i).isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10: {
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Any m =
                    input.readMessage(
                        com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.parser(),
                        extensionRegistry);
                if (valueBuilder_ == null) {
                  ensureValueIsMutable();
                  value_.add(m);
                } else {
                  valueBuilder_.addMessage(m);
                }
                break;
              } // case 10
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> value_ =
        java.util.Collections.emptyList();
      private void ensureValueIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          value_ = new java.util.ArrayList<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any>(value_);
          bitField0_ |= 0x00000001;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Any, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> valueBuilder_;

      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> getValueList() {
        if (valueBuilder_ == null) {
          return java.util.Collections.unmodifiableList(value_);
        } else {
          return valueBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public int getValueCount() {
        if (valueBuilder_ == null) {
          return value_.size();
        } else {
          return valueBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getValue(int index) {
        if (valueBuilder_ == null) {
          return value_.get(index);
        } else {
          return valueBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public Builder setValue(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.set(index, value);
          onChanged();
        } else {
          valueBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public Builder setValue(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.set(index, builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public Builder addValue(com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.add(value);
          onChanged();
        } else {
          valueBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public Builder addValue(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any value) {
        if (valueBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValueIsMutable();
          value_.add(index, value);
          onChanged();
        } else {
          valueBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public Builder addValue(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.add(builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public Builder addValue(
          int index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder builderForValue) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.add(index, builderForValue.build());
          onChanged();
        } else {
          valueBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public Builder addAllValue(
          java.lang.Iterable<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.Any> values) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, value_);
          onChanged();
        } else {
          valueBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public Builder clearValue() {
        if (valueBuilder_ == null) {
          value_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          valueBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public Builder removeValue(int index) {
        if (valueBuilder_ == null) {
          ensureValueIsMutable();
          value_.remove(index);
          onChanged();
        } else {
          valueBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder getValueBuilder(
          int index) {
        return getValueFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder getValueOrBuilder(
          int index) {
        if (valueBuilder_ == null) {
          return value_.get(index);  } else {
          return valueBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public java.util.List<? extends com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> 
           getValueOrBuilderList() {
        if (valueBuilder_ != null) {
          return valueBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(value_);
        }
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder addValueBuilder() {
        return getValueFieldBuilder().addBuilder(
            com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder addValueBuilder(
          int index) {
        return getValueFieldBuilder().addBuilder(
            index, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance());
      }
      /**
       * <code>repeated .Mysqlx.Datatypes.Any value = 1;</code>
       */
      public java.util.List<com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder> 
           getValueBuilderList() {
        return getValueFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Any, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder> 
          getValueFieldBuilder() {
        if (valueBuilder_ == null) {
          valueBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Any, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder>(
                  value_,
                  ((bitField0_ & 0x00000001) != 0),
                  getParentForChildren(),
                  isClean());
          value_ = null;
        }
        return valueBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Datatypes.Array)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Datatypes.Array)
    private static final com.mysql.cj.x.protobuf.MysqlxDatatypes.Array DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Array();
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Array getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Array>
        PARSER = new com.google.protobuf.AbstractParser<Array>() {
      @java.lang.Override
      public Array parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Array> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Array> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Array getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  public interface AnyOrBuilder extends
      // @@protoc_insertion_point(interface_extends:Mysqlx.Datatypes.Any)
      com.google.protobuf.MessageOrBuilder {

    /**
     * <code>required .Mysqlx.Datatypes.Any.Type type = 1;</code>
     * @return Whether the type field is set.
     */
    boolean hasType();
    /**
     * <code>required .Mysqlx.Datatypes.Any.Type type = 1;</code>
     * @return The type.
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type getType();

    /**
     * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
     * @return Whether the scalar field is set.
     */
    boolean hasScalar();
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
     * @return The scalar.
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getScalar();
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getScalarOrBuilder();

    /**
     * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
     * @return Whether the obj field is set.
     */
    boolean hasObj();
    /**
     * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
     * @return The obj.
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Object getObj();
    /**
     * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.ObjectOrBuilder getObjOrBuilder();

    /**
     * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
     * @return Whether the array field is set.
     */
    boolean hasArray();
    /**
     * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
     * @return The array.
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.Array getArray();
    /**
     * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
     */
    com.mysql.cj.x.protobuf.MysqlxDatatypes.ArrayOrBuilder getArrayOrBuilder();
  }
  /**
   * <pre>
   * *
   * A helper to allow all field types
   * </pre>
   *
   * Protobuf type {@code Mysqlx.Datatypes.Any}
   */
  public static final class Any extends
      com.google.protobuf.GeneratedMessage implements
      // @@protoc_insertion_point(message_implements:Mysqlx.Datatypes.Any)
      AnyOrBuilder {
  private static final long serialVersionUID = 0L;
    static {
      com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
        com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
        /* major= */ 4,
        /* minor= */ 29,
        /* patch= */ 0,
        /* suffix= */ "",
        Any.class.getName());
    }
    // Use Any.newBuilder() to construct.
    private Any(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
    }
    private Any() {
      type_ = 1;
    }

    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Any_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Any_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder.class);
    }

    /**
     * Protobuf enum {@code Mysqlx.Datatypes.Any.Type}
     */
    public enum Type
        implements com.google.protobuf.ProtocolMessageEnum {
      /**
       * <code>SCALAR = 1;</code>
       */
      SCALAR(1),
      /**
       * <code>OBJECT = 2;</code>
       */
      OBJECT(2),
      /**
       * <code>ARRAY = 3;</code>
       */
      ARRAY(3),
      ;

      static {
        com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
          com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
          /* major= */ 4,
          /* minor= */ 29,
          /* patch= */ 0,
          /* suffix= */ "",
          Type.class.getName());
      }
      /**
       * <code>SCALAR = 1;</code>
       */
      public static final int SCALAR_VALUE = 1;
      /**
       * <code>OBJECT = 2;</code>
       */
      public static final int OBJECT_VALUE = 2;
      /**
       * <code>ARRAY = 3;</code>
       */
      public static final int ARRAY_VALUE = 3;


      public final int getNumber() {
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Type valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Type forNumber(int value) {
        switch (value) {
          case 1: return SCALAR;
          case 2: return OBJECT;
          case 3: return ARRAY;
          default: return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Type>
          internalGetValueMap() {
        return internalValueMap;
      }
      private static final com.google.protobuf.Internal.EnumLiteMap<
          Type> internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<Type>() {
              public Type findValueByNumber(int number) {
                return Type.forNumber(number);
              }
            };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor
          getValueDescriptor() {
        return getDescriptor().getValues().get(ordinal());
      }
      public final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptorForType() {
        return getDescriptor();
      }
      public static final com.google.protobuf.Descriptors.EnumDescriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDescriptor().getEnumTypes().get(0);
      }

      private static final Type[] VALUES = values();

      public static Type valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException(
            "EnumValueDescriptor is not for this type.");
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Type(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:Mysqlx.Datatypes.Any.Type)
    }

    private int bitField0_;
    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_ = 1;
    /**
     * <code>required .Mysqlx.Datatypes.Any.Type type = 1;</code>
     * @return Whether the type field is set.
     */
    @java.lang.Override public boolean hasType() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     * <code>required .Mysqlx.Datatypes.Any.Type type = 1;</code>
     * @return The type.
     */
    @java.lang.Override public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type getType() {
      com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type result = com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type.forNumber(type_);
      return result == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type.SCALAR : result;
    }

    public static final int SCALAR_FIELD_NUMBER = 2;
    private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar scalar_;
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
     * @return Whether the scalar field is set.
     */
    @java.lang.Override
    public boolean hasScalar() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
     * @return The scalar.
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getScalar() {
      return scalar_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance() : scalar_;
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getScalarOrBuilder() {
      return scalar_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance() : scalar_;
    }

    public static final int OBJ_FIELD_NUMBER = 3;
    private com.mysql.cj.x.protobuf.MysqlxDatatypes.Object obj_;
    /**
     * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
     * @return Whether the obj field is set.
     */
    @java.lang.Override
    public boolean hasObj() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
     * @return The obj.
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object getObj() {
      return obj_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.getDefaultInstance() : obj_;
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.ObjectOrBuilder getObjOrBuilder() {
      return obj_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.getDefaultInstance() : obj_;
    }

    public static final int ARRAY_FIELD_NUMBER = 4;
    private com.mysql.cj.x.protobuf.MysqlxDatatypes.Array array_;
    /**
     * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
     * @return Whether the array field is set.
     */
    @java.lang.Override
    public boolean hasArray() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
     * @return The array.
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Array getArray() {
      return array_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.getDefaultInstance() : array_;
    }
    /**
     * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
     */
    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.ArrayOrBuilder getArrayOrBuilder() {
      return array_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.getDefaultInstance() : array_;
    }

    private byte memoizedIsInitialized = -1;
    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      if (!hasType()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (hasScalar()) {
        if (!getScalar().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasObj()) {
        if (!getObj().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (hasArray()) {
        if (!getArray().isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(1, type_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getScalar());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeMessage(3, getObj());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeMessage(4, getArray());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(1, type_);
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, getScalar());
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, getObj());
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(4, getArray());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
       return true;
      }
      if (!(obj instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Any)) {
        return super.equals(obj);
      }
      com.mysql.cj.x.protobuf.MysqlxDatatypes.Any other = (com.mysql.cj.x.protobuf.MysqlxDatatypes.Any) obj;

      if (hasType() != other.hasType()) return false;
      if (hasType()) {
        if (type_ != other.type_) return false;
      }
      if (hasScalar() != other.hasScalar()) return false;
      if (hasScalar()) {
        if (!getScalar()
            .equals(other.getScalar())) return false;
      }
      if (hasObj() != other.hasObj()) return false;
      if (hasObj()) {
        if (!getObj()
            .equals(other.getObj())) return false;
      }
      if (hasArray() != other.hasArray()) return false;
      if (hasArray()) {
        if (!getArray()
            .equals(other.getArray())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasType()) {
        hash = (37 * hash) + TYPE_FIELD_NUMBER;
        hash = (53 * hash) + type_;
      }
      if (hasScalar()) {
        hash = (37 * hash) + SCALAR_FIELD_NUMBER;
        hash = (53 * hash) + getScalar().hashCode();
      }
      if (hasObj()) {
        hash = (37 * hash) + OBJ_FIELD_NUMBER;
        hash = (53 * hash) + getObj().hashCode();
      }
      if (hasArray()) {
        hash = (37 * hash) + ARRAY_FIELD_NUMBER;
        hash = (53 * hash) + getArray().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseFrom(
        java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseFrom(
        java.nio.ByteBuffer data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input);
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input);
    }
    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessage
          .parseWithIOException(PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }
    public static Builder newBuilder(com.mysql.cj.x.protobuf.MysqlxDatatypes.Any prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }
    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE
          ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * <pre>
     * *
     * A helper to allow all field types
     * </pre>
     *
     * Protobuf type {@code Mysqlx.Datatypes.Any}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder> implements
        // @@protoc_insertion_point(builder_implements:Mysqlx.Datatypes.Any)
        com.mysql.cj.x.protobuf.MysqlxDatatypes.AnyOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Any_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Any_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.class, com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Builder.class);
      }

      // Construct using com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage
                .alwaysUseFieldBuilders) {
          getScalarFieldBuilder();
          getObjFieldBuilder();
          getArrayFieldBuilder();
        }
      }
      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = 1;
        scalar_ = null;
        if (scalarBuilder_ != null) {
          scalarBuilder_.dispose();
          scalarBuilder_ = null;
        }
        obj_ = null;
        if (objBuilder_ != null) {
          objBuilder_.dispose();
          objBuilder_ = null;
        }
        array_ = null;
        if (arrayBuilder_ != null) {
          arrayBuilder_.dispose();
          arrayBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.internal_static_Mysqlx_Datatypes_Any_descriptor;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getDefaultInstanceForType() {
        return com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance();
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any build() {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Any result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any buildPartial() {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Any result = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Any(this);
        if (bitField0_ != 0) { buildPartial0(result); }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.mysql.cj.x.protobuf.MysqlxDatatypes.Any result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.scalar_ = scalarBuilder_ == null
              ? scalar_
              : scalarBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.obj_ = objBuilder_ == null
              ? obj_
              : objBuilder_.build();
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.array_ = arrayBuilder_ == null
              ? array_
              : arrayBuilder_.build();
          to_bitField0_ |= 0x00000008;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.mysql.cj.x.protobuf.MysqlxDatatypes.Any) {
          return mergeFrom((com.mysql.cj.x.protobuf.MysqlxDatatypes.Any)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.mysql.cj.x.protobuf.MysqlxDatatypes.Any other) {
        if (other == com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.getDefaultInstance()) return this;
        if (other.hasType()) {
          setType(other.getType());
        }
        if (other.hasScalar()) {
          mergeScalar(other.getScalar());
        }
        if (other.hasObj()) {
          mergeObj(other.getObj());
        }
        if (other.hasArray()) {
          mergeArray(other.getArray());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        if (!hasType()) {
          return false;
        }
        if (hasScalar()) {
          if (!getScalar().isInitialized()) {
            return false;
          }
        }
        if (hasObj()) {
          if (!getObj().isInitialized()) {
            return false;
          }
        }
        if (hasArray()) {
          if (!getArray().isInitialized()) {
            return false;
          }
        }
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8: {
                int tmpRaw = input.readEnum();
                com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type tmpValue =
                    com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type.forNumber(tmpRaw);
                if (tmpValue == null) {
                  mergeUnknownVarintField(1, tmpRaw);
                } else {
                  type_ = tmpRaw;
                  bitField0_ |= 0x00000001;
                }
                break;
              } // case 8
              case 18: {
                input.readMessage(
                    getScalarFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
              case 26: {
                input.readMessage(
                    getObjFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
              case 34: {
                input.readMessage(
                    getArrayFieldBuilder().getBuilder(),
                    extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
              default: {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }
      private int bitField0_;

      private int type_ = 1;
      /**
       * <code>required .Mysqlx.Datatypes.Any.Type type = 1;</code>
       * @return Whether the type field is set.
       */
      @java.lang.Override public boolean hasType() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       * <code>required .Mysqlx.Datatypes.Any.Type type = 1;</code>
       * @return The type.
       */
      @java.lang.Override
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type getType() {
        com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type result = com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type.forNumber(type_);
        return result == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type.SCALAR : result;
      }
      /**
       * <code>required .Mysqlx.Datatypes.Any.Type type = 1;</code>
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.mysql.cj.x.protobuf.MysqlxDatatypes.Any.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       * <code>required .Mysqlx.Datatypes.Any.Type type = 1;</code>
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 1;
        onChanged();
        return this;
      }

      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar scalar_;
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> scalarBuilder_;
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
       * @return Whether the scalar field is set.
       */
      public boolean hasScalar() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
       * @return The scalar.
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar getScalar() {
        if (scalarBuilder_ == null) {
          return scalar_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance() : scalar_;
        } else {
          return scalarBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
       */
      public Builder setScalar(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (scalarBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          scalar_ = value;
        } else {
          scalarBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
       */
      public Builder setScalar(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder builderForValue) {
        if (scalarBuilder_ == null) {
          scalar_ = builderForValue.build();
        } else {
          scalarBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
       */
      public Builder mergeScalar(com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar value) {
        if (scalarBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0) &&
            scalar_ != null &&
            scalar_ != com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance()) {
            getScalarBuilder().mergeFrom(value);
          } else {
            scalar_ = value;
          }
        } else {
          scalarBuilder_.mergeFrom(value);
        }
        if (scalar_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
       */
      public Builder clearScalar() {
        bitField0_ = (bitField0_ & ~0x00000002);
        scalar_ = null;
        if (scalarBuilder_ != null) {
          scalarBuilder_.dispose();
          scalarBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder getScalarBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getScalarFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder getScalarOrBuilder() {
        if (scalarBuilder_ != null) {
          return scalarBuilder_.getMessageOrBuilder();
        } else {
          return scalar_ == null ?
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.getDefaultInstance() : scalar_;
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Scalar scalar = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder> 
          getScalarFieldBuilder() {
        if (scalarBuilder_ == null) {
          scalarBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar, com.mysql.cj.x.protobuf.MysqlxDatatypes.Scalar.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ScalarOrBuilder>(
                  getScalar(),
                  getParentForChildren(),
                  isClean());
          scalar_ = null;
        }
        return scalarBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Object obj_;
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ObjectOrBuilder> objBuilder_;
      /**
       * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
       * @return Whether the obj field is set.
       */
      public boolean hasObj() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
       * @return The obj.
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object getObj() {
        if (objBuilder_ == null) {
          return obj_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.getDefaultInstance() : obj_;
        } else {
          return objBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
       */
      public Builder setObj(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object value) {
        if (objBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          obj_ = value;
        } else {
          objBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
       */
      public Builder setObj(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.Builder builderForValue) {
        if (objBuilder_ == null) {
          obj_ = builderForValue.build();
        } else {
          objBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
       */
      public Builder mergeObj(com.mysql.cj.x.protobuf.MysqlxDatatypes.Object value) {
        if (objBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0) &&
            obj_ != null &&
            obj_ != com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.getDefaultInstance()) {
            getObjBuilder().mergeFrom(value);
          } else {
            obj_ = value;
          }
        } else {
          objBuilder_.mergeFrom(value);
        }
        if (obj_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
       */
      public Builder clearObj() {
        bitField0_ = (bitField0_ & ~0x00000004);
        obj_ = null;
        if (objBuilder_ != null) {
          objBuilder_.dispose();
          objBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.Builder getObjBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getObjFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.ObjectOrBuilder getObjOrBuilder() {
        if (objBuilder_ != null) {
          return objBuilder_.getMessageOrBuilder();
        } else {
          return obj_ == null ?
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.getDefaultInstance() : obj_;
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Object obj = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Object, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ObjectOrBuilder> 
          getObjFieldBuilder() {
        if (objBuilder_ == null) {
          objBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Object, com.mysql.cj.x.protobuf.MysqlxDatatypes.Object.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ObjectOrBuilder>(
                  getObj(),
                  getParentForChildren(),
                  isClean());
          obj_ = null;
        }
        return objBuilder_;
      }

      private com.mysql.cj.x.protobuf.MysqlxDatatypes.Array array_;
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Array, com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ArrayOrBuilder> arrayBuilder_;
      /**
       * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
       * @return Whether the array field is set.
       */
      public boolean hasArray() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
       * @return The array.
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Array getArray() {
        if (arrayBuilder_ == null) {
          return array_ == null ? com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.getDefaultInstance() : array_;
        } else {
          return arrayBuilder_.getMessage();
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
       */
      public Builder setArray(com.mysql.cj.x.protobuf.MysqlxDatatypes.Array value) {
        if (arrayBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          array_ = value;
        } else {
          arrayBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
       */
      public Builder setArray(
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.Builder builderForValue) {
        if (arrayBuilder_ == null) {
          array_ = builderForValue.build();
        } else {
          arrayBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
       */
      public Builder mergeArray(com.mysql.cj.x.protobuf.MysqlxDatatypes.Array value) {
        if (arrayBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0) &&
            array_ != null &&
            array_ != com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.getDefaultInstance()) {
            getArrayBuilder().mergeFrom(value);
          } else {
            array_ = value;
          }
        } else {
          arrayBuilder_.mergeFrom(value);
        }
        if (array_ != null) {
          bitField0_ |= 0x00000008;
          onChanged();
        }
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
       */
      public Builder clearArray() {
        bitField0_ = (bitField0_ & ~0x00000008);
        array_ = null;
        if (arrayBuilder_ != null) {
          arrayBuilder_.dispose();
          arrayBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.Builder getArrayBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getArrayFieldBuilder().getBuilder();
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
       */
      public com.mysql.cj.x.protobuf.MysqlxDatatypes.ArrayOrBuilder getArrayOrBuilder() {
        if (arrayBuilder_ != null) {
          return arrayBuilder_.getMessageOrBuilder();
        } else {
          return array_ == null ?
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.getDefaultInstance() : array_;
        }
      }
      /**
       * <code>optional .Mysqlx.Datatypes.Array array = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          com.mysql.cj.x.protobuf.MysqlxDatatypes.Array, com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ArrayOrBuilder> 
          getArrayFieldBuilder() {
        if (arrayBuilder_ == null) {
          arrayBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              com.mysql.cj.x.protobuf.MysqlxDatatypes.Array, com.mysql.cj.x.protobuf.MysqlxDatatypes.Array.Builder, com.mysql.cj.x.protobuf.MysqlxDatatypes.ArrayOrBuilder>(
                  getArray(),
                  getParentForChildren(),
                  isClean());
          array_ = null;
        }
        return arrayBuilder_;
      }

      // @@protoc_insertion_point(builder_scope:Mysqlx.Datatypes.Any)
    }

    // @@protoc_insertion_point(class_scope:Mysqlx.Datatypes.Any)
    private static final com.mysql.cj.x.protobuf.MysqlxDatatypes.Any DEFAULT_INSTANCE;
    static {
      DEFAULT_INSTANCE = new com.mysql.cj.x.protobuf.MysqlxDatatypes.Any();
    }

    public static com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Any>
        PARSER = new com.google.protobuf.AbstractParser<Any>() {
      @java.lang.Override
      public Any parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        Builder builder = newBuilder();
        try {
          builder.mergeFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.setUnfinishedMessage(builder.buildPartial());
        } catch (com.google.protobuf.UninitializedMessageException e) {
          throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
        } catch (java.io.IOException e) {
          throw new com.google.protobuf.InvalidProtocolBufferException(e)
              .setUnfinishedMessage(builder.buildPartial());
        }
        return builder.buildPartial();
      }
    };

    public static com.google.protobuf.Parser<Any> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Any> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.mysql.cj.x.protobuf.MysqlxDatatypes.Any getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }

  }

  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Datatypes_Scalar_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Datatypes_Scalar_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Datatypes_Scalar_String_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Datatypes_Scalar_String_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Datatypes_Scalar_Octets_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Datatypes_Scalar_Octets_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Datatypes_Object_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Datatypes_Object_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Datatypes_Object_ObjectField_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Datatypes_Object_ObjectField_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Datatypes_Array_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Datatypes_Array_fieldAccessorTable;
  private static final com.google.protobuf.Descriptors.Descriptor
    internal_static_Mysqlx_Datatypes_Any_descriptor;
  private static final 
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_Mysqlx_Datatypes_Any_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static  com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n\026mysqlx_datatypes.proto\022\020Mysqlx.Datatyp" +
      "es\"\306\003\n\006Scalar\022+\n\004type\030\001 \002(\0162\035.Mysqlx.Dat" +
      "atypes.Scalar.Type\022\024\n\014v_signed_int\030\002 \001(\022" +
      "\022\026\n\016v_unsigned_int\030\003 \001(\004\0221\n\010v_octets\030\005 \001" +
      "(\0132\037.Mysqlx.Datatypes.Scalar.Octets\022\020\n\010v" +
      "_double\030\006 \001(\001\022\017\n\007v_float\030\007 \001(\002\022\016\n\006v_bool" +
      "\030\010 \001(\010\0221\n\010v_string\030\t \001(\0132\037.Mysqlx.Dataty" +
      "pes.Scalar.String\032*\n\006String\022\r\n\005value\030\001 \002" +
      "(\014\022\021\n\tcollation\030\002 \001(\004\032-\n\006Octets\022\r\n\005value" +
      "\030\001 \002(\014\022\024\n\014content_type\030\002 \001(\r\"m\n\004Type\022\n\n\006" +
      "V_SINT\020\001\022\n\n\006V_UINT\020\002\022\n\n\006V_NULL\020\003\022\014\n\010V_OC" +
      "TETS\020\004\022\014\n\010V_DOUBLE\020\005\022\013\n\007V_FLOAT\020\006\022\n\n\006V_B" +
      "OOL\020\007\022\014\n\010V_STRING\020\010\"}\n\006Object\0221\n\003fld\030\001 \003" +
      "(\0132$.Mysqlx.Datatypes.Object.ObjectField" +
      "\032@\n\013ObjectField\022\013\n\003key\030\001 \002(\t\022$\n\005value\030\002 " +
      "\002(\0132\025.Mysqlx.Datatypes.Any\"-\n\005Array\022$\n\005v" +
      "alue\030\001 \003(\0132\025.Mysqlx.Datatypes.Any\"\323\001\n\003An" +
      "y\022(\n\004type\030\001 \002(\0162\032.Mysqlx.Datatypes.Any.T" +
      "ype\022(\n\006scalar\030\002 \001(\0132\030.Mysqlx.Datatypes.S" +
      "calar\022%\n\003obj\030\003 \001(\0132\030.Mysqlx.Datatypes.Ob" +
      "ject\022&\n\005array\030\004 \001(\0132\027.Mysqlx.Datatypes.A" +
      "rray\")\n\004Type\022\n\n\006SCALAR\020\001\022\n\n\006OBJECT\020\002\022\t\n\005" +
      "ARRAY\020\003B\031\n\027com.mysql.cj.x.protobuf"
    };
    descriptor = com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
        });
    internal_static_Mysqlx_Datatypes_Scalar_descriptor =
      getDescriptor().getMessageTypes().get(0);
    internal_static_Mysqlx_Datatypes_Scalar_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Datatypes_Scalar_descriptor,
        new java.lang.String[] { "Type", "VSignedInt", "VUnsignedInt", "VOctets", "VDouble", "VFloat", "VBool", "VString", });
    internal_static_Mysqlx_Datatypes_Scalar_String_descriptor =
      internal_static_Mysqlx_Datatypes_Scalar_descriptor.getNestedTypes().get(0);
    internal_static_Mysqlx_Datatypes_Scalar_String_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Datatypes_Scalar_String_descriptor,
        new java.lang.String[] { "Value", "Collation", });
    internal_static_Mysqlx_Datatypes_Scalar_Octets_descriptor =
      internal_static_Mysqlx_Datatypes_Scalar_descriptor.getNestedTypes().get(1);
    internal_static_Mysqlx_Datatypes_Scalar_Octets_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Datatypes_Scalar_Octets_descriptor,
        new java.lang.String[] { "Value", "ContentType", });
    internal_static_Mysqlx_Datatypes_Object_descriptor =
      getDescriptor().getMessageTypes().get(1);
    internal_static_Mysqlx_Datatypes_Object_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Datatypes_Object_descriptor,
        new java.lang.String[] { "Fld", });
    internal_static_Mysqlx_Datatypes_Object_ObjectField_descriptor =
      internal_static_Mysqlx_Datatypes_Object_descriptor.getNestedTypes().get(0);
    internal_static_Mysqlx_Datatypes_Object_ObjectField_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Datatypes_Object_ObjectField_descriptor,
        new java.lang.String[] { "Key", "Value", });
    internal_static_Mysqlx_Datatypes_Array_descriptor =
      getDescriptor().getMessageTypes().get(2);
    internal_static_Mysqlx_Datatypes_Array_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Datatypes_Array_descriptor,
        new java.lang.String[] { "Value", });
    internal_static_Mysqlx_Datatypes_Any_descriptor =
      getDescriptor().getMessageTypes().get(3);
    internal_static_Mysqlx_Datatypes_Any_fieldAccessorTable = new
      com.google.protobuf.GeneratedMessage.FieldAccessorTable(
        internal_static_Mysqlx_Datatypes_Any_descriptor,
        new java.lang.String[] { "Type", "Scalar", "Obj", "Array", });
    descriptor.resolveAllFeaturesImmutable();
  }

  // @@protoc_insertion_point(outer_class_scope)
}
