/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.StateSetEnumerator;

public final class StateSet {
    private final boolean DEBUG = false;
    public static final StateSet EMPTY = new StateSet();
    static final int BITS = 6;
    static final int MASK = 63;
    long[] bits;

    public StateSet() {
        this(256);
    }

    public StateSet(int size) {
        this.bits = new long[this.size2nbits(size)];
    }

    public StateSet(int size, int state) {
        this(size);
        this.addState(state);
    }

    public StateSet(StateSet set) {
        this.bits = new long[set.bits.length];
        System.arraycopy(set.bits, 0, this.bits, 0, set.bits.length);
    }

    public void addState(int state) {
        int index = state >> 6;
        if (index >= this.bits.length) {
            this.resize(state);
        }
        int n = index;
        this.bits[n] = this.bits[n] | 1L << (state & 0x3F);
    }

    private int size2nbits(int size) {
        return (size >> 6) + 1;
    }

    private void resize(int size) {
        int needed = this.size2nbits(size);
        long[] newbits = new long[Math.max(this.bits.length * 4, needed)];
        System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
        this.bits = newbits;
    }

    public void clear() {
        int l = this.bits.length;
        int i = 0;
        while (i < l) {
            this.bits[i] = 0L;
            ++i;
        }
    }

    public boolean isElement(int state) {
        int index = state >> 6;
        if (index >= this.bits.length) {
            return false;
        }
        return (this.bits[index] & 1L << (state & 0x3F)) != 0L;
    }

    public int getAndRemoveElement() {
        int i = 0;
        int o = 0;
        long m = 1L;
        while (this.bits[i] == 0L) {
            ++i;
        }
        while ((this.bits[i] & m) == 0L) {
            m <<= 1;
            ++o;
        }
        int n = i;
        this.bits[n] = this.bits[n] & (m ^ 0xFFFFFFFFFFFFFFFFL);
        return (i << 6) + o;
    }

    public void remove(int state) {
        int index = state >> 6;
        if (index >= this.bits.length) {
            return;
        }
        int n = index;
        this.bits[n] = this.bits[n] & (1L << (state & 0x3F) ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public StateSet complement(StateSet set) {
        if (set == null) {
            return null;
        }
        StateSet result = new StateSet();
        result.bits = new long[set.bits.length];
        int m = Math.min(this.bits.length, set.bits.length);
        int i = 0;
        while (i < m) {
            result.bits[i] = (this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL) & set.bits[i];
            ++i;
        }
        if (this.bits.length < set.bits.length) {
            System.arraycopy(set.bits, m, result.bits, m, result.bits.length - m);
        }
        return result;
    }

    public void add(StateSet set) {
        long[] tbits;
        if (set == null) {
            return;
        }
        long[] sbits = set.bits;
        int sbitsl = sbits.length;
        if (this.bits.length < sbitsl) {
            tbits = new long[sbitsl];
            System.arraycopy(this.bits, 0, tbits, 0, this.bits.length);
        } else {
            tbits = this.bits;
        }
        int i = 0;
        while (i < sbitsl) {
            int n = i;
            tbits[n] = tbits[n] | sbits[i];
            ++i;
        }
        this.bits = tbits;
    }

    public boolean containsSet(StateSet set) {
        int min = Math.min(this.bits.length, set.bits.length);
        int i = 0;
        while (i < min) {
            if ((this.bits[i] & set.bits[i]) != set.bits[i]) {
                return false;
            }
            ++i;
        }
        i = min;
        while (i < set.bits.length) {
            if (set.bits[i] != 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public boolean equals(Object b) {
        block6: {
            i = 0;
            set = (StateSet)b;
            l1 = this.bits.length;
            l2 = set.bits.length;
            if (l1 > l2) ** GOTO lbl18
            while (i < l1) {
                if (this.bits[i] != set.bits[i]) {
                    return false;
                }
                ++i;
            }
            while (i < l2) {
                if (set.bits[i++] == 0L) continue;
                return false;
            }
            break block6;
lbl-1000:
            // 1 sources

            {
                if (this.bits[i] != set.bits[i]) {
                    return false;
                }
                ++i;
lbl18:
                // 2 sources

                ** while (i < l2)
            }
lbl19:
            // 2 sources

            while (i < l1) {
                if (this.bits[i++] == 0L) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        long h = 1234L;
        long[] _bits = this.bits;
        int i = this.bits.length - 1;
        while (i >= 0 && _bits[i] == 0L) {
            --i;
        }
        while (i >= 0) {
            h ^= _bits[i--] * (long)i;
        }
        return (int)(h >> 32 ^ h);
    }

    public StateSetEnumerator states() {
        return new StateSetEnumerator(this);
    }

    public boolean containsElements() {
        int i = 0;
        while (i < this.bits.length) {
            if (this.bits[i] != 0L) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public StateSet copy() {
        StateSet set = new StateSet();
        set.bits = new long[this.bits.length];
        System.arraycopy(this.bits, 0, set.bits, 0, this.bits.length);
        return set;
    }

    public void copy(StateSet set) {
        if (set == null) {
            int i = 0;
            while (i < this.bits.length) {
                this.bits[i] = 0L;
                ++i;
            }
            return;
        }
        if (this.bits.length < set.bits.length) {
            this.bits = new long[set.bits.length];
        } else {
            int i = set.bits.length;
            while (i < this.bits.length) {
                this.bits[i] = 0L;
                ++i;
            }
        }
        System.arraycopy(set.bits, 0, this.bits, 0, this.bits.length);
    }

    public String toString() {
        StateSetEnumerator stateSetEnumerator = this.states();
        StringBuffer result = new StringBuffer("{");
        if (stateSetEnumerator.hasMoreElements()) {
            result.append("" + stateSetEnumerator.nextElement());
        }
        while (stateSetEnumerator.hasMoreElements()) {
            int i = stateSetEnumerator.nextElement();
            result.append(", " + i);
        }
        result.append("}");
        return result.toString();
    }
}

