/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class PropertyFile
extends Task {
    private static final String NEWLINE = System.getProperty("line.separator");
    private String m_comment;
    private Properties m_properties;
    private File m_propertyfile;
    private Vector entries = new Vector();
    private Entry mainEntry = new Entry();
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$java$io$OutputStream;
    static /* synthetic */ Class class$java$lang$String;

    private boolean checkParam(File param) {
        return param != null;
    }

    private boolean checkParam(String param) {
        return (param == null || param.equals("null")) ^ true;
    }

    private void checkParameters() throws BuildException {
        if (!this.checkParam(this.m_propertyfile)) {
            throw new BuildException("file token must not be null.", this.location);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Entry createEntry() {
        Entry e = new Entry();
        this.entries.addElement(e);
        return e;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.readFile();
        this.executeOperation();
        this.writeFile();
    }

    private void executeOperation() throws BuildException {
        Enumeration e = this.entries.elements();
        while (e.hasMoreElements()) {
            Entry entry = (Entry)e.nextElement();
            entry.executeOn(this.m_properties);
        }
    }

    private void readFile() throws BuildException {
        this.m_properties = new Properties();
        try {
            if (this.m_propertyfile.exists()) {
                this.log("Updating property file: " + this.m_propertyfile.getAbsolutePath());
                this.m_properties.load(new BufferedInputStream(new FileInputStream(this.m_propertyfile)));
            } else {
                this.log("Creating new property file: " + this.m_propertyfile.getAbsolutePath());
                FileOutputStream out = new FileOutputStream(this.m_propertyfile.getAbsolutePath());
                out.flush();
                out.close();
            }
        }
        catch (IOException ioe) {
            throw new BuildException(ioe.toString());
        }
    }

    public void setComment(String hdr) {
        this.m_comment = hdr;
    }

    public void setFile(String file) {
        this.m_propertyfile = new File(file);
    }

    public void setKey(String key) {
        this.mainEntry.setKey(key);
    }

    public void setOperation(String op) {
        this.mainEntry.setOperation(op);
    }

    public void setType(String type) {
        this.mainEntry.setType(type);
    }

    public void setValue(String value) {
        this.mainEntry.setValue(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeFile() throws BuildException {
        BufferedOutputStream bos = null;
        try {
            try {
                bos = new BufferedOutputStream(new FileOutputStream(this.m_propertyfile));
                Method m = (class$java$util$Properties != null ? class$java$util$Properties : (class$java$util$Properties = PropertyFile.class$("java.util.Properties"))).getMethod("store", class$java$io$OutputStream != null ? class$java$io$OutputStream : (class$java$io$OutputStream = PropertyFile.class$("java.io.OutputStream")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = PropertyFile.class$("java.lang.String")));
                m.invoke((Object)this.m_properties, bos, this.m_comment);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.m_properties.save(bos, this.m_comment);
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getTargetException();
                throw new BuildException(t, this.location);
            }
            catch (IllegalAccessException iae) {
                throw new BuildException(iae, this.location);
            }
            catch (IOException ioe) {
                throw new BuildException(ioe, this.location);
            }
            Object var3_7 = null;
            if (bos == null) return;
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            if (bos == null) throw throwable;
            try {
                bos.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            bos.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public static class Entry {
        private static final String INTEGER_TYPE = "int";
        private static final String DATE_TYPE = "date";
        private static final String STRING_TYPE = "string";
        private static final String INCREMENT_OPER = "+";
        private static final String DECREMENT_OPER = "-";
        private static final String EQUALS_OPER = "=";
        private static final String NOW_VALUE = "now";
        private static final String NULL_VALUE = "never";
        private static final int DEFAULT_INT_VALUE = 1;
        private static final GregorianCalendar DEFAULT_DATE_VALUE = new GregorianCalendar();
        private String m_key;
        private String m_type = null;
        private String m_operation = null;
        private String m_value;
        private int m_intValue = 1;
        private GregorianCalendar m_dateValue = DEFAULT_DATE_VALUE;

        private void executeDate(String oldValue) throws BuildException {
            StringBuffer dateString = new StringBuffer();
            if (this.m_operation.equals(NULL_VALUE)) {
                this.m_dateValue = null;
            } else {
                Date now = new Date();
                this.m_dateValue.setTime(now);
                dateString.append(this.m_dateValue.get(1));
                dateString.append("/");
                dateString.append(this.m_dateValue.get(2) + 1 < 10 ? "0" : "");
                dateString.append(this.m_dateValue.get(2) + 1);
                dateString.append("/");
                dateString.append(this.m_dateValue.get(5) < 10 ? "0" : "");
                dateString.append(this.m_dateValue.get(5));
                dateString.append(" ");
                dateString.append(this.m_dateValue.get(11) < 10 ? "0" : "");
                dateString.append(this.m_dateValue.get(11));
                dateString.append(":");
                dateString.append(this.m_dateValue.get(12) < 10 ? "0" : "");
                dateString.append(this.m_dateValue.get(12));
                this.m_value = dateString.toString();
            }
            this.m_value = dateString.toString();
        }

        private void executeInteger(String oldValue) throws BuildException {
            String newValue = "";
            int currentValue = 0;
            try {
                currentValue = new Integer(oldValue);
            }
            catch (NumberFormatException numberFormatException) {}
            if (this.m_operation.equals(INCREMENT_OPER)) {
                this.m_value = new String(String.valueOf(++currentValue));
            } else if (this.m_operation.equals(DECREMENT_OPER)) {
                this.m_value = new String(String.valueOf(--currentValue));
            }
        }

        protected void executeOn(Properties props) throws BuildException {
            try {
                if (this.m_type.equals(INTEGER_TYPE)) {
                    this.executeInteger((String)((Hashtable)props).get(this.m_key));
                } else if (this.m_type.equals(DATE_TYPE)) {
                    this.executeDate((String)((Hashtable)props).get(this.m_key));
                } else if (!this.m_type.equals(STRING_TYPE)) {
                    throw new BuildException("Unknown operation type: " + this.m_type);
                }
            }
            catch (NullPointerException nullPointerException) {}
            ((Hashtable)props).put(this.m_key, this.m_value);
        }

        public void setKey(String value) {
            this.m_key = value;
        }

        public void setOperation(String value) {
            this.m_operation = value;
        }

        public void setType(String value) {
            this.m_type = value;
        }

        public void setValue(String value) {
            this.m_value = value;
            this.setOperation(EQUALS_OPER);
        }
    }
}

