/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.PatternSet;

public abstract class MatchingTask
extends Task {
    protected boolean useDefaultExcludes = true;
    protected FileSet fileset = new FileSet();

    public void XsetIgnore(String ignoreString) {
        this.log("The ignore attribute is deprecated.Please use the excludes attribute.", 1);
        if (ignoreString != null && ignoreString.length() > 0) {
            Vector tmpExcludes = new Vector();
            StringTokenizer tok = new StringTokenizer(ignoreString, ", ", false);
            while (tok.hasMoreTokens()) {
                this.createExclude().setName("**/" + tok.nextToken().trim() + "/**");
            }
        }
    }

    public void XsetItems(String itemString) {
        this.log("The items attribute is deprecated. Please use the includes attribute.", 1);
        if (itemString == null || itemString.equals("*") || itemString.equals(".")) {
            this.createInclude().setName("**");
        } else {
            StringTokenizer tok = new StringTokenizer(itemString, ", ");
            while (tok.hasMoreTokens()) {
                String pattern = tok.nextToken().trim();
                if (pattern.length() <= 0) continue;
                this.createInclude().setName(String.valueOf(pattern) + "/**");
            }
        }
    }

    public PatternSet.NameEntry createExclude() {
        return this.fileset.createExclude();
    }

    public PatternSet.NameEntry createInclude() {
        return this.fileset.createInclude();
    }

    public PatternSet createPatternSet() {
        return this.fileset.createPatternSet();
    }

    protected DirectoryScanner getDirectoryScanner(File baseDir) {
        this.fileset.setDir(baseDir);
        this.fileset.setDefaultexcludes(this.useDefaultExcludes);
        return this.fileset.getDirectoryScanner(this.project);
    }

    public void setDefaultexcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }

    public void setExcludes(String excludes) {
        this.fileset.setExcludes(excludes);
    }

    public void setExcludesfile(File excludesfile) {
        this.fileset.setExcludesfile(excludesfile);
    }

    public void setIncludes(String includes) {
        this.fileset.setIncludes(includes);
    }

    public void setIncludesfile(File includesfile) {
        this.fileset.setIncludesfile(includesfile);
    }
}

