defmodule Faker.Pokemon.De do
  import Faker, only: [sampler: 2]

  @moduledoc """
  Functions for Pokemon names in German
  """

  @doc """
  Returns a Pokemon name

  ## Examples

      iex> Faker.Pokemon.De.name()
      "Viscogon"
      iex> Faker.Pokemon.De.name()
      "Lepumentas"
      iex> Faker.Pokemon.De.name()
      "Quajutsu"
      iex> Faker.Pokemon.De.name()
      "Pyroleo"
  """
  @spec name() :: String.t()
  sampler(:name, [
    "Bisasam",
    "Bisaknosp",
    "Bisaflor",
    "Glumanda",
    "Glutexo",
    "Glurak",
    "Schiggy",
    "Schillok",
    "Turtok",
    "Raupy",
    "Safcon",
    "Smettbo",
    "Hornliu",
    "Kokuna",
    "Bibor",
    "Taubsi",
    "Tauboga",
    "Tauboss",
    "Rattfratz",
    "Rattikarl",
    "Habitak",
    "Ibitak",
    "Rettan",
    "Arbok",
    "Pikachu",
    "Raichu",
    "Sandan",
    "Sandamer",
    "Nidoran♀",
    "Nidorina",
    "Nidoqueen",
    "Nidoran♂",
    "Nidorino",
    "Nidoking",
    "Piepi",
    "Pixi",
    "Vulpix",
    "Vulnona",
    "Pummeluff",
    "Knuddeluff",
    "Zubat",
    "Golbat",
    "Myrapla",
    "Duflor",
    "Giflor",
    "Paras",
    "Parasek",
    "Bluzuk",
    "Omot",
    "Digda",
    "Digdri",
    "Mauzi",
    "Snobilikat",
    "Enton",
    "Entoron",
    "Menki",
    "Rasaff",
    "Fukano",
    "Arkani",
    "Quapsel",
    "Quaputzi",
    "Quappo",
    "Abra",
    "Kadabra",
    "Simsala",
    "Machollo",
    "Maschock",
    "Machomei",
    "Knofensa",
    "Ultrigaria",
    "Sarzenia",
    "Tentacha",
    "Tentoxa",
    "Kleinstein",
    "Georok",
    "Geowaz",
    "Ponita",
    "Gallopa",
    "Flegmon",
    "Lahmus",
    "Magnetilo",
    "Magneton",
    "Porenta",
    "Dodu",
    "Dodri",
    "Jurob",
    "Jugong",
    "Sleima",
    "Sleimok",
    "Muschas",
    "Austos",
    "Nebulak",
    "Alpollo",
    "Gengar",
    "Onix",
    "Traumato",
    "Hypno",
    "Krabby",
    "Kingler",
    "Voltobal",
    "Lektrobal",
    "Owei",
    "Kokowei",
    "Tragosso",
    "Knogga",
    "Kicklee",
    "Nockchan",
    "Schlurp",
    "Smogon",
    "Smogmog",
    "Rihorn",
    "Rizeros",
    "Chaneira",
    "Tangela",
    "Kangama",
    "Seeper",
    "Seemon",
    "Goldini",
    "Golking",
    "Sterndu",
    "Starmie",
    "Pantimos",
    "Sichlor",
    "Rossana",
    "Elektek",
    "Magmar",
    "Pinsir",
    "Tauros",
    "Karpador",
    "Garados",
    "Lapras",
    "Ditto",
    "Evoli",
    "Aquana",
    "Blitza",
    "Flamara",
    "Porygon",
    "Amonitas",
    "Amoroso",
    "Kabuto",
    "Kabutops",
    "Aerodactyl",
    "Relaxo",
    "Arktos",
    "Zapdos",
    "Lavados",
    "Dratini",
    "Dragonir",
    "Dragoran",
    "Mewtu",
    "Mew",
    "Endivie",
    "Lorblatt",
    "Meganie",
    "Feurigel",
    "Igelavar",
    "Tornupto",
    "Karnimani",
    "Tyracroc",
    "Impergator",
    "Wiesor",
    "Wiesenior",
    "Hoothoot",
    "Noctuh",
    "Ledyba",
    "Ledian",
    "Webarak",
    "Ariados",
    "Iksbat",
    "Lampi",
    "Lanturn",
    "Pichu",
    "Pii",
    "Fluffeluff",
    "Togepi",
    "Togetic",
    "Natu",
    "Xatu",
    "Voltilamm",
    "Waaty",
    "Ampharos",
    "Blubella",
    "Marill",
    "Azumarill",
    "Mogelbaum",
    "Quaxo",
    "Hoppspross",
    "Hubelupf",
    "Papungha",
    "Griffel",
    "Sonnkern",
    "Sonnflora",
    "Yanma",
    "Felino",
    "Morlord",
    "Psiana",
    "Nachtara",
    "Kramurx",
    "Laschoking",
    "Traunfugil",
    "Icognito",
    "Woingenau",
    "Girafarig",
    "Tannza",
    "Forstellka",
    "Dummisel",
    "Skorgla",
    "Stahlos",
    "Snubbull",
    "Granbull",
    "Baldorfish",
    "Scherox",
    "Pottrott",
    "Skaraborn",
    "Sniebel",
    "Teddiursa",
    "Ursaring",
    "Schneckmag",
    "Magcargo",
    "Quiekel",
    "Keifel",
    "Corasonn",
    "Remoraid",
    "Octillery",
    "Botogel",
    "Mantax",
    "Panzaeron",
    "Hunduster",
    "Hundemon",
    "Seedraking",
    "Phanpy",
    "Donphan",
    "Porygon2",
    "Damhirplex",
    "Farbeagle",
    "Rabauz",
    "Kapoera",
    "Kussilla",
    "Elekid",
    "Magby",
    "Miltank",
    "Heiteira",
    "Raikou",
    "Entei",
    "Suicune",
    "Larvitar",
    "Pupitar",
    "Despotar",
    "Lugia",
    "Ho-Oh",
    "Celebi",
    "Geckarbor",
    "Reptain",
    "Gewaldro",
    "Flemmli",
    "Jungglut",
    "Lohgock",
    "Hydropi",
    "Moorabbel",
    "Sumpex",
    "Fiffyen",
    "Magnayen",
    "Zigzachs",
    "Geradaks",
    "Waumpel",
    "Schaloko",
    "Papinella",
    "Panekon",
    "Pudox",
    "Loturzel",
    "Lombrero",
    "Kappalores",
    "Samurzel",
    "Blanas",
    "Tengulist",
    "Schwalbini",
    "Schwalboss",
    "Wingull",
    "Pelipper",
    "Trasla",
    "Kirlia",
    "Guardevoir",
    "Gehweiher",
    "Maskeregen",
    "Knilz",
    "Kapilz",
    "Bummelz",
    "Muntier",
    "Letarking",
    "Nincada",
    "Ninjask",
    "Ninjatom",
    "Flurmel",
    "Krakeelo",
    "Krawumms",
    "Makuhita",
    "Hariyama",
    "Azurill",
    "Nasgnet",
    "Eneco",
    "Enekoro",
    "Zobiris",
    "Flunkifer",
    "Stollunior",
    "Stollrak",
    "Stolloss",
    "Meditie",
    "Meditalis",
    "Frizelbliz",
    "Voltenso",
    "Plusle",
    "Minun",
    "Volbeat",
    "Illumise",
    "Roselia",
    "Schluppuck",
    "Schlukwech",
    "Kanivanha",
    "Tohaido",
    "Wailmer",
    "Wailord",
    "Camaub",
    "Camerupt",
    "Qurtel",
    "Spoink",
    "Groink",
    "Pandir",
    "Knacklion",
    "Vibrava",
    "Libelldra",
    "Tuska",
    "Noktuska",
    "Wablu",
    "Altaria",
    "Sengo",
    "Vipitis",
    "Lunastein",
    "Sonnfel",
    "Schmerbe",
    "Welsar",
    "Krebscorps",
    "Krebutack",
    "Puppance",
    "Lepumentas",
    "Liliep",
    "Wielie",
    "Anorith",
    "Armaldo",
    "Barschwa",
    "Milotic",
    "Formeo",
    "Kecleon",
    "Shuppet",
    "Banette",
    "Zwirrlicht",
    "Zwirrklop",
    "Tropius",
    "Palimpalim",
    "Absol",
    "Isso",
    "Schneppke",
    "Firnontor",
    "Seemops",
    "Seejong",
    "Walraisa",
    "Perlu",
    "Aalabyss",
    "Saganabyss",
    "Relicanth",
    "Liebiskus",
    "Kindwurm",
    "Draschel",
    "Brutalanda",
    "Tanhel",
    "Metang",
    "Metagross",
    "Regirock",
    "Regice",
    "Registeel",
    "Latias",
    "Latios",
    "Kyogre",
    "Groudon",
    "Rayquaza",
    "Jirachi",
    "Deoxys",
    "Chelast",
    "Chelcarain",
    "Chelterrar",
    "Panflam",
    "Panpyro",
    "Panferno",
    "Plinfa",
    "Pliprin",
    "Impoleon",
    "Staralili",
    "Staravia",
    "Staraptor",
    "Bidiza",
    "Bidifas",
    "Zirpurze",
    "Zirpeise",
    "Sheinux",
    "Luxio",
    "Luxtra",
    "Knospi",
    "Roserade",
    "Koknodon",
    "Rameidon",
    "Schilterus",
    "Bollterus",
    "Burmy",
    "Burmadame",
    "Moterpel",
    "Wadribie",
    "Honweisel",
    "Pachirisu",
    "Bamelin",
    "Bojelin",
    "Kikugi",
    "Kinoso",
    "Schalellos",
    "Gastrodon",
    "Ambidiffel",
    "Driftlon",
    "Drifzepeli",
    "Haspiror",
    "Schlapor",
    "Traunmagil",
    "Kramshef",
    "Charmian",
    "Shnurgarst",
    "Klingplim",
    "Skunkapuh",
    "Skunktank",
    "Bronzel",
    "Bronzong",
    "Mobai",
    "Pantimimi",
    "Wonneira",
    "Plaudagei",
    "Kryppuk",
    "Kaumalat",
    "Knarksel",
    "Knakrack",
    "Mampfaxo",
    "Riolu",
    "Lucario",
    "Hippopotas",
    "Hippoterus",
    "Pionskora",
    "Piondragi",
    "Glibunkel",
    "Toxiquak",
    "Venuflibis",
    "Finneon",
    "Lumineon",
    "Mantirps",
    "Shnebedeck",
    "Rexblisar",
    "Snibunna",
    "Magnezone",
    "Schlurplek",
    "Rihornior",
    "Tangoloss",
    "Elevoltek",
    "Magbrant",
    "Togekiss",
    "Yanmega",
    "Folipurba",
    "Glaziola",
    "Skorgro",
    "Mamutel",
    "Porygon-Z",
    "Galagladi",
    "Voluminas",
    "Zwirrfinst",
    "Frosdedje",
    "Rotom",
    "Selfe",
    "Vesprit",
    "Tobutz",
    "Dialga",
    "Palkia",
    "Heatran",
    "Regigigas",
    "Giratina",
    "Cresselia",
    "Phione",
    "Manaphy",
    "Darkrai",
    "Shaymin",
    "Arceus",
    "Victini",
    "Serpifeu",
    "Efoserp",
    "Serpiroyal",
    "Floink",
    "Ferkokel",
    "Flambirex",
    "Ottaro",
    "Zwottronin",
    "Admurai",
    "Nagelotz",
    "Kukmarda",
    "Yorkleff",
    "Terribark",
    "Bissbark",
    "Felilou",
    "Kleoparda",
    "Vegimak",
    "Vegichita",
    "Grillmak",
    "Grillchita",
    "Sodamak",
    "Sodachita",
    "Somniam",
    "Somnivora",
    "Dusselgurr",
    "Navitaub",
    "Fasasnob",
    "Elezeba",
    "Zebritz",
    "Kiesling",
    "Sedimantur",
    "Brockoloss",
    "Fleknoil",
    "Fletiamo",
    "Rotomurf",
    "Stalobor",
    "Ohrdoch",
    "Praktibalk",
    "Strepoli",
    "Meistagrif",
    "Schallquap",
    "Mebrana",
    "Branawarz",
    "Jiutesto",
    "Karadonis",
    "Strawickl",
    "Folikon",
    "Matrifol",
    "Toxiped",
    "Rollum",
    "Cerapendra",
    "Waumboll",
    "Elfun",
    "Lilminip",
    "Dressella",
    "Barschuft",
    "Ganovil",
    "Rokkaiman",
    "Rabigator",
    "Flampion",
    "Flampivian",
    "Maracamba",
    "Lithomith",
    "Castellith",
    "Zurrokex",
    "Irokex",
    "Symvolara",
    "Makabaja",
    "Echnatoll",
    "Galapaflos",
    "Karippas",
    "Flapteryx",
    "Aeropteryx",
    "Unratütox",
    "Deponitox",
    "Zorua",
    "Zoroark",
    "Picochilla",
    "Chillabell",
    "Mollimorba",
    "Hypnomorba",
    "Morbitesse",
    "Monozyto",
    "Mitodos",
    "Zytomega",
    "Piccolente",
    "Swaroness",
    "Gelatini",
    "Gelatroppo",
    "Gelatwino",
    "Sesokitz",
    "Kronjuwild",
    "Emolga",
    "Laukaps",
    "Cavalanzas",
    "Tarnpignon",
    "Hutsassa",
    "Quabbel",
    "Apoquallyp",
    "Mamolida",
    "Wattzapf",
    "Voltula",
    "Kastadur",
    "Tentantel",
    "Klikk",
    "Kliklak",
    "Klikdiklak",
    "Zapplardin",
    "Zapplalek",
    "Zapplarang",
    "Pygraulon",
    "Megalon",
    "Lichtel",
    "Laternecto",
    "Skelabra",
    "Milza",
    "Sharfax",
    "Maxax",
    "Petznief",
    "Siberio",
    "Frigometri",
    "Schnuthelm",
    "Hydragil",
    "Flunschlik",
    "Fu",
    "Shu",
    "Shardrago",
    "Golbit",
    "Golgantes",
    "Gladiantri",
    "Caesurio",
    "Bisofank",
    "Geronimatz",
    "Washakwil",
    "Skallyk",
    "Grypheldis",
    "Furnifraß",
    "Fermicula",
    "Kapuno",
    "Duodino",
    "Trikephalo",
    "Ignivor",
    "Ramoth",
    "Kobalium",
    "Terrakium",
    "Viridium",
    "Boreos",
    "Voltolos",
    "Reshiram",
    "Zekrom",
    "Demeteros",
    "Kyurem",
    "Keldeo",
    "Meloetta",
    "Genesect",
    "Igamaro",
    "Igastarnish",
    "Brigaron",
    "Fynx",
    "Rutena",
    "Fennexis",
    "Froxy",
    "Amphizel",
    "Quajutsu",
    "Scoppel",
    "Grebbit",
    "Dartiri",
    "Dartignis",
    "Fiaro",
    "Purmel",
    "Puponcho",
    "Vivillon",
    "Leufeo",
    "Pyroleo",
    "Flabébé",
    "Floette",
    "Florges",
    "Mähikel",
    "Chevrumm",
    "Pam",
    "Pandagro",
    "Coiffwaff",
    "Psiau",
    "Psiaugon",
    "Gramokles",
    "Duokles",
    "Durengard",
    "Parfi",
    "Parfinesse",
    "Flauschling",
    "Sabbaione",
    "Iscalar",
    "Calamanero",
    "Bithora",
    "Thanathora",
    "Algitt",
    "Tandrak",
    "Scampisto",
    "Wummer",
    "Eguana",
    "Elezard",
    "Balgoras",
    "Monargoras",
    "Amarino",
    "Amagarga",
    "Feelinara",
    "Resladero",
    "Dedenne",
    "Rocara",
    "Viscora",
    "Viscargot",
    "Viscogon",
    "Clavion",
    "Paragoni",
    "Trombork",
    "Irrbis",
    "Pumpdjinn",
    "Arktip",
    "Arktilas",
    "eF-eM",
    "UHaFnir",
    "Xerneas",
    "Yveltal",
    "Zygarde",
    "Diancie",
    "Hoopa",
    "Volcanion",
    "Bauz",
    "Arboretoss",
    "Silvarro",
    "Flamiau",
    "Miezunder",
    "Fuegro",
    "Robball",
    "Marikeck",
    "Primarene",
    "Peppeck",
    "Trompeck",
    "Tukanon",
    "Mangunior",
    "Manguspektor",
    "Mabula",
    "Akkup",
    "Donarion",
    "Krabbox",
    "Krawell",
    "Choreogel",
    "Wommel",
    "Bandelby",
    "Wuffels",
    "Wolwerock",
    "Lusardin",
    "Garstella",
    "Aggrostella",
    "Pampuli",
    "Pampross",
    "Araqua",
    "Aranestro",
    "Imantis",
    "Mantidea",
    "Bubungus",
    "Lamellux",
    "Molunk",
    "Amfira",
    "Velursi",
    "Kosturso",
    "Frubberl",
    "Frubaila",
    "Fruyal",
    "Curelei",
    "Kommandutan",
    "Quartermak",
    "Reißlaus",
    "Tectass",
    "Sankabuh",
    "Colossand",
    "Gufa",
    "Typ:Null",
    "Amigento",
    "Meteno",
    "Koalelu",
    "Tortunator",
    "Togedemaru",
    "Mimigma",
    "Knirfish",
    "Sen-Long",
    "Moruda",
    "Miniras",
    "Mediras",
    "Grandiras",
    "Kapu-Riki",
    "Kapu-Fala",
    "Kapu-Toro",
    "Kapu-Kime",
    "Cosmog",
    "Cosmovum",
    "Solgaleo",
    "Lunala",
    "Anego",
    "Masskito",
    "Schabelle",
    "Voltriant",
    "Kaguron",
    "Katagami",
    "Schlingking",
    "Necrozma",
    "Magearna",
    "Marshadow",
    "Venicro",
    "Agoyon",
    "Muramura",
    "Kopplosio",
    "Zeraora",
    "Meltan",
    "Melmetal"
  ])

  @doc """
  Returns a location from Pokemon universe

  ## Examples

      iex> Faker.Pokemon.De.location()
      "Blumenparadies"
      iex> Faker.Pokemon.De.location()
      "Kraterberg"
      iex> Faker.Pokemon.De.location()
      "Zweiblattdorf"
      iex> Faker.Pokemon.De.location()
      "Sandgemme"
  """
  @spec location() :: String.t()
  sampler(:location, [
    "Mysteriöser Ort",
    "Zweiblattdorf",
    "Sandgemme",
    "Flori",
    "Trostu",
    "Elyses",
    "Jubelstadt",
    "Fleetburg",
    "Erzelingen",
    "Ewigenau",
    "Herzhofen",
    "Weideburg",
    "Schleiede",
    "Sonnewik",
    "Blizzach",
    "Pokémon Liga",
    "Erzelingen-Mine",
    "Windkraftwerk",
    "Ewigwald",
    "Feuriohütte",
    "Kraterberg",
    "Speersäule",
    "Großmoor",
    "Trostu-Ruinen",
    "Siegesstraße",
    "Park der Freunde",
    "Platz der Treue",
    "Verwüsteter Pfad",
    "Auen von Flori",
    "Erzelingen-Tor",
    "Vollmond-Insel",
    "Scheidequelle",
    "Höhle der Umkehr",
    "Blumenparadies",
    "Blizzach-Tempel",
    "Bizarre Höhle",
    "Maniac-Höhle",
    "Maniac-Tunnel",
    "Trophäengarten",
    "Eiseninsel",
    "Alte Villa",
    "Galakti-Zentrale",
    "Wahrheitsufer",
    "Kühnheitsufer",
    "Stärkeufer",
    "Frühlingspfad",
    "See der Wahrheit",
    "See der Kühnheit",
    "See der Stärke",
    "Neumond-Insel",
    "Duellturm",
    "Kampfareal",
    "Überlebensareal",
    "Erholungsgebiet",
    "Kahlberg",
    "Buhnen-Pfad",
    "Halle d. Beginns",
    "Wahrheitsgrotte",
    "Kühnheitsgrotte",
    "Stärkegrotte",
    "Jubelstadt TV",
    "Pokétch Ges.",
    "GTS",
    "Trainerschule",
    "Bergbaumuseum",
    "Blumenladen",
    "Fahrradladen",
    "Wettbewerbshalle",
    "Knursperei",
    "Begegnungsstätte",
    "Pokémon-Pension",
    "Schleiede-Kaufh.",
    "Spielhalle",
    "Fleetburg-Bibl.",
    "Leuchtturm",
    "Sonnewik-Markt",
    "PKMN-Landgut",
    "Schrittritt-Haus",
    "Café",
    "Prachtsee",
    "Restaurant",
    "Duellpark",
    "Kampfzone",
    "Kampffabrik",
    "Kampfpalais",
    "Kampfarkaden",
    "Kampfsaal",
    "Zerrwelt",
    "Global. Terminal",
    "Villa",
    "Duellareal",
    "Raum von ROTOM",
    "Galaktik-Gebäude",
    "Eisen-Ruinen",
    "Eisberg-Ruinen",
    "Gipfelruinen",
    "Neuborkia",
    "Rosalia City",
    "Viola City",
    "Azalea City",
    "Anemonia City",
    "Dukatia City",
    "Oliviana City",
    "Teak City",
    "Mahagonia City",
    "See des Zorns",
    "Ebenholz City",
    "Silberberg",
    "Alabastia",
    "Vertania City",
    "Marmoria City",
    "Azuria City",
    "Lavandia",
    "Orania City",
    "Prismania City",
    "Fuchsania City",
    "Zinnoberinsel",
    "Indigo Plateau",
    "Saffronia City",
    "DIGDAs Höhle",
    "Mondberg",
    "Azuria-Höhle",
    "Felstunnel",
    "Kraftwerk",
    "Safari-Zone",
    "Seeschauminseln",
    "KNOFENSA-Turm",
    "Glockenturm",
    "Turmruine",
    "Nationalpark",
    "Radioturm",
    "Alph-Ruinen",
    "Einheitstunnel",
    "FLEGMON-Brunnen",
    "Leuchtturm",
    "Rocket-Versteck",
    "Steineichenwald",
    "Dukatia-Passage",
    "Kesselberg",
    "Eispfad",
    "Strudelinseln",
    "Silberberghöhle",
    "Dunkelhöhle",
    "Siegesstraße",
    "Drachenhöhle",
    "Tohjo-Fälle",
    "Vertania-Wald",
    "Pokéathlonhallen",
    "M.S. Aqua",
    "Safari-Eingang",
    "Felsschlundhöhle",
    "Kampfzonenzugang",
    "Glockenklangpfad",
    "Sinjoh-Ruinen",
    "Felsenherzturm",
    "Pokéwalker",
    "Felsklippentor"
  ])
end
