Run regression tests
--------------------

In simple terms, this is using the `tidy` binary of **your** choice to run a set of so called `regression` tests...

This means, using a console `tidy` binary of **your** choice, to input a known `case` file, or files, with a specific config, if one is given, else the `config_default.conf`, and output a message file, and the tidied html, to an `output` directory, and first to test the tidy exit value, and additionally, very important, to compare both the message and html outputs to what is **expected**...

That is, a one-by-one case compare the `expects` output with the current `output`. Any failure, either with the step one `tidy` exit value, or the compare of the current output with the `expects` is a cause for concern...

But as the current source `tidy` **next** branch moves forward so might this tests `next` branch move forward, but not in exact sync. That is many changes in the tidy source `next` branch may **not** mean any change is required in this `tests` **next** branch... but more on that later...

Some attempt has been made to `automate` this, and for Windows there is an `tools-cmd` folder, and for unix a `tools-sh` directory. All `testing` should be run **in** these folders, since some of the `environment` setup is based on being in these directories, repectively...

And the parallel default directory structure assumed is -

```
<some_root>/tidy-html5       # git clone and build of source
<some_root>/tidy-html5-tests # git clone of this tests
```

Always the first issue is which `tidy` binary to use? 

The `default` build of the `tidy` binary is to link `statically` to the `libtidy`, on purpose, so each `tidy` binary built is **not** dependant on some possibly different `libtidy` **shared** library!

If you have used some available cmake options, like `TIDY_CONSOLE_SHARED:BOOL=YES`, then all bets are **off**... This would mean a console `tidy` app would use an installed `libtidy`, of what ever version that is... and you would have to deal with any miss-matched variations here...

So assuming a `static` linked `tidy` binary...

#### tidy binary

The first issue is the `path` to the `tidy` binary to use... this is the relative, or absolute, path to the `tidy` binary to use... in a general sense this is the `TY_TIDY_PATH` environment variable - very **important**...

But how it is set depends on the port, Windows, ie `tools-cmd`, **or** Unix, ie `tools-sh`...

In Windows, the `alltest.bat` supports a command line `-t path/to/exe...` - use `alltest --help` -

```
    alltest [-t path/to/tidy.exe] [-o output_directory/] [-c case_set_name]
```

In Unix, the `run-tests.sh` **must** be manually adjusted to set the `TMPTIDY="/path/to/tidy"`... 

There are other ways to run the `tests` manually, but not fully dealt with here...

#### tidy test version

Naturally this `test` **next** branch is setup to work with the **next** branch of the tidy source...

There can be times, like at the time of writing, where this will **fail**, until a PR is merged, but in general this should work cleanly...

That is essentually the `workflow` of any changes to `tidy`... does it **pass** the regression tests? And should be done **before** presenting say any source **PR**...

Some changes do **not** necessarily mean a **failure**, depending on what was changed, and why, but some source `PR's` may also require a `PR` here to change the **test** `expects` to match...

But if you want to test a **previous** version of tidy, then it **may** be necessary to backup the `repo` to a place suitable for that **version**...

There is no easy way to determine this... repeat **no easy way**...

For example to `test` tidy version `5.4.0` we can get a suitable commit hash to back up to by running `$ git log -p cases/_version.txt > ../tempv.log`...

Review the `../tempv.log`... doing that you will see you will need commit 3123900, that is `$ git checkout 3123900`...

It will always be a little difficult to test older tidy versions, in that you must know how to find a suitable commit to back up the repo, which requires git knowledge...

#### general

Respectively, the `regression` tests can be run using `alltest.bat` Windows, **or** `run-tests.sh` Unix, but they require the `path` to the `tidy` version to **test**... and these scripts run other `scripts` in turn...

Personally, I have 10 or more `t-???.bat` files, like `t-643.bat`, to be able to **test** a very specific **new** version of `tidy.exe`... each tidy developer needs to add their own...

In each case there is also a `t1.bat`, `t1.sh` to just run **one** test... environment/command line conditions apply...

In general each `tidy` version should pass **all** tests!

But there are correct times when the **tests** need to be updated to match the `tidy` version, if, and only if, the difference between the `expects` and current output is fully understood, and **justified**, discussed and agreed...

And in general this is only for the `case_set_name`, `TY_CASES_SETNAME`, default **testbase**, but there exists **access**, **xml**, **special**, etc... test case targets... these have **not** been fully explored, or updated... and may, will!, need **work**...

Happy `tidy` **regression** testing...

; 20171231 - eof
