/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.joran.action;

import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.joran.action.Action;
import org.apache.log4j.joran.spi.ExecutionContext;
import org.apache.log4j.spi.ErrorItem;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.OptionHandler;
import org.xml.sax.Attributes;

public class LayoutAction
extends Action {
    Layout layout;
    boolean inError = false;
    static /* synthetic */ Class class$org$apache$log4j$Layout;

    public void begin(ExecutionContext ec, String name, Attributes attributes) {
        this.inError = false;
        String className = attributes.getValue("class");
        try {
            this.getLogger().debug("About to instantiate layout of type [" + className + "]");
            this.layout = (Layout)OptionConverter.instantiateByClassName(className, class$org$apache$log4j$Layout == null ? (class$org$apache$log4j$Layout = LayoutAction.class$("org.apache.log4j.Layout")) : class$org$apache$log4j$Layout, null);
            LoggerRepository repo = (LoggerRepository)ec.getObjectStack().get(0);
            this.layout.setLoggerRepository(repo);
            this.getLogger().debug("Pushing layout on top of the object stack.");
            ec.pushObject(this.layout);
        }
        catch (Exception oops) {
            this.inError = true;
            this.getLogger().error((Object)"Could not create an Layout. Reported error follows.", oops);
            ec.addError(new ErrorItem("Could not create layout of type " + className + "]."));
        }
    }

    public void end(ExecutionContext ec, String e) {
        Object o;
        if (this.inError) {
            return;
        }
        if (this.layout instanceof OptionHandler) {
            this.layout.activateOptions();
        }
        if ((o = ec.peekObject()) != this.layout) {
            this.getLogger().warn("The object on the top the of the stack is not the layout pushed earlier.");
        } else {
            this.getLogger().debug("Popping layout from the object stack");
            ec.popObject();
            try {
                this.getLogger().debug("About to set the layout of the containing appender.");
                Appender appender = (Appender)ec.peekObject();
                appender.setLayout(this.layout);
            }
            catch (Exception ex) {
                this.getLogger().error((Object)"Could not set the layout for containing appender.", ex);
            }
        }
    }

    public void finish(ExecutionContext ec) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

