/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.depend;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFileUtils;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ClassCPInfo;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPool;
import org.apache.tools.ant.taskdefs.optional.depend.constantpool.ConstantPoolEntry;

public class ClassFile {
    private static final int CLASS_MAGIC = -889275714;
    private ConstantPool constantPool;
    private String className;

    public void read(InputStream inputStream) throws IOException, ClassFormatError {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        if (dataInputStream.readInt() != -889275714) {
            throw new ClassFormatError("No Magic Code Found - probably not a Java class file.");
        }
        int n = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readUnsignedShort();
        this.constantPool = new ConstantPool();
        this.constantPool.read(dataInputStream);
        this.constantPool.resolve();
        int n3 = dataInputStream.readUnsignedShort();
        int n4 = dataInputStream.readUnsignedShort();
        int n5 = dataInputStream.readUnsignedShort();
        this.className = ((ClassCPInfo)this.constantPool.getEntry(n4)).getClassName();
    }

    public Vector getClassRefs() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.constantPool.size()) {
            ClassCPInfo classCPInfo;
            ConstantPoolEntry constantPoolEntry = this.constantPool.getEntry(n);
            if (constantPoolEntry != null && constantPoolEntry.getTag() == 7 && !(classCPInfo = (ClassCPInfo)constantPoolEntry).getClassName().equals(this.className)) {
                vector.addElement(ClassFileUtils.convertSlashName(classCPInfo.getClassName()));
            }
            ++n;
        }
        return vector;
    }

    public String getFullClassName() {
        return ClassFileUtils.convertSlashName(this.className);
    }
}

