sys.version_info(major=3, minor=10, micro=12, releaselevel='final', serial=0)

### Timing comparison of `int` functions

| Input type        | builtin (ms)       | fastnumbers (ms) |
| ----------------: | -----------------: | ---------------: |
|  Small Int String | **11.092 ± 0.432** |   12.237 ± 0.208 |
|        Int String | **11.861 ± 0.396** |   13.258 ± 0.604 |
| Medium Int String | **12.997 ± 0.203** |   13.446 ± 0.149 |
|  Large Int String | **17.833 ± 0.165** |   21.808 ± 0.589 |
|               Int |  **6.643 ± 0.078** |   10.165 ± 0.072 |
|             Float | **15.842 ± 0.077** |   20.163 ± 0.222 |

### Timing comparison of `float` functions

| Input type         | builtin (ms)       | fastnumbers (ms)   |
| -----------------: | -----------------: | -----------------: |
|   Small Int String |  **9.566 ± 0.183** |   13.027 ± 0.243   |
|         Int String | **10.394 ± 0.506** |   13.096 ± 0.291   |
|  Medium Int String | **11.413 ± 0.123** |   13.336 ± 0.032   |
|   Large Int String |   31.631 ± 1.921   | **18.929 ± 0.653** |
| Small Float String | **10.273 ± 0.231** |   14.179 ± 0.401   |
|       Float String |   30.081 ± 0.475   | **16.037 ± 1.841** |
| Large Float String |   54.017 ± 0.483   | **15.901 ± 0.240** |
|                Int |  **6.100 ± 0.116** |   11.657 ± 0.110   |
|              Float |  **5.161 ± 0.118** |   11.155 ± 0.830   |

### Timing comparison of `int` functions with error handling

| Input type         | try/except (ms)    | regex (ms)     | fastnumbers (ms)   |
| -----------------: | -----------------: | -------------: | -----------------: |
|  Non-number String |  113.202 ± 0.579   | 25.564 ± 0.110 | **25.252 ± 0.269** |
|   Small Int String | **16.965 ± 0.173** | 39.167 ± 0.142 |   24.718 ± 0.129   |
|         Int String | **17.452 ± 0.100** | 41.228 ± 0.315 |   24.957 ± 0.245   |
|  Medium Int String | **18.582 ± 0.040** | 45.616 ± 0.582 |   25.866 ± 0.241   |
|   Large Int String | **24.156 ± 0.145** | 63.173 ± 0.971 |   36.465 ± 0.163   |
| Small Float String |  110.149 ± 1.713   | 28.186 ± 0.097 | **24.986 ± 0.009** |
|       Float String |  114.896 ± 2.194   | 31.928 ± 0.195 | **24.745 ± 0.012** |
| Large Float String |  119.042 ± 2.276   | 31.819 ± 0.032 | **24.555 ± 0.003** |
|                Int | **11.635 ± 0.126** | 53.456 ± 1.543 |   20.933 ± 0.008   |
|              Float | **22.063 ± 0.034** | 63.347 ± 0.234 |   33.105 ± 0.009   |

### Timing comparison of `float` functions with error handling

| Input type         | try/except (ms)    | regex (ms)      | fastnumbers (ms)   |
| -----------------: | -----------------: | --------------: | -----------------: |
|  Non-number String |   56.617 ± 1.375   |  32.739 ± 0.163 | **27.683 ± 0.303** |
|   Small Int String | **15.291 ± 0.485** |  50.644 ± 0.255 |   28.029 ± 0.843   |
|         Int String | **15.720 ± 0.121** |  51.995 ± 0.196 |   27.200 ± 0.282   |
|  Medium Int String | **17.134 ± 0.069** |  55.756 ± 0.792 |   27.009 ± 0.735   |
|   Large Int String |   40.095 ± 0.966   |  93.589 ± 0.880 | **34.135 ± 0.171** |
| Small Float String | **15.468 ± 0.466** |  49.260 ± 0.964 |   27.918 ± 0.268   |
|       Float String |   36.782 ± 1.775   |  81.130 ± 1.230 | **28.737 ± 0.708** |
| Large Float String |   58.457 ± 0.102   | 108.927 ± 1.635 | **29.112 ± 0.794** |
|                Int | **10.307 ± 0.058** |  52.180 ± 0.937 |   23.691 ± 0.041   |
|              Float |  **9.346 ± 0.106** |  51.267 ± 0.351 |   22.532 ± 0.043   |

### Timing comparison of `float` (but coerce to `int` if possible) functions with error handling

| Input type         | try/except (ms)    | regex (ms)      | fastnumbers (ms)   |
| -----------------: | -----------------: | --------------: | -----------------: |
|  Non-number String |   57.608 ± 1.651   |  54.978 ± 0.326 | **27.921 ± 0.177** |
|   Small Int String | **26.613 ± 0.392** |  46.520 ± 1.416 |   29.897 ± 1.089   |
|         Int String |   29.245 ± 0.405   |  45.891 ± 0.712 | **28.096 ± 0.224** |
|  Medium Int String |   32.873 ± 0.565   |  49.332 ± 1.103 | **28.462 ± 0.428** |
|   Large Int String |   66.924 ± 0.429   |  67.025 ± 0.641 | **38.593 ± 0.716** |
| Small Float String | **25.545 ± 0.070** |  72.406 ± 0.396 |   27.890 ± 0.049   |
|       Float String |   62.505 ± 0.280   | 109.089 ± 0.757 | **35.906 ± 0.062** |
| Large Float String |  118.232 ± 1.297   | 136.863 ± 0.331 | **52.193 ± 1.313** |
|                Int | **20.701 ± 0.301** |  56.421 ± 0.255 |   22.572 ± 0.032   |
|              Float |   44.322 ± 0.212   |  55.771 ± 0.746 | **35.303 ± 0.059** |

### Timing comparison of forced `int` functions with error handling

| Input type         | try/except (ms)    | regex (ms)      | fastnumbers (ms)   |
| -----------------: | -----------------: | --------------: | -----------------: |
|  Non-number String |  175.536 ± 2.587   |  58.207 ± 1.653 | **26.633 ± 0.464** |
|   Small Int String | **16.959 ± 0.182** |  40.102 ± 0.287 |   24.765 ± 0.468   |
|         Int String | **16.974 ± 0.073** |  42.753 ± 0.154 |   25.931 ± 0.341   |
|  Medium Int String | **19.218 ± 0.021** |  86.577 ± 0.956 |   27.437 ± 0.051   |
|   Large Int String | **24.800 ± 0.063** | 123.863 ± 1.388 |   36.065 ± 0.708   |
| Small Float String |  120.859 ± 1.432   |  77.422 ± 1.719 | **25.935 ± 0.035** |
|       Float String |  157.032 ± 2.880   | 123.336 ± 2.130 | **34.594 ± 0.549** |
| Large Float String |  199.295 ± 1.216   | 165.259 ± 0.766 | **50.933 ± 0.184** |
|                Int | **11.577 ± 0.136** |  52.683 ± 0.715 |   20.948 ± 0.170   |
|              Float | **21.888 ± 0.056** |  63.656 ± 0.202 |   32.672 ± 0.499   |

### Timing comparison of forced `int` functions with error handling and denoising

| Input type        | Python (ms)        | fastnumbers (ms)   |
| ----------------: | -----------------: | -----------------: |
|  Small Int String |   93.493 ± 2.242   | **36.376 ± 0.558** |
|        Int String |  100.662 ± 2.329   | **36.382 ± 0.060** |
| Medium Int String |  102.393 ± 0.312   | **36.916 ± 0.585** |
|  Large Int String |  130.328 ± 0.827   | **46.775 ± 0.196** |
|               Int | **16.143 ± 0.139** |   31.414 ± 0.492   |
|             Float | **44.120 ± 0.474** |  147.534 ± 2.202   |

### Timing comparison to check if value can be converted to `int`

| Input type         | try/except (ms) | regex (ms)     | fastnumbers (ms)   |
| -----------------: | --------------: | -------------: | -----------------: |
|  Non-number String | 118.028 ± 1.823 | 41.887 ± 0.088 | **13.041 ± 0.050** |
|   Small Int String |  19.945 ± 0.062 | 43.000 ± 0.837 | **12.992 ± 0.108** |
|         Int String |  20.728 ± 0.061 | 44.557 ± 0.078 | **13.261 ± 0.049** |
|  Medium Int String |  22.067 ± 0.383 | 49.914 ± 1.883 | **13.193 ± 0.720** |
|   Large Int String |  28.054 ± 0.112 | 61.048 ± 0.344 | **13.330 ± 0.018** |
| Small Float String | 112.634 ± 2.110 | 41.909 ± 0.103 | **13.664 ± 0.051** |
|       Float String | 113.043 ± 1.858 | 46.018 ± 0.796 | **14.704 ± 0.023** |
| Large Float String | 116.146 ± 0.974 | 45.656 ± 0.831 | **14.341 ± 0.026** |
|                Int |  14.687 ± 0.100 | 15.973 ± 0.034 | **11.135 ± 0.055** |
|              Float |  25.165 ± 0.061 | 14.810 ± 0.048 | **11.580 ± 0.032** |

### Timing comparison to check if value can be converted to `float`

| Input type         | try/except (ms)    | regex (ms)     | fastnumbers (ms)   |
| -----------------: | -----------------: | -------------: | -----------------: |
|  Non-number String |   54.271 ± 0.501   | 39.412 ± 0.742 | **13.743 ± 0.046** |
|   Small Int String |   18.396 ± 0.075   | 48.818 ± 0.773 | **13.977 ± 0.082** |
|         Int String |   19.097 ± 0.081   | 49.772 ± 0.084 | **13.918 ± 0.165** |
|  Medium Int String |   22.318 ± 2.071   | 53.233 ± 0.140 | **13.738 ± 0.058** |
|   Large Int String |   43.237 ± 0.077   | 62.866 ± 0.820 | **13.883 ± 0.070** |
| Small Float String |   19.097 ± 0.765   | 46.680 ± 0.233 | **14.549 ± 0.041** |
|       Float String |   39.558 ± 0.065   | 58.776 ± 0.069 | **15.406 ± 0.039** |
| Large Float String |   64.763 ± 0.753   | 60.598 ± 0.875 | **14.992 ± 0.043** |
|                Int |   13.656 ± 0.097   | 15.824 ± 0.057 | **11.930 ± 0.044** |
|              Float | **12.355 ± 0.051** | 14.945 ± 0.074 |   12.445 ± 0.354   |

### Timing comparison to check if value can be converted to `float` or `int`

| Input type         | try/except (ms)    | regex (ms)     | fastnumbers (ms)   |
| -----------------: | -----------------: | -------------: | -----------------: |
|  Non-number String |   53.658 ± 0.350   | 39.587 ± 0.153 | **14.210 ± 0.044** |
|   Small Int String |   15.975 ± 0.051   | 48.993 ± 0.085 | **13.812 ± 0.290** |
|         Int String |   16.725 ± 0.616   | 50.617 ± 0.763 | **13.878 ± 0.152** |
|  Medium Int String |   17.625 ± 0.123   | 52.930 ± 0.106 | **13.833 ± 0.066** |
|   Large Int String |   40.287 ± 0.038   | 66.025 ± 2.936 | **14.981 ± 0.043** |
| Small Float String |   17.528 ± 0.114   | 52.857 ± 1.250 | **16.117 ± 0.082** |
|       Float String |   39.864 ± 0.734   | 61.293 ± 1.203 | **16.062 ± 0.112** |
| Large Float String |   61.656 ± 0.910   | 62.064 ± 1.048 | **15.764 ± 0.083** |
|                Int | **11.164 ± 0.112** | 14.399 ± 0.070 |   12.288 ± 0.112   |
|              Float |  **9.936 ± 0.134** | 12.923 ± 0.092 |   12.258 ± 0.124   |

### Timing comparison to check if value can be coerced losslessly to `int`

| Input type         | try/except (ms) | regex (ms)      | fastnumbers (ms)   |
| -----------------: | --------------: | --------------: | -----------------: |
|  Non-number String | 170.765 ± 1.858 |  50.004 ± 0.021 | **12.958 ± 0.096** |
|   Small Int String |  29.082 ± 0.030 |  28.829 ± 0.096 | **12.845 ± 0.085** |
|         Int String |  30.915 ± 0.752 |  30.586 ± 0.061 | **13.100 ± 0.060** |
|  Medium Int String |  37.731 ± 0.176 |  34.163 ± 0.044 | **13.224 ± 0.031** |
|   Large Int String |  72.769 ± 1.948 |  46.075 ± 0.071 | **13.854 ± 0.105** |
| Small Float String | 127.177 ± 2.296 |  71.233 ± 0.069 | **13.773 ± 0.040** |
|       Float String | 151.302 ± 2.129 | 107.778 ± 1.722 | **14.639 ± 0.052** |
| Large Float String | 180.478 ± 2.451 | 136.962 ± 2.403 | **14.761 ± 0.050** |
|                Int |  19.196 ± 0.090 |  55.841 ± 0.960 | **11.093 ± 0.024** |
|              Float |  43.682 ± 0.958 |  87.132 ± 4.137 | **11.791 ± 0.029** |

### Timing comparison of `map` option vs. iterating over `try_float` for a 50 element list

| Input type         | [try_float(x) for x in iterable] (ms) | list(map(try_float, iterable)) (ms) | list(try_float(iterable, map=True)) (ms) | try_float(iterable, map=list) (ms) |
| -----------------: | ------------------------------------: | ----------------------------------: | ---------------------------------------: | ---------------------------------: |
|  Non-number String |                     1482.567 ± 20.256 |                   1236.148 ± 49.371 |                         565.553 ± 1.914  |                **518.170 ± 1.063** |
|   Small Int String |                     1305.220 ± 3.554  |                   1206.032 ± 13.992 |                         512.903 ± 3.340  |                **465.668 ± 4.668** |
|         Int String |                     1348.915 ± 6.915  |                   1242.778 ± 13.141 |                         545.363 ± 4.215  |                **503.872 ± 4.873** |
|  Medium Int String |                     1453.734 ± 32.830 |                   1312.213 ± 6.849  |                         573.176 ± 3.782  |                **516.781 ± 5.425** |
|   Large Int String |                     1712.902 ± 24.834 |                   1594.502 ± 23.588 |                         816.883 ± 1.048  |                **765.571 ± 0.891** |
| Small Float String |                     1453.519 ± 6.409  |                   1323.319 ± 7.257  |                         577.669 ± 3.256  |                **521.870 ± 3.854** |
|       Float String |                     1548.539 ± 26.220 |                   1290.591 ± 2.738  |                         609.395 ± 2.951  |                **559.704 ± 0.929** |
| Large Float String |                     1427.750 ± 3.479  |                   1304.587 ± 2.346  |                         618.428 ± 4.291  |                **567.612 ± 0.963** |
|                Int |                     1228.263 ± 32.644 |                   1118.997 ± 11.022 |                         434.530 ± 2.691  |                **389.568 ± 7.671** |
|              Float |                     1261.292 ± 5.261  |                   1109.500 ± 3.782  |                         415.979 ± 10.739 |                **355.064 ± 3.159** |

### Timing comparison of `try_array` vs. `map` option for a 50 element list to a numpy array

| Input type         | np.array(try_float(iterable, map=True)) (ms) | try_array(iterable) (ms) | try_array(iterable, output) (ms) |
| -----------------: | -------------------------------------------: | -----------------------: | -------------------------------: |
|   Small Int String |                             732.517 ± 15.921 |          348.400 ± 4.755 |              **318.083 ± 3.908** |
|         Int String |                             737.113 ± 8.770  |          371.494 ± 5.423 |              **341.768 ± 1.819** |
|  Medium Int String |                             758.224 ± 5.928  |          387.031 ± 1.666 |              **360.645 ± 4.783** |
|   Large Int String |                             991.258 ± 3.948  |          622.803 ± 1.156 |              **599.306 ± 7.056** |
| Small Float String |                             743.274 ± 4.975  |          367.816 ± 0.625 |              **342.918 ± 3.585** |
|       Float String |                             833.836 ± 3.685  |          482.629 ± 5.504 |              **448.936 ± 3.358** |
| Large Float String |                             833.565 ± 3.566  |          490.710 ± 1.109 |              **446.306 ± 9.360** |
|                Int |                             564.029 ± 2.480  |          347.858 ± 1.909 |              **322.863 ± 0.912** |
|              Float |                             527.257 ± 3.082  |          307.528 ± 1.075 |              **282.723 ± 1.460** |

