<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.0//EN">
<html> <head>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8">
<title>Getting Netpbm</title>

<style type="text/css">
DIV.div1 { margin: 15px 10px 5px 20px; }
DIV.div2 { margin: 5px 10px 0px 20px; }
DIV.div3 { text-align: right; }
H1.h1a { border-bottom: 1px black solid; }
TD.td1 { padding: 5px 10px 5px 10px; }
TD.td2 { padding: 5px 10px 5px 10px; }
TD.td3 {
	padding: 5px 10px 5px 10px;
	text-align: center;
}
TH.th1 {
	padding: 10px 10px 10px 10px;
	font-size: larger;
	background-color: #EEFF00;
}
TABLE.table1 {
	border-width: 1px 2px 2px 1px;
	border-style: solid;
	border-color: red;
}
</style>
</head>




<body>

<h1>Getting Netpbm</h1>

<h2>Netpbm Source Package</h2>

<p>The most basic way to get Netpbm is to get the source package from
the Netpbm Sourceforge project and build it for the particular system
on which you want to run it.

<p>Netpbm has a sophisticated system of releasing source code
(see <a href="release.html">Release System</a>), but you probably don't
need to know any more than the following to download Netpbm.

<p>No matter how you get the Netpbm source code, you have to
<em>build</em> it, following instructions and using tools in the
package, before you can install and use it.

<p>The source code packages <em>do not contain documentation</em>.  The
documentation is <a href="doc">online</a>, and if you want a local copy, you
can get it from the <b>userguide</b> directory in Subversion:

<pre>
<kbd>
    svn checkout http://svn.code.sf.net/p/netpbm/code/userguide userguide
</kbd>
</pre>

<p>(Before 2013, there was also a way to get a tarball, using a Sourceforge
feature that generated it from the Subversion repository, but Sourceforge
withdrew that service).

<p>There are more details on installing local documentation in the source code
pacakge in the <b>doc/USERDOC</b> file.

<p>At any particular time, there are 3 Netpbm releases from which to choose:

<table frame="hsides" rules="all">
<tr>
<th>Series name
<th>Bugs
<th>Features
<th>How to download

<tr>
<td>Super Stable
<td>Very few
<td>more than 3 years old
<td>Conventional source code tarball from Sourceforge

<tr>
<td>Stable
<td>Few
<td>1/4 - 3 years old
<td>Subversion

<tr>
<td>Advanced
<td>Many
<td>up to 1/4 year old
<td>Subversion

</table>

<p>Note that <b>none of these releases we're talking about have
<em>any</em> known bugs</b>.  The bugs are those that haven't been
reported yet.

<h3>Downloading A Tarball</h3>

<p>Get the tarball for the Super Stable release from
<a href="http://sourceforge.net/project/showfiles.php?group_id=5128">
Sourceforge</a>.

<p>This is a highly conventional Unix source code package.  Use the
conventional Unix program <b>tar</b> to unpack it.  It is Gzipped.

<p>The project does not distribute tarballs for the other release series.

<p>You can get Sourceforge to make you a tarball of the current Development
release.  It is a rather quirky feature of <a href="#browsing">browsing</a>
the code.

<p>(Before 2013, there was a way to get a tarball of all the series, using a
Sourceforge feature that generated it from the Subversion repository, but
Sourceforge withdrew that service).


<h3>Downloading From Subversion</h3>

<p>Downloading from Subversion is not a common way to get a release of
software, but it is very easy.  You need a Subversion client program
to do it, but even that is not hard to get, and you may well find
other uses for a Subversion client later.

<p><a href="http://subversion.apache.org">Subversion</a> is a source code
control system (like <b>git</b>) -- a system designed for tracking changes to
code as people develop it.  Subversion is primarily intended to be used by
developers, but works well as a release tool as well.

<p>If you <em>need</em> a tarball of a Netpbm release, it is not hard to
write a program to extract it from Subversion (use a Subversion <b>export</b>
command) and generate the tarball from that.

<p>The reason Netpbm uses this nontraditional method of distributing
code is that it saves work for the Netpbm maintainer.  In some cases,
it shifts work from the maintainer to the user.  In others, it actually
eliminates work.

<p>If you don't have Subversion installed on your system (type
<kbd>svn</kbd> at a shell prompt to find out), see <a
href="gettingsubversion.html">Getting Subversion</a> for information on
getting it.

<p>The URL of the Netpbm Subversion repository is
<b>http://svn.code.sf.net/p/netpbm/code</b>.  So to download the
current Stable release:

<pre>
<kbd>
    svn checkout http://svn.code.sf.net/p/netpbm/code/stable netpbm
</kbd>
</pre>

<p>That puts the source tree in a directory called <tt>netpbm</tt> in
your current directory.

<p>To download the current Advanced release, replace &quot;stable&quot; with
&quot;advanced&quot; in the above command.


<h3 id="browsing">Browsing</h3>

<p>You can browse the source code one file at a time with
Sourceforge's <a
href="http://sourceforge.net/p/netpbm/code/HEAD/tree">Subversion web
access</a>.

<p>There is a misleading button in that facility labelled &quot;Download
Snapshot.&quot; at the right end of the title bar that is near the
middle of the page.  You might think that that downloads a snapshot of the
part of the repository you are viewing, or maybe downloads a snapshot of
the entire repository, but what it does is download a snapshot of the
&quot;trunk&quot; directory regardless of what part of the repository
you are viewing.


<h2>Pre-Built Distributions</h2>

<p>There are a few distributions of Netpbm pre-built for particular kinds of
systems.  These are often called "binary" distributions.  The "Netpbm
maintainer" is the maintainer only of the source package, though.  The
pre-built packages are distributed independently from the Netpbm source
package.  They are typically based on a fairly downlevel Netpbm source
package.

<p>If you have built Netpbm for a common platform, consider making it
available to others; Contact the Netpbm maintainer to get it listed here or to
add it to the Netpbm Sourceforge project.

<p>Here are pre-built distributions the Netpbm maintainer knows about:

<h4>Linux</h4>

Lots of &quot;Linux distributions&quot; include Netpbm at least optionally, so
you can get it via the normal distribution system for the distribution.

<p><strong>But if you use Debian before Version 11 or Ubuntu 22</strong>, note
that their Netpbm package is essentially Netpbm 9.25 from 2002, minus a bunch
of unimportant programs.  Also note that the Debian version numbering (in
these old versions) is not consistent with Sourceforge Netpbm, so a program
may appear to be from e.g. Sourceforge Netpbm 10.0, but is actually 9.25.  In
2002, Debian decided for various reasons not to distribute regular Netpbm and
instead created its own variation of it.  That variation was too hard to
update with ongoing development on the main branch of Netpbm, so no one did so
until around 2017, with the result being included in Debian 11, which became
Debian Stable in June 2023.

<p>
Also:

<ul>

<li><a href="http://rpm.pbone.net/index.php3/stat/3/search/netpbm">
RPM Pbone Search</a>: lists Netpbm RPMs for various Linux systems.

<li><a href="http://www.rpmfind.net/linux/rpm2html/search.php?query=netpbm">
Rpmfind</a>: lists Netpbm RPMs for various Linux systems.

<li>Netpbm for Slackware:

<ul>
  <li><a href="http://mirrors.slackware.com/slackware/slackware-current/source/l/netpbm/">32 bit</a>

  <li><a href="http://mirrors.slackware.com/slackware/slackware-current/source/l/netpbm/">64 bit</a>

  <li><a href="http://keesan.freeshell.org/bl/netpbm-10.31-SW81-full.tgz">
Netpbm 10.31 for Slackware 8.1</a>

</ul>


<h4>BSD</h4>

<ul>

<li><a
href="http://pkgsrc.se/graphics/netpbm/">Netpbm for NetBSD</a>.

<li><a href="http://www.freebsd.org/ports/">FreeBSD.org</a>.  You can add
Netpbm to a FreeBSD system with a <kbd>pkg install -y netpbm</kbd> command.

<li><a href="http://www.freshports.org">Freshports.org</a>: FreeBSD.

</ul>


<h4>Windows</h4>

<ul>

<li>The <a href="http://www.cygwin.com">Cygwin project</a> (for the Cygwin
environment).  Install it via the regular Cygwin installer (setup.exe).

<li><a href="http://gnuwin32.sourceforge.net/packages/netpbm.htm">Netpbm
for Windows using Mingw32 and GNU Bash</a>, distributed by the GnuWin32
Project.  Last update 2005.

</ul>


<h4>Mac OS X/Darwin</h4>

<ul>
  <li><a href="http://pdb.finkproject.org/pdb/package.php/netpbm10">Fink</a>

  <li><a href="https://trac.macports.org/browser/trunk/dports/graphics/netpbm/Portfile">MacPorts</a>
    (ports also available for FreeBSD)

  </ul>


<h4>Solaris</h4>

<ul>
<li><a href="http://unixpackages.com">Unixpackages</a>: for many versions of
Solaris, for a fee.

<li><a href="http://www.sunfreeware.com">sunfreeware.com</a> for Solaris 10,
Sparc and x86, maintained by <a href="mailto:steve@smc.vnet.net">Steven
M. Christensen</a>.

<li><a href="http://www.opencsw.org/packages/CSWnetpbm/">Opensw</a>

<li><a href="http://www.ibiblio.org/pub/packages/solaris/sparc/">ibiblio</a>,
maintained by <a href="mailto:mark@ibiblio.org">mark@ibiblio.org</a>.

</ul>


<h4>AIX</h4>

<ul>

<li><a href="http://www.perzl.org/aix/index.php?n=Main.Netpbm">Michael
Perzl's open source software for AIX repository</a> (files come from
<a href="http://www.oss4aix.org/download/RPMS/netpbm/">this server</a>).

</ul>

<h4>Other</h4>

<ul>

<li><a href="http://Amiga.SourceForge.net">Netpbm for Amiga</a>,
maintained by <a href="mailto:dcr8520@amiga.org">Diego Casorran</a>.

</ul>

<hr>
<address style="font-size:75%">
By Bryan Henderson, Lacey, WA;  bryanh@giraffe-data.com
last checked 2023.07.23.
</address>

<p style="font-size:75%">
This page was generated on 10 Mar 2025.


</body> </html>
