; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mattr=+fma | FileCheck %s

; This test checks that (fneg (fma (fneg x), y, (fneg z))) can't be folded to (fma x, y, z)
; without no signed zeros flag (nsz).

declare float @llvm.fma.f32(float, float, float)

define float @fneg_fma32(float %x, float %y, float %z) {
; CHECK-LABEL: fneg_fma32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfnmsub213ss {{.*#+}} xmm0 = -(xmm1 * xmm0) - xmm2
; CHECK-NEXT:    vxorps {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; CHECK-NEXT:    retq
  %negx = fneg float %x
  %negz = fneg float %z
  %fma = call float @llvm.fma.f32(float %negx, float %y, float %negz)
  %n = fneg float %fma
  ret float %n
}

define float @fneg_fma32_nsz(float %x, float %y, float %z) {
; CHECK-LABEL: fneg_fma32_nsz:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmadd213ss {{.*#+}} xmm0 = (xmm1 * xmm0) + xmm2
; CHECK-NEXT:    retq
  %negx = fneg float %x
  %negz = fneg float %z
  %fma = call nsz float @llvm.fma.f32(float %negx, float %y, float %negz)
  %n = fneg float %fma
  ret float %n
}

declare double @llvm.fma.f64(double, double, double)

define double @fneg_fma64(double %x, double %y, double %z) {
; CHECK-LABEL: fneg_fma64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfnmsub213sd {{.*#+}} xmm0 = -(xmm1 * xmm0) - xmm2
; CHECK-NEXT:    vxorpd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; CHECK-NEXT:    retq
  %negx = fneg double %x
  %negz = fneg double %z
  %fma = call double @llvm.fma.f64(double %negx, double %y, double %negz)
  %n = fneg double %fma
  ret double %n
}

define double @fneg_fma64_nsz(double %x, double %y, double %z) {
; CHECK-LABEL: fneg_fma64_nsz:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfmadd213sd {{.*#+}} xmm0 = (xmm1 * xmm0) + xmm2
; CHECK-NEXT:    retq
  %negx = fneg double %x
  %negz = fneg double %z
  %fma = call nsz double @llvm.fma.f64(double %negx, double %y, double %negz)
  %n = fneg double %fma
  ret double %n
}
