; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=hexagon < %s | FileCheck %s

declare i32 @llvm.hexagon.S2.tstbit.i(i32, i32 immarg) #0

define i1 @f0(i32 %a0, i32 %a1) #1 {
; CHECK-LABEL: f0:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p0,p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = p0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a0, i32 3)
  %v1 = trunc i32 %v0 to i1
  %v2 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a1, i32 3)
  %v3 = trunc i32 %v2 to i1
  %v4 = and i1 %v1, %v3
  ret i1 %v4
}

define i1 @f1(i32 %a0, i32 %a1) #1 {
; CHECK-LABEL: f1:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p0,p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = p0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a0, i32 3)
  %v1 = trunc i32 %v0 to i1
  %v2 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a1, i32 3)
  %v3 = trunc i32 %v2 to i1
  %v4 = or i1 %v1, %v3
  ret i1 %v4
}

define i1 @f2(i32 %a0, i32 %a1) #1 {
; CHECK-LABEL: f2:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = xor(p0,p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = p0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a0, i32 3)
  %v1 = trunc i32 %v0 to i1
  %v2 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a1, i32 3)
  %v3 = trunc i32 %v2 to i1
  %v4 = xor i1 %v1, %v3
  ret i1 %v4
}

define i1 @f3(i32 %a0, i32 %a1) #1 {
; CHECK-LABEL: f3:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = p0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = p1
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p0,!p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = mux(p0,#1,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a0, i32 3)
  %v1 = trunc i32 %v0 to i1
  %v2 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a1, i32 3)
  %v3 = trunc i32 %v2 to i1
  %v4 = xor i1 %v3, true
  %v5 = and i1 %v1, %v4
  ret i1 %v5
}

define i1 @f4(i32 %a0, i32 %a1) #1 {
; CHECK-LABEL: f4:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = p0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = p1
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p0,!p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = mux(p0,#1,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a0, i32 3)
  %v1 = trunc i32 %v0 to i1
  %v2 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a1, i32 3)
  %v3 = trunc i32 %v2 to i1
  %v4 = xor i1 %v3, true
  %v5 = or i1 %v1, %v4
  ret i1 %v5
}

define i1 @f5(i32 %a0, i32 %a1, i32 %a2) #1 {
; CHECK-LABEL: f5:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = tstbit(r2,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p2,and(p0,p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = p0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a0, i32 3)
  %v1 = trunc i32 %v0 to i1
  %v2 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a1, i32 3)
  %v3 = trunc i32 %v2 to i1
  %v4 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a2, i32 3)
  %v5 = trunc i32 %v4 to i1
  %v6 = and i1 %v1, %v3
  %v7 = and i1 %v5, %v6
  ret i1 %v7
}

define i1 @f6(i32 %a0, i32 %a1, i32 %a2) #1 {
; CHECK-LABEL: f6:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = tstbit(r2,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p2,or(p0,p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = p0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a0, i32 3)
  %v1 = trunc i32 %v0 to i1
  %v2 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a1, i32 3)
  %v3 = trunc i32 %v2 to i1
  %v4 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a2, i32 3)
  %v5 = trunc i32 %v4 to i1
  %v6 = or i1 %v1, %v3
  %v7 = and i1 %v5, %v6
  ret i1 %v7
}

define i1 @f7(i32 %a0, i32 %a1, i32 %a2) #1 {
; CHECK-LABEL: f7:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = tstbit(r2,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p2,and(p0,p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = p0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a0, i32 3)
  %v1 = trunc i32 %v0 to i1
  %v2 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a1, i32 3)
  %v3 = trunc i32 %v2 to i1
  %v4 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a2, i32 3)
  %v5 = trunc i32 %v4 to i1
  %v6 = and i1 %v1, %v3
  %v7 = or i1 %v5, %v6
  ret i1 %v7
}

define i1 @f8(i32 %a0, i32 %a1, i32 %a2) #1 {
; CHECK-LABEL: f8:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = tstbit(r2,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p2,or(p0,p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = p0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a0, i32 3)
  %v1 = trunc i32 %v0 to i1
  %v2 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a1, i32 3)
  %v3 = trunc i32 %v2 to i1
  %v4 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a2, i32 3)
  %v5 = trunc i32 %v4 to i1
  %v6 = or i1 %v1, %v3
  %v7 = or i1 %v5, %v6
  ret i1 %v7
}

define i1 @f9(i32 %a0, i32 %a1, i32 %a2) #1 {
; CHECK-LABEL: f9:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = tstbit(r2,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = p0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = p1
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r2 = p2
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = tstbit(r2,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p2,and(p0,!p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = mux(p0,#1,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a0, i32 3)
  %v1 = trunc i32 %v0 to i1
  %v2 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a1, i32 3)
  %v3 = trunc i32 %v2 to i1
  %v4 = xor i1 %v3, true
  %v5 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a2, i32 3)
  %v6 = trunc i32 %v5 to i1
  %v7 = and i1 %v1, %v4
  %v8 = and i1 %v6, %v7
  ret i1 %v8
}

define i1 @f10(i32 %a0, i32 %a1, i32 %a2) #1 {
; CHECK-LABEL: f10:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = tstbit(r2,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = p0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = p1
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r2 = p2
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = tstbit(r2,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p2,or(p0,!p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = mux(p0,#1,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a0, i32 3)
  %v1 = trunc i32 %v0 to i1
  %v2 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a1, i32 3)
  %v3 = trunc i32 %v2 to i1
  %v4 = xor i1 %v3, true
  %v5 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a2, i32 3)
  %v6 = trunc i32 %v5 to i1
  %v7 = or i1 %v1, %v4
  %v8 = and i1 %v6, %v7
  ret i1 %v8
}

define i1 @f11(i32 %a0, i32 %a1, i32 %a2) #1 {
; CHECK-LABEL: f11:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = tstbit(r2,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = p0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = p1
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r2 = p2
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = tstbit(r2,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p2,and(p0,!p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = mux(p0,#1,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a0, i32 3)
  %v1 = trunc i32 %v0 to i1
  %v2 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a1, i32 3)
  %v3 = trunc i32 %v2 to i1
  %v4 = xor i1 %v3, true
  %v5 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a2, i32 3)
  %v6 = trunc i32 %v5 to i1
  %v7 = and i1 %v1, %v4
  %v8 = or i1 %v6, %v7
  ret i1 %v8
}

define i1 @f12(i32 %a0, i32 %a1, i32 %a2) #1 {
; CHECK-LABEL: f12:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = tstbit(r2,#3)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = p0
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1 = p1
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r2 = p2
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = tstbit(r0,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = tstbit(r1,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = tstbit(r2,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p2,or(p0,!p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r0 = mux(p0,#1,#0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a0, i32 3)
  %v1 = trunc i32 %v0 to i1
  %v2 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a1, i32 3)
  %v3 = trunc i32 %v2 to i1
  %v4 = xor i1 %v3, true
  %v5 = call i32 @llvm.hexagon.S2.tstbit.i(i32 %a2, i32 3)
  %v6 = trunc i32 %v5 to i1
  %v7 = or i1 %v1, %v4
  %v8 = or i1 %v6, %v7
  ret i1 %v8
}

define <2 x i32> @f13(<2 x i32> %a0, <2 x i32> %a1) #1 {
; CHECK-LABEL: f13:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r5:4 = combine(#1,#1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpw.eq(r1:0,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpw.eq(r3:2,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p0,p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <2 x i32> %a0, <i32 1, i32 1>
  %v1 = icmp eq <2 x i32> %a1, <i32 1, i32 1>
  %v2 = and <2 x i1> %v0, %v1
  %v3 = sext <2 x i1> %v2 to <2 x i32>
  ret <2 x i32> %v3
}

define <2 x i32> @f14(<2 x i32> %a0, <2 x i32> %a1) #1 {
; CHECK-LABEL: f14:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r5:4 = combine(#1,#1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpw.eq(r1:0,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpw.eq(r3:2,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p0,p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <2 x i32> %a0, <i32 1, i32 1>
  %v1 = icmp eq <2 x i32> %a1, <i32 1, i32 1>
  %v2 = or <2 x i1> %v0, %v1
  %v3 = sext <2 x i1> %v2 to <2 x i32>
  ret <2 x i32> %v3
}

define <2 x i32> @f15(<2 x i32> %a0, <2 x i32> %a1) #1 {
; CHECK-LABEL: f15:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r5:4 = combine(#1,#1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpw.eq(r1:0,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpw.eq(r3:2,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = xor(p0,p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <2 x i32> %a0, <i32 1, i32 1>
  %v1 = icmp eq <2 x i32> %a1, <i32 1, i32 1>
  %v2 = xor <2 x i1> %v0, %v1
  %v3 = sext <2 x i1> %v2 to <2 x i32>
  ret <2 x i32> %v3
}

define <2 x i32> @f16(<2 x i32> %a0, <2 x i32> %a1) #1 {
; CHECK-LABEL: f16:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r5:4 = combine(#1,#1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpw.eq(r1:0,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpw.eq(r3:2,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p0,!p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <2 x i32> %a0, <i32 1, i32 1>
  %v1 = icmp eq <2 x i32> %a1, <i32 1, i32 1>
  %v2 = xor <2 x i1> %v1, <i1 true, i1 true>
  %v3 = and <2 x i1> %v0, %v2
  %v4 = sext <2 x i1> %v3 to <2 x i32>
  ret <2 x i32> %v4
}

define <2 x i32> @f17(<2 x i32> %a0, <2 x i32> %a1) #1 {
; CHECK-LABEL: f17:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r5:4 = combine(#1,#1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpw.eq(r1:0,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpw.eq(r3:2,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p0,!p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <2 x i32> %a0, <i32 1, i32 1>
  %v1 = icmp eq <2 x i32> %a1, <i32 1, i32 1>
  %v2 = xor <2 x i1> %v1, <i1 true, i1 true>
  %v3 = or <2 x i1> %v0, %v2
  %v4 = sext <2 x i1> %v3 to <2 x i32>
  ret <2 x i32> %v4
}

define <2 x i32> @f18(<2 x i32> %a0, <2 x i32> %a1, <2 x i32> %a2) #1 {
; CHECK-LABEL: f18:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r7:6 = combine(#1,#1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpw.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpw.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmpw.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p2,and(p0,p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <2 x i32> %a0, <i32 1, i32 1>
  %v1 = icmp eq <2 x i32> %a1, <i32 1, i32 1>
  %v2 = icmp eq <2 x i32> %a2, <i32 1, i32 1>
  %v3 = and <2 x i1> %v0, %v1
  %v4 = and <2 x i1> %v2, %v3
  %v5 = sext <2 x i1> %v4 to <2 x i32>
  ret <2 x i32> %v5
}

define <2 x i32> @f19(<2 x i32> %a0, <2 x i32> %a1, <2 x i32> %a2) #1 {
; CHECK-LABEL: f19:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r7:6 = combine(#1,#1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpw.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpw.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmpw.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p2,or(p0,p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <2 x i32> %a0, <i32 1, i32 1>
  %v1 = icmp eq <2 x i32> %a1, <i32 1, i32 1>
  %v2 = icmp eq <2 x i32> %a2, <i32 1, i32 1>
  %v3 = or <2 x i1> %v0, %v1
  %v4 = and <2 x i1> %v2, %v3
  %v5 = sext <2 x i1> %v4 to <2 x i32>
  ret <2 x i32> %v5
}

define <2 x i32> @f20(<2 x i32> %a0, <2 x i32> %a1, <2 x i32> %a2) #1 {
; CHECK-LABEL: f20:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r7:6 = combine(#1,#1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpw.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpw.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmpw.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p2,and(p0,p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <2 x i32> %a0, <i32 1, i32 1>
  %v1 = icmp eq <2 x i32> %a1, <i32 1, i32 1>
  %v2 = icmp eq <2 x i32> %a2, <i32 1, i32 1>
  %v3 = and <2 x i1> %v0, %v1
  %v4 = or <2 x i1> %v2, %v3
  %v5 = sext <2 x i1> %v4 to <2 x i32>
  ret <2 x i32> %v5
}

define <2 x i32> @f21(<2 x i32> %a0, <2 x i32> %a1, <2 x i32> %a2) #1 {
; CHECK-LABEL: f21:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r7:6 = combine(#1,#1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpw.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpw.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmpw.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p2,or(p0,p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <2 x i32> %a0, <i32 1, i32 1>
  %v1 = icmp eq <2 x i32> %a1, <i32 1, i32 1>
  %v2 = icmp eq <2 x i32> %a2, <i32 1, i32 1>
  %v3 = or <2 x i1> %v0, %v1
  %v4 = or <2 x i1> %v2, %v3
  %v5 = sext <2 x i1> %v4 to <2 x i32>
  ret <2 x i32> %v5
}

define <2 x i32> @f22(<2 x i32> %a0, <2 x i32> %a1, <2 x i32> %a2) #1 {
; CHECK-LABEL: f22:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r7:6 = combine(#1,#1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpw.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpw.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmpw.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p2,and(p0,!p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <2 x i32> %a0, <i32 1, i32 1>
  %v1 = icmp eq <2 x i32> %a1, <i32 1, i32 1>
  %v2 = xor <2 x i1> %v1, <i1 true, i1 true>
  %v3 = icmp eq <2 x i32> %a2, <i32 1, i32 1>
  %v4 = and <2 x i1> %v0, %v2
  %v5 = and <2 x i1> %v3, %v4
  %v6 = sext <2 x i1> %v5 to <2 x i32>
  ret <2 x i32> %v6
}

define <2 x i32> @f23(<2 x i32> %a0, <2 x i32> %a1, <2 x i32> %a2) #1 {
; CHECK-LABEL: f23:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r7:6 = combine(#1,#1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpw.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpw.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmpw.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p2,or(p0,!p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <2 x i32> %a0, <i32 1, i32 1>
  %v1 = icmp eq <2 x i32> %a1, <i32 1, i32 1>
  %v2 = xor <2 x i1> %v1, <i1 true, i1 true>
  %v3 = icmp eq <2 x i32> %a2, <i32 1, i32 1>
  %v4 = or <2 x i1> %v0, %v2
  %v5 = and <2 x i1> %v3, %v4
  %v6 = sext <2 x i1> %v5 to <2 x i32>
  ret <2 x i32> %v6
}

define <2 x i32> @f24(<2 x i32> %a0, <2 x i32> %a1, <2 x i32> %a2) #1 {
; CHECK-LABEL: f24:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r7:6 = combine(#1,#1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpw.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpw.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmpw.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p2,and(p0,!p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <2 x i32> %a0, <i32 1, i32 1>
  %v1 = icmp eq <2 x i32> %a1, <i32 1, i32 1>
  %v2 = xor <2 x i1> %v1, <i1 true, i1 true>
  %v3 = icmp eq <2 x i32> %a2, <i32 1, i32 1>
  %v4 = and <2 x i1> %v0, %v2
  %v5 = or <2 x i1> %v3, %v4
  %v6 = sext <2 x i1> %v5 to <2 x i32>
  ret <2 x i32> %v6
}

define <2 x i32> @f25(<2 x i32> %a0, <2 x i32> %a1, <2 x i32> %a2) #1 {
; CHECK-LABEL: f25:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r7:6 = combine(#1,#1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpw.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpw.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmpw.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p2,or(p0,!p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <2 x i32> %a0, <i32 1, i32 1>
  %v1 = icmp eq <2 x i32> %a1, <i32 1, i32 1>
  %v2 = xor <2 x i1> %v1, <i1 true, i1 true>
  %v3 = icmp eq <2 x i32> %a2, <i32 1, i32 1>
  %v4 = or <2 x i1> %v0, %v2
  %v5 = or <2 x i1> %v3, %v4
  %v6 = sext <2 x i1> %v5 to <2 x i32>
  ret <2 x i32> %v6
}

define <4 x i16> @f26(<4 x i16> %a0, <4 x i16> %a1) #1 {
; CHECK-LABEL: f26:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r4 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r5 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmph.eq(r1:0,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmph.eq(r3:2,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p0,p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <4 x i16> %a0, <i16 1, i16 1, i16 1, i16 1>
  %v1 = icmp eq <4 x i16> %a1, <i16 1, i16 1, i16 1, i16 1>
  %v2 = and <4 x i1> %v0, %v1
  %v3 = sext <4 x i1> %v2 to <4 x i16>
  ret <4 x i16> %v3
}

define <4 x i16> @f27(<4 x i16> %a0, <4 x i16> %a1) #1 {
; CHECK-LABEL: f27:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r4 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r5 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmph.eq(r1:0,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmph.eq(r3:2,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p0,p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <4 x i16> %a0, <i16 1, i16 1, i16 1, i16 1>
  %v1 = icmp eq <4 x i16> %a1, <i16 1, i16 1, i16 1, i16 1>
  %v2 = or <4 x i1> %v0, %v1
  %v3 = sext <4 x i1> %v2 to <4 x i16>
  ret <4 x i16> %v3
}

define <4 x i16> @f28(<4 x i16> %a0, <4 x i16> %a1) #1 {
; CHECK-LABEL: f28:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r4 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r5 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmph.eq(r1:0,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmph.eq(r3:2,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = xor(p0,p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <4 x i16> %a0, <i16 1, i16 1, i16 1, i16 1>
  %v1 = icmp eq <4 x i16> %a1, <i16 1, i16 1, i16 1, i16 1>
  %v2 = xor <4 x i1> %v0, %v1
  %v3 = sext <4 x i1> %v2 to <4 x i16>
  ret <4 x i16> %v3
}

define <4 x i16> @f29(<4 x i16> %a0, <4 x i16> %a1) #1 {
; CHECK-LABEL: f29:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r4 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r5 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmph.eq(r1:0,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmph.eq(r3:2,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p0,!p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <4 x i16> %a0, <i16 1, i16 1, i16 1, i16 1>
  %v1 = icmp eq <4 x i16> %a1, <i16 1, i16 1, i16 1, i16 1>
  %v2 = xor <4 x i1> %v1, <i1 true, i1 true, i1 true, i1 true>
  %v3 = and <4 x i1> %v0, %v2
  %v4 = sext <4 x i1> %v3 to <4 x i16>
  ret <4 x i16> %v4
}

define <4 x i16> @f30(<4 x i16> %a0, <4 x i16> %a1) #1 {
; CHECK-LABEL: f30:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r4 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r5 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmph.eq(r1:0,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmph.eq(r3:2,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p0,!p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <4 x i16> %a0, <i16 1, i16 1, i16 1, i16 1>
  %v1 = icmp eq <4 x i16> %a1, <i16 1, i16 1, i16 1, i16 1>
  %v2 = xor <4 x i1> %v1, <i1 true, i1 true, i1 true, i1 true>
  %v3 = or <4 x i1> %v0, %v2
  %v4 = sext <4 x i1> %v3 to <4 x i16>
  ret <4 x i16> %v4
}

define <4 x i16> @f31(<4 x i16> %a0, <4 x i16> %a1, <4 x i16> %a2) #1 {
; CHECK-LABEL: f31:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r6 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r7 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmph.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmph.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmph.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p2,and(p0,p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <4 x i16> %a0, <i16 1, i16 1, i16 1, i16 1>
  %v1 = icmp eq <4 x i16> %a1, <i16 1, i16 1, i16 1, i16 1>
  %v2 = icmp eq <4 x i16> %a2, <i16 1, i16 1, i16 1, i16 1>
  %v3 = and <4 x i1> %v0, %v1
  %v4 = and <4 x i1> %v2, %v3
  %v5 = sext <4 x i1> %v4 to <4 x i16>
  ret <4 x i16> %v5
}

define <4 x i16> @f32(<4 x i16> %a0, <4 x i16> %a1, <4 x i16> %a2) #1 {
; CHECK-LABEL: f32:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r6 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r7 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmph.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmph.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmph.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p2,or(p0,p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <4 x i16> %a0, <i16 1, i16 1, i16 1, i16 1>
  %v1 = icmp eq <4 x i16> %a1, <i16 1, i16 1, i16 1, i16 1>
  %v2 = icmp eq <4 x i16> %a2, <i16 1, i16 1, i16 1, i16 1>
  %v3 = or <4 x i1> %v0, %v1
  %v4 = and <4 x i1> %v2, %v3
  %v5 = sext <4 x i1> %v4 to <4 x i16>
  ret <4 x i16> %v5
}

define <4 x i16> @f33(<4 x i16> %a0, <4 x i16> %a1, <4 x i16> %a2) #1 {
; CHECK-LABEL: f33:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r6 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r7 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmph.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmph.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmph.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p2,and(p0,p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <4 x i16> %a0, <i16 1, i16 1, i16 1, i16 1>
  %v1 = icmp eq <4 x i16> %a1, <i16 1, i16 1, i16 1, i16 1>
  %v2 = icmp eq <4 x i16> %a2, <i16 1, i16 1, i16 1, i16 1>
  %v3 = and <4 x i1> %v0, %v1
  %v4 = or <4 x i1> %v2, %v3
  %v5 = sext <4 x i1> %v4 to <4 x i16>
  ret <4 x i16> %v5
}

define <4 x i16> @f34(<4 x i16> %a0, <4 x i16> %a1, <4 x i16> %a2) #1 {
; CHECK-LABEL: f34:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r6 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r7 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmph.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmph.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmph.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p2,or(p0,p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <4 x i16> %a0, <i16 1, i16 1, i16 1, i16 1>
  %v1 = icmp eq <4 x i16> %a1, <i16 1, i16 1, i16 1, i16 1>
  %v2 = icmp eq <4 x i16> %a2, <i16 1, i16 1, i16 1, i16 1>
  %v3 = or <4 x i1> %v0, %v1
  %v4 = or <4 x i1> %v2, %v3
  %v5 = sext <4 x i1> %v4 to <4 x i16>
  ret <4 x i16> %v5
}

define <4 x i16> @f35(<4 x i16> %a0, <4 x i16> %a1, <4 x i16> %a2) #1 {
; CHECK-LABEL: f35:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r6 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r7 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmph.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmph.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmph.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p2,and(p0,!p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <4 x i16> %a0, <i16 1, i16 1, i16 1, i16 1>
  %v1 = icmp eq <4 x i16> %a1, <i16 1, i16 1, i16 1, i16 1>
  %v2 = xor <4 x i1> %v1, <i1 true, i1 true, i1 true, i1 true>
  %v3 = icmp eq <4 x i16> %a2, <i16 1, i16 1, i16 1, i16 1>
  %v4 = and <4 x i1> %v0, %v2
  %v5 = and <4 x i1> %v3, %v4
  %v6 = sext <4 x i1> %v5 to <4 x i16>
  ret <4 x i16> %v6
}

define <4 x i16> @f36(<4 x i16> %a0, <4 x i16> %a1, <4 x i16> %a2) #1 {
; CHECK-LABEL: f36:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r6 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r7 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmph.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmph.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmph.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p2,or(p0,!p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <4 x i16> %a0, <i16 1, i16 1, i16 1, i16 1>
  %v1 = icmp eq <4 x i16> %a1, <i16 1, i16 1, i16 1, i16 1>
  %v2 = xor <4 x i1> %v1, <i1 true, i1 true, i1 true, i1 true>
  %v3 = icmp eq <4 x i16> %a2, <i16 1, i16 1, i16 1, i16 1>
  %v4 = or <4 x i1> %v0, %v2
  %v5 = and <4 x i1> %v3, %v4
  %v6 = sext <4 x i1> %v5 to <4 x i16>
  ret <4 x i16> %v6
}

define <4 x i16> @f37(<4 x i16> %a0, <4 x i16> %a1, <4 x i16> %a2) #1 {
; CHECK-LABEL: f37:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r6 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r7 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmph.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmph.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmph.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p2,and(p0,!p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <4 x i16> %a0, <i16 1, i16 1, i16 1, i16 1>
  %v1 = icmp eq <4 x i16> %a1, <i16 1, i16 1, i16 1, i16 1>
  %v2 = xor <4 x i1> %v1, <i1 true, i1 true, i1 true, i1 true>
  %v3 = icmp eq <4 x i16> %a2, <i16 1, i16 1, i16 1, i16 1>
  %v4 = and <4 x i1> %v0, %v2
  %v5 = or <4 x i1> %v3, %v4
  %v6 = sext <4 x i1> %v5 to <4 x i16>
  ret <4 x i16> %v6
}

define <4 x i16> @f38(<4 x i16> %a0, <4 x i16> %a1, <4 x i16> %a2) #1 {
; CHECK-LABEL: f38:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r6 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r7 = ##65537
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmph.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmph.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmph.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p2,or(p0,!p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <4 x i16> %a0, <i16 1, i16 1, i16 1, i16 1>
  %v1 = icmp eq <4 x i16> %a1, <i16 1, i16 1, i16 1, i16 1>
  %v2 = xor <4 x i1> %v1, <i1 true, i1 true, i1 true, i1 true>
  %v3 = icmp eq <4 x i16> %a2, <i16 1, i16 1, i16 1, i16 1>
  %v4 = or <4 x i1> %v0, %v2
  %v5 = or <4 x i1> %v3, %v4
  %v6 = sext <4 x i1> %v5 to <4 x i16>
  ret <4 x i16> %v6
}

define <8 x i8> @f39(<8 x i8> %a0, <8 x i8> %a1) #1 {
; CHECK-LABEL: f39:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r4 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r5 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpb.eq(r1:0,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpb.eq(r3:2,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p0,p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <8 x i8> %a0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v1 = icmp eq <8 x i8> %a1, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v2 = and <8 x i1> %v0, %v1
  %v3 = sext <8 x i1> %v2 to <8 x i8>
  ret <8 x i8> %v3
}

define <8 x i8> @f40(<8 x i8> %a0, <8 x i8> %a1) #1 {
; CHECK-LABEL: f40:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r4 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r5 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpb.eq(r1:0,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpb.eq(r3:2,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p0,p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <8 x i8> %a0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v1 = icmp eq <8 x i8> %a1, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v2 = or <8 x i1> %v0, %v1
  %v3 = sext <8 x i1> %v2 to <8 x i8>
  ret <8 x i8> %v3
}

define <8 x i8> @f41(<8 x i8> %a0, <8 x i8> %a1) #1 {
; CHECK-LABEL: f41:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r4 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r5 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpb.eq(r1:0,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpb.eq(r3:2,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = xor(p0,p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <8 x i8> %a0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v1 = icmp eq <8 x i8> %a1, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v2 = xor <8 x i1> %v0, %v1
  %v3 = sext <8 x i1> %v2 to <8 x i8>
  ret <8 x i8> %v3
}

define <8 x i8> @f42(<8 x i8> %a0, <8 x i8> %a1) #1 {
; CHECK-LABEL: f42:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r4 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r5 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpb.eq(r1:0,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpb.eq(r3:2,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p0,!p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <8 x i8> %a0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v1 = icmp eq <8 x i8> %a1, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v2 = xor <8 x i1> %v1, <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>
  %v3 = and <8 x i1> %v0, %v2
  %v4 = sext <8 x i1> %v3 to <8 x i8>
  ret <8 x i8> %v4
}

define <8 x i8> @f43(<8 x i8> %a0, <8 x i8> %a1) #1 {
; CHECK-LABEL: f43:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r4 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r5 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpb.eq(r1:0,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpb.eq(r3:2,r5:4)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p0,!p1)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <8 x i8> %a0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v1 = icmp eq <8 x i8> %a1, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v2 = xor <8 x i1> %v1, <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>
  %v3 = or <8 x i1> %v0, %v2
  %v4 = sext <8 x i1> %v3 to <8 x i8>
  ret <8 x i8> %v4
}

define <8 x i8> @f44(<8 x i8> %a0, <8 x i8> %a1, <8 x i8> %a2) #1 {
; CHECK-LABEL: f44:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r6 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r7 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpb.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpb.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmpb.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p2,and(p0,p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <8 x i8> %a0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v1 = icmp eq <8 x i8> %a1, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v2 = icmp eq <8 x i8> %a2, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v3 = and <8 x i1> %v0, %v1
  %v4 = and <8 x i1> %v2, %v3
  %v5 = sext <8 x i1> %v4 to <8 x i8>
  ret <8 x i8> %v5
}

define <8 x i8> @f45(<8 x i8> %a0, <8 x i8> %a1, <8 x i8> %a2) #1 {
; CHECK-LABEL: f45:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r6 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r7 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpb.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpb.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmpb.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p2,or(p0,p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <8 x i8> %a0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v1 = icmp eq <8 x i8> %a1, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v2 = icmp eq <8 x i8> %a2, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v3 = or <8 x i1> %v0, %v1
  %v4 = and <8 x i1> %v2, %v3
  %v5 = sext <8 x i1> %v4 to <8 x i8>
  ret <8 x i8> %v5
}

define <8 x i8> @f46(<8 x i8> %a0, <8 x i8> %a1, <8 x i8> %a2) #1 {
; CHECK-LABEL: f46:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r6 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r7 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpb.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpb.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmpb.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p2,and(p0,p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <8 x i8> %a0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v1 = icmp eq <8 x i8> %a1, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v2 = icmp eq <8 x i8> %a2, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v3 = and <8 x i1> %v0, %v1
  %v4 = or <8 x i1> %v2, %v3
  %v5 = sext <8 x i1> %v4 to <8 x i8>
  ret <8 x i8> %v5
}

define <8 x i8> @f47(<8 x i8> %a0, <8 x i8> %a1, <8 x i8> %a2) #1 {
; CHECK-LABEL: f47:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r6 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r7 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpb.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpb.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmpb.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p2,or(p0,p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <8 x i8> %a0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v1 = icmp eq <8 x i8> %a1, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v2 = icmp eq <8 x i8> %a2, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v3 = or <8 x i1> %v0, %v1
  %v4 = or <8 x i1> %v2, %v3
  %v5 = sext <8 x i1> %v4 to <8 x i8>
  ret <8 x i8> %v5
}

define <8 x i8> @f48(<8 x i8> %a0, <8 x i8> %a1, <8 x i8> %a2) #1 {
; CHECK-LABEL: f48:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r6 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r7 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpb.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpb.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmpb.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p2,and(p0,!p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <8 x i8> %a0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v1 = icmp eq <8 x i8> %a1, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v2 = xor <8 x i1> %v1, <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>
  %v3 = icmp eq <8 x i8> %a2, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v4 = and <8 x i1> %v0, %v2
  %v5 = and <8 x i1> %v3, %v4
  %v6 = sext <8 x i1> %v5 to <8 x i8>
  ret <8 x i8> %v6
}

define <8 x i8> @f49(<8 x i8> %a0, <8 x i8> %a1, <8 x i8> %a2) #1 {
; CHECK-LABEL: f49:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r6 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r7 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpb.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpb.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmpb.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = and(p2,or(p0,!p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <8 x i8> %a0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v1 = icmp eq <8 x i8> %a1, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v2 = xor <8 x i1> %v1, <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>
  %v3 = icmp eq <8 x i8> %a2, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v4 = or <8 x i1> %v0, %v2
  %v5 = and <8 x i1> %v3, %v4
  %v6 = sext <8 x i1> %v5 to <8 x i8>
  ret <8 x i8> %v6
}

define <8 x i8> @f50(<8 x i8> %a0, <8 x i8> %a1, <8 x i8> %a2) #1 {
; CHECK-LABEL: f50:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r6 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r7 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpb.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpb.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmpb.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p2,and(p0,!p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <8 x i8> %a0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v1 = icmp eq <8 x i8> %a1, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v2 = xor <8 x i1> %v1, <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>
  %v3 = icmp eq <8 x i8> %a2, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v4 = and <8 x i1> %v0, %v2
  %v5 = or <8 x i1> %v3, %v4
  %v6 = sext <8 x i1> %v5 to <8 x i8>
  ret <8 x i8> %v6
}

define <8 x i8> @f51(<8 x i8> %a0, <8 x i8> %a1, <8 x i8> %a2) #1 {
; CHECK-LABEL: f51:
; CHECK:       // %bb.0: // %b0
; CHECK-NEXT:    {
; CHECK-NEXT:     r6 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r7 = ##16843009
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = vcmpb.eq(r1:0,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p1 = vcmpb.eq(r3:2,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p2 = vcmpb.eq(r5:4,r7:6)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     p0 = or(p2,or(p0,!p1))
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     r1:0 = mask(p0)
; CHECK-NEXT:    }
; CHECK-NEXT:    {
; CHECK-NEXT:     jumpr r31
; CHECK-NEXT:    }
b0:
  %v0 = icmp eq <8 x i8> %a0, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v1 = icmp eq <8 x i8> %a1, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v2 = xor <8 x i1> %v1, <i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true, i1 true>
  %v3 = icmp eq <8 x i8> %a2, <i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1, i8 1>
  %v4 = or <8 x i1> %v0, %v2
  %v5 = or <8 x i1> %v3, %v4
  %v6 = sext <8 x i1> %v5 to <8 x i8>
  ret <8 x i8> %v6
}

attributes #0 = { nounwind readnone }
attributes #1 = { nounwind "target-features"="-small-data,-packets" }
