; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s --mattr=+complxnum,+neon -o - | FileCheck %s

target triple = "aarch64"

; a * b + c
define <4 x double> @mull_add(<4 x double> %a, <4 x double> %b, <4 x double> %c) {
; CHECK-LABEL: mull_add:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    zip2 v4.2d, v2.2d, v3.2d
; CHECK-NEXT:    zip2 v5.2d, v0.2d, v1.2d
; CHECK-NEXT:    zip1 v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    zip1 v2.2d, v2.2d, v3.2d
; CHECK-NEXT:    fmul v1.2d, v5.2d, v4.2d
; CHECK-NEXT:    fmul v3.2d, v0.2d, v4.2d
; CHECK-NEXT:    fneg v1.2d, v1.2d
; CHECK-NEXT:    fmla v3.2d, v2.2d, v5.2d
; CHECK-NEXT:    fmla v1.2d, v2.2d, v0.2d
; CHECK-NEXT:    fadd v3.2d, v3.2d, v4.2d
; CHECK-NEXT:    fadd v1.2d, v2.2d, v1.2d
; CHECK-NEXT:    zip1 v0.2d, v1.2d, v3.2d
; CHECK-NEXT:    zip2 v1.2d, v1.2d, v3.2d
; CHECK-NEXT:    ret
entry:
  %strided.vec = shufflevector <4 x double> %a, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec28 = shufflevector <4 x double> %a, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %strided.vec30 = shufflevector <4 x double> %b, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec31 = shufflevector <4 x double> %b, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %0 = fmul contract <2 x double> %strided.vec, %strided.vec31
  %1 = fmul contract <2 x double> %strided.vec28, %strided.vec30
  %2 = fadd contract <2 x double> %1, %0
  %3 = fmul contract <2 x double> %strided.vec, %strided.vec30
  %4 = fmul contract <2 x double> %strided.vec28, %strided.vec31
  %5 = fsub contract <2 x double> %3, %4
  %strided.vec33 = shufflevector <4 x double> %b, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec34 = shufflevector <4 x double> %b, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %6 = fadd contract <2 x double> %strided.vec33, %5
  %7 = fadd contract <2 x double> %2, %strided.vec34
  %interleaved.vec = shufflevector <2 x double> %6, <2 x double> %7, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x double> %interleaved.vec
}

; a * b + c * d
define <4 x double> @mul_add_mull(<4 x double> %a, <4 x double> %b, <4 x double> %c, <4 x double> %d) {
; CHECK-LABEL: mul_add_mull:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi v16.2d, #0000000000000000
; CHECK-NEXT:    movi v17.2d, #0000000000000000
; CHECK-NEXT:    movi v18.2d, #0000000000000000
; CHECK-NEXT:    movi v19.2d, #0000000000000000
; CHECK-NEXT:    fcmla v16.2d, v0.2d, v2.2d, #0
; CHECK-NEXT:    fcmla v17.2d, v1.2d, v3.2d, #0
; CHECK-NEXT:    fcmla v18.2d, v4.2d, v6.2d, #0
; CHECK-NEXT:    fcmla v19.2d, v5.2d, v7.2d, #0
; CHECK-NEXT:    fcmla v16.2d, v0.2d, v2.2d, #90
; CHECK-NEXT:    fcmla v17.2d, v1.2d, v3.2d, #90
; CHECK-NEXT:    fcmla v18.2d, v4.2d, v6.2d, #90
; CHECK-NEXT:    fcmla v19.2d, v5.2d, v7.2d, #90
; CHECK-NEXT:    fadd v0.2d, v16.2d, v18.2d
; CHECK-NEXT:    fadd v1.2d, v17.2d, v19.2d
; CHECK-NEXT:    ret
entry:
  %strided.vec = shufflevector <4 x double> %a, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec51 = shufflevector <4 x double> %a, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %strided.vec53 = shufflevector <4 x double> %b, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec54 = shufflevector <4 x double> %b, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %0 = fmul contract <2 x double> %strided.vec, %strided.vec54
  %1 = fmul contract <2 x double> %strided.vec51, %strided.vec53
  %2 = fadd contract <2 x double> %1, %0
  %3 = fmul contract <2 x double> %strided.vec, %strided.vec53
  %4 = fmul contract <2 x double> %strided.vec51, %strided.vec54
  %5 = fsub contract <2 x double> %3, %4
  %strided.vec56 = shufflevector <4 x double> %c, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec57 = shufflevector <4 x double> %c, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %strided.vec59 = shufflevector <4 x double> %d, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec60 = shufflevector <4 x double> %d, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %6 = fmul contract <2 x double> %strided.vec56, %strided.vec60
  %7 = fmul contract <2 x double> %strided.vec57, %strided.vec59
  %8 = fadd contract <2 x double> %7, %6
  %9 = fmul contract <2 x double> %strided.vec56, %strided.vec59
  %10 = fmul contract <2 x double> %strided.vec57, %strided.vec60
  %11 = fsub contract <2 x double> %9, %10
  %12 = fadd contract <2 x double> %5, %11
  %13 = fadd contract <2 x double> %2, %8
  %interleaved.vec = shufflevector <2 x double> %12, <2 x double> %13, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x double> %interleaved.vec
}

; a * b - c * d
define <4 x double> @mul_sub_mull(<4 x double> %a, <4 x double> %b, <4 x double> %c, <4 x double> %d) {
; CHECK-LABEL: mul_sub_mull:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi v16.2d, #0000000000000000
; CHECK-NEXT:    movi v17.2d, #0000000000000000
; CHECK-NEXT:    movi v18.2d, #0000000000000000
; CHECK-NEXT:    movi v19.2d, #0000000000000000
; CHECK-NEXT:    fcmla v16.2d, v0.2d, v2.2d, #0
; CHECK-NEXT:    fcmla v17.2d, v1.2d, v3.2d, #0
; CHECK-NEXT:    fcmla v18.2d, v4.2d, v6.2d, #0
; CHECK-NEXT:    fcmla v19.2d, v5.2d, v7.2d, #0
; CHECK-NEXT:    fcmla v16.2d, v0.2d, v2.2d, #90
; CHECK-NEXT:    fcmla v17.2d, v1.2d, v3.2d, #90
; CHECK-NEXT:    fcmla v18.2d, v4.2d, v6.2d, #90
; CHECK-NEXT:    fcmla v19.2d, v5.2d, v7.2d, #90
; CHECK-NEXT:    fsub v0.2d, v16.2d, v18.2d
; CHECK-NEXT:    fsub v1.2d, v17.2d, v19.2d
; CHECK-NEXT:    ret
entry:
  %strided.vec = shufflevector <4 x double> %a, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec51 = shufflevector <4 x double> %a, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %strided.vec53 = shufflevector <4 x double> %b, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec54 = shufflevector <4 x double> %b, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %0 = fmul contract <2 x double> %strided.vec, %strided.vec54
  %1 = fmul contract <2 x double> %strided.vec51, %strided.vec53
  %2 = fadd contract <2 x double> %1, %0
  %3 = fmul contract <2 x double> %strided.vec, %strided.vec53
  %4 = fmul contract <2 x double> %strided.vec51, %strided.vec54
  %5 = fsub contract <2 x double> %3, %4
  %strided.vec56 = shufflevector <4 x double> %c, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec57 = shufflevector <4 x double> %c, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %strided.vec59 = shufflevector <4 x double> %d, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec60 = shufflevector <4 x double> %d, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %6 = fmul contract <2 x double> %strided.vec56, %strided.vec60
  %7 = fmul contract <2 x double> %strided.vec57, %strided.vec59
  %8 = fadd contract <2 x double> %7, %6
  %9 = fmul contract <2 x double> %strided.vec56, %strided.vec59
  %10 = fmul contract <2 x double> %strided.vec57, %strided.vec60
  %11 = fsub contract <2 x double> %9, %10
  %12 = fsub contract <2 x double> %5, %11
  %13 = fsub contract <2 x double> %2, %8
  %interleaved.vec = shufflevector <2 x double> %12, <2 x double> %13, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x double> %interleaved.vec
}

; a * b + conj(c) * d
define <4 x double> @mul_conj_mull(<4 x double> %a, <4 x double> %b, <4 x double> %c, <4 x double> %d) {
; CHECK-LABEL: mul_conj_mull:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi v16.2d, #0000000000000000
; CHECK-NEXT:    movi v17.2d, #0000000000000000
; CHECK-NEXT:    movi v18.2d, #0000000000000000
; CHECK-NEXT:    movi v19.2d, #0000000000000000
; CHECK-NEXT:    fcmla v16.2d, v0.2d, v2.2d, #0
; CHECK-NEXT:    fcmla v17.2d, v1.2d, v3.2d, #0
; CHECK-NEXT:    fcmla v18.2d, v6.2d, v4.2d, #0
; CHECK-NEXT:    fcmla v19.2d, v7.2d, v5.2d, #0
; CHECK-NEXT:    fcmla v16.2d, v0.2d, v2.2d, #90
; CHECK-NEXT:    fcmla v17.2d, v1.2d, v3.2d, #90
; CHECK-NEXT:    fcmla v18.2d, v6.2d, v4.2d, #270
; CHECK-NEXT:    fcmla v19.2d, v7.2d, v5.2d, #270
; CHECK-NEXT:    fadd v0.2d, v16.2d, v18.2d
; CHECK-NEXT:    fadd v1.2d, v17.2d, v19.2d
; CHECK-NEXT:    ret
entry:
  %strided.vec = shufflevector <4 x double> %a, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec59 = shufflevector <4 x double> %a, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %strided.vec61 = shufflevector <4 x double> %b, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec62 = shufflevector <4 x double> %b, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %0 = fmul contract <2 x double> %strided.vec, %strided.vec62
  %1 = fmul contract <2 x double> %strided.vec59, %strided.vec61
  %2 = fadd contract <2 x double> %1, %0
  %3 = fmul contract <2 x double> %strided.vec, %strided.vec61
  %4 = fmul contract <2 x double> %strided.vec59, %strided.vec62
  %5 = fsub contract <2 x double> %3, %4
  %strided.vec64 = shufflevector <4 x double> %c, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec65 = shufflevector <4 x double> %c, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %strided.vec67 = shufflevector <4 x double> %d, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec68 = shufflevector <4 x double> %d, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %6 = fmul contract <2 x double> %strided.vec64, %strided.vec68
  %7 = fmul contract <2 x double> %strided.vec65, %strided.vec67
  %8 = fsub contract <2 x double> %6, %7
  %9 = fmul contract <2 x double> %strided.vec64, %strided.vec67
  %10 = fmul contract <2 x double> %strided.vec65, %strided.vec68
  %11 = fadd contract <2 x double> %9, %10
  %12 = fadd contract <2 x double> %5, %11
  %13 = fadd contract <2 x double> %2, %8
  %interleaved.vec = shufflevector <2 x double> %12, <2 x double> %13, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x double> %interleaved.vec
}

; a + b + 1i * c * d
define <4 x double> @mul_add_rot_mull(<4 x double> %a, <4 x double> %b, <4 x double> %c, <4 x double> %d) {
; CHECK-LABEL: mul_add_rot_mull:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    movi v16.2d, #0xffffffffffffffff
; CHECK-NEXT:    zip2 v17.2d, v4.2d, v5.2d
; CHECK-NEXT:    movi v18.2d, #0000000000000000
; CHECK-NEXT:    zip1 v19.2d, v0.2d, v1.2d
; CHECK-NEXT:    fneg v16.2d, v16.2d
; CHECK-NEXT:    zip2 v0.2d, v0.2d, v1.2d
; CHECK-NEXT:    zip1 v1.2d, v4.2d, v5.2d
; CHECK-NEXT:    zip1 v5.2d, v2.2d, v3.2d
; CHECK-NEXT:    mov v4.16b, v16.16b
; CHECK-NEXT:    bsl v4.16b, v18.16b, v17.16b
; CHECK-NEXT:    zip2 v2.2d, v2.2d, v3.2d
; CHECK-NEXT:    mov v3.16b, v16.16b
; CHECK-NEXT:    bsl v3.16b, v18.16b, v1.16b
; CHECK-NEXT:    fadd v1.2d, v1.2d, v4.2d
; CHECK-NEXT:    zip2 v4.2d, v6.2d, v7.2d
; CHECK-NEXT:    zip1 v6.2d, v6.2d, v7.2d
; CHECK-NEXT:    fmul v7.2d, v0.2d, v2.2d
; CHECK-NEXT:    fsub v3.2d, v3.2d, v17.2d
; CHECK-NEXT:    fmul v16.2d, v1.2d, v4.2d
; CHECK-NEXT:    fmul v2.2d, v19.2d, v2.2d
; CHECK-NEXT:    fneg v7.2d, v7.2d
; CHECK-NEXT:    fmul v4.2d, v3.2d, v4.2d
; CHECK-NEXT:    fneg v16.2d, v16.2d
; CHECK-NEXT:    fmla v2.2d, v5.2d, v0.2d
; CHECK-NEXT:    fmla v7.2d, v5.2d, v19.2d
; CHECK-NEXT:    fmla v4.2d, v1.2d, v6.2d
; CHECK-NEXT:    fmla v16.2d, v6.2d, v3.2d
; CHECK-NEXT:    fadd v1.2d, v2.2d, v4.2d
; CHECK-NEXT:    fadd v2.2d, v7.2d, v16.2d
; CHECK-NEXT:    zip1 v0.2d, v2.2d, v1.2d
; CHECK-NEXT:    zip2 v1.2d, v2.2d, v1.2d
; CHECK-NEXT:    ret
entry:
  %strided.vec = shufflevector <4 x double> %a, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec77 = shufflevector <4 x double> %a, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %strided.vec79 = shufflevector <4 x double> %b, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec80 = shufflevector <4 x double> %b, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %0 = fmul contract <2 x double> %strided.vec, %strided.vec80
  %1 = fmul contract <2 x double> %strided.vec77, %strided.vec79
  %2 = fadd contract <2 x double> %1, %0
  %3 = fmul contract <2 x double> %strided.vec, %strided.vec79
  %4 = fmul contract <2 x double> %strided.vec77, %strided.vec80
  %5 = fsub contract <2 x double> %3, %4
  %strided.vec82 = shufflevector <4 x double> %c, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec83 = shufflevector <4 x double> %c, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %6 = tail call contract <2 x double> @llvm.copysign.v2f64(<2 x double> zeroinitializer, <2 x double> %strided.vec83)
  %7 = fadd contract <2 x double> %strided.vec82, %6
  %8 = tail call contract <2 x double> @llvm.copysign.v2f64(<2 x double> zeroinitializer, <2 x double> %strided.vec82)
  %9 = fsub contract <2 x double> %8, %strided.vec83
  %strided.vec85 = shufflevector <4 x double> %d, <4 x double> poison, <2 x i32> <i32 0, i32 2>
  %strided.vec86 = shufflevector <4 x double> %d, <4 x double> poison, <2 x i32> <i32 1, i32 3>
  %10 = fmul contract <2 x double> %9, %strided.vec86
  %11 = fmul contract <2 x double> %strided.vec85, %7
  %12 = fadd contract <2 x double> %11, %10
  %13 = fmul contract <2 x double> %9, %strided.vec85
  %14 = fmul contract <2 x double> %7, %strided.vec86
  %15 = fsub contract <2 x double> %13, %14
  %16 = fadd contract <2 x double> %5, %15
  %17 = fadd contract <2 x double> %2, %12
  %interleaved.vec = shufflevector <2 x double> %16, <2 x double> %17, <4 x i32> <i32 0, i32 2, i32 1, i32 3>
  ret <4 x double> %interleaved.vec
}

declare <2 x double> @llvm.copysign.v2f64(<2 x double>, <2 x double>)
