/* Generated by JTB 1.5.1 */
package grammars.tcf.visitor;

import static grammars.tcf.syntaxtree.NodeConstants.*;
import grammars.tcf.Token;
import grammars.tcf.syntaxtree.*;
import grammars.tcf.visitor.signature.NodeFieldsSignature;

/**
 * Provides default methods which visit each node in the tree in depth-first order.<br>
 * In your "Void" visitors extend this class and override part or all of these methods.
 *
 */
public class DepthFirstVoidVisitor implements IVoidVisitor {


  /*
   * Base nodes classes visit methods (to be overridden if necessary)
   */

  /**
   * Visits a {@link NodeChoice} node.
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final NodeChoice n) {
    n.choice.accept(this);
    return;
  }

  /**
   * Visits a {@link NodeList} node.
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final NodeList n) {
    for (INode e : n.nodes) {
      e.accept(this);
    }
    return;
  }

  /**
   * Visits a {@link NodeListOptional} node.
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final NodeListOptional n) {
    if (n.present()) {
      for (INode e : n.nodes) {
        e.accept(this);
      }
      return;
    }
    return;
  }

  /**
   * Visits a {@link NodeOptional} node.
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final NodeOptional n) {
    if (n.present()) {
      n.node.accept(this);
      return;
    }
    return;
  }

  /**
   * Visits a {@link NodeSequence} node.
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final NodeSequence n) {
    for (INode e : n.nodes) {
      e.accept(this);
    }
    return;
  }

  /**
   * Visits a {@link Token} node.
   *
   * @param n - the node to visit
   */
  @Override
  public void visit(final Token n) {
    @SuppressWarnings("unused")
    final String tkIm = n.image;
    return;
  }

  /*
   * User grammar generated visit methods (to be overridden if necessary)
   */

  /**
   * Visits a {@link Start} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 Tcf1() #1 < EOF ><br>
   * .. .. | %1 :0 bp_iv1()<br>
   * .. .. . .. :1 bp_iv2()<br>
   * .. .. . ..   :2 . &0 bp_iv3()<br>
   * .. .. . .. .. | &1 bp_iv3_()<br>
   * .. .. . ..   :3 . &0 bp_iv3()<br>
   * .. .. . .. .. | &1 {}<br>
   * .. .. . .. :4 $0 bp_iv4() $1 bp_iv5()<br>
   * .. .. . ..   :5 . &0 $0 bp_iv6() $1 bp_iv7()<br>
   * .. .. . .. .. | &1 {}<br>
   * .. .. . .. #6 < EOF ><br>
   * s: 1737026419<br>
   *
   * @param n - the node to visit
   */
  @Override
  @NodeFieldsSignature({ 1737026419, JTB_SIG_START, JTB_USER_START })
  public void visit(final Start n) {
    // f0 -> . %0 #0 Tcf1() #1 < EOF >
    // .. .. | %1 :0 bp_iv1()
    // .. .. . .. :1 bp_iv2()
    // .. .. . ..   :2 . &0 bp_iv3()
    // .. .. . .. .. | &1 bp_iv3_()
    // .. .. . ..   :3 . &0 bp_iv3()
    // .. .. . .. .. | &1 {}
    // .. .. . .. :4 $0 bp_iv4() $1 bp_iv5()
    // .. .. . ..   :5 . &0 $0 bp_iv6() $1 bp_iv7()
    // .. .. . .. .. | &1 {}
    // .. .. . .. #6 < EOF >
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 Tcf1() #1 < EOF >
        final NodeSequence seq = (NodeSequence) ich;
        //#0 Tcf1()
        final INode nd = seq.elementAt(0);
        nd.accept(this);
        //#1 < EOF >
        final INode nd1 = seq.elementAt(1);
        nd1.accept(this);
        break;
      case 1:
        //%1 :0 bp_iv1()
        //.. :1 bp_iv2()
        //..   :2 . &0 bp_iv3()
        //.. .. | &1 bp_iv3_()
        //..   :3 . &0 bp_iv3()
        //.. .. | &1 {}
        //.. :4 $0 bp_iv4() $1 bp_iv5()
        //..   :5 . &0 $0 bp_iv6() $1 bp_iv7()
        //.. .. | &1 {}
        //.. #6 < EOF >
        final NodeSequence seq1 = (NodeSequence) ich;
        //:0 bp_iv1()
        final INode nd2 = seq1.elementAt(0);
        if (nd2 != null) {
          nd2.accept(this);
        }
        //:1 bp_iv2()
        final INode nd3 = seq1.elementAt(1);
        if (nd3 != null) {
          nd3.accept(this);
        }
        //:2 . &0 bp_iv3()
        //.. | &1 bp_iv3_()
        final NodeChoice nch1 = (NodeChoice) seq1.elementAt(2);;
        if (nch1 != null) {
          final INode ich1 = nch1.choice;
          switch (nch1.which) {
            case 0:
              //&0 bp_iv3()
              if (ich1 != null) {
                ich1.accept(this);
              }
              break;
            case 1:
              //&1 bp_iv3_()
              if (ich1 != null) {
                ich1.accept(this);
              }
              break;
            default:
              // should not occur !!!
              throw new ShouldNotOccurException(nch1);
          }
        }
        //:3 . &0 bp_iv3()
        //.. | &1 {}
        final NodeChoice nch2 = (NodeChoice) seq1.elementAt(3);;
        if (nch2 != null) {
          final INode ich2 = nch2.choice;
          switch (nch2.which) {
            case 0:
              //&0 bp_iv3()
              if (ich2 != null) {
                ich2.accept(this);
              }
              break;
            case 1:
              //&1 {}
              break;
            default:
              // should not occur !!!
              throw new ShouldNotOccurException(nch2);
          }
        }
        //:4 $0 bp_iv4() $1 bp_iv5()
        final INode nd4 = seq1.elementAt(4);
        if (nd4 != null) {
          nd4.accept(this);
        }
        //$0 bp_iv4()
        final INode nd5 = seq1.elementAt(5);
        if (nd5 != null) {
          nd5.accept(this);
        }
        //$1 bp_iv5()
        final NodeChoice nch3 = (NodeChoice) seq1.elementAt(5);;
        if (nch3 != null) {
          final INode ich3 = nch3.choice;
          switch (nch3.which) {
            case 0:
              //:5 . &0 $0 bp_iv6() $1 bp_iv7()
              //.. | &1 {}
              //&0 $0 bp_iv6() $1 bp_iv7()
              final INode nd6 = ((NodeSequence) ich3).elementAt(5);
              if (nd6 != null) {
                nd6.accept(this);
              }
              //$0 bp_iv6()
              final INode nd7 = ((NodeSequence) ich3).elementAt(6);
              if (nd7 != null) {
                nd7.accept(this);
              }
              break;
            case 1:
              //$1 bp_iv7()
              break;
            default:
              // should not occur !!!
              throw new ShouldNotOccurException(nch3);
          }
        }
        //&1 {}
        final INode nd8 = seq1.elementAt(6);
        nd8.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
  }

  /**
   * Visits a {@link Tcf1} node, whose children are the following :
   * <p>
   * f0 -> Identifier()<br>
   * f1 -> f2 -> ( %0 Identifier()<br>
   * .. .. .. .. | %1 Integer_literal_boum() )*<br>
   * f3 -> "."<br>
   * s: -1841305487<br>
   *
   * @param n - the node to visit
   */
  @Override
  @NodeFieldsSignature({ -1841305487, JTB_SIG_TCF1, JTB_USER_TCF1 })
  public void visit(final Tcf1 n) {
    // f0 -> Identifier()
    if (n.f0 != null) {
      n.f0.accept(this);
    }
    // f1 -> f2 -> ( %0 Identifier()
    // .. .. .. .. | %1 Integer_literal_boum() )*
    if ((n.f1 != null) && n.f1.present()) {
      for (int i = 0; i < n.f1.size(); i++) {
        final INode nloeai = n.f1.elementAt(i);
        final NodeChoice nch = (NodeChoice) nloeai;
        if (nch != null) {
          final INode ich = nch.choice;
          switch (nch.which) {
            case 0:
              //%0 Identifier()
              if (ich != null) {
                ich.accept(this);
              }
              break;
            case 1:
              //%1 Integer_literal_boum()
              if (ich != null) {
                ich.accept(this);
              }
              break;
            default:
              // should not occur !!!
              throw new ShouldNotOccurException(nch);
          }
        }
      }
    }
    // f3 -> "."
    if (n.f2 != null) {
      n.f2.accept(this);
    }
    final Token n3 = n.f3;
    n3.accept(this);
  }

  /**
   * Visits a {@link Tcf2} node, whose child is the following :
   * <p>
   * {}f0 ->   %0 Identifier()<br>
   * .. .. | !1 Integer_literal_boum()<br>
   * s: 1058520479<br>
   *
   * @param n - the node to visit
   */
  @Override
  @NodeFieldsSignature({ 1058520479, JTB_SIG_TCF2, JTB_USER_TCF2 })
  public void visit(final Tcf2 n) {
    if (n.f0 != null) {
      final INode ich = n.f0.choice;
      switch (n.f0.which) {
        case 0:
          //%0 Identifier()
          if (ich != null) {
            ich.accept(this);
          }
          break;
        case 1:
          //!1 Integer_literal_boum()
          // invalid sub comment index (2), size = 2 ; ExpansionUnitTCF
          if (ich != null) {
            ich.accept(this);
          }
          break;
        default:
          // should not occur !!!
          throw new ShouldNotOccurException(n.f0);
      }
    }
  }

  /**
   * Visits a {@link Tcf3} node, whose children are the following :
   * <p>
   * f0 -> Identifier()<br>
   * f1 -> ( %0 {}<br>
   * .. .. | %1 Integer_literal_boum() )?<br>
   * f2 -> ":"<br>
   * s: 553976958<br>
   *
   * @param n - the node to visit
   */
  @Override
  @NodeFieldsSignature({ 553976958, JTB_SIG_TCF3, JTB_USER_TCF3 })
  public void visit(final Tcf3 n) {
    // f0 -> Identifier()
    if (n.f0 != null) {
      n.f0.accept(this);
    }
    // f1 -> ( %0 {}
    // .. .. | %1 Integer_literal_boum() )?
    if ((n.f1 != null) && n.f1.present()) {
      final NodeChoice nch = (NodeChoice) n.f1.node;
      if (nch != null) {
        final INode ich = nch.choice;
        switch (nch.which) {
          case 0:
            //%0 {}
            break;
          case 1:
            //%1 Integer_literal_boum()
            if (ich != null) {
              ich.accept(this);
            }
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch);
        }
      }
    }
    // f2 -> ":"
    final Token n2 = n.f2;
    n2.accept(this);
  }

  /**
   * Visits a {@link bp_iv1} node, whose child is the following :
   * <p>
   * f0 -> "1*"<br>
   * s: -699039424<br>
   *
   * @param n - the node to visit
   */
  @Override
  @NodeFieldsSignature({ -699039424, JTB_SIG_BP_IV1, JTB_USER_BP_IV1 })
  public void visit(final bp_iv1 n) {
    // f0 -> "1*"
    final Token n0 = n.f0;
    n0.accept(this);
  }

  /**
   * Visits a {@link bp_iv2} node, whose child is the following :
   * <p>
   * f0 -> "2*"<br>
   * s: -699038463<br>
   *
   * @param n - the node to visit
   */
  @Override
  @NodeFieldsSignature({ -699038463, JTB_SIG_BP_IV2, JTB_USER_BP_IV2 })
  public void visit(final bp_iv2 n) {
    // f0 -> "2*"
    final Token n0 = n.f0;
    n0.accept(this);
  }

  /**
   * Visits a {@link bp_iv3} node, whose child is the following :
   * <p>
   * f0 -> "3*"<br>
   * s: -699037502<br>
   *
   * @param n - the node to visit
   */
  @Override
  @NodeFieldsSignature({ -699037502, JTB_SIG_BP_IV3, JTB_USER_BP_IV3 })
  public void visit(final bp_iv3 n) {
    // f0 -> "3*"
    final Token n0 = n.f0;
    n0.accept(this);
  }

  /**
   * Visits a {@link bp_iv3_} node, whose children are the following :
   * <p>
   * f0 -> "3_"<br>
   * f1 -> < NUM_3_9 ><br>
   * s: -1427135545<br>
   *
   * @param n - the node to visit
   */
  @Override
  @NodeFieldsSignature({ -1427135545, JTB_SIG_BP_IV3_, JTB_USER_BP_IV3_ })
  public void visit(final bp_iv3_ n) {
    // f0 -> "3_"
    final Token n0 = n.f0;
    n0.accept(this);
    // f1 -> < NUM_3_9 >
    final Token n1 = n.f1;
    n1.accept(this);
  }

  /**
   * Visits a {@link bp_iv4} node, whose child is the following :
   * <p>
   * f0 -> "4*"<br>
   * s: -699036541<br>
   *
   * @param n - the node to visit
   */
  @Override
  @NodeFieldsSignature({ -699036541, JTB_SIG_BP_IV4, JTB_USER_BP_IV4 })
  public void visit(final bp_iv4 n) {
    // f0 -> "4*"
    final Token n0 = n.f0;
    n0.accept(this);
  }

  /**
   * Visits a {@link bp_iv5} node, whose child is the following :
   * <p>
   * f0 -> "5*"<br>
   * s: -699035580<br>
   *
   * @param n - the node to visit
   */
  @Override
  @NodeFieldsSignature({ -699035580, JTB_SIG_BP_IV5, JTB_USER_BP_IV5 })
  public void visit(final bp_iv5 n) {
    // f0 -> "5*"
    final Token n0 = n.f0;
    n0.accept(this);
  }

  /**
   * Visits a {@link bp_iv6} node, whose child is the following :
   * <p>
   * f0 -> "6*"<br>
   * s: -699034619<br>
   *
   * @param n - the node to visit
   */
  @Override
  @NodeFieldsSignature({ -699034619, JTB_SIG_BP_IV6, JTB_USER_BP_IV6 })
  public void visit(final bp_iv6 n) {
    // f0 -> "6*"
    final Token n0 = n.f0;
    n0.accept(this);
  }

  /**
   * Visits a {@link bp_iv7} node, whose child is the following :
   * <p>
   * f0 -> "7*"<br>
   * s: -699033658<br>
   *
   * @param n - the node to visit
   */
  @Override
  @NodeFieldsSignature({ -699033658, JTB_SIG_BP_IV7, JTB_USER_BP_IV7 })
  public void visit(final bp_iv7 n) {
    // f0 -> "7*"
    final Token n0 = n.f0;
    n0.accept(this);
  }

  /**
   * Visits a {@link Identifier} node, whose child is the following :
   * <p>
   * f0 -> < IDENTIFIER ><br>
   * s: -1580059612<br>
   *
   * @param n - the node to visit
   */
  @Override
  @NodeFieldsSignature({ -1580059612, JTB_SIG_IDENTIFIER, JTB_USER_IDENTIFIER })
  public void visit(final Identifier n) {
    // f0 -> < IDENTIFIER >
    final Token n0 = n.f0;
    n0.accept(this);
  }

  /**
   * Visits a {@link Integer_literal_boum} node, whose child is the following :
   * <p>
   * f0 -> < INTEGER_LITERAL ><br>
   * s: -1048223857<br>
   *
   * @param n - the node to visit
   */
  @Override
  @NodeFieldsSignature({ -1048223857, JTB_SIG_INTEGER_LITERAL_BOUM, JTB_USER_INTEGER_LITERAL_BOUM })
  public void visit(final Integer_literal_boum n) {
    // f0 -> < INTEGER_LITERAL >
    final Token n0 = n.f0;
    n0.accept(this);
  }

  /**
   * Class handling a programmatic exception. Static for generic outer classes.
   */
  public static class ShouldNotOccurException extends RuntimeException {

    /** Default serialVersionUID */
    private static final long serialVersionUID = 1L;

    /**
     * Constructor with no message.
     */
    public ShouldNotOccurException() {
      super();
    }

    /**
     * Constructor which outputs a message.
     *
     * @param ch - a NodeChoice whose which value is invalid or lead to a fall-through
     */
    public ShouldNotOccurException(final NodeChoice ch) {
      super("Invalid switch value (" + ch.which + ") or fall-through");
    }

  }

}
