/* Generated by JTB 1.5.1 */
package grammars.a.sgtree;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import grammars.a.sgvis.IVis2Visitor;
import grammars.a.sgvis.IVoidVisitor;

@SuppressWarnings("javadoc")
public class NodeSequence implements INodeList {

  public ArrayList<INode> nodes;

  private INode parent;

  private static final long serialVersionUID = 151L;

  public NodeSequence() {
    nodes = new ArrayList<>();
  }

  public NodeSequence(final int sz) {
    nodes = new ArrayList<>(sz);
  }

  public NodeSequence(final INode firstNode) {
    nodes = new ArrayList<>();
    addNode(firstNode);
  }

  public NodeSequence(final int sz, final INode firstNode) {
    nodes = new ArrayList<>(sz);
    addNode(firstNode);
  }

  @Override
  public void addNode(final INode n) {
    nodes.add(n);
    if (n != null)
      n.setParent(this);
  }

  @Override
  public INode elementAt(final int i) {
    return nodes.get(i); }

  @Override
  public Iterator<INode> elements() {
    return nodes.iterator(); }

  @Override
  public int size() {
    return nodes.size(); }

  /*
   * Visitors accept methods (no -novis option, visitors specification : Void,void,None;Vis2,R,A,int[],short...)
   */

  @Override
  public <R, A> R accept(final IVis2Visitor<R, A> vis, final A argu, final int[] argu1, final short... argu2) {
    return vis.visit(this, argu, argu1, argu2);
  }

  @Override
  public void accept(final IVoidVisitor vis) {
    vis.visit(this);
  }

  /*
   * Parent pointer getter and setter (-pp option)
   */

  @Override
  public INode getParent() {
    return parent;
  }

  @Override
  public void setParent(final INode n) {
    parent = n;
  }

  /*
   * Children methods (-chm option)
   */

  private List<INode> lac = null;

  private List<INode> lbc = null;

  private List<INode> luc = null;

  private int nbLbc = -1;

  private int nbLuc = -1;

  @Override
  public int getNbAllChildren() {
    return nodes.size();
  }

  @Override
  public int getNbBaseChildren() {
    if (lbc == null)
      getBaseChildren();
    return nbLbc;
  }

  @Override
  public int getNbUserChildren() {
    if (luc == null)
      getUserChildren();
    return nbLuc;
  }

  @Override
  public List<INode> getAllChildren() {
    if (lac == null) {
      lac = new ArrayList<>(nodes.size());
        lac.addAll(nodes);
    }
    return lac;
  }

  @Override
  public List<INode> getBaseChildren() {
    if (lbc == null) {
      nbLbc = 0;
      for (final INode node : nodes)
        if (node.isBaseNode())
          nbLbc++;
      lbc = new ArrayList<>(nbLbc);
      for (final INode node : nodes)
        if (node.isBaseNode())
          lbc.add(node);
    }
    return lbc;
  }

  @Override
  public List<INode> getUserChildren() {
    if (luc == null) {
      nbLuc = 0;
      for (final INode node : nodes)
        if (!node.isBaseNode())
          nbLuc++;
      luc = new ArrayList<>(nbLuc);
      for (final INode node : nodes)
        if (!node.isBaseNode())
          luc.add(node);
    }
    return luc;
  }

  @Override
  public boolean isBaseNode() {
    return true;
  }

}
