/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.Action;
import JFlex.CharClassIntervall;
import JFlex.CharClasses;
import JFlex.CharSet;
import JFlex.CharSetEnumerator;
import JFlex.DFA;
import JFlex.EOFActions;
import JFlex.LexParse;
import JFlex.LexScan;
import JFlex.Main;
import JFlex.Out;
import JFlex.Skeleton;
import JFlex.StateSet;
import JFlex.StateSetEnumerator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public final class Emitter {
    private static final int FINAL = 1;
    private static final int PUSHBACK = 2;
    private static final int LOOKEND = 4;
    private static final int NOLOOK = 8;
    static final int maxSize = 65529;
    private static final String date = new SimpleDateFormat().format(new Date());
    public static File directory;
    private File inputFile;
    private PrintWriter out;
    private Skeleton skel;
    private LexScan scanner;
    private LexParse parser;
    private DFA dfa;
    private CharSet[][] table;
    private boolean[] isTransition;
    private CharSet[] noTarget;
    private int numRows;
    private int[] rowMap;
    private boolean[] rowKilled;
    private int numCols;
    private int[] colMap;
    private boolean[] colKilled;
    private int numTableChunks;
    private CharClassIntervall[] intervalls;
    private int currentIntervall;

    public Emitter(File file, LexParse lexParse, DFA dFA) throws IOException {
        String string = lexParse.scanner.className + ".java";
        File file2 = Emitter.normalize(string, directory, file);
        Out.println("Writing code to \"" + file2 + "\"");
        this.out = new PrintWriter(new BufferedWriter(new FileWriter(file2)));
        this.parser = lexParse;
        this.scanner = lexParse.scanner;
        this.inputFile = file;
        this.dfa = dFA;
        this.skel = new Skeleton(this.out);
    }

    public static File normalize(String string, File file, File file2) {
        File file3 = directory == null ? (file2 == null || file2.getParent() == null ? new File(string) : new File(file2.getParent(), string)) : new File(directory, string);
        if (file3.exists() && !Main.no_backup) {
            File file4 = new File(file3.toString() + "~");
            if (file4.exists()) {
                file4.delete();
            }
            if (file3.renameTo(file4)) {
                Out.println("Old file \"" + file3 + "\" saved as \"" + file4 + "\"");
            } else {
                Out.println("Couldn't save old file \"" + file3 + "\", overwriting!");
            }
        }
        return file3;
    }

    private void println() {
        this.out.println();
    }

    private void println(String string) {
        this.out.println(string);
    }

    private void println(int n) {
        this.out.println(n);
    }

    private void print(String string) {
        this.out.print(string);
    }

    private void print(int n) {
        this.out.print(n);
    }

    private void print(int n, int n2) {
        int n3 = n < 0 ? 1 : 10;
        while (n2-- > 1) {
            if (Math.abs(n) < n3) {
                this.print(" ");
            }
            n3 *= 10;
        }
        this.print(n);
    }

    private void printUC(int n) {
        if (n > 255) {
            this.print("\\u");
            if (n < 4096) {
                this.print("0");
            }
            this.print(Integer.toHexString(n));
        } else {
            this.print("\\");
            this.print(Integer.toOctalString(n));
        }
    }

    private void emitScanError() {
        this.print("  private void yy_ScanError(int errorCode)");
        if (this.scanner.scanErrorException != null) {
            this.print(" throws " + this.scanner.scanErrorException);
        }
        this.println(" {");
        this.skel.emitNext();
        if (this.scanner.scanErrorException == null) {
            this.println("    throw new Error(message);");
        } else {
            this.println("    throw new " + this.scanner.scanErrorException + "(message);");
        }
        this.skel.emitNext();
        this.print("  private void yypushback(int number) ");
        if (this.scanner.scanErrorException == null) {
            this.println(" {");
        } else {
            this.println(" throws " + this.scanner.scanErrorException + " {");
        }
    }

    private void emitMain() {
        if (!(this.scanner.standalone || this.scanner.debugOption || this.scanner.cupDebug)) {
            return;
        }
        if (this.scanner.cupDebug) {
            this.println("  /**");
            this.println("   * Converts an int token code into the name of the");
            this.println("   * token by reflection on the cup symbol class/interface " + this.scanner.cupSymbol);
            this.println("   *");
            this.println("   * This code was contributed by Karl Meissner <meissnersd@yahoo.com>");
            this.println("   * <a href=\"http://meissner.v0.net/msd.htm\">meissner.v0.net/msd.htm</a>");
            this.println("   */");
            this.println("  private String getTokenName(int token) {");
            this.println("    try {");
            this.println("      java.lang.reflect.Field [] class_fields = sym.class.getFields();");
            this.println("      for (int i = 0; i < class_fields.length; i++) {");
            this.println("        if (class_fields[i].getInt(null) == token) {");
            this.println("          return class_fields[i].getName();");
            this.println("        }");
            this.println("      }");
            this.println("    } catch (Exception e) {");
            this.println("      e.printStackTrace(System.err);");
            this.println("    }");
            this.println("");
            this.println("    return \"UNKNOWN TOKEN\";");
            this.println("  }");
            this.println("");
            this.println("  /**");
            this.println("   * Same as " + this.scanner.functionName + " but also prints the token to standard out");
            this.println("   * for debugging.");
            this.println("   *");
            this.println("   * This code was contributed by Karl Meissner <meissnersd@yahoo.com>");
            this.println("   * <a href=\"http://meissner.v0.net/msd.htm\">meissner.v0.net/msd.htm</a>");
            this.println("   */");
            this.print("  public ");
            if (this.scanner.tokenType == null) {
                if (this.scanner.isInteger) {
                    this.print("int");
                } else if (this.scanner.isIntWrap) {
                    this.print("Integer");
                } else {
                    this.print("Yytoken");
                }
            } else {
                this.print(this.scanner.tokenType);
            }
            this.print(" debug_");
            this.print(this.scanner.functionName);
            this.print("() throws java.io.IOException");
            if (this.scanner.lexThrow != null) {
                this.print(", ");
                this.print(this.scanner.lexThrow);
            }
            if (this.scanner.scanErrorException != null) {
                this.print(", ");
                this.print(this.scanner.scanErrorException);
            }
            this.println(" {");
            this.println("    java_cup.runtime.Symbol s = " + this.scanner.functionName + "();");
            this.print("    System.out.println( ");
            if (this.scanner.lineCount) {
                this.print("\"line:\" + (yyline+1) + ");
            }
            if (this.scanner.columnCount) {
                this.print("\" col:\" + (yycolumn+1) + ");
            }
            this.println("\" --\"+ yytext() + \"--\" + getTokenName(s.sym) + \"--\");");
            this.println("    return s;");
            this.println("  }");
            this.println("");
        }
        if (this.scanner.standalone) {
            this.println("  /**");
            this.println("   * Runs the scanner on input files.");
            this.println("   *");
            this.println("   * This is a standalone scanner, i.e. it will print any unmatched");
            this.println("   * text to System.out unchanged.");
            this.println("   *");
            this.println("   * @param argv   the command line, contains the filenames to run");
            this.println("   *               the scanner on.");
            this.println("   */");
        } else {
            this.println("  /**");
            this.println("   * Runs the scanner on input files.");
            this.println("   *");
            this.println("   * This main method is the debugging routine for the scanner.");
            this.println("   * It prints debugging information about each returned token to");
            this.println("   * System.out until the end of file is reached, or an error occured.");
            this.println("   *");
            this.println("   * @param argv   the command line, contains the filenames to run");
            this.println("   *               the scanner on.");
            this.println("   */");
        }
        this.println("  public static void main(String argv[]) {");
        this.println("    if (argv.length == 0) {");
        this.println("      System.out.println(\"Usage : java " + this.scanner.className + " <inputfile>\");");
        this.println("    }");
        this.println("    else {");
        this.println("      for (int i = 0; i < argv.length; i++) {");
        this.println("        " + this.scanner.className + " scanner = null;");
        this.println("        try {");
        this.println("          scanner = new " + this.scanner.className + "( new java.io.FileReader(argv[i]) );");
        if (this.scanner.standalone) {
            this.println("          while ( !scanner.yy_atEOF ) scanner." + this.scanner.functionName + "();");
        } else if (this.scanner.cupDebug) {
            this.println("          while ( !scanner.yy_atEOF ) scanner.debug_" + this.scanner.functionName + "();");
        } else {
            this.println("          do {");
            this.println("            System.out.println(scanner." + this.scanner.functionName + "());");
            this.println("          } while (!scanner.yy_atEOF);");
            this.println("");
        }
        this.println("        }");
        this.println("        catch (java.io.FileNotFoundException e) {");
        this.println("          System.out.println(\"File not found : \\\"\"+argv[i]+\"\\\"\");");
        this.println("        }");
        this.println("        catch (java.io.IOException e) {");
        this.println("          System.out.println(\"IO error scanning file \\\"\"+argv[i]+\"\\\"\");");
        this.println("          System.out.println(e);");
        this.println("        }");
        this.println("        catch (Exception e) {");
        this.println("          System.out.println(\"Unexpected exception:\");");
        this.println("          e.printStackTrace();");
        this.println("        }");
        this.println("      }");
        this.println("    }");
        this.println("  }");
        this.println("");
    }

    private void emitNoMatch() {
        this.println("            yy_ScanError(YY_NO_MATCH);");
    }

    private void emitNextInput() {
        this.println("          if (yy_currentPos_l < yy_endRead_l)");
        this.println("            yy_input = yy_buffer_l[yy_currentPos_l++];");
        this.println("          else if (yy_atEOF) {");
        this.println("            yy_input = YYEOF;");
        this.println("            break yy_forAction;");
        this.println("          }");
        this.println("          else {");
        this.println("            // store back cached positions");
        this.println("            yy_currentPos  = yy_currentPos_l;");
        this.println("            yy_markedPos   = yy_markedPos_l;");
        if (this.scanner.lookAheadUsed) {
            this.println("            yy_pushbackPos = yy_pushbackPos_l;");
        }
        this.println("            boolean eof = yy_refill();");
        this.println("            // get translated positions and possibly new buffer");
        this.println("            yy_currentPos_l  = yy_currentPos;");
        this.println("            yy_markedPos_l   = yy_markedPos;");
        this.println("            yy_buffer_l      = yy_buffer;");
        this.println("            yy_endRead_l     = yy_endRead;");
        if (this.scanner.lookAheadUsed) {
            this.println("            yy_pushbackPos_l = yy_pushbackPos;");
        }
        this.println("            if (eof) {");
        this.println("              yy_input = YYEOF;");
        this.println("              break yy_forAction;");
        this.println("            }");
        this.println("            else {");
        this.println("              yy_input = yy_buffer_l[yy_currentPos_l++];");
        this.println("            }");
        this.println("          }");
    }

    private void emitHeader() {
        this.println("/* The following code was generated by JFlex 1.3.5 on " + date + " */");
        this.println("");
    }

    private void emitUserCode() {
        if (this.scanner.userCode.length() > 0) {
            this.println(this.scanner.userCode.toString());
        }
    }

    private void emitClassName() {
        this.println("/**");
        this.println(" * This class is a scanner generated by ");
        this.println(" * <a href=\"http://www.jflex.de/\">JFlex</a> 1.3.5");
        this.println(" * on " + date + " from the specification file");
        try {
            this.println(" * <tt>" + Emitter.toURL(this.inputFile) + "</tt>");
        }
        catch (MalformedURLException malformedURLException) {
            this.println(" * (couldn't find spec. file)");
        }
        this.println(" */");
        if (this.scanner.isPublic) {
            this.print("public ");
        }
        if (this.scanner.isAbstract) {
            this.print("abstract ");
        }
        if (this.scanner.isFinal) {
            this.print("final ");
        }
        this.print("class ");
        this.print(this.scanner.className);
        if (this.scanner.isExtending != null) {
            this.print(" extends ");
            this.print(this.scanner.isExtending);
        }
        if (this.scanner.isImplementing != null) {
            this.print(" implements ");
            this.print(this.scanner.isImplementing);
        }
        this.println(" {");
    }

    private void emitLexicalStates() {
        int n;
        Enumeration enumeration = this.scanner.states.names();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            n = this.scanner.states.getNumber(string);
            if (this.scanner.bolUsed) {
                this.println("  final public static int " + string + " = " + 2 * n + ";");
                continue;
            }
            this.println("  final public static int " + string + " = " + this.dfa.lexState[2 * n] + ";");
        }
        if (this.scanner.bolUsed) {
            this.println("");
            this.println("  /**");
            this.println("   * YY_LEXSTATE[l] is the state in the DFA for the lexical state l");
            this.println("   * YY_LEXSTATE[l+1] is the state in the DFA for the lexical state l");
            this.println("   *                  at the beginning of a line");
            this.println("   * l is of the form l = 2*k, k a non negative integer");
            this.println("   */");
            this.println("  private final static int YY_LEXSTATE[] = { ");
            n = 0;
            this.print("    ");
            int n2 = 0;
            while (n2 < this.dfa.lexState.length - 1) {
                this.print(this.dfa.lexState[n2], 2);
                this.print(", ");
                if (++n >= 16) {
                    this.println();
                    this.print("    ");
                    n = 0;
                }
                ++n2;
            }
            this.println(this.dfa.lexState[n2]);
            this.println("  };");
        }
    }

    private void emitDynInitHead(int n) {
        this.println("  /** ");
        this.println("   * The packed transition table of the DFA (part " + n + ")");
        this.println("   */");
        this.println("  final private static String yy_packed" + n + " = ");
    }

    private int UTF8Length(int n) {
        if (n < 0 || n > 65535) {
            throw new Error("not a char value (" + n + ")");
        }
        if (n == 0) {
            return 2;
        }
        if (n <= 127) {
            return 1;
        }
        if (n < 1024) {
            return 2;
        }
        if (n <= 2047) {
            return 3;
        }
        return 3;
    }

    private void emitDynamicInit() {
        this.emitDynInitHead(this.numTableChunks++);
        int n = 0;
        this.print("    \"");
        int n2 = 0;
        int n3 = this.dfa.table[0][0];
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.dfa.numStates) {
            if (!this.rowKilled[n5]) {
                int n6 = 0;
                while (n6 < this.dfa.numInput) {
                    if (!this.colKilled[n6]) {
                        if (this.dfa.table[n5][n6] == n3) {
                            ++n2;
                        } else {
                            this.printUC(n2);
                            this.printUC(n3 + 1);
                            n4 += this.UTF8Length(n2) + this.UTF8Length(n3 + 1);
                            if ((n += 2) >= 16) {
                                this.print("\"+");
                                this.println();
                                this.print("    \"");
                                n = 0;
                            }
                            n2 = 1;
                            n3 = this.dfa.table[n5][n6];
                            if (n4 >= 65529) {
                                n4 = 0;
                                this.println("\";");
                                this.println();
                                this.emitDynInitHead(this.numTableChunks++);
                                this.print("    \"");
                                n = 0;
                            }
                        }
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        this.printUC(n2);
        this.printUC(n3 + 1);
        n4 += this.UTF8Length(n2) + this.UTF8Length(n3 + 1);
        this.println("\";");
        this.println();
        this.println("  /** ");
        this.println("   * The transition table of the DFA");
        this.println("   */");
        this.println("  final private static int yytrans [] = yy_unpack();");
        this.println();
    }

    private void emitDynamicInitFunction() {
        this.println();
        this.println("  /** ");
        this.println("   * Unpacks the split, compressed DFA transition table.");
        this.println("   *");
        this.println("   * @return the unpacked transition table");
        this.println("   */");
        this.println("  private static int [] yy_unpack() {");
        this.println("    int [] trans = new int[" + this.numRows * this.numCols + "];");
        this.println("    int offset = 0;");
        int n = 0;
        while (n < this.numTableChunks) {
            this.println("    offset = yy_unpack(yy_packed" + n + ", offset, trans);");
            ++n;
        }
        this.println("    return trans;");
        this.println("  }");
        this.println();
        this.println("  /** ");
        this.println("   * Unpacks the compressed DFA transition table.");
        this.println("   *");
        this.println("   * @param packed   the packed transition table");
        this.println("   * @return         the index of the last entry");
        this.println("   */");
        this.println("  private static int yy_unpack(String packed, int offset, int [] trans) {");
        this.println("    int i = 0;       /* index in packed string  */");
        this.println("    int j = offset;  /* index in unpacked array */");
        this.println("    int l = packed.length();");
        this.println("    while (i < l) {");
        this.println("      int count = packed.charAt(i++);");
        this.println("      int value = packed.charAt(i++);");
        this.println("      value--;");
        this.println("      do trans[j++] = value; while (--count > 0);");
        this.println("    }");
        this.println("    return j;");
        this.println("  }");
    }

    private void emitCharMapInitFunction() {
        CharClasses charClasses = this.parser.getCharClasses();
        if (charClasses.getMaxCharCode() < '\u0100') {
            return;
        }
        this.println("");
        this.println("  /** ");
        this.println("   * Unpacks the compressed character translation table.");
        this.println("   *");
        this.println("   * @param packed   the packed character translation table");
        this.println("   * @return         the unpacked character translation table");
        this.println("   */");
        this.println("  private static char [] yy_unpack_cmap(String packed) {");
        this.println("    char [] map = new char[0x10000];");
        this.println("    int i = 0;  /* index in packed string  */");
        this.println("    int j = 0;  /* index in unpacked array */");
        this.println("    while (i < " + 2 * this.intervalls.length + ") {");
        this.println("      int  count = packed.charAt(i++);");
        this.println("      char value = packed.charAt(i++);");
        this.println("      do map[j++] = value; while (--count > 0);");
        this.println("    }");
        this.println("    return map;");
        this.println("  }");
    }

    private void emitYYTrans() {
        int n = 0;
        this.println("  /** ");
        this.println("   * The transition table of the DFA");
        this.println("   */");
        this.println("  final private static int yytrans [] = {");
        boolean bl = true;
        this.print("    ");
        int n2 = 0;
        while (n2 < this.dfa.numStates) {
            if (!this.rowKilled[n2]) {
                int n3 = 0;
                while (n3 < this.dfa.numInput) {
                    if (!this.colKilled[n3]) {
                        if (n >= 10) {
                            this.println();
                            this.print("    ");
                            n = 0;
                        }
                        this.print(this.dfa.table[n2][n3]);
                        if (n2 != this.dfa.numStates - 1 || n3 != this.dfa.numInput - 1) {
                            this.print(", ");
                        }
                        ++n;
                    }
                    ++n3;
                }
            }
            ++n2;
        }
        this.println();
        this.println("  };");
    }

    private void emitRowMap() {
        this.reduceRows();
        this.println("  /** ");
        this.println("   * Translates a state to a row index in the transition table");
        this.println("   */");
        this.println("  final private static int yy_rowMap [] = { ");
        int n = 0;
        this.print("    ");
        int n2 = 0;
        while (n2 < this.dfa.numStates - 1) {
            this.print(this.rowMap[n2] * this.numCols, 5);
            this.print(", ");
            if (++n >= 10) {
                this.println();
                this.print("    ");
                n = 0;
            }
            ++n2;
        }
        this.print(this.rowMap[n2] * this.numCols, 5);
        this.println();
        this.println("  };");
        this.println();
        if (this.scanner.packed) {
            this.emitDynamicInit();
        } else {
            this.emitYYTrans();
        }
    }

    private void emitCharMapArrayUnPacked() {
        CharClasses charClasses = this.parser.getCharClasses();
        this.intervalls = charClasses.getIntervalls();
        this.println("");
        this.println("  /** ");
        this.println("   * Translates characters to character classes");
        this.println("   */");
        this.println("  final private static char [] yycmap = {");
        int n = 0;
        this.print("    ");
        char c = charClasses.getMaxCharCode();
        int n2 = 0;
        while (n2 < this.intervalls.length && this.intervalls[n2].start <= c) {
            int n3 = Math.min(this.intervalls[n2].end, c);
            int n4 = this.intervalls[n2].start;
            while (n4 <= n3) {
                this.print(this.colMap[this.intervalls[n2].charClass], 2);
                if (n4 < c) {
                    this.print(", ");
                    if (++n >= 16) {
                        this.println();
                        this.print("    ");
                        n = 0;
                    }
                }
                ++n4;
            }
            ++n2;
        }
        this.println();
        this.println("  };");
        this.println();
    }

    private void emitCharMapArray() {
        CharClasses charClasses = this.parser.getCharClasses();
        if (charClasses.getMaxCharCode() < '\u0100') {
            this.emitCharMapArrayUnPacked();
            return;
        }
        this.intervalls = charClasses.getIntervalls();
        this.println("");
        this.println("  /** ");
        this.println("   * Translates characters to character classes");
        this.println("   */");
        this.println("  final private static String yycmap_packed = ");
        int n = 0;
        this.print("    \"");
        int n2 = 0;
        while (n2 < this.intervalls.length - 1) {
            int n3 = this.intervalls[n2].end - this.intervalls[n2].start + 1;
            int n4 = this.colMap[this.intervalls[n2].charClass];
            this.printUC(n3);
            this.printUC(n4);
            if (++n >= 10) {
                this.println("\"+");
                this.print("    \"");
                n = 0;
            }
            ++n2;
        }
        this.printUC(this.intervalls[n2].end - this.intervalls[n2].start + 1);
        this.printUC(this.colMap[this.intervalls[n2].charClass]);
        this.println("\";");
        this.println();
        this.println("  /** ");
        this.println("   * Translates characters to character classes");
        this.println("   */");
        this.println("  final private static char [] yycmap = yy_unpack_cmap(yycmap_packed);");
        this.println();
    }

    private void emitAttributes() {
        int n;
        if (this.dfa.numStates <= 0) {
            return;
        }
        this.println("  /**");
        this.println("   * YY_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>");
        this.println("   */");
        this.println("  private final static byte YY_ATTRIBUTE[] = {");
        this.print("    ");
        int n2 = 0;
        int n3 = 0;
        while (n2 < this.dfa.numStates - 1) {
            if (n3 >= 16) {
                n3 = 0;
                this.println();
                this.print("    ");
            }
            n = 0;
            if (this.dfa.isFinal[n2]) {
                n = 1;
            }
            if (this.dfa.isPushback[n2]) {
                n |= 2;
            }
            if (this.dfa.isLookEnd[n2]) {
                n |= 4;
            }
            if (!this.isTransition[n2]) {
                n |= 8;
            }
            this.print(n, 2);
            this.print(", ");
            ++n2;
            ++n3;
        }
        n = 0;
        if (this.dfa.isFinal[this.dfa.numStates - 1]) {
            n = 1;
        }
        if (this.dfa.isPushback[this.dfa.numStates - 1]) {
            n |= 2;
        }
        if (this.dfa.isLookEnd[this.dfa.numStates - 1]) {
            n |= 4;
        }
        if (!this.isTransition[this.dfa.numStates - 1]) {
            n |= 8;
        }
        this.print(n, 2);
        this.println();
        this.println("  };");
        this.println();
    }

    private void emitClassCode() {
        if (this.scanner.eofCode != null) {
            this.println("  /** denotes if the user-EOF-code has already been executed */");
            this.println("  private boolean yy_eof_done;");
            this.println("");
        }
        if (this.scanner.classCode != null) {
            this.println("  /* user code: */");
            this.println(this.scanner.classCode);
        }
    }

    private void emitConstructorDecl() {
        this.print("  ");
        if (this.scanner.isPublic) {
            this.print("public ");
        }
        this.print(this.scanner.className);
        this.print("(java.io.Reader in)");
        if (this.scanner.initThrow != null) {
            this.print(" throws ");
            this.print(this.scanner.initThrow);
        }
        this.println(" {");
        if (this.scanner.initCode != null) {
            this.print("  ");
            this.print(this.scanner.initCode);
        }
        this.println("    this.yy_reader = in;");
        this.println("  }");
        this.println();
        this.println("  /**");
        this.println("   * Creates a new scanner.");
        this.println("   * There is also java.io.Reader version of this constructor.");
        this.println("   *");
        this.println("   * @param   in  the java.io.Inputstream to read input from.");
        this.println("   */");
        this.print("  ");
        if (this.scanner.isPublic) {
            this.print("public ");
        }
        this.print(this.scanner.className);
        this.print("(java.io.InputStream in)");
        if (this.scanner.initThrow != null) {
            this.print(" throws ");
            this.print(this.scanner.initThrow);
        }
        this.println(" {");
        this.println("    this(new java.io.InputStreamReader(in));");
        this.println("  }");
    }

    private void emitDoEOF() {
        if (this.scanner.eofCode == null) {
            return;
        }
        this.println("  /**");
        this.println("   * Contains user EOF-code, which will be executed exactly once,");
        this.println("   * when the end of file is reached");
        this.println("   */");
        this.print("  private void yy_do_eof()");
        if (this.scanner.eofThrow != null) {
            this.print(" throws ");
            this.print(this.scanner.eofThrow);
        }
        this.println(" {");
        this.println("    if (!yy_eof_done) {");
        this.println("      yy_eof_done = true;");
        this.println("    " + this.scanner.eofCode);
        this.println("    }");
        this.println("  }");
        this.println("");
        this.println("");
    }

    private void emitLexFunctHeader() {
        this.print("  public ");
        if (this.scanner.tokenType == null) {
            if (this.scanner.isInteger) {
                this.print("int");
            } else if (this.scanner.isIntWrap) {
                this.print("Integer");
            } else {
                this.print("Yytoken");
            }
        } else {
            this.print(this.scanner.tokenType);
        }
        this.print(" ");
        this.print(this.scanner.functionName);
        this.print("() throws java.io.IOException");
        if (this.scanner.lexThrow != null) {
            this.print(", ");
            this.print(this.scanner.lexThrow);
        }
        if (this.scanner.scanErrorException != null) {
            this.print(", ");
            this.print(this.scanner.scanErrorException);
        }
        this.println(" {");
        this.skel.emitNext();
        if (this.scanner.useRowMap) {
            this.println("    int [] yytrans_l = yytrans;");
            this.println("    int [] yy_rowMap_l = yy_rowMap;");
            this.println("    byte [] yy_attr_l = YY_ATTRIBUTE;");
        }
        if (this.scanner.lookAheadUsed) {
            this.println("    int yy_pushbackPos_l = yy_pushbackPos = -1;");
            this.println("    boolean yy_was_pushback;");
        }
        this.skel.emitNext();
        if (this.scanner.charCount) {
            this.println("      yychar+= yy_markedPos_l-yy_startRead;");
            this.println("");
        }
        if (this.scanner.lineCount || this.scanner.columnCount) {
            this.println("      boolean yy_r = false;");
            this.println("      for (yy_currentPos_l = yy_startRead; yy_currentPos_l < yy_markedPos_l;");
            this.println("                                                             yy_currentPos_l++) {");
            this.println("        switch (yy_buffer_l[yy_currentPos_l]) {");
            this.println("        case '\\u000B':");
            this.println("        case '\\u000C':");
            this.println("        case '\\u0085':");
            this.println("        case '\\u2028':");
            this.println("        case '\\u2029':");
            if (this.scanner.lineCount) {
                this.println("          yyline++;");
            }
            if (this.scanner.columnCount) {
                this.println("          yycolumn = 0;");
            }
            this.println("          yy_r = false;");
            this.println("          break;");
            this.println("        case '\\r':");
            if (this.scanner.lineCount) {
                this.println("          yyline++;");
            }
            if (this.scanner.columnCount) {
                this.println("          yycolumn = 0;");
            }
            this.println("          yy_r = true;");
            this.println("          break;");
            this.println("        case '\\n':");
            this.println("          if (yy_r)");
            this.println("            yy_r = false;");
            this.println("          else {");
            if (this.scanner.lineCount) {
                this.println("            yyline++;");
            }
            if (this.scanner.columnCount) {
                this.println("            yycolumn = 0;");
            }
            this.println("          }");
            this.println("          break;");
            this.println("        default:");
            this.println("          yy_r = false;");
            if (this.scanner.columnCount) {
                this.println("          yycolumn++;");
            }
            this.println("        }");
            this.println("      }");
            this.println();
            if (this.scanner.lineCount) {
                this.println("      if (yy_r) {");
                this.println("        // peek one character ahead if it is \\n (if we have counted one line too much)");
                this.println("        boolean yy_peek;");
                this.println("        if (yy_markedPos_l < yy_endRead_l)");
                this.println("          yy_peek = yy_buffer_l[yy_markedPos_l] == '\\n';");
                this.println("        else if (yy_atEOF)");
                this.println("          yy_peek = false;");
                this.println("        else {");
                this.println("          boolean eof = yy_refill();");
                this.println("          yy_markedPos_l = yy_markedPos;");
                this.println("          yy_buffer_l = yy_buffer;");
                this.println("          if (eof) ");
                this.println("            yy_peek = false;");
                this.println("          else ");
                this.println("            yy_peek = yy_buffer_l[yy_markedPos_l] == '\\n';");
                this.println("        }");
                this.println("        if (yy_peek) yyline--;");
                this.println("      }");
            }
        }
        if (this.scanner.bolUsed) {
            this.println("      if (yy_markedPos_l > yy_startRead) {");
            this.println("        switch (yy_buffer_l[yy_markedPos_l-1]) {");
            this.println("        case '\\n':");
            this.println("        case '\\u000B':");
            this.println("        case '\\u000C':");
            this.println("        case '\\u0085':");
            this.println("        case '\\u2028':");
            this.println("        case '\\u2029':");
            this.println("          yy_atBOL = true;");
            this.println("          break;");
            this.println("        case '\\r': ");
            this.println("          if (yy_markedPos_l < yy_endRead_l)");
            this.println("            yy_atBOL = yy_buffer_l[yy_markedPos_l] != '\\n';");
            this.println("          else if (yy_atEOF)");
            this.println("            yy_atBOL = false;");
            this.println("          else {");
            this.println("            boolean eof = yy_refill();");
            this.println("            yy_markedPos_l = yy_markedPos;");
            this.println("            yy_buffer_l = yy_buffer;");
            this.println("            if (eof) ");
            this.println("              yy_atBOL = false;");
            this.println("            else ");
            this.println("              yy_atBOL = yy_buffer_l[yy_markedPos_l] != '\\n';");
            this.println("          }");
            this.println("          break;");
            this.println("        default:");
            this.println("          yy_atBOL = false;");
            this.println("        }");
            this.println("      }");
        }
        this.skel.emitNext();
        if (this.scanner.bolUsed) {
            this.println("      if (yy_atBOL)");
            this.println("        yy_state = YY_LEXSTATE[yy_lexical_state+1];");
            this.println("      else");
            this.println("        yy_state = YY_LEXSTATE[yy_lexical_state];");
            this.println();
        } else {
            this.println("      yy_state = yy_lexical_state;");
            this.println();
        }
        if (this.scanner.lookAheadUsed) {
            this.println("      yy_was_pushback = false;");
        }
        this.skel.emitNext();
    }

    private void emitGetRowMapNext() {
        this.println("          int yy_next = yytrans_l[ yy_rowMap_l[yy_state] + yycmap_l[yy_input] ];");
        this.println("          if (yy_next == " + -1 + ") break yy_forAction;");
        this.println("          yy_state = yy_next;");
        this.println();
        this.println("          int yy_attributes = yy_attr_l[yy_state];");
        if (this.scanner.lookAheadUsed) {
            this.println("          if ( (yy_attributes & 2) == 2 )");
            this.println("            yy_pushbackPos_l = yy_currentPos_l;");
            this.println();
        }
        this.println("          if ( (yy_attributes & 1) == 1 ) {");
        if (this.scanner.lookAheadUsed) {
            this.println("            yy_was_pushback = (yy_attributes & 4) == 4;");
        }
        this.skel.emitNext();
        this.println("            if ( (yy_attributes & 8) == 8 ) break yy_forAction;");
        this.skel.emitNext();
    }

    private void emitTransitionTable() {
        this.transformTransitionTable();
        this.println("          yy_input = yycmap_l[yy_input];");
        this.println();
        if (this.scanner.lookAheadUsed) {
            this.println("          boolean yy_pushback = false;");
        }
        this.println("          boolean yy_isFinal = false;");
        this.println("          boolean yy_noLookAhead = false;");
        this.println();
        this.println("          yy_forNext: { switch (yy_state) {");
        int n = 0;
        while (n < this.dfa.numStates) {
            if (this.isTransition[n]) {
                this.emitState(n);
            }
            ++n;
        }
        this.println("            default:");
        this.println("              yy_ScanError(YY_ILLEGAL_STATE);");
        this.println("              break;");
        this.println("          } }");
        this.println();
        this.println("          if ( yy_isFinal ) {");
        if (this.scanner.lookAheadUsed) {
            this.println("            yy_was_pushback = yy_pushback;");
        }
        this.skel.emitNext();
        this.println("            if ( yy_noLookAhead ) break yy_forAction;");
        this.skel.emitNext();
    }

    private String escapify(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\'': {
                    stringBuffer.append("\\'");
                    break;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    break;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case '\r': {
                    if (n + 1 != string.length() && string.charAt(n + 1) == '\n') break;
                    stringBuffer.append("\"+yy_NL+\"");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\"+yy_NL+\"");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private void emitActions() {
        Hashtable<Action, StateSet> hashtable = new Hashtable<Action, StateSet>();
        int n = 0;
        while (n < this.dfa.numStates) {
            if (this.dfa.isFinal[n]) {
                Action action = this.dfa.action[n];
                if (hashtable.get(action) == null) {
                    hashtable.put(action, new StateSet(n));
                } else {
                    ((StateSet)hashtable.get(action)).addState(n);
                }
            }
            ++n;
        }
        int n2 = this.dfa.numStates + 1;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Action action = (Action)enumeration.nextElement();
            StateSet stateSet = (StateSet)hashtable.get(action);
            StateSetEnumerator stateSetEnumerator = stateSet.states();
            while (stateSetEnumerator.hasMoreElements()) {
                this.println("        case " + stateSetEnumerator.nextElement() + ": ");
            }
            if (this.scanner.debugOption) {
                this.print("          System.out.println(");
                if (this.scanner.lineCount) {
                    this.print("\"line: \"+(yyline+1)+\" \"+");
                }
                if (this.scanner.columnCount) {
                    this.print("\"col: \"+(yycolumn+1)+\" \"+");
                }
                this.println("\"match: --\"+yytext()+\"--\");");
                this.print("          System.out.println(\"action [" + action.priority + "] {");
                this.print(this.escapify(action.content));
                this.println("}\");");
            }
            this.println("          { " + action.content + " }");
            this.println("        case " + n2++ + ": break;");
        }
    }

    private void emitEOFVal() {
        EOFActions eOFActions = this.parser.getEOFActions();
        if (this.scanner.eofCode != null) {
            this.println("            yy_do_eof();");
        }
        if (eOFActions.numActions() > 0) {
            this.println("            switch (yy_lexical_state) {");
            Enumeration enumeration = this.scanner.states.names();
            Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
            int n = this.dfa.numStates;
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                int n2 = this.scanner.states.getNumber(string);
                Action action = eOFActions.getAction(n2);
                boolean bl = true;
                if (!this.scanner.bolUsed) {
                    Integer n3 = new Integer(this.dfa.lexState[2 * n2]);
                    boolean bl2 = bl = hashtable.get(n3) == null;
                    if (!bl) {
                        Out.warning("Lexical states <" + string + "> and <" + hashtable.get(n3) + "> are equivalent.");
                    } else {
                        hashtable.put(n3, string);
                    }
                }
                if (action == null || !bl) continue;
                this.println("            case " + string + ":");
                this.println("              { " + action.content + " }");
                this.println("            case " + ++n + ": break;");
            }
            this.println("            default:");
        }
        if (eOFActions.getDefault() != null) {
            this.println("              { " + eOFActions.getDefault().content + " }");
        } else if (this.scanner.eofVal != null) {
            this.println("              { " + this.scanner.eofVal + " }");
        } else if (this.scanner.isInteger) {
            this.println("            return YYEOF;");
        } else {
            this.println("            return null;");
        }
        if (eOFActions.numActions() > 0) {
            this.println("            }");
        }
    }

    private void emitState(int n) {
        this.println("            case " + n + ":");
        this.println("              switch (yy_input) {");
        int n2 = this.getDefaultTransition(n);
        int n3 = 0;
        while (n3 < this.dfa.numStates) {
            if (n3 != n2 && this.table[n][n3] != null) {
                this.emitTransition(n, n3);
            }
            ++n3;
        }
        if (n2 != -1 && this.noTarget[n] != null) {
            this.emitTransition(n, -1);
        }
        this.emitDefaultTransition(n, n2);
        this.println("              }");
        this.println("");
    }

    private void emitTransition(int n, int n2) {
        CharSetEnumerator charSetEnumerator = n2 != -1 ? this.table[n][n2].characters() : this.noTarget[n].characters();
        this.print("                case ");
        this.print(charSetEnumerator.nextElement());
        this.print(": ");
        while (charSetEnumerator.hasMoreElements()) {
            this.println();
            this.print("                case ");
            this.print(charSetEnumerator.nextElement());
            this.print(": ");
        }
        if (n2 != -1) {
            if (this.dfa.isFinal[n2]) {
                this.print("yy_isFinal = true; ");
            }
            if (this.dfa.isPushback[n2]) {
                this.print("yy_pushbackPos_l = yy_currentPos_l; ");
            }
            if (this.dfa.isLookEnd[n2]) {
                this.print("yy_pushback = true; ");
            }
            if (!this.isTransition[n2]) {
                this.print("yy_noLookAhead = true; ");
            }
            if (n2 == n) {
                this.println("yy_state = " + n2 + "; break yy_forNext;");
            } else {
                this.println("yy_state = " + n2 + "; break yy_forNext;");
            }
        } else {
            this.println("break yy_forAction;");
        }
    }

    private void emitDefaultTransition(int n, int n2) {
        this.print("                default: ");
        if (n2 != -1) {
            if (this.dfa.isFinal[n2]) {
                this.print("yy_isFinal = true; ");
            }
            if (this.dfa.isPushback[n2]) {
                this.print("yy_pushbackPos_l = yy_currentPos_l; ");
            }
            if (this.dfa.isLookEnd[n2]) {
                this.print("yy_pushback = true; ");
            }
            if (!this.isTransition[n2]) {
                this.print("yy_noLookAhead = true; ");
            }
            if (n2 == n) {
                this.println("yy_state = " + n2 + "; break yy_forNext;");
            } else {
                this.println("yy_state = " + n2 + "; break yy_forNext;");
            }
        } else {
            this.println("break yy_forAction;");
        }
    }

    private void emitPushback() {
        this.println("      if (yy_was_pushback)");
        this.println("        yy_markedPos = yy_pushbackPos_l;");
    }

    private int getDefaultTransition(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.dfa.numStates) {
            if (this.table[n][n2] == null) {
                n2 = n3;
            } else if (this.table[n][n3] != null && this.table[n][n2].size() < this.table[n][n3].size()) {
                n2 = n3;
            }
            ++n3;
        }
        if (this.table[n][n2] == null) {
            return -1;
        }
        if (this.noTarget[n] == null) {
            return n2;
        }
        if (this.table[n][n2].size() < this.noTarget[n].size()) {
            n2 = -1;
        }
        return n2;
    }

    private void transformTransitionTable() {
        int n = this.parser.getCharClasses().getNumClasses() + 1;
        this.table = new CharSet[this.dfa.numStates][this.dfa.numStates];
        this.noTarget = new CharSet[this.dfa.numStates];
        int n2 = 0;
        while (n2 < this.dfa.numStates) {
            int n3 = 0;
            while (n3 < this.dfa.numInput) {
                int n4 = this.dfa.table[n2][n3];
                if (n4 == -1) {
                    if (this.noTarget[n2] == null) {
                        this.noTarget[n2] = new CharSet(n, this.colMap[n3]);
                    } else {
                        this.noTarget[n2].add(this.colMap[n3]);
                    }
                } else if (this.table[n2][n4] == null) {
                    this.table[n2][n4] = new CharSet(n, this.colMap[n3]);
                } else {
                    this.table[n2][n4].add(this.colMap[n3]);
                }
                n3 = (char)(n3 + 1);
            }
            ++n2;
        }
    }

    private void findActionStates() {
        this.isTransition = new boolean[this.dfa.numStates];
        int n = 0;
        while (n < this.dfa.numStates) {
            int n2 = 0;
            while (!this.isTransition[n] && n2 < this.dfa.numInput) {
                int n3 = n2;
                n2 = (char)(n2 + 1);
                boolean bl = this.isTransition[n] = this.dfa.table[n][n3] != -1;
            }
            ++n;
        }
    }

    private void reduceColumns() {
        this.colMap = new int[this.dfa.numInput];
        this.colKilled = new boolean[this.dfa.numInput];
        int n = 0;
        this.numCols = this.dfa.numInput;
        int n2 = 0;
        while (n2 < this.dfa.numInput) {
            this.colMap[n2] = n2 - n;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = -1;
                boolean bl = true;
                while (bl && ++n4 < this.dfa.numStates) {
                    boolean bl2 = bl = this.dfa.table[n4][n2] == this.dfa.table[n4][n3];
                }
                if (bl) {
                    ++n;
                    this.colMap[n2] = this.colMap[n3];
                    this.colKilled[n2] = true;
                    --this.numCols;
                    break;
                }
                ++n3;
            }
            ++n2;
        }
    }

    private void reduceRows() {
        this.rowMap = new int[this.dfa.numStates];
        this.rowKilled = new boolean[this.dfa.numStates];
        int n = 0;
        this.numRows = this.dfa.numStates;
        int n2 = 0;
        while (n2 < this.dfa.numStates) {
            this.rowMap[n2] = n2 - n;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = -1;
                boolean bl = true;
                while (bl && ++n4 < this.dfa.numInput) {
                    boolean bl2 = bl = this.dfa.table[n2][n4] == this.dfa.table[n3][n4];
                }
                if (bl) {
                    ++n;
                    this.rowMap[n2] = this.rowMap[n3];
                    this.rowKilled[n2] = true;
                    --this.numRows;
                    break;
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void emit() {
        if (this.scanner.functionName == null) {
            this.scanner.functionName = "yylex";
        }
        this.reduceColumns();
        this.findActionStates();
        this.emitHeader();
        this.emitUserCode();
        this.emitClassName();
        this.skel.emitNext();
        this.println("  final private static int YY_BUFFERSIZE = " + this.scanner.bufferSize + ";");
        if (this.scanner.debugOption) {
            this.println("  final private static String yy_NL = System.getProperty(\"line.separator\");");
        }
        this.skel.emitNext();
        this.emitLexicalStates();
        this.emitCharMapArray();
        if (this.scanner.useRowMap) {
            this.emitRowMap();
        }
        this.skel.emitNext();
        if (this.scanner.useRowMap) {
            this.emitAttributes();
        }
        this.skel.emitNext();
        this.emitClassCode();
        this.skel.emitNext();
        this.emitConstructorDecl();
        if (this.scanner.packed) {
            this.emitDynamicInitFunction();
        }
        this.emitCharMapInitFunction();
        this.skel.emitNext();
        this.emitScanError();
        this.skel.emitNext();
        this.emitDoEOF();
        this.skel.emitNext();
        this.emitLexFunctHeader();
        this.emitNextInput();
        if (this.scanner.useRowMap) {
            this.emitGetRowMapNext();
        } else {
            this.emitTransitionTable();
        }
        if (this.scanner.lookAheadUsed) {
            this.emitPushback();
        }
        this.skel.emitNext();
        this.emitActions();
        this.skel.emitNext();
        this.emitEOFVal();
        this.skel.emitNext();
        this.emitNoMatch();
        this.skel.emitNext();
        this.emitMain();
        this.skel.emitNext();
        this.out.close();
    }

    public static URL toURL(File file) throws MalformedURLException {
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        return new URL("file", "", string);
    }
}

