/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.hsqldb.util.CommonSwing;
import org.hsqldb.util.ConnectionDialogCommon;
import org.hsqldb.util.ConnectionDialogSwing;
import org.hsqldb.util.ConnectionSetting;
import org.hsqldb.util.DatabaseManagerCommon;
import org.hsqldb.util.FontDialogSwing;
import org.hsqldb.util.GridSwing;
import org.hsqldb.util.RCData;
import org.hsqldb.util.TableSorter;
import org.hsqldb.util.Transfer;

public class DatabaseManagerSwing
extends JFrame
implements ActionListener,
WindowListener,
KeyListener,
MouseListener {
    private static String homedir = System.getProperty("user.home");
    private boolean isOracle = false;
    ArrayList<JMenuItem> localActionList = new ArrayList();
    private JFrame jframe;
    private static final String DEFAULT_RCFILE = homedir + "/dbmanager.rc";
    private static boolean TT_AVAILABLE = false;
    private static final String HELP_TEXT;
    private static final String ABOUT_TEXT;
    static final String NL;
    static final String NULL_STR = "[null]";
    static int iMaxRecent;
    Connection cConn;
    Connection rowConn;
    DatabaseMetaData dMeta;
    Statement sStatement;
    JMenu mRecent;
    String[] sRecent;
    int iRecent;
    JTextArea txtCommand;
    JScrollPane txtCommandScroll;
    JTree tTree;
    JScrollPane tScrollPane;
    DefaultTreeModel treeModel;
    TableModel tableModel;
    DefaultMutableTreeNode rootNode;
    JPanel pResult;
    long lTime;
    GridSwing gResult;
    JTable gResultTable;
    JScrollPane gScrollPane;
    JTextArea txtResult;
    JScrollPane txtResultScroll;
    JSplitPane nsSplitPane;
    JSplitPane ewSplitPane;
    boolean bHelp;
    RootPaneContainer fMain;
    static boolean bMustExit;
    String sqlScriptBuffer = null;
    private boolean showSchemas = true;
    private boolean showTooltips = true;
    private boolean autoRefresh = true;
    private boolean gridFormat = true;
    boolean displayRowCounts = false;
    boolean showSys = false;
    boolean showIndexDetails = true;
    String currentLAF = null;
    JPanel pStatus;
    static JButton iReadyStatus;
    JRadioButtonMenuItem rbAllSchemas = new JRadioButtonMenuItem("*");
    JMenuItem mitemAbout = new JMenuItem("About", 65);
    JMenuItem mitemHelp = new JMenuItem("Help", 72);
    JMenuItem mitemUpdateSchemas = new JMenuItem("Update Schemas");
    JCheckBoxMenuItem boxAutoCommit = new JCheckBoxMenuItem("Autocommit mode");
    JCheckBoxMenuItem boxLogging = new JCheckBoxMenuItem("Logging mode");
    JCheckBoxMenuItem boxShowSchemas = new JCheckBoxMenuItem("Show schemas");
    JCheckBoxMenuItem boxAutoRefresh = new JCheckBoxMenuItem("Auto-refresh tree");
    JCheckBoxMenuItem boxTooltips = new JCheckBoxMenuItem("Show Tooltips");
    JCheckBoxMenuItem boxRowCounts = new JCheckBoxMenuItem("Show row counts");
    JCheckBoxMenuItem boxShowGrid = new JCheckBoxMenuItem("Show results in Grid (a.o.t. Text)");
    JCheckBoxMenuItem boxShowSys = new JCheckBoxMenuItem("Show system tables");
    JRadioButtonMenuItem rbNativeLF = new JRadioButtonMenuItem("Native Look & Feel");
    JRadioButtonMenuItem rbJavaLF = new JRadioButtonMenuItem("Java Look & Feel");
    JRadioButtonMenuItem rbMotifLF = new JRadioButtonMenuItem("Motif Look & Feel");
    JLabel jStatusLine;
    static String READY_STATUS;
    private static final String AUTOCOMMIT_BOX_TEXT = "Autocommit mode";
    private static final String LOGGING_BOX_TEXT = "Logging mode";
    private static final String SHOWSCHEMAS_BOX_TEXT = "Show schemas";
    private static final String AUTOREFRESH_BOX_TEXT = "Auto-refresh tree";
    private static final String SHOWTIPS_BOX_TEXT = "Show Tooltips";
    private static final String ROWCOUNTS_BOX_TEXT = "Show row counts";
    private static final String SHOWSYS_BOX_TEXT = "Show system tables";
    private static final String GRID_BOX_TEXT = "Show results in Grid (a.o.t. Text)";
    Cursor fMainCursor;
    Cursor txtCommandCursor;
    Cursor txtResultCursor;
    HashMap<AbstractButton, String> tipMap = new HashMap();
    private final JMenu mnuSchemas = new JMenu("Schemas");
    private final Cursor waitCursor = new Cursor(3);
    static String defDirectory;
    private String schemaFilter = null;
    private DBMPrefs prefs = null;
    private String busyText = null;
    private final Runnable enableButtonRunnable = new Runnable(){

        @Override
        public void run() {
            DatabaseManagerSwing.this.jbuttonClear.setEnabled(true);
            DatabaseManagerSwing.this.jbuttonExecute.setEnabled(true);
        }
    };
    private final Runnable disableButtonRunnable = new Runnable(){

        @Override
        public void run() {
            DatabaseManagerSwing.this.jbuttonClear.setEnabled(false);
            DatabaseManagerSwing.this.jbuttonExecute.setEnabled(false);
        }
    };
    private Thread buttonUpdaterThread = null;
    private static final int BUTTON_CHECK_PERIOD = 500;
    private final Runnable buttonUpdater = new Runnable(){

        @Override
        public void run() {
            while (true) {
                boolean bl;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (DatabaseManagerSwing.this.buttonUpdaterThread == null) {
                    return;
                }
                boolean bl2 = bl = DatabaseManagerSwing.this.txtCommand.getText().length() > 0;
                if (DatabaseManagerSwing.this.jbuttonClear.isEnabled() == bl) continue;
                SwingUtilities.invokeLater(bl ? DatabaseManagerSwing.this.enableButtonRunnable : DatabaseManagerSwing.this.disableButtonRunnable);
            }
        }
    };
    private JButton jbuttonClear;
    private JButton jbuttonExecute;
    private final Runnable treeRefreshRunnable = new Runnable(){

        @Override
        public void run() {
            try {
                DatabaseManagerSwing.this.directRefreshTree();
            }
            catch (RuntimeException runtimeException) {
                CommonSwing.errorMessage(runtimeException);
                throw runtimeException;
            }
            finally {
                DatabaseManagerSwing.this.setWaiting(null);
            }
        }
    };
    private MouseEvent alreadyHandled = null;
    private static final String[] usertables;
    private static final String[] nonSystables;
    private static final HashSet<String> oracleSysUsers;
    private static final String[] oracleSysSchemas;
    ActionListener schemaListListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DatabaseManagerSwing.this.schemaFilter = actionEvent.getActionCommand();
            if (DatabaseManagerSwing.this.schemaFilter.equals("*")) {
                DatabaseManagerSwing.this.schemaFilter = null;
            }
            DatabaseManagerSwing.this.refreshTree();
        }
    };
    private static final String tString;
    private static final String fString;

    public DatabaseManagerSwing() {
        this.jframe = new JFrame("HyperSQL Database Manager");
        this.fMain = this.jframe;
    }

    public DatabaseManagerSwing(JFrame jFrame) {
        this.jframe = jFrame;
        this.fMain = this.jframe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        System.getProperties().put("sun.java2d.noddraw", "true");
        String string = null;
        String string2 = null;
        String string3 = "org.hsqldb.jdbc.JDBCDriver";
        String string4 = "jdbc:hsqldb:mem:.";
        String string5 = "SA";
        String string6 = "";
        boolean bl = false;
        boolean bl2 = false;
        bMustExit = true;
        for (int i = 0; i < stringArray.length; ++i) {
            String string7 = stringArray[i];
            String string8 = stringArray[i].toLowerCase();
            if (string8.startsWith("--")) {
                string8 = string8.substring(1);
            }
            if (!string8.equals("-noexit") && !string8.equals("-help") && i == stringArray.length - 1) {
                throw new IllegalArgumentException("No value for argument " + string7);
            }
            ++i;
            if (string8.equals("-driver")) {
                string3 = stringArray[i];
                bl = true;
                continue;
            }
            if (string8.equals("-url")) {
                string4 = stringArray[i];
                bl = true;
                continue;
            }
            if (string8.equals("-user")) {
                string5 = stringArray[i];
                bl = true;
                continue;
            }
            if (string8.equals("-password")) {
                string6 = stringArray[i];
                bl = true;
                continue;
            }
            if (string8.equals("-urlid")) {
                string = stringArray[i];
                bl2 = true;
                continue;
            }
            if (string8.equals("-rcfile")) {
                string2 = stringArray[i];
                bl2 = true;
                continue;
            }
            if (string8.equals("-dir")) {
                defDirectory = stringArray[i];
                continue;
            }
            if (string8.equals("-script")) continue;
            if (string8.equals("-noexit")) {
                bMustExit = false;
                --i;
                continue;
            }
            if (string8.equals("-help")) {
                DatabaseManagerSwing.showUsage();
                return;
            }
            throw new IllegalArgumentException("invalid argument " + string7 + " try:  java... " + DatabaseManagerSwing.class.getName() + " --help");
        }
        DatabaseManagerSwing databaseManagerSwing = new DatabaseManagerSwing();
        databaseManagerSwing.main();
        Connection connection = null;
        databaseManagerSwing.setWaiting("Initializing");
        try {
            if (bl && bl2) {
                throw new IllegalArgumentException("You may not specify both (urlid) AND (url/user/password).");
            }
            if (bl) {
                connection = ConnectionDialogSwing.createConnection(string3, string4, string5, string6);
            } else if (bl2) {
                if (string == null) {
                    throw new IllegalArgumentException("You must specify an 'urlid' to use an RC file");
                }
                String string9 = string2 == null ? DEFAULT_RCFILE : string2;
                RCData rCData = new RCData(new File(string9), string);
                connection = rCData.getConnection(null, System.getProperty("javax.net.ssl.trustStore"));
            } else {
                connection = ConnectionDialogSwing.createConnection(databaseManagerSwing.jframe, "Connect");
            }
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
        finally {
            databaseManagerSwing.setWaiting(null);
        }
        if (connection != null) {
            databaseManagerSwing.connect(connection);
        }
        databaseManagerSwing.start();
    }

    public void connect(Connection connection) {
        this.schemaFilter = null;
        if (connection == null) {
            return;
        }
        if (this.cConn != null) {
            try {
                this.cConn.close();
            }
            catch (SQLException sQLException) {
                CommonSwing.errorMessage(sQLException);
            }
        }
        this.cConn = connection;
        this.rowConn = connection;
        try {
            this.dMeta = this.cConn.getMetaData();
            this.isOracle = this.dMeta.getDatabaseProductName().contains("Oracle");
            this.sStatement = this.cConn.createStatement();
            this.updateAutoCommitBox();
            this.showIndexDetails = !this.isOracle;
            Driver driver = DriverManager.getDriver(this.dMeta.getURL());
            ConnectionSetting connectionSetting = new ConnectionSetting(this.dMeta.getDatabaseProductName(), driver.getClass().getName(), this.dMeta.getURL(), this.dMeta.getUserName().replaceAll("@localhost", ""), "");
            Hashtable hashtable = ConnectionDialogCommon.loadRecentConnectionSettings();
            ConnectionDialogCommon.addToRecentConnectionSettings(hashtable, connectionSetting);
            ConnectionDialogSwing.setConnectionSetting(connectionSetting);
            this.refreshTree();
            this.clearResultPanel();
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
        catch (IOException iOException) {
            CommonSwing.errorMessage(iOException);
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
    }

    private static void showUsage() {
        System.out.println("Usage: java DatabaseManagerSwing [--options]\nwhere options include:\n    --help                show this message\n    --driver <classname>  jdbc driver class\n    --url <name>          jdbc url\n    --user <name>         username used for connection\n    --password <password> password for this user\n    --urlid <urlid>       use url/user/password/driver in rc file\n    --rcfile <file>       (defaults to 'dbmanager.rc' in home dir)\n    --dir <path>          default directory\n    --script <file>       reads from script file\n    --noexit              do not call system.exit()");
    }

    private void insertTestData() {
        try {
            DatabaseManagerCommon.createTestTables(this.sStatement);
            this.txtCommand.setText(DatabaseManagerCommon.createTestData(this.sStatement));
            for (int i = 0; i < DatabaseManagerCommon.testDataSql.length; ++i) {
                this.addToRecent(DatabaseManagerCommon.testDataSql[i]);
            }
            this.executeCurrentSQL();
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
    }

    public void main() {
        JMenuItem jMenuItem;
        try {
            this.prefs = new DBMPrefs(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.prefs == null) {
            this.setLF("Native");
        } else {
            this.autoRefresh = this.prefs.autoRefresh;
            this.displayRowCounts = this.prefs.showRowCounts;
            this.showSys = this.prefs.showSysTables;
            this.showSchemas = this.prefs.showSchemas;
            this.gridFormat = this.prefs.resultGrid;
            this.showTooltips = this.prefs.showTooltips;
            this.setLF(this.prefs.laf);
        }
        this.fMain.getContentPane().add((Component)this.createToolBar(), "North");
        if (this.fMain instanceof Frame) {
            ((Frame)((Object)this.fMain)).setIconImage(CommonSwing.getIcon("Frame"));
        }
        if (this.fMain instanceof Window) {
            ((Window)((Object)this.fMain)).addWindowListener(this);
        }
        JMenuBar jMenuBar = new JMenuBar();
        Object[] objectArray = new String[]{"-Connect...", "-Close Connection", "--", "OOpen Script...", "-Save Script...", "-Save Result...", "--", "-Exit"};
        JMenu jMenu = this.addMenu(jMenuBar, "File", objectArray);
        for (int i = 3; i < jMenu.getItemCount(); ++i) {
            jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null) continue;
            this.localActionList.add(jMenuItem);
        }
        Object[] objectArray2 = new Object[]{"RRefresh Tree", this.boxAutoRefresh, "--", this.boxRowCounts, this.boxShowSys, this.boxShowSchemas, this.boxShowGrid};
        this.addMenu(jMenuBar, "View", objectArray2);
        Object[] objectArray3 = new String[]{"SSELECT", "IINSERT", "UUPDATE", "DDELETE", "EEXECUTE", "---", "-CREATE TABLE", "-DROP TABLE", "-CREATE INDEX", "-DROP INDEX", "--", "CCOMMIT*", "LROLLBACK*", "-CHECKPOINT*", "-SCRIPT", "-SET", "-SHUTDOWN", "--", "-Test Script"};
        this.addMenu(jMenuBar, "Command", objectArray3);
        this.mRecent = new JMenu("Recent");
        this.mRecent.setMnemonic(82);
        jMenuBar.add(this.mRecent);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbNativeLF);
        buttonGroup.add(this.rbJavaLF);
        buttonGroup.add(this.rbMotifLF);
        this.boxShowSchemas.setSelected(this.showSchemas);
        this.boxShowGrid.setSelected(this.gridFormat);
        this.boxTooltips.setSelected(this.showTooltips);
        this.boxShowGrid.setAccelerator(KeyStroke.getKeyStroke(71, 128));
        this.boxAutoRefresh.setSelected(this.autoRefresh);
        this.boxRowCounts.setSelected(this.displayRowCounts);
        this.boxShowSys.setSelected(this.showSys);
        this.rbNativeLF.setActionCommand("LFMODE:Native");
        this.rbJavaLF.setActionCommand("LFMODE:Java");
        this.rbMotifLF.setActionCommand("LFMODE:Motif");
        this.tipMap.put(this.mitemUpdateSchemas, "Refresh the schema list in this menu");
        this.tipMap.put(this.rbAllSchemas, "Display items in all schemas");
        this.tipMap.put(this.mitemAbout, "Display product information");
        this.tipMap.put(this.mitemHelp, "Display advice for obtaining help");
        this.tipMap.put(this.boxAutoRefresh, "Refresh tree (and schema list) automaticallywhen YOU modify database objects");
        this.tipMap.put(this.boxShowSchemas, "Display object names in tree-like schemaname.basename");
        this.tipMap.put(this.rbNativeLF, "Set Look and Feel to Native for your platform");
        this.tipMap.put(this.rbJavaLF, "Set Look and Feel to Java");
        this.tipMap.put(this.rbMotifLF, "Set Look and Feel to Motif");
        this.boxTooltips.setToolTipText("Display tooltips (hover text), like this");
        this.tipMap.put(this.boxAutoCommit, "Shows current Auto-commit mode.  Click to change");
        this.tipMap.put(this.boxLogging, "Shows current JDBC DriverManager logging mode.  Click to change");
        this.tipMap.put(this.boxShowSys, "Show system tables in table tree to the left");
        this.tipMap.put(this.boxShowGrid, "Show query results in grid (in text if off)");
        this.tipMap.put(this.boxRowCounts, "Show row counts with table names in tree");
        this.boxAutoRefresh.setMnemonic(67);
        this.boxShowSchemas.setMnemonic(89);
        this.boxAutoCommit.setMnemonic(65);
        this.boxShowSys.setMnemonic(89);
        this.boxShowGrid.setMnemonic(71);
        this.boxRowCounts.setMnemonic(67);
        this.boxLogging.setMnemonic(76);
        this.rbAllSchemas.setMnemonic(151);
        this.rbNativeLF.setMnemonic(78);
        this.rbJavaLF.setMnemonic(74);
        this.rbMotifLF.setMnemonic(77);
        this.mitemUpdateSchemas.setMnemonic(85);
        Object[] objectArray4 = new Object[]{this.rbNativeLF, this.rbJavaLF, this.rbMotifLF, "--", "-Set Fonts", "--", this.boxAutoCommit, "--", "-Disable MaxRows", "-Set MaxRows to 100", "--", this.boxLogging, "--", "-Insert test data"};
        this.addMenu(jMenuBar, "Options", objectArray4);
        Object[] objectArray5 = new String[]{"-Dump", "-Restore", "-Transfer"};
        jMenu = this.addMenu(jMenuBar, "Tools", objectArray5);
        jMenu.setEnabled(TT_AVAILABLE);
        this.localActionList.add(jMenu);
        for (int i = 0; i < jMenu.getItemCount(); ++i) {
            jMenuItem = jMenu.getItem(i);
            if (jMenuItem == null) continue;
            this.localActionList.add(jMenuItem);
        }
        this.mnuSchemas.setMnemonic(83);
        jMenuBar.add(this.mnuSchemas);
        JMenu jMenu2 = new JMenu("Help");
        jMenu2.setMnemonic(72);
        jMenu2.add(this.mitemAbout);
        jMenu2.add(this.mitemHelp);
        jMenu2.add(this.boxTooltips);
        this.rbAllSchemas.addActionListener(this.schemaListListener);
        this.mitemUpdateSchemas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseManagerSwing.this.updateSchemaList();
            }
        });
        this.mitemHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(DatabaseManagerSwing.this.fMain.getContentPane(), HELP_TEXT, "HELP", 1);
            }
        });
        this.mitemAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JOptionPane.showMessageDialog(DatabaseManagerSwing.this.fMain.getContentPane(), ABOUT_TEXT, "About", 1);
            }
        });
        this.boxTooltips.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseManagerSwing.this.showTooltips = DatabaseManagerSwing.this.boxTooltips.isSelected();
                DatabaseManagerSwing.this.resetTooltips();
            }
        });
        jMenuBar.add(jMenu2);
        if (this.fMain instanceof JFrame) {
            ((JFrame)this.fMain).setJMenuBar(jMenuBar);
        }
        this.initGUI();
        this.sRecent = new String[iMaxRecent];
        CommonSwing.setFramePositon((JFrame)this.fMain);
        ((Component)((Object)this.fMain)).setVisible(true);
        FontDialogSwing.creatFontDialog(this);
        this.resetTooltips();
        this.txtCommand.requestFocus();
    }

    private JMenu addMenu(JMenuBar jMenuBar, String string, Object[] objectArray) {
        JMenu jMenu = new JMenu(string);
        jMenu.setMnemonic(string.charAt(0));
        this.addMenuItems(jMenu, objectArray);
        jMenuBar.add(jMenu);
        return jMenu;
    }

    private void addMenuItems(JMenu jMenu, Object[] objectArray) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        for (int i = 0; i < objectArray.length; ++i) {
            JMenuItem jMenuItem;
            if (objectArray[i].equals("--")) {
                jMenu.addSeparator();
                continue;
            }
            if (objectArray[i].equals("---")) {
                if (dimension.width >= 640) {
                    jMenu.addSeparator();
                    continue;
                }
                return;
            }
            if (objectArray[i] instanceof JMenuItem) {
                jMenuItem = (JMenuItem)objectArray[i];
            } else if (objectArray[i] instanceof String) {
                jMenuItem = new JMenuItem(((String)objectArray[i]).substring(1));
                char c = ((String)objectArray[i]).charAt(0);
                if (c != '-') {
                    KeyStroke keyStroke = KeyStroke.getKeyStroke((int)c, 128);
                    jMenuItem.setAccelerator(keyStroke);
                }
            } else {
                throw new RuntimeException("Unexpected element for menu item creation: " + objectArray[i].getClass().getName());
            }
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n' && keyEvent.isControlDown()) {
            keyEvent.consume();
            this.executeCurrentSQL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null && actionEvent.getSource() instanceof JMenuItem) {
            string = ((JMenuItem)actionEvent.getSource()).getText();
        }
        if (string != null) {
            if (string.equals("Exit")) {
                this.windowClosing(null);
            } else if (string.equals("Transfer")) {
                Transfer.work(null);
            } else if (string.equals("Dump")) {
                Transfer.work((String[])new String[]{"-d"});
            } else if (string.equals("Restore")) {
                JOptionPane.showMessageDialog(this.fMain.getContentPane(), "Use Ctrl-R or the View menu to\nupdate nav. tree after Restoration", "Suggestion", 1);
                Transfer.work((String[])new String[]{"-r"});
            } else if (string.equals(LOGGING_BOX_TEXT)) {
                DatabaseManagerSwing.setLogToSystem(this.boxLogging.isSelected());
            } else if (string.equals(AUTOREFRESH_BOX_TEXT)) {
                this.autoRefresh = this.boxAutoRefresh.isSelected();
                this.refreshTree();
            } else if (string.equals("Refresh Tree")) {
                this.refreshTree();
            } else if (string.startsWith("#")) {
                int n = Integer.parseInt(string.substring(1));
                this.txtCommand.setText(this.sRecent[n]);
            } else if (string.equals("Connect...")) {
                Connection connection;
                try {
                    this.setWaiting("Connecting");
                    connection = ConnectionDialogSwing.createConnection(this.jframe, "Connect");
                }
                finally {
                    this.setWaiting(null);
                }
                this.connect(connection);
            } else if (string.equals("Close Connection")) {
                if (this.cConn != null) {
                    try {
                        this.cConn.close();
                    }
                    catch (SQLException sQLException) {
                        CommonSwing.errorMessage(sQLException);
                    }
                    this.cConn = null;
                    this.dMeta = null;
                    this.rootNode.setUserObject("Connection");
                    this.directRefreshTree();
                }
            } else if (string.equals(GRID_BOX_TEXT)) {
                this.gridFormat = this.boxShowGrid.isSelected();
                this.displayResults();
            } else if (string.equals("Open Script...")) {
                File file;
                int n;
                JFileChooser jFileChooser = new JFileChooser(".");
                jFileChooser.setDialogTitle("Open Script...");
                if (defDirectory != null) {
                    jFileChooser.setCurrentDirectory(new File(defDirectory));
                }
                if ((n = jFileChooser.showOpenDialog((Component)((Object)this.fMain))) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    this.sqlScriptBuffer = DatabaseManagerCommon.readFile(file.getAbsolutePath());
                    if (4096 <= this.sqlScriptBuffer.length()) {
                        int n2 = this.sqlScriptBuffer.indexOf(10);
                        if (n2 > 0) {
                            n2 = this.sqlScriptBuffer.indexOf(10, n2 + 1);
                        }
                        if (n2 > 0) {
                            n2 = this.sqlScriptBuffer.indexOf(10, n2 + 1);
                        }
                        if (n2 < 1) {
                            n2 = 100;
                        }
                        this.txtCommand.setText("............... Script File loaded: " + file + " ..................... \n............... Click Execute or Clear ...................\n" + this.sqlScriptBuffer.substring(0, n2 + 1) + ".........................................................................\n.........................................................................\n");
                        this.txtCommand.setEnabled(false);
                    } else {
                        this.txtCommand.setText(this.sqlScriptBuffer);
                        this.sqlScriptBuffer = null;
                        this.txtCommand.setEnabled(true);
                    }
                }
            } else if (string.equals("Save Script...")) {
                File file;
                int n;
                JFileChooser jFileChooser = new JFileChooser(".");
                jFileChooser.setDialogTitle("Save Script");
                if (defDirectory != null) {
                    jFileChooser.setCurrentDirectory(new File(defDirectory));
                }
                if ((n = jFileChooser.showSaveDialog((Component)((Object)this.fMain))) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    DatabaseManagerCommon.writeFile(file.getAbsolutePath(), this.txtCommand.getText());
                }
            } else if (string.equals("Save Result...")) {
                File file;
                int n;
                JFileChooser jFileChooser = new JFileChooser(".");
                jFileChooser.setDialogTitle("Save Result...");
                if (defDirectory != null) {
                    jFileChooser.setCurrentDirectory(new File(defDirectory));
                }
                if ((n = jFileChooser.showSaveDialog((Component)((Object)this.fMain))) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    this.showResultInText();
                    DatabaseManagerCommon.writeFile(file.getAbsolutePath(), this.txtResult.getText());
                }
            } else if (string.equals(SHOWSYS_BOX_TEXT)) {
                this.showSys = this.boxShowSys.isSelected();
                this.refreshTree();
            } else if (string.equals(ROWCOUNTS_BOX_TEXT)) {
                this.displayRowCounts = this.boxRowCounts.isSelected();
                this.refreshTree();
            } else if (string.startsWith("LFMODE:")) {
                this.setLF(string.substring("LFMODE:".length()));
            } else if (string.equals("Set Fonts")) {
                FontDialogSwing.creatFontDialog(this);
            } else if (string.equals(AUTOCOMMIT_BOX_TEXT)) {
                try {
                    this.cConn.setAutoCommit(this.boxAutoCommit.isSelected());
                }
                catch (SQLException sQLException) {
                    this.boxAutoCommit.setSelected(!this.boxAutoCommit.isSelected());
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string.equals("COMMIT*")) {
                try {
                    this.cConn.commit();
                    this.showHelp(new String[]{"", "COMMIT executed"});
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string.equals("Insert test data")) {
                this.insertTestData();
                this.refreshTree();
            } else if (string.equals("ROLLBACK*")) {
                try {
                    this.cConn.rollback();
                    this.showHelp(new String[]{"", "ROLLBACK executed"});
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string.equals("Disable MaxRows")) {
                try {
                    this.sStatement.setMaxRows(0);
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string.equals("Set MaxRows to 100")) {
                try {
                    this.sStatement.setMaxRows(100);
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string.equals("SELECT")) {
                this.showHelp(DatabaseManagerCommon.selectHelp);
            } else if (string.equals("INSERT")) {
                this.showHelp(DatabaseManagerCommon.insertHelp);
            } else if (string.equals("UPDATE")) {
                this.showHelp(DatabaseManagerCommon.updateHelp);
            } else if (string.equals("DELETE")) {
                this.showHelp(DatabaseManagerCommon.deleteHelp);
            } else if (string.equals("EXECUTE")) {
                this.executeCurrentSQL();
            } else if (string.equals("CREATE TABLE")) {
                this.showHelp(DatabaseManagerCommon.createTableHelp);
            } else if (string.equals("DROP TABLE")) {
                this.showHelp(DatabaseManagerCommon.dropTableHelp);
            } else if (string.equals("CREATE INDEX")) {
                this.showHelp(DatabaseManagerCommon.createIndexHelp);
            } else if (string.equals("DROP INDEX")) {
                this.showHelp(DatabaseManagerCommon.dropIndexHelp);
            } else if (string.equals("CHECKPOINT*")) {
                try {
                    this.cConn.createStatement().executeUpdate("CHECKPOINT");
                    this.showHelp(new String[]{"", "CHECKPOINT executed"});
                }
                catch (SQLException sQLException) {
                    CommonSwing.errorMessage(sQLException);
                }
            } else if (string.equals("SCRIPT")) {
                this.showHelp(DatabaseManagerCommon.scriptHelp);
            } else if (string.equals("SHUTDOWN")) {
                this.showHelp(DatabaseManagerCommon.shutdownHelp);
            } else if (string.equals("SET")) {
                this.showHelp(DatabaseManagerCommon.setHelp);
            } else if (string.equals("Test Script")) {
                this.showHelp(DatabaseManagerCommon.testHelp);
            } else if (string.equals(SHOWSCHEMAS_BOX_TEXT)) {
                this.showSchemas = this.boxShowSchemas.isSelected();
                this.refreshTree();
            } else {
                throw new RuntimeException("Unexpected action triggered: " + string);
            }
        }
    }

    private void displayResults() {
        if (this.gridFormat) {
            this.setResultsInGrid();
        } else {
            this.setResultsInText();
        }
    }

    private void setResultsInGrid() {
        this.pResult.removeAll();
        this.pResult.add((Component)this.gScrollPane, "Center");
        this.pResult.doLayout();
        this.gResult.fireTableChanged(null);
        this.pResult.repaint();
    }

    private void setResultsInText() {
        this.pResult.removeAll();
        this.pResult.add((Component)this.txtResultScroll, "Center");
        this.pResult.doLayout();
        this.showResultInText();
        this.pResult.repaint();
    }

    private void showHelp(String[] stringArray) {
        this.txtCommand.setText(stringArray[0]);
        this.bHelp = true;
        this.pResult.removeAll();
        this.pResult.add((Component)this.txtResultScroll, "Center");
        this.pResult.doLayout();
        this.txtResult.setText(stringArray[1]);
        this.pResult.repaint();
        this.txtCommand.requestFocus();
        this.txtCommand.setCaretPosition(stringArray[0].length());
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.stop();
        try {
            if (this.cConn != null) {
                this.cConn.close();
            }
            if (this.prefs != null) {
                this.prefs.autoRefresh = this.autoRefresh;
                this.prefs.showRowCounts = this.displayRowCounts;
                this.prefs.showSysTables = this.showSys;
                this.prefs.showSchemas = this.showSchemas;
                this.prefs.resultGrid = this.gridFormat;
                this.prefs.showTooltips = this.showTooltips;
                this.prefs.laf = this.currentLAF;
                this.prefs.store();
            }
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
        if (this.fMain instanceof Window) {
            ((Window)((Object)this.fMain)).dispose();
        }
        if (bMustExit) {
            System.exit(0);
        }
    }

    private void clear() {
        this.sqlScriptBuffer = null;
        this.txtCommand.setText("");
        this.txtCommand.setEnabled(true);
    }

    private void backgroundIt(Runnable runnable, String string) {
        if (this.busyText != null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.setWaiting(string);
        SwingUtilities.invokeLater(runnable);
    }

    private void clearResultPanel() {
        this.gResult.setHead(new Object[0]);
        this.gResult.clear();
        if (this.gridFormat) {
            this.gResult.fireTableChanged(null);
        } else {
            this.showResultInText();
        }
    }

    public void setWaiting(String string) {
        this.busyText = string;
        if (this.busyText == null) {
            if (this.fMain instanceof Frame) {
                ((Frame)((Object)this.fMain)).setCursor(this.fMainCursor);
            } else {
                ((Component)((Object)this.fMain)).setCursor(this.fMainCursor);
            }
            this.txtCommand.setCursor(this.txtCommandCursor);
            this.txtResult.setCursor(this.txtResultCursor);
        } else {
            if (this.fMainCursor == null) {
                this.fMainCursor = this.fMain instanceof Frame ? ((Frame)((Object)this.fMain)).getCursor() : ((Component)((Object)this.fMain)).getCursor();
                this.txtCommandCursor = this.txtCommand.getCursor();
                this.txtResultCursor = this.txtResult.getCursor();
            }
            if (this.fMain instanceof Frame) {
                ((Frame)((Object)this.fMain)).setCursor(this.waitCursor);
            } else {
                ((Component)((Object)this.fMain)).setCursor(this.waitCursor);
            }
            this.txtCommand.setCursor(this.waitCursor);
            this.txtResult.setCursor(this.waitCursor);
        }
        this.setStatusLine(this.busyText, this.busyText == null ? this.gResult.getRowCount() : 0);
    }

    public void start() {
        if (this.buttonUpdaterThread == null) {
            this.buttonUpdaterThread = new Thread(this.buttonUpdater);
        }
        this.buttonUpdaterThread.start();
    }

    public void stop() {
        System.err.println("Stopping");
        Thread thread = this.buttonUpdaterThread;
        if (thread != null) {
            thread.setContextClassLoader(null);
        }
        this.buttonUpdaterThread = null;
    }

    protected void executeCurrentSQL() {
        if (this.txtCommand.getText().isEmpty()) {
            CommonSwing.errorMessage("No SQL to execute");
            return;
        }
        this.backgroundIt(new StatementExecRunnable(), "Executing SQL");
    }

    private void executeSQL() {
        String string;
        Object[] objectArray = new String[1];
        try {
            this.lTime = System.nanoTime();
            String string2 = string = this.sqlScriptBuffer == null ? this.txtCommand.getText() : this.sqlScriptBuffer;
            if (this.sStatement == null) {
                objectArray[0] = "no connection";
                this.gResult.setHead(objectArray);
                return;
            }
            this.sStatement.execute(string);
            this.lTime = System.nanoTime() - this.lTime;
            int n = this.sStatement.getUpdateCount();
            if (n == -1) {
                ResultSet resultSet = this.sStatement.getResultSet();
                try {
                    this.formatResultSet(resultSet);
                }
                catch (Throwable throwable) {
                    objectArray[0] = "Error displaying the ResultSet";
                    this.gResult.setHead(objectArray);
                    String string3 = throwable.getMessage();
                    objectArray[0] = string3;
                    this.gResult.addRow(objectArray);
                }
            } else if (this.sStatement.getMoreResults()) {
                ResultSet resultSet = this.sStatement.getResultSet();
                try {
                    this.formatResultSet(resultSet);
                }
                catch (Throwable throwable) {
                    objectArray[0] = "Error displaying the ResultSet";
                    this.gResult.setHead(objectArray);
                    String string4 = throwable.getMessage();
                    objectArray[0] = string4;
                    this.gResult.addRow(objectArray);
                }
            } else {
                objectArray[0] = "update count";
                this.gResult.setHead(objectArray);
                objectArray[0] = "" + n;
                this.gResult.addRow(objectArray);
            }
            if (this.sqlScriptBuffer == null) {
                this.addToRecent(string);
                this.txtCommand.setEnabled(true);
            } else {
                this.clear();
            }
        }
        catch (SQLException sQLException) {
            this.lTime = System.nanoTime() - this.lTime;
            objectArray[0] = "SQL Error";
            this.gResult.setHead(objectArray);
            String string5 = sQLException.getMessage();
            string5 = string5 + " / Error Code: " + sQLException.getErrorCode();
            string5 = string5 + " / State: " + sQLException.getSQLState();
            objectArray[0] = string5;
            this.gResult.addRow(objectArray);
            return;
        }
        if (this.autoRefresh) {
            this.setStatusLine("Refreshing object tree", 0);
            String string6 = string.toUpperCase(Locale.ENGLISH);
            if (string6.contains("ALTER") || string6.contains("DROP") || string6.contains("CREATE")) {
                this.directRefreshTree();
            }
        }
    }

    private void updateResult() {
        if (this.gridFormat) {
            if (this.bHelp) {
                this.pResult.removeAll();
                this.pResult.add((Component)this.gScrollPane, "Center");
                this.pResult.doLayout();
                this.gResult.fireTableChanged(null);
                this.pResult.repaint();
                this.bHelp = false;
            }
        } else {
            this.showResultInText();
        }
        this.txtCommand.selectAll();
        this.txtCommand.requestFocus();
    }

    private void formatResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            Object[] objectArray = new String[]{"Result"};
            this.gResult.setHead(objectArray);
            objectArray[0] = "(empty)";
            this.gResult.addRow(objectArray);
            return;
        }
        try {
            int n;
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            Object[] objectArray = new Object[n2];
            boolean[] blArray = new boolean[n2];
            for (n = 1; n <= n2; ++n) {
                objectArray[n - 1] = resultSetMetaData.getColumnLabel(n);
                switch (resultSetMetaData.getColumnType(n)) {
                    case -3: 
                    case 1: 
                    case 12: {
                        blArray[n - 1] = true;
                    }
                }
            }
            this.gResult.setHead(objectArray);
            while (resultSet.next()) {
                for (n = 1; n <= n2; ++n) {
                    try {
                        objectArray[n - 1] = resultSet.getObject(n);
                        if (resultSet.wasNull()) {
                            objectArray[n - 1] = blArray[n - 1] ? NULL_STR : null;
                            continue;
                        }
                        if (resultSetMetaData.getColumnType(n) != -3 && resultSetMetaData.getColumnType(n) != -2) continue;
                        objectArray[n - 1] = resultSet.getString(n);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                this.gResult.addRow(objectArray);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
    }

    private void testPerformance() {
        int n;
        String string = this.txtCommand.getText();
        StringBuilder stringBuilder = new StringBuilder();
        long l = 0L;
        this.lTime = 0L;
        for (int i = 0; i < string.length(); ++i) {
            n = string.charAt(i);
            if (n == 10) continue;
            stringBuilder.append((char)n);
        }
        string = stringBuilder.toString();
        Object[] objectArray = new String[]{"ms", "count", "sql", "error"};
        this.gResult.setHead(objectArray);
        n = 1;
        this.lTime = System.nanoTime() - this.lTime;
        while (!string.isEmpty()) {
            String string2;
            int n2 = string.indexOf(59);
            if (n2 != -1) {
                string2 = string.substring(0, n2);
                string = string.substring(n2 + 1);
            } else {
                string2 = string;
                string = "";
            }
            if (string2.startsWith("--#")) {
                n = Integer.parseInt(string2.substring(3));
                continue;
            }
            if (string2.startsWith("--")) continue;
            objectArray[2] = string2;
            long l2 = 0L;
            try {
                l2 = DatabaseManagerCommon.testStatement(this.sStatement, string2, n);
                l += l2;
                objectArray[0] = "" + l2;
                objectArray[1] = "" + n;
                objectArray[3] = "";
            }
            catch (SQLException sQLException) {
                objectArray[1] = "n/a";
                objectArray[0] = "n/a";
                objectArray[3] = sQLException.toString();
                CommonSwing.errorMessage(sQLException);
            }
            this.gResult.addRow(objectArray);
            System.out.println(l2 + " ms : " + string2);
        }
        objectArray[0] = "" + l;
        objectArray[1] = "total";
        objectArray[2] = "";
        this.gResult.addRow(objectArray);
        this.lTime = System.nanoTime() - this.lTime;
    }

    private void showResultInText() {
        int n;
        Object[] objectArray;
        int n2;
        Object[] objectArray2 = this.gResult.getHead();
        int n3 = objectArray2.length;
        int[] nArray = new int[n3];
        ArrayList<Object[]> arrayList = this.gResult.getData();
        int n4 = arrayList.size();
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = objectArray2[n2].toString().length();
        }
        for (n2 = 0; n2 < n4; ++n2) {
            objectArray = arrayList.get(n2);
            for (n = 0; n < n3; ++n) {
                String string = objectArray[n] == null ? "" : objectArray[n].toString();
                int n5 = string.length();
                if (n5 <= nArray[n]) continue;
                nArray[n] = n5;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < n3; ++n) {
            stringBuilder.append(objectArray2[n]);
            for (int i = objectArray2[n].toString().length(); i <= nArray[n]; ++i) {
                stringBuilder.append(' ');
            }
        }
        stringBuilder.append(NL);
        for (n = 0; n < n3; ++n) {
            for (int i = 0; i < nArray[n]; ++i) {
                stringBuilder.append('-');
            }
            stringBuilder.append(' ');
        }
        stringBuilder.append(NL);
        for (n = 0; n < n4; ++n) {
            objectArray = arrayList.get(n);
            for (int i = 0; i < n3; ++i) {
                String string = objectArray[i] == null ? "" : objectArray[i].toString();
                stringBuilder.append(string);
                for (int j = string.length(); j <= nArray[i]; ++j) {
                    stringBuilder.append(' ');
                }
            }
            stringBuilder.append(NL);
        }
        this.txtResult.setText(stringBuilder.toString());
    }

    private void addToRecent(String string) {
        for (int i = 0; i < iMaxRecent; ++i) {
            if (!string.equals(this.sRecent[i])) continue;
            return;
        }
        if (this.sRecent[this.iRecent] != null) {
            this.mRecent.remove(this.iRecent);
        }
        this.sRecent[this.iRecent] = string;
        if (string.length() > 43) {
            string = string.substring(0, 40) + "...";
        }
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand("#" + this.iRecent);
        jMenuItem.addActionListener(this);
        this.mRecent.insert(jMenuItem, this.iRecent);
        this.iRecent = (this.iRecent + 1) % iMaxRecent;
    }

    @Override
    public final void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public final void mousePressed(MouseEvent mouseEvent) {
        if (this.alreadyHandled == mouseEvent) {
            return;
        }
        this.handlePopup(mouseEvent);
        this.alreadyHandled = mouseEvent;
    }

    @Override
    public final void mouseReleased(MouseEvent mouseEvent) {
        if (this.alreadyHandled == mouseEvent) {
            return;
        }
        this.handlePopup(mouseEvent);
        this.alreadyHandled = mouseEvent;
    }

    public final void handlePopup(MouseEvent mouseEvent) {
        if (!mouseEvent.isPopupTrigger()) {
            return;
        }
        Object object = mouseEvent.getSource();
        if (!(object instanceof JTree)) {
            return;
        }
        JTree jTree = (JTree)object;
        TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath == null) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        String[] stringArray = new String[]{"Select", "Delete", "Update", "Insert"};
        for (int i = 0; i < stringArray.length; ++i) {
            PopupListener popupListener = new PopupListener(stringArray[i], treePath);
            String string = popupListener.toString();
            if (string == null) {
                return;
            }
            if (string.length() > 40) {
                string = string.substring(0, 40) + "...";
            }
            JMenuItem jMenuItem = new JMenuItem(string);
            jMenuItem.addActionListener(popupListener);
            jPopupMenu.add(jMenuItem);
        }
        jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    private String quoteTableName(String string) {
        int n = string.indexOf(".");
        if (n < 0) {
            int n2 = string.indexOf(" (");
            if (n2 >= 0) {
                string = string.substring(0, n2);
            }
            return this.quoteObjectName(string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        int n3 = string3.indexOf(" (");
        if (n3 >= 0) {
            string3 = string3.substring(0, n3);
        }
        return this.quoteObjectName(string2) + '.' + this.quoteObjectName(string3);
    }

    private String quoteObjectName(String string) {
        return "\"" + string + "\"";
    }

    private void initGUI() {
        JPanel jPanel = new JPanel();
        this.pResult = new JPanel();
        this.nsSplitPane = new JSplitPane(0, jPanel, this.pResult);
        this.nsSplitPane.setOneTouchExpandable(true);
        jPanel.setLayout(new BorderLayout());
        this.pResult.setLayout(new BorderLayout());
        Font font = new Font("Dialog", 0, 12);
        this.txtCommand = new JTextArea(7, 40);
        this.txtCommand.setMargin(new Insets(5, 5, 5, 5));
        this.txtCommand.addKeyListener(this);
        this.txtCommandScroll = new JScrollPane(this.txtCommand);
        this.txtResult = new JTextArea(25, 40);
        this.txtResult.setMargin(new Insets(5, 5, 5, 5));
        this.txtResultScroll = new JScrollPane(this.txtResult);
        this.txtCommand.setFont(font);
        this.txtResult.setFont(new Font("Courier", 0, 12));
        jPanel.add((Component)this.txtCommandScroll, "Center");
        this.gResult = new GridSwing();
        TableSorter tableSorter = new TableSorter(this.gResult);
        this.tableModel = tableSorter;
        this.gResultTable = new JTable(tableSorter);
        tableSorter.setTableHeader(this.gResultTable.getTableHeader());
        this.gScrollPane = new JScrollPane(this.gResultTable);
        this.gResultTable.setAutoResizeMode(0);
        this.gResult.setJTable(this.gResultTable);
        this.pResult.add((Component)this.gScrollPane, "Center");
        this.rootNode = new DefaultMutableTreeNode("Connection");
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tTree = new JTree(this.treeModel);
        this.tScrollPane = new JScrollPane(this.tTree);
        this.tTree.addMouseListener(this);
        this.tScrollPane.setPreferredSize(new Dimension(200, 400));
        this.tScrollPane.setMinimumSize(new Dimension(70, 100));
        this.txtCommandScroll.setPreferredSize(new Dimension(560, 100));
        this.txtCommandScroll.setMinimumSize(new Dimension(180, 100));
        this.gScrollPane.setPreferredSize(new Dimension(460, 300));
        this.ewSplitPane = new JSplitPane(1, this.tScrollPane, this.nsSplitPane);
        this.ewSplitPane.setOneTouchExpandable(true);
        this.fMain.getContentPane().add((Component)this.ewSplitPane, "Center");
        this.jStatusLine = new JLabel();
        iReadyStatus = new JButton(new ImageIcon(CommonSwing.getIcon("StatusReady")));
        iReadyStatus.setSelectedIcon(new ImageIcon(CommonSwing.getIcon("StatusRunning")));
        this.pStatus = new JPanel();
        this.pStatus.setLayout(new BorderLayout());
        this.pStatus.add((Component)iReadyStatus, "West");
        this.pStatus.add((Component)this.jStatusLine, "Center");
        this.fMain.getContentPane().add((Component)this.pStatus, "South");
        this.doLayout();
        if (this.fMain instanceof Window) {
            ((Window)((Object)this.fMain)).pack();
        } else {
            ((Container)((Object)this.fMain)).validate();
        }
    }

    private DefaultMutableTreeNode makeNode(Object object, MutableTreeNode mutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(object);
        if (mutableTreeNode != null) {
            this.treeModel.insertNodeInto(defaultMutableTreeNode, mutableTreeNode, mutableTreeNode.getChildCount());
        }
        return defaultMutableTreeNode;
    }

    protected void refreshTree() {
        this.backgroundIt(this.treeRefreshRunnable, "Refreshing object tree");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void directRefreshTree() {
        Object object;
        DecimalFormat decimalFormat = new DecimalFormat(" ( ####,###,####,##0 )");
        while (this.treeModel.getChildCount(this.rootNode) > 0) {
            object = (DefaultMutableTreeNode)this.treeModel.getChild(this.rootNode, 0);
            this.treeModel.removeNodeFromParent((MutableTreeNode)object);
            ((DefaultMutableTreeNode)object).removeAllChildren();
            ((DefaultMutableTreeNode)object).removeFromParent();
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
        this.treeModel.reload();
        this.tScrollPane.repaint();
        if (this.dMeta == null) {
            return;
        }
        object = null;
        try {
            String string;
            this.rootNode.setUserObject(this.dMeta.getURL());
            object = this.dMeta.getTables(null, null, null, this.showSys ? usertables : nonSystables);
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            while (object.next()) {
                string = object.getString(2);
                if (!this.showSys && this.isOracle && oracleSysUsers.contains(string) || this.schemaFilter != null && !string.equals(this.schemaFilter)) continue;
                arrayList2.add(string);
                arrayList.add(object.getString(3));
                arrayList3.add(object.getString(5));
            }
            object.close();
            object = null;
            int[] nArray = new int[arrayList.size()];
            try {
                nArray = this.getRowCounts(arrayList, arrayList2);
            }
            catch (Exception exception) {
                CommonSwing.errorMessage(exception);
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                Object object2;
                Object object3;
                DefaultMutableTreeNode defaultMutableTreeNode;
                Object object4;
                Object object5;
                Object object6;
                String string2;
                ResultSet resultSet = null;
                try {
                    string2 = (String)arrayList.get(i);
                    if (this.isOracle && string2.startsWith("BIN$")) continue;
                    string = (String)arrayList2.get(i);
                    object6 = "";
                    if (string != null && this.showSchemas) {
                        object6 = string + '.';
                    }
                    object5 = this.displayRowCounts ? decimalFormat.format(nArray[i]) : "";
                    object4 = (String)object6 + string2 + (String)object5;
                    defaultMutableTreeNode = this.makeNode(object4, this.rootNode);
                    resultSet = this.dMeta.getColumns(null, string, string2, null);
                    if (string != null && !string.trim().isEmpty()) {
                        this.makeNode(string, defaultMutableTreeNode);
                    }
                    if ((object3 = (String)arrayList3.get(i)) != null && !((String)object3).trim().isEmpty()) {
                        this.makeNode(object3, defaultMutableTreeNode);
                    }
                    while (resultSet.next()) {
                        String string3 = resultSet.getString(4);
                        object2 = this.makeNode(string3, defaultMutableTreeNode);
                        String string4 = resultSet.getString(6);
                        this.makeNode("Type: " + string4, (MutableTreeNode)object2);
                        boolean bl = resultSet.getInt(11) != 0;
                        this.makeNode("Nullable: " + bl, (MutableTreeNode)object2);
                    }
                }
                finally {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
                object6 = this.makeNode("Indices", defaultMutableTreeNode);
                if (!this.showIndexDetails) continue;
                object5 = null;
                try {
                    object5 = this.dMeta.getIndexInfo(null, string, string2, false, false);
                    object4 = null;
                    object3 = null;
                    while (object5.next()) {
                        boolean bl = object5.getBoolean(4);
                        object2 = object5.getString(6);
                        if (object4 == null || !((String)object4).equals(object2)) {
                            object3 = this.makeNode(object2, (MutableTreeNode)object6);
                            this.makeNode("Unique: " + !bl, (MutableTreeNode)object3);
                            object4 = object2;
                        }
                        this.makeNode(object5.getString(9), (MutableTreeNode)object3);
                    }
                    continue;
                }
                catch (SQLException sQLException) {
                    if (sQLException.getMessage() != null && (sQLException.getMessage().startsWith("ORA-25191:") || sQLException.getMessage().startsWith("ORA-01702:") || sQLException.getMessage().startsWith("ORA-01031:"))) continue;
                    throw sQLException;
                }
                finally {
                    if (object5 != null) {
                        object5.close();
                    }
                }
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.makeNode("Properties", this.rootNode);
            this.makeNode("User: " + this.dMeta.getUserName(), defaultMutableTreeNode);
            this.makeNode("ReadOnly: " + this.cConn.isReadOnly(), defaultMutableTreeNode);
            this.makeNode("AutoCommit: " + this.cConn.getAutoCommit(), defaultMutableTreeNode);
            this.makeNode("Driver: " + this.dMeta.getDriverName(), defaultMutableTreeNode);
            this.makeNode("Product: " + this.dMeta.getDatabaseProductName(), defaultMutableTreeNode);
            this.makeNode("Version: " + this.dMeta.getDatabaseProductVersion(), defaultMutableTreeNode);
        }
        catch (SQLException sQLException) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.makeNode("Error getting metadata:", this.rootNode);
            this.makeNode(sQLException.getMessage(), defaultMutableTreeNode);
            this.makeNode(sQLException.getSQLState(), defaultMutableTreeNode);
            CommonSwing.errorMessage(sQLException);
        }
        finally {
            if (object != null) {
                try {
                    object.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        this.treeModel.nodeStructureChanged(this.rootNode);
        this.treeModel.reload();
        this.tScrollPane.repaint();
        this.updateSchemaList();
    }

    void setStatusLine(String string, int n) {
        iReadyStatus.setSelected(string != null);
        if (string == null) {
            String string2 = "";
            if (this.schemaFilter != null) {
                string2 = " /  Tree showing objects in schema '" + this.schemaFilter + "'";
            }
            long l = this.lTime / 1000000L;
            long l2 = this.lTime % 1000000L / 100000L;
            string2 = string2 + " / " + n + " rows retrieved in " + l + '.' + l2 + " ms";
            this.jStatusLine.setText("  " + READY_STATUS + string2);
        } else {
            this.jStatusLine.setText("  " + string + "...");
        }
    }

    protected int[] getRowCounts(ArrayList arrayList, ArrayList arrayList2) {
        if (!this.displayRowCounts) {
            return null;
        }
        String string = "SELECT COUNT(*) FROM ";
        int[] nArray = new int[arrayList.size()];
        try {
            Statement statement = this.rowConn.createStatement();
            for (int i = 0; i < arrayList.size(); ++i) {
                try {
                    String string2 = (String)arrayList2.get(i);
                    string2 = string2 == null ? "" : "\"" + string2 + "\".\"";
                    String string3 = string2 + arrayList.get(i) + "\"";
                    ResultSet resultSet = statement.executeQuery(string + string3);
                    while (resultSet.next()) {
                        nArray[i] = resultSet.getInt(1);
                    }
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("Unable to get row count for table " + arrayList2.get(i) + '.' + arrayList.get(i) + ".  Using value '0': " + exception);
                }
            }
        }
        catch (Exception exception) {
            CommonSwing.errorMessage(exception);
        }
        return nArray;
    }

    protected JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.jbuttonClear = new JButton("Clear SQL", new ImageIcon(CommonSwing.getIcon("Clear")));
        this.jbuttonClear.putClientProperty("is3DEnabled", Boolean.TRUE);
        this.tipMap.put(this.jbuttonClear, "Clear SQL");
        this.jbuttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (DatabaseManagerSwing.this.sqlScriptBuffer == null && DatabaseManagerSwing.this.txtCommand.getText().isEmpty()) {
                    CommonSwing.errorMessage("No SQL to clear");
                    return;
                }
                DatabaseManagerSwing.this.clear();
            }
        });
        this.jbuttonExecute = new JButton("Execute SQL", new ImageIcon(CommonSwing.getIcon("Execute")));
        this.tipMap.put(this.jbuttonExecute, "Execute SQL");
        this.jbuttonExecute.putClientProperty("is3DEnabled", Boolean.TRUE);
        this.jbuttonExecute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseManagerSwing.this.executeCurrentSQL();
            }
        });
        jToolBar.addSeparator();
        jToolBar.add(this.jbuttonClear);
        jToolBar.addSeparator();
        jToolBar.add(this.jbuttonExecute);
        jToolBar.addSeparator();
        this.jbuttonClear.setAlignmentY(0.5f);
        this.jbuttonClear.setAlignmentX(0.5f);
        this.jbuttonExecute.setAlignmentY(0.5f);
        this.jbuttonExecute.setAlignmentX(0.5f);
        return jToolBar;
    }

    void updateAutoCommitBox() {
        try {
            if (this.cConn != null) {
                this.boxAutoCommit.setSelected(this.cConn.getAutoCommit());
            }
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
    }

    private void setLF(String string) {
        if (this.currentLAF != null && this.currentLAF == string) {
            return;
        }
        if (this.pResult != null && this.gridFormat) {
            this.pResult.removeAll();
        }
        CommonSwing.setSwingLAF((Component)((Object)this.fMain), string);
        if (this.pResult != null && this.gridFormat) {
            this.setResultsInGrid();
        }
        this.currentLAF = string;
        if (this.currentLAF.equals("Native")) {
            this.rbNativeLF.setSelected(true);
        } else if (this.currentLAF.equals("Java")) {
            this.rbJavaLF.setSelected(true);
        } else if (this.currentLAF.equals("Motif")) {
            this.rbMotifLF.setSelected(true);
        }
    }

    void resetTooltips() {
        for (JComponent jComponent : this.tipMap.keySet()) {
            jComponent.setToolTipText(this.showTooltips ? this.tipMap.get(jComponent) : null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSchemaList() {
        ButtonGroup buttonGroup = new ButtonGroup();
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSet resultSet = null;
        try {
            resultSet = this.dMeta.getSchemas();
            if (resultSet == null) {
                throw new SQLException("Failed to get metadata from database");
            }
            while (resultSet.next()) {
                arrayList.add(resultSet.getString(1));
            }
        }
        catch (SQLException sQLException) {
            CommonSwing.errorMessage(sQLException);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        this.mnuSchemas.removeAll();
        this.rbAllSchemas.setSelected(this.schemaFilter == null);
        buttonGroup.add(this.rbAllSchemas);
        this.mnuSchemas.add(this.rbAllSchemas);
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(string);
            buttonGroup.add(jRadioButtonMenuItem);
            this.mnuSchemas.add(jRadioButtonMenuItem);
            jRadioButtonMenuItem.setSelected(this.schemaFilter != null && this.schemaFilter.equals(string));
            jRadioButtonMenuItem.addActionListener(this.schemaListListener);
            jRadioButtonMenuItem.setEnabled(arrayList.size() > 1);
        }
        this.mnuSchemas.addSeparator();
        this.mnuSchemas.add(this.mitemUpdateSchemas);
    }

    private static void setLogToSystem(boolean bl) {
        try {
            PrintWriter printWriter = bl ? new PrintWriter(System.out) : null;
            DriverManager.setLogWriter(printWriter);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            Class.forName(DatabaseManagerSwing.class.getPackage().getName() + ".Transfer");
            TT_AVAILABLE = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        HELP_TEXT = "See the HSQLDB Utilities Guide, forums and mailing lists \nat http://hsqldb.org.\n\nPlease paste the following version identifier with any\nproblem reports or help requests:  $Revision: 6721 $" + (TT_AVAILABLE ? "" : "\n\nTransferTool classes are not in CLASSPATH.\nTo enable the Tools menu, add 'transfer.jar' to your class path.");
        ABOUT_TEXT = "$Revision: 6721 $ of DatabaseManagerSwing\n\nCopyright c 2001-2024, The HSQL Development Group.\nhttp://hsqldb.org  (Utilities Guide available at this site).\n\n\nYou may use and redistribute according to the HSQLDB\nlicense documented in the source code and at the web\nsite above." + (TT_AVAILABLE ? "\n\nTransferTool options are available." : "");
        NL = System.getProperty("line.separator");
        iMaxRecent = 24;
        READY_STATUS = "Ready";
        usertables = new String[]{"TABLE", "GLOBAL TEMPORARY", "VIEW", "SYSTEM TABLE"};
        nonSystables = new String[]{"TABLE", "GLOBAL TEMPORARY", "VIEW"};
        oracleSysUsers = new HashSet();
        oracleSysSchemas = new String[]{"SYS", "SYSTEM", "OUTLN", "DBSNMP", "OUTLN", "MDSYS", "ORDSYS", "ORDPLUGINS", "CTXSYS", "DSSYS", "PERFSTAT", "WKPROXY", "WKSYS", "WMSYS", "XDB", "ANONYMOUS", "ODM", "ODM_MTR", "OLAPSYS", "TRACESVR", "REPADMIN"};
        Collections.addAll(oracleSysUsers, oracleSysSchemas);
        tString = Boolean.TRUE.toString();
        fString = Boolean.FALSE.toString();
    }

    public static class DBMPrefs {
        public File prefsFile = null;
        boolean autoRefresh = true;
        boolean showRowCounts = false;
        boolean showSysTables = false;
        boolean showSchemas = true;
        boolean resultGrid = true;
        String laf = "Native";
        boolean showTooltips = true;

        public DBMPrefs(boolean bl) throws IOException {
            if (!bl) {
                if (homedir == null) {
                    throw new IOException("Skipping preferences since do not know home dir");
                }
                this.prefsFile = new File(homedir, "dbmprefs.properties");
            }
            this.load();
        }

        public void load() throws IOException {
            if (this.prefsFile != null) {
                if (!this.prefsFile.exists()) {
                    throw new IOException("No such file: " + this.prefsFile);
                }
                Properties properties = new Properties();
                try {
                    FileInputStream fileInputStream = new FileInputStream(this.prefsFile);
                    properties.load(fileInputStream);
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    throw new IOException("Failed to read preferences file '" + this.prefsFile + "':  " + iOException.getMessage(), iOException);
                }
                String string = properties.getProperty("autoRefresh");
                if (string != null) {
                    this.autoRefresh = Boolean.valueOf(string);
                }
                if ((string = properties.getProperty("showRowCounts")) != null) {
                    this.showRowCounts = Boolean.valueOf(string);
                }
                if ((string = properties.getProperty("showSysTables")) != null) {
                    this.showSysTables = Boolean.valueOf(string);
                }
                if ((string = properties.getProperty("showSchemas")) != null) {
                    this.showSchemas = Boolean.valueOf(string);
                }
                if ((string = properties.getProperty("resultGrid")) != null) {
                    this.resultGrid = Boolean.valueOf(string);
                }
                this.laf = (string = properties.getProperty("laf")) == null ? "Native" : string;
                string = properties.getProperty("showTooltips");
                if (string != null) {
                    this.showTooltips = Boolean.valueOf(string);
                }
            }
        }

        public void store() {
            if (this.prefsFile == null) {
                return;
            }
            Properties properties = new Properties();
            properties.setProperty("autoRefresh", this.autoRefresh ? tString : fString);
            properties.setProperty("showRowCounts", this.showRowCounts ? tString : fString);
            properties.setProperty("showSysTables", this.showSysTables ? tString : fString);
            properties.setProperty("showSchemas", this.showSchemas ? tString : fString);
            properties.setProperty("resultGrid", this.resultGrid ? tString : fString);
            properties.setProperty("laf", this.laf);
            properties.setProperty("showTooltips", this.showTooltips ? tString : fString);
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.prefsFile);
                properties.store(fileOutputStream, "DatabaseManagerSwing user preferences");
                fileOutputStream.flush();
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to prepare preferences file '" + this.prefsFile + "':  " + iOException.getMessage());
            }
        }
    }

    private class PopupListener
    implements ActionListener {
        public static final int DEPTH_URL = 1;
        public static final int DEPTH_TABLE = 2;
        public static final int DEPTH_COLUMN = 3;
        String command;
        TreePath treePath;
        TreePath tablePath;
        TreePath columnPath;
        String table = null;
        String column = null;

        PopupListener(String string, TreePath treePath) {
            this.command = string;
            this.treePath = treePath;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DatabaseManagerSwing.this.txtCommand.setText(this.getCommandString());
        }

        public String toString() {
            return this.getCommandString();
        }

        public String getCommandString() {
            int n = this.treePath.getPathCount();
            if (n == 1) {
                return "";
            }
            if (n == 2) {
                this.tablePath = this.treePath;
                this.table = this.treePath.getPathComponent(1).toString();
            }
            if (n == 3) {
                this.tablePath = this.treePath.getParentPath();
                this.table = this.treePath.getPathComponent(1).toString();
                this.columnPath = this.treePath;
                this.column = this.treePath.getPathComponent(2).toString();
            }
            if (this.command.equalsIgnoreCase("SELECT")) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                String string = "SELECT * FROM " + DatabaseManagerSwing.this.quoteTableName(this.table);
                if (this.column != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)this.treePath.getLastPathComponent()).getChildCount() > 0) {
                    String string2 = defaultMutableTreeNode.getFirstChild().toString();
                    boolean bl = string2.contains("CHAR");
                    string = string + " WHERE " + DatabaseManagerSwing.this.quoteObjectName(this.column);
                    string = bl ? string + " LIKE '%%'" : string + " = ";
                }
                return string;
            }
            if (this.command.equalsIgnoreCase("UPDATE")) {
                String string = "UPDATE " + DatabaseManagerSwing.this.quoteTableName(this.table) + " SET ";
                if (this.column != null) {
                    string = string + DatabaseManagerSwing.this.quoteObjectName(this.column) + " = ";
                }
                return string;
            }
            if (this.command.equalsIgnoreCase("DELETE")) {
                DefaultMutableTreeNode defaultMutableTreeNode;
                String string = "DELETE FROM " + DatabaseManagerSwing.this.quoteTableName(this.table);
                if (this.column != null && (defaultMutableTreeNode = (DefaultMutableTreeNode)this.treePath.getLastPathComponent()).getChildCount() > 0) {
                    String string3 = defaultMutableTreeNode.getFirstChild().toString();
                    boolean bl = string3.contains("CHAR");
                    string = string + " WHERE " + DatabaseManagerSwing.this.quoteObjectName(this.column);
                    string = bl ? string + " LIKE '%%'" : string + " = ";
                }
                return string;
            }
            if (this.command.equalsIgnoreCase("INSERT")) {
                String string = "";
                String string4 = " ";
                String string5 = "";
                if (this.tablePath == null) {
                    return null;
                }
                TreeNode treeNode = (TreeNode)this.tablePath.getLastPathComponent();
                Enumeration<? extends TreeNode> enumeration = treeNode.children();
                while (enumeration.hasMoreElements()) {
                    DefaultMutableTreeNode defaultMutableTreeNode;
                    TreeNode treeNode2 = enumeration.nextElement();
                    if (treeNode2.toString().equals("Indices") || (defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode2).getChildCount() == 0) continue;
                    String string6 = defaultMutableTreeNode.getFirstChild().toString();
                    String string7 = string6.contains("CHAR") ? "''" : "";
                    string = string + string5 + DatabaseManagerSwing.this.quoteObjectName(treeNode2.toString());
                    string4 = string4 + string5 + string7;
                    string5 = ", ";
                }
                return "INSERT INTO " + DatabaseManagerSwing.this.quoteTableName(this.table) + "\n( " + string + " )\nVALUES (" + string4 + ")";
            }
            return "Got here in error " + this.command + ".  Should never happen";
        }
    }

    protected class StatementExecRunnable
    implements Runnable {
        protected StatementExecRunnable() {
        }

        @Override
        public void run() {
            DatabaseManagerSwing.this.gResult.clear();
            try {
                if (DatabaseManagerSwing.this.txtCommand.getText().startsWith("-->>>TEST<<<--")) {
                    DatabaseManagerSwing.this.testPerformance();
                } else {
                    DatabaseManagerSwing.this.executeSQL();
                }
                DatabaseManagerSwing.this.updateResult();
                DatabaseManagerSwing.this.displayResults();
                DatabaseManagerSwing.this.updateAutoCommitBox();
            }
            catch (RuntimeException runtimeException) {
                CommonSwing.errorMessage(runtimeException);
                throw runtimeException;
            }
            finally {
                DatabaseManagerSwing.this.setWaiting(null);
            }
        }
    }
}

