// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
pub use crate::operation::list_languages::_list_languages_output::ListLanguagesOutputBuilder;

pub use crate::operation::list_languages::_list_languages_input::ListLanguagesInputBuilder;

impl crate::operation::list_languages::builders::ListLanguagesInputBuilder {
    /// Sends a request with this input using the given client.
    pub async fn send_with(
        self,
        client: &crate::Client,
    ) -> ::std::result::Result<
        crate::operation::list_languages::ListLanguagesOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_languages::ListLanguagesError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let mut fluent_builder = client.list_languages();
        fluent_builder.inner = self;
        fluent_builder.send().await
    }
}
/// Fluent builder constructing a request to `ListLanguages`.
///
/// <p>Provides a list of languages (RFC-5646 codes and names) that Amazon Translate supports.</p>
#[derive(::std::clone::Clone, ::std::fmt::Debug)]
pub struct ListLanguagesFluentBuilder {
    handle: ::std::sync::Arc<crate::client::Handle>,
    inner: crate::operation::list_languages::builders::ListLanguagesInputBuilder,
    config_override: ::std::option::Option<crate::config::Builder>,
}
impl
    crate::client::customize::internal::CustomizableSend<
        crate::operation::list_languages::ListLanguagesOutput,
        crate::operation::list_languages::ListLanguagesError,
    > for ListLanguagesFluentBuilder
{
    fn send(
        self,
        config_override: crate::config::Builder,
    ) -> crate::client::customize::internal::BoxFuture<
        crate::client::customize::internal::SendResult<
            crate::operation::list_languages::ListLanguagesOutput,
            crate::operation::list_languages::ListLanguagesError,
        >,
    > {
        ::std::boxed::Box::pin(async move { self.config_override(config_override).send().await })
    }
}
impl ListLanguagesFluentBuilder {
    /// Creates a new `ListLanguagesFluentBuilder`.
    pub(crate) fn new(handle: ::std::sync::Arc<crate::client::Handle>) -> Self {
        Self {
            handle,
            inner: ::std::default::Default::default(),
            config_override: ::std::option::Option::None,
        }
    }
    /// Access the ListLanguages as a reference.
    pub fn as_input(&self) -> &crate::operation::list_languages::builders::ListLanguagesInputBuilder {
        &self.inner
    }
    /// Sends the request and returns the response.
    ///
    /// If an error occurs, an `SdkError` will be returned with additional details that
    /// can be matched against.
    ///
    /// By default, any retryable failures will be retried twice. Retry behavior
    /// is configurable with the [RetryConfig](aws_smithy_types::retry::RetryConfig), which can be
    /// set when configuring the client.
    pub async fn send(
        self,
    ) -> ::std::result::Result<
        crate::operation::list_languages::ListLanguagesOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::list_languages::ListLanguagesError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = self
            .inner
            .build()
            .map_err(::aws_smithy_runtime_api::client::result::SdkError::construction_failure)?;
        let runtime_plugins = crate::operation::list_languages::ListLanguages::operation_runtime_plugins(
            self.handle.runtime_plugins.clone(),
            &self.handle.conf,
            self.config_override,
        );
        crate::operation::list_languages::ListLanguages::orchestrate(&runtime_plugins, input).await
    }

    /// Consumes this builder, creating a customizable operation that can be modified before being sent.
    pub fn customize(
        self,
    ) -> crate::client::customize::CustomizableOperation<
        crate::operation::list_languages::ListLanguagesOutput,
        crate::operation::list_languages::ListLanguagesError,
        Self,
    > {
        crate::client::customize::CustomizableOperation::new(self)
    }
    pub(crate) fn config_override(mut self, config_override: impl ::std::convert::Into<crate::config::Builder>) -> Self {
        self.set_config_override(::std::option::Option::Some(config_override.into()));
        self
    }

    pub(crate) fn set_config_override(&mut self, config_override: ::std::option::Option<crate::config::Builder>) -> &mut Self {
        self.config_override = config_override;
        self
    }
    /// Create a paginator for this request
    ///
    /// Paginators are used by calling [`send().await`](crate::operation::list_languages::paginator::ListLanguagesPaginator::send) which returns a [`PaginationStream`](aws_smithy_async::future::pagination_stream::PaginationStream).
    pub fn into_paginator(self) -> crate::operation::list_languages::paginator::ListLanguagesPaginator {
        crate::operation::list_languages::paginator::ListLanguagesPaginator::new(self.handle, self.inner)
    }
    /// <p>The language code for the language to use to display the language names in the response. The language code is <code>en</code> by default.</p>
    pub fn display_language_code(mut self, input: crate::types::DisplayLanguageCode) -> Self {
        self.inner = self.inner.display_language_code(input);
        self
    }
    /// <p>The language code for the language to use to display the language names in the response. The language code is <code>en</code> by default.</p>
    pub fn set_display_language_code(mut self, input: ::std::option::Option<crate::types::DisplayLanguageCode>) -> Self {
        self.inner = self.inner.set_display_language_code(input);
        self
    }
    /// <p>The language code for the language to use to display the language names in the response. The language code is <code>en</code> by default.</p>
    pub fn get_display_language_code(&self) -> &::std::option::Option<crate::types::DisplayLanguageCode> {
        self.inner.get_display_language_code()
    }
    /// <p>Include the NextToken value to fetch the next group of supported languages.</p>
    pub fn next_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.inner = self.inner.next_token(input.into());
        self
    }
    /// <p>Include the NextToken value to fetch the next group of supported languages.</p>
    pub fn set_next_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.inner = self.inner.set_next_token(input);
        self
    }
    /// <p>Include the NextToken value to fetch the next group of supported languages.</p>
    pub fn get_next_token(&self) -> &::std::option::Option<::std::string::String> {
        self.inner.get_next_token()
    }
    /// <p>The maximum number of results to return in each response.</p>
    pub fn max_results(mut self, input: i32) -> Self {
        self.inner = self.inner.max_results(input);
        self
    }
    /// <p>The maximum number of results to return in each response.</p>
    pub fn set_max_results(mut self, input: ::std::option::Option<i32>) -> Self {
        self.inner = self.inner.set_max_results(input);
        self
    }
    /// <p>The maximum number of results to return in each response.</p>
    pub fn get_max_results(&self) -> &::std::option::Option<i32> {
        self.inner.get_max_results()
    }
}
