// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Contains entities identified as personally identifiable information (PII) in your transcription output, along with various associated attributes. Examples include category, confidence score, type, stability score, and start and end times.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct Entity {
    /// <p>The start time, in milliseconds, of the utterance that was identified as PII.</p>
    pub start_time: f64,
    /// <p>The end time, in milliseconds, of the utterance that was identified as PII.</p>
    pub end_time: f64,
    /// <p>The category of information identified. The only category is <code>PII</code>.</p>
    pub category: ::std::option::Option<::std::string::String>,
    /// <p>The type of PII identified. For example, <code>NAME</code> or <code>CREDIT_DEBIT_NUMBER</code>.</p>
    pub r#type: ::std::option::Option<::std::string::String>,
    /// <p>The word or words identified as PII.</p>
    pub content: ::std::option::Option<::std::string::String>,
    /// <p>The confidence score associated with the identified PII entity in your audio.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified entity correctly matches the entity spoken in your media.</p>
    pub confidence: ::std::option::Option<f64>,
}
impl Entity {
    /// <p>The start time, in milliseconds, of the utterance that was identified as PII.</p>
    pub fn start_time(&self) -> f64 {
        self.start_time
    }
    /// <p>The end time, in milliseconds, of the utterance that was identified as PII.</p>
    pub fn end_time(&self) -> f64 {
        self.end_time
    }
    /// <p>The category of information identified. The only category is <code>PII</code>.</p>
    pub fn category(&self) -> ::std::option::Option<&str> {
        self.category.as_deref()
    }
    /// <p>The type of PII identified. For example, <code>NAME</code> or <code>CREDIT_DEBIT_NUMBER</code>.</p>
    pub fn r#type(&self) -> ::std::option::Option<&str> {
        self.r#type.as_deref()
    }
    /// <p>The word or words identified as PII.</p>
    pub fn content(&self) -> ::std::option::Option<&str> {
        self.content.as_deref()
    }
    /// <p>The confidence score associated with the identified PII entity in your audio.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified entity correctly matches the entity spoken in your media.</p>
    pub fn confidence(&self) -> ::std::option::Option<f64> {
        self.confidence
    }
}
impl Entity {
    /// Creates a new builder-style object to manufacture [`Entity`](crate::types::Entity).
    pub fn builder() -> crate::types::builders::EntityBuilder {
        crate::types::builders::EntityBuilder::default()
    }
}

/// A builder for [`Entity`](crate::types::Entity).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct EntityBuilder {
    pub(crate) start_time: ::std::option::Option<f64>,
    pub(crate) end_time: ::std::option::Option<f64>,
    pub(crate) category: ::std::option::Option<::std::string::String>,
    pub(crate) r#type: ::std::option::Option<::std::string::String>,
    pub(crate) content: ::std::option::Option<::std::string::String>,
    pub(crate) confidence: ::std::option::Option<f64>,
}
impl EntityBuilder {
    /// <p>The start time, in milliseconds, of the utterance that was identified as PII.</p>
    pub fn start_time(mut self, input: f64) -> Self {
        self.start_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The start time, in milliseconds, of the utterance that was identified as PII.</p>
    pub fn set_start_time(mut self, input: ::std::option::Option<f64>) -> Self {
        self.start_time = input;
        self
    }
    /// <p>The start time, in milliseconds, of the utterance that was identified as PII.</p>
    pub fn get_start_time(&self) -> &::std::option::Option<f64> {
        &self.start_time
    }
    /// <p>The end time, in milliseconds, of the utterance that was identified as PII.</p>
    pub fn end_time(mut self, input: f64) -> Self {
        self.end_time = ::std::option::Option::Some(input);
        self
    }
    /// <p>The end time, in milliseconds, of the utterance that was identified as PII.</p>
    pub fn set_end_time(mut self, input: ::std::option::Option<f64>) -> Self {
        self.end_time = input;
        self
    }
    /// <p>The end time, in milliseconds, of the utterance that was identified as PII.</p>
    pub fn get_end_time(&self) -> &::std::option::Option<f64> {
        &self.end_time
    }
    /// <p>The category of information identified. The only category is <code>PII</code>.</p>
    pub fn category(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.category = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The category of information identified. The only category is <code>PII</code>.</p>
    pub fn set_category(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.category = input;
        self
    }
    /// <p>The category of information identified. The only category is <code>PII</code>.</p>
    pub fn get_category(&self) -> &::std::option::Option<::std::string::String> {
        &self.category
    }
    /// <p>The type of PII identified. For example, <code>NAME</code> or <code>CREDIT_DEBIT_NUMBER</code>.</p>
    pub fn r#type(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.r#type = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The type of PII identified. For example, <code>NAME</code> or <code>CREDIT_DEBIT_NUMBER</code>.</p>
    pub fn set_type(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.r#type = input;
        self
    }
    /// <p>The type of PII identified. For example, <code>NAME</code> or <code>CREDIT_DEBIT_NUMBER</code>.</p>
    pub fn get_type(&self) -> &::std::option::Option<::std::string::String> {
        &self.r#type
    }
    /// <p>The word or words identified as PII.</p>
    pub fn content(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The word or words identified as PII.</p>
    pub fn set_content(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content = input;
        self
    }
    /// <p>The word or words identified as PII.</p>
    pub fn get_content(&self) -> &::std::option::Option<::std::string::String> {
        &self.content
    }
    /// <p>The confidence score associated with the identified PII entity in your audio.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified entity correctly matches the entity spoken in your media.</p>
    pub fn confidence(mut self, input: f64) -> Self {
        self.confidence = ::std::option::Option::Some(input);
        self
    }
    /// <p>The confidence score associated with the identified PII entity in your audio.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified entity correctly matches the entity spoken in your media.</p>
    pub fn set_confidence(mut self, input: ::std::option::Option<f64>) -> Self {
        self.confidence = input;
        self
    }
    /// <p>The confidence score associated with the identified PII entity in your audio.</p>
    /// <p>Confidence scores are values between 0 and 1. A larger value indicates a higher probability that the identified entity correctly matches the entity spoken in your media.</p>
    pub fn get_confidence(&self) -> &::std::option::Option<f64> {
        &self.confidence
    }
    /// Consumes the builder and constructs a [`Entity`](crate::types::Entity).
    pub fn build(self) -> crate::types::Entity {
        crate::types::Entity {
            start_time: self.start_time.unwrap_or_default(),
            end_time: self.end_time.unwrap_or_default(),
            category: self.category,
            r#type: self.r#type,
            content: self.content,
            confidence: self.confidence,
        }
    }
}
