// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>An encoded stream of audio blobs. Audio streams are encoded as either HTTP/2 or WebSocket data frames.</p>
/// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html">Transcribing streaming audio</a>.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub enum AudioStream {
    /// <p>A blob of audio from your application. Your audio stream consists of one or more audio events.</p>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/event-stream.html">Event stream encoding</a>.</p>
    AudioEvent(crate::types::AudioEvent),
    /// <p>Contains audio channel definitions and post-call analytics settings.</p>
    ConfigurationEvent(crate::types::ConfigurationEvent),
    /// The `Unknown` variant represents cases where new union variant was received. Consider upgrading the SDK to the latest available version.
    /// An unknown enum variant
    ///
    /// _Note: If you encounter this error, consider upgrading your SDK to the latest version._
    /// The `Unknown` variant represents cases where the server sent a value that wasn't recognized
    /// by the client. This can happen when the server adds new functionality, but the client has not been updated.
    /// To investigate this, consider turning on debug logging to print the raw HTTP response.
    #[non_exhaustive]
    Unknown,
}
impl AudioStream {
    /// Tries to convert the enum instance into [`AudioEvent`](crate::types::AudioStream::AudioEvent), extracting the inner [`AudioEvent`](crate::types::AudioEvent).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_audio_event(&self) -> ::std::result::Result<&crate::types::AudioEvent, &Self> {
        if let AudioStream::AudioEvent(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`AudioEvent`](crate::types::AudioStream::AudioEvent).
    pub fn is_audio_event(&self) -> bool {
        self.as_audio_event().is_ok()
    }
    /// Tries to convert the enum instance into [`ConfigurationEvent`](crate::types::AudioStream::ConfigurationEvent), extracting the inner [`ConfigurationEvent`](crate::types::ConfigurationEvent).
    /// Returns `Err(&Self)` if it can't be converted.
    pub fn as_configuration_event(&self) -> ::std::result::Result<&crate::types::ConfigurationEvent, &Self> {
        if let AudioStream::ConfigurationEvent(val) = &self {
            ::std::result::Result::Ok(val)
        } else {
            ::std::result::Result::Err(self)
        }
    }
    /// Returns true if this is a [`ConfigurationEvent`](crate::types::AudioStream::ConfigurationEvent).
    pub fn is_configuration_event(&self) -> bool {
        self.as_configuration_event().is_ok()
    }
    /// Returns true if the enum instance is the `Unknown` variant.
    pub fn is_unknown(&self) -> bool {
        matches!(self, Self::Unknown)
    }
}
