// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`StartStreamTranscription`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`language_code(LanguageCode)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_language_code):<br>required: **false**<br><p>Specify the language code that represents the language spoken in your audio.</p> <p>If you're unsure of the language spoken in your audio, consider using <code>IdentifyLanguage</code> to enable automatic language identification.</p> <p>For a list of languages supported with Amazon Transcribe streaming, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p><br>
    ///   - [`media_sample_rate_hertz(i32)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::media_sample_rate_hertz) / [`set_media_sample_rate_hertz(Option<i32>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_media_sample_rate_hertz):<br>required: **true**<br><p>The sample rate of the input audio (in hertz). Low-quality audio, such as telephone audio, is typically around 8,000 Hz. High-quality audio typically ranges from 16,000 Hz to 48,000 Hz. Note that the sample rate you specify must match that of your audio.</p><br>
    ///   - [`media_encoding(MediaEncoding)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::media_encoding) / [`set_media_encoding(Option<MediaEncoding>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_media_encoding):<br>required: **true**<br><p>Specify the encoding of your input audio. Supported formats are:</p> <ul>  <li>   <p>FLAC</p></li>  <li>   <p>OPUS-encoded audio in an Ogg container</p></li>  <li>   <p>PCM (only signed 16-bit little-endian audio formats, which does not include WAV)</p></li> </ul> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.</p><br>
    ///   - [`vocabulary_name(impl Into<String>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::vocabulary_name) / [`set_vocabulary_name(Option<String>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_vocabulary_name):<br>required: **false**<br><p>Specify the name of the custom vocabulary that you want to use when processing your transcription. Note that vocabulary names are case sensitive.</p> <p>If the language of the specified custom vocabulary doesn't match the language identified in your media, the custom vocabulary is not applied to your transcription.</p><important>  <p>This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If you're including <code>IdentifyLanguage</code> in your request and want to use one or more custom vocabularies with your transcription, use the <code>VocabularyNames</code> parameter instead.</p> </important> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.</p><br>
    ///   - [`session_id(impl Into<String>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::session_id) / [`set_session_id(Option<String>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_session_id):<br>required: **false**<br><p>Specify a name for your transcription session. If you don't include this parameter in your request, Amazon Transcribe generates an ID and returns it in the response.</p><br>
    ///   - [`audio_stream(EventStreamSender<AudioStream, AudioStreamError>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::audio_stream) / [`set_audio_stream(EventStreamSender<AudioStream, AudioStreamError>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_audio_stream):<br>required: **true**<br><p>An encoded stream of audio blobs. Audio streams are encoded as either HTTP/2 or WebSocket data frames.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html">Transcribing streaming audio</a>.</p><br>
    ///   - [`vocabulary_filter_name(impl Into<String>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::vocabulary_filter_name) / [`set_vocabulary_filter_name(Option<String>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_vocabulary_filter_name):<br>required: **false**<br><p>Specify the name of the custom vocabulary filter that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.</p> <p>If the language of the specified custom vocabulary filter doesn't match the language identified in your media, the vocabulary filter is not applied to your transcription.</p><important>  <p>This parameter is <b>not</b> intended for use with the <code>IdentifyLanguage</code> parameter. If you're including <code>IdentifyLanguage</code> in your request and want to use one or more vocabulary filters with your transcription, use the <code>VocabularyFilterNames</code> parameter instead.</p> </important> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering with unwanted words</a>.</p><br>
    ///   - [`vocabulary_filter_method(VocabularyFilterMethod)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::vocabulary_filter_method) / [`set_vocabulary_filter_method(Option<VocabularyFilterMethod>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_vocabulary_filter_method):<br>required: **false**<br><p>Specify how you want your vocabulary filter applied to your transcript.</p> <p>To replace words with <code>***</code>, choose <code>mask</code>.</p> <p>To delete words, choose <code>remove</code>.</p> <p>To flag words without changing them, choose <code>tag</code>.</p><br>
    ///   - [`show_speaker_label(bool)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::show_speaker_label) / [`set_show_speaker_label(Option<bool>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_show_speaker_label):<br>required: **false**<br><p>Enables speaker partitioning (diarization) in your transcription output. Speaker partitioning labels the speech from individual speakers in your media file.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/diarization.html">Partitioning speakers (diarization)</a>.</p><br>
    ///   - [`enable_channel_identification(bool)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::enable_channel_identification) / [`set_enable_channel_identification(Option<bool>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_enable_channel_identification):<br>required: **false**<br><p>Enables channel identification in multi-channel audio.</p> <p>Channel identification transcribes the audio on each channel independently, then appends the output for each channel into one transcript.</p> <p>If you have multi-channel audio and do not enable channel identification, your audio is transcribed in a continuous manner and your transcript is not separated by channel.</p> <p>If you include <code>EnableChannelIdentification</code> in your request, you must also include <code>NumberOfChannels</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/channel-id.html">Transcribing multi-channel audio</a>.</p><br>
    ///   - [`number_of_channels(i32)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::number_of_channels) / [`set_number_of_channels(Option<i32>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_number_of_channels):<br>required: **false**<br><p>Specify the number of channels in your audio stream. This value must be <code>2</code>, as only two channels are supported. If your audio doesn't contain multiple channels, do not include this parameter in your request.</p> <p>If you include <code>NumberOfChannels</code> in your request, you must also include <code>EnableChannelIdentification</code>.</p><br>
    ///   - [`enable_partial_results_stabilization(bool)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::enable_partial_results_stabilization) / [`set_enable_partial_results_stabilization(Option<bool>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_enable_partial_results_stabilization):<br>required: **false**<br><p>Enables partial result stabilization for your transcription. Partial result stabilization can reduce latency in your output, but may impact accuracy. For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization">Partial-result stabilization</a>.</p><br>
    ///   - [`partial_results_stability(PartialResultsStability)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::partial_results_stability) / [`set_partial_results_stability(Option<PartialResultsStability>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_partial_results_stability):<br>required: **false**<br><p>Specify the level of stability to use when you enable partial results stabilization (<code>EnablePartialResultsStabilization</code>).</p> <p>Low stability provides the highest accuracy. High stability transcribes faster, but with slightly lower accuracy.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/streaming.html#streaming-partial-result-stabilization">Partial-result stabilization</a>.</p><br>
    ///   - [`content_identification_type(ContentIdentificationType)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::content_identification_type) / [`set_content_identification_type(Option<ContentIdentificationType>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_content_identification_type):<br>required: **false**<br><p>Labels all personally identifiable information (PII) identified in your transcript.</p> <p>Content identification is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is flagged upon complete transcription of an audio segment. If you don't include <code>PiiEntityTypes</code> in your request, all PII is identified.</p> <p>You can’t set <code>ContentIdentificationType</code> and <code>ContentRedactionType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying personally identifiable information</a>.</p><br>
    ///   - [`content_redaction_type(ContentRedactionType)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::content_redaction_type) / [`set_content_redaction_type(Option<ContentRedactionType>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_content_redaction_type):<br>required: **false**<br><p>Redacts all personally identifiable information (PII) identified in your transcript.</p> <p>Content redaction is performed at the segment level; PII specified in <code>PiiEntityTypes</code> is redacted upon complete transcription of an audio segment. If you don't include <code>PiiEntityTypes</code> in your request, all PII is redacted.</p> <p>You can’t set <code>ContentRedactionType</code> and <code>ContentIdentificationType</code> in the same request. If you set both, your request returns a <code>BadRequestException</code>.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/pii-redaction.html">Redacting or identifying personally identifiable information</a>.</p><br>
    ///   - [`pii_entity_types(impl Into<String>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::pii_entity_types) / [`set_pii_entity_types(Option<String>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_pii_entity_types):<br>required: **false**<br><p>Specify which types of personally identifiable information (PII) you want to redact in your transcript. You can include as many types as you'd like, or you can select <code>ALL</code>.</p> <p>Values must be comma-separated and can include: <code>ADDRESS</code>, <code>BANK_ACCOUNT_NUMBER</code>, <code>BANK_ROUTING</code>, <code>CREDIT_DEBIT_CVV</code>, <code>CREDIT_DEBIT_EXPIRY</code>, <code>CREDIT_DEBIT_NUMBER</code>, <code>EMAIL</code>, <code>NAME</code>, <code>PHONE</code>, <code>PIN</code>, <code>SSN</code>, or <code>ALL</code>.</p> <p>Note that if you include <code>PiiEntityTypes</code> in your request, you must also include <code>ContentIdentificationType</code> or <code>ContentRedactionType</code>.</p> <p>If you include <code>ContentRedactionType</code> or <code>ContentIdentificationType</code> in your request, but do not include <code>PiiEntityTypes</code>, all PII is redacted or identified.</p><br>
    ///   - [`language_model_name(impl Into<String>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::language_model_name) / [`set_language_model_name(Option<String>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_language_model_name):<br>required: **false**<br><p>Specify the name of the custom language model that you want to use when processing your transcription. Note that language model names are case sensitive.</p> <p>The language of the specified language model must match the language code you specify in your transcription request. If the languages don't match, the custom language model isn't applied. There are no errors or warnings associated with a language mismatch.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-language-models.html">Custom language models</a>.</p><br>
    ///   - [`identify_language(bool)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::identify_language) / [`set_identify_language(Option<bool>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_identify_language):<br>required: **false**<br><p>Enables automatic language identification for your transcription.</p> <p>If you include <code>IdentifyLanguage</code>, you must include a list of language codes, using <code>LanguageOptions</code>, that you think may be present in your audio stream.</p> <p>You can also include a preferred language using <code>PreferredLanguage</code>. Adding a preferred language can help Amazon Transcribe identify the language faster than if you omit this parameter.</p> <p>If you have multi-channel audio that contains different languages on each channel, and you've enabled channel identification, automatic language identification identifies the dominant language on each audio channel.</p> <p>Note that you must include either <code>LanguageCode</code> or <code>IdentifyLanguage</code> or <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your transcription job fails.</p> <p>Streaming language identification can't be combined with custom language models or redaction.</p><br>
    ///   - [`language_options(impl Into<String>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::language_options) / [`set_language_options(Option<String>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_language_options):<br>required: **false**<br><p>Specify two or more language codes that represent the languages you think may be present in your media; including more than five is not recommended.</p> <p>Including language options can improve the accuracy of language identification.</p> <p>If you include <code>LanguageOptions</code> in your request, you must also include <code>IdentifyLanguage</code> or <code>IdentifyMultipleLanguages</code>.</p> <p>For a list of languages supported with Amazon Transcribe streaming, refer to the <a href="https://docs.aws.amazon.com/transcribe/latest/dg/supported-languages.html">Supported languages</a> table.</p><important>  <p>You can only include one language dialect per language per stream. For example, you cannot include <code>en-US</code> and <code>en-AU</code> in the same request.</p> </important><br>
    ///   - [`preferred_language(LanguageCode)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::preferred_language) / [`set_preferred_language(Option<LanguageCode>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_preferred_language):<br>required: **false**<br><p>Specify a preferred language from the subset of languages codes you specified in <code>LanguageOptions</code>.</p> <p>You can only use this parameter if you've included <code>IdentifyLanguage</code> and <code>LanguageOptions</code> in your request.</p><br>
    ///   - [`identify_multiple_languages(bool)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::identify_multiple_languages) / [`set_identify_multiple_languages(Option<bool>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_identify_multiple_languages):<br>required: **false**<br><p>Enables automatic multi-language identification in your transcription job request. Use this parameter if your stream contains more than one language. If your stream contains only one language, use IdentifyLanguage instead.</p> <p>If you include <code>IdentifyMultipleLanguages</code>, you must include a list of language codes, using <code>LanguageOptions</code>, that you think may be present in your stream.</p> <p>If you want to apply a custom vocabulary or a custom vocabulary filter to your automatic multiple language identification request, include <code>VocabularyNames</code> or <code>VocabularyFilterNames</code>.</p> <p>Note that you must include one of <code>LanguageCode</code>, <code>IdentifyLanguage</code>, or <code>IdentifyMultipleLanguages</code> in your request. If you include more than one of these parameters, your transcription job fails.</p><br>
    ///   - [`vocabulary_names(impl Into<String>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::vocabulary_names) / [`set_vocabulary_names(Option<String>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_vocabulary_names):<br>required: **false**<br><p>Specify the names of the custom vocabularies that you want to use when processing your transcription. Note that vocabulary names are case sensitive.</p> <p>If none of the languages of the specified custom vocabularies match the language identified in your media, your job fails.</p><important>  <p>This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If you're <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary with your transcription, use the <code>VocabularyName</code> parameter instead.</p> </important> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html">Custom vocabularies</a>.</p><br>
    ///   - [`vocabulary_filter_names(impl Into<String>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::vocabulary_filter_names) / [`set_vocabulary_filter_names(Option<String>)`](crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::set_vocabulary_filter_names):<br>required: **false**<br><p>Specify the names of the custom vocabulary filters that you want to use when processing your transcription. Note that vocabulary filter names are case sensitive.</p> <p>If none of the languages of the specified custom vocabulary filters match the language identified in your media, your job fails.</p><important>  <p>This parameter is only intended for use <b>with</b> the <code>IdentifyLanguage</code> parameter. If you're <b>not</b> including <code>IdentifyLanguage</code> in your request and want to use a custom vocabulary filter with your transcription, use the <code>VocabularyFilterName</code> parameter instead.</p> </important> <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/vocabulary-filtering.html">Using vocabulary filtering with unwanted words</a>.</p><br>
    /// - On success, responds with [`StartStreamTranscriptionOutput`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput) with field(s):
    ///   - [`request_id(Option<String>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::request_id): <p>Provides the identifier for your streaming request.</p>
    ///   - [`language_code(Option<LanguageCode>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::language_code): <p>Provides the language code that you specified in your request.</p>
    ///   - [`media_sample_rate_hertz(Option<i32>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::media_sample_rate_hertz): <p>Provides the sample rate that you specified in your request.</p>
    ///   - [`media_encoding(Option<MediaEncoding>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::media_encoding): <p>Provides the media encoding you specified in your request.</p>
    ///   - [`vocabulary_name(Option<String>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::vocabulary_name): <p>Provides the name of the custom vocabulary that you specified in your request.</p>
    ///   - [`session_id(Option<String>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::session_id): <p>Provides the identifier for your transcription session.</p>
    ///   - [`transcript_result_stream(EventReceiver<TranscriptResultStream, TranscriptResultStreamError>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::transcript_result_stream): <p>Provides detailed information about your streaming session.</p>
    ///   - [`vocabulary_filter_name(Option<String>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::vocabulary_filter_name): <p>Provides the name of the custom vocabulary filter that you specified in your request.</p>
    ///   - [`vocabulary_filter_method(Option<VocabularyFilterMethod>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::vocabulary_filter_method): <p>Provides the vocabulary filtering method used in your transcription.</p>
    ///   - [`show_speaker_label(bool)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::show_speaker_label): <p>Shows whether speaker partitioning was enabled for your transcription.</p>
    ///   - [`enable_channel_identification(bool)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::enable_channel_identification): <p>Shows whether channel identification was enabled for your transcription.</p>
    ///   - [`number_of_channels(Option<i32>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::number_of_channels): <p>Provides the number of channels that you specified in your request.</p>
    ///   - [`enable_partial_results_stabilization(bool)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::enable_partial_results_stabilization): <p>Shows whether partial results stabilization was enabled for your transcription.</p>
    ///   - [`partial_results_stability(Option<PartialResultsStability>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::partial_results_stability): <p>Provides the stabilization level used for your transcription.</p>
    ///   - [`content_identification_type(Option<ContentIdentificationType>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::content_identification_type): <p>Shows whether content identification was enabled for your transcription.</p>
    ///   - [`content_redaction_type(Option<ContentRedactionType>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::content_redaction_type): <p>Shows whether content redaction was enabled for your transcription.</p>
    ///   - [`pii_entity_types(Option<String>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::pii_entity_types): <p>Lists the PII entity types you specified in your request.</p>
    ///   - [`language_model_name(Option<String>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::language_model_name): <p>Provides the name of the custom language model that you specified in your request.</p>
    ///   - [`identify_language(bool)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::identify_language): <p>Shows whether automatic language identification was enabled for your transcription.</p>
    ///   - [`language_options(Option<String>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::language_options): <p>Provides the language codes that you specified in your request.</p>
    ///   - [`preferred_language(Option<LanguageCode>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::preferred_language): <p>Provides the preferred language that you specified in your request.</p>
    ///   - [`identify_multiple_languages(bool)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::identify_multiple_languages): <p>Shows whether automatic multi-language identification was enabled for your transcription.</p>
    ///   - [`vocabulary_names(Option<String>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::vocabulary_names): <p>Provides the names of the custom vocabularies that you specified in your request.</p>
    ///   - [`vocabulary_filter_names(Option<String>)`](crate::operation::start_stream_transcription::StartStreamTranscriptionOutput::vocabulary_filter_names): <p>Provides the names of the custom vocabulary filters that you specified in your request.</p>
    /// - On failure, responds with [`SdkError<StartStreamTranscriptionError>`](crate::operation::start_stream_transcription::StartStreamTranscriptionError)
    pub fn start_stream_transcription(&self) -> crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder {
        crate::operation::start_stream_transcription::builders::StartStreamTranscriptionFluentBuilder::new(self.handle.clone())
    }
}
