// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`SynthesizeSpeech`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`engine(Engine)`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::engine) / [`set_engine(Option<Engine>)`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::set_engine):<br>required: **false**<br><p>Specifies the engine (<code>standard</code>, <code>neural</code>, <code>long-form</code>, or <code>generative</code>) for Amazon Polly to use when processing input text for speech synthesis. Provide an engine that is supported by the voice you select. If you don't provide an engine, the standard engine is selected by default. If a chosen voice isn't supported by the standard engine, this will result in an error. For information on Amazon Polly voices and which voices are available for each engine, see <a href="https://docs.aws.amazon.com/polly/latest/dg/voicelist.html">Available Voices</a>.</p> <p>Type: String</p> <p>Valid Values: <code>standard</code> | <code>neural</code> | <code>long-form</code> | <code>generative</code></p> <p>Required: Yes</p><br>
    ///   - [`language_code(LanguageCode)`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::language_code) / [`set_language_code(Option<LanguageCode>)`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::set_language_code):<br>required: **false**<br><p>Optional language code for the Synthesize Speech request. This is only necessary if using a bilingual voice, such as Aditi, which can be used for either Indian English (en-IN) or Hindi (hi-IN).</p> <p>If a bilingual voice is used and no language code is specified, Amazon Polly uses the default language of the bilingual voice. The default language for any voice is the one returned by the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation for the <code>LanguageCode</code> parameter. For example, if no language code is specified, Aditi will use Indian English rather than Hindi.</p><br>
    ///   - [`lexicon_names(impl Into<String>)`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::lexicon_names) / [`set_lexicon_names(Option<Vec::<String>>)`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::set_lexicon_names):<br>required: **false**<br><p>List of one or more pronunciation lexicon names you want the service to apply during synthesis. Lexicons are applied only if the language of the lexicon is the same as the language of the voice. For information about storing lexicons, see <a href="https://docs.aws.amazon.com/polly/latest/dg/API_PutLexicon.html">PutLexicon</a>.</p><br>
    ///   - [`output_format(OutputFormat)`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::output_format) / [`set_output_format(Option<OutputFormat>)`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::set_output_format):<br>required: **true**<br><p>The format in which the returned output will be encoded. For audio stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this will be json.</p> <p>When pcm is used, the content returned is audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format.</p><br>
    ///   - [`sample_rate(impl Into<String>)`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::sample_rate) / [`set_sample_rate(Option<String>)`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::set_sample_rate):<br>required: **false**<br><p>The audio frequency specified in Hz.</p> <p>The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050", and "24000". The default value for standard voices is "22050". The default value for neural voices is "24000". The default value for long-form voices is "24000". The default value for generative voices is "24000".</p> <p>Valid values for pcm are "8000" and "16000" The default value is "16000".</p><br>
    ///   - [`speech_mark_types(SpeechMarkType)`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::speech_mark_types) / [`set_speech_mark_types(Option<Vec::<SpeechMarkType>>)`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::set_speech_mark_types):<br>required: **false**<br><p>The type of speech marks returned for the input text.</p><br>
    ///   - [`text(impl Into<String>)`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::text) / [`set_text(Option<String>)`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::set_text):<br>required: **true**<br><p>Input text to synthesize. If you specify <code>ssml</code> as the <code>TextType</code>, follow the SSML format for the input text.</p><br>
    ///   - [`text_type(TextType)`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::text_type) / [`set_text_type(Option<TextType>)`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::set_text_type):<br>required: **false**<br><p>Specifies whether the input text is plain text or SSML. The default value is plain text. For more information, see <a href="https://docs.aws.amazon.com/polly/latest/dg/ssml.html">Using SSML</a>.</p><br>
    ///   - [`voice_id(VoiceId)`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::voice_id) / [`set_voice_id(Option<VoiceId>)`](crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::set_voice_id):<br>required: **true**<br><p>Voice ID to use for the synthesis. You can get a list of available voice IDs by calling the <a href="https://docs.aws.amazon.com/polly/latest/dg/API_DescribeVoices.html">DescribeVoices</a> operation.</p><br>
    /// - On success, responds with [`SynthesizeSpeechOutput`](crate::operation::synthesize_speech::SynthesizeSpeechOutput) with field(s):
    ///   - [`audio_stream(ByteStream)`](crate::operation::synthesize_speech::SynthesizeSpeechOutput::audio_stream): <p>Stream containing the synthesized speech.</p>
    ///   - [`content_type(Option<String>)`](crate::operation::synthesize_speech::SynthesizeSpeechOutput::content_type): <p>Specifies the type audio stream. This should reflect the <code>OutputFormat</code> parameter in your request.</p> <ul>  <li>   <p>If you request <code>mp3</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/mpeg.</p></li>  <li>   <p>If you request <code>ogg_vorbis</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/ogg.</p></li>  <li>   <p>If you request <code>pcm</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is audio/pcm in a signed 16-bit, 1 channel (mono), little-endian format.</p></li>  <li>   <p>If you request <code>json</code> as the <code>OutputFormat</code>, the <code>ContentType</code> returned is application/x-json-stream.</p></li> </ul> <p></p>
    ///   - [`request_characters(i32)`](crate::operation::synthesize_speech::SynthesizeSpeechOutput::request_characters): <p>Number of characters synthesized.</p>
    /// - On failure, responds with [`SdkError<SynthesizeSpeechError>`](crate::operation::synthesize_speech::SynthesizeSpeechError)
    pub fn synthesize_speech(&self) -> crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder {
        crate::operation::synthesize_speech::builders::SynthesizeSpeechFluentBuilder::new(self.handle.clone())
    }
}
