// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`CreateStream`](crate::operation::create_stream::builders::CreateStreamFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`device_name(impl Into<String>)`](crate::operation::create_stream::builders::CreateStreamFluentBuilder::device_name) / [`set_device_name(Option<String>)`](crate::operation::create_stream::builders::CreateStreamFluentBuilder::set_device_name):<br>required: **false**<br><p>The name of the device that is writing to the stream.</p><note>  <p>In the current implementation, Kinesis Video Streams does not use this name.</p> </note><br>
    ///   - [`stream_name(impl Into<String>)`](crate::operation::create_stream::builders::CreateStreamFluentBuilder::stream_name) / [`set_stream_name(Option<String>)`](crate::operation::create_stream::builders::CreateStreamFluentBuilder::set_stream_name):<br>required: **true**<br><p>A name for the stream that you are creating.</p> <p>The stream name is an identifier for the stream, and must be unique for each account and region.</p><br>
    ///   - [`media_type(impl Into<String>)`](crate::operation::create_stream::builders::CreateStreamFluentBuilder::media_type) / [`set_media_type(Option<String>)`](crate::operation::create_stream::builders::CreateStreamFluentBuilder::set_media_type):<br>required: **false**<br><p>The media type of the stream. Consumers of the stream can use this information when processing the stream. For more information about media types, see <a href="http://www.iana.org/assignments/media-types/media-types.xhtml">Media Types</a>. If you choose to specify the <code>MediaType</code>, see <a href="https://tools.ietf.org/html/rfc6838#section-4.2">Naming Requirements</a> for guidelines.</p> <p>Example valid values include "video/h264" and "video/h264,audio/aac".</p> <p>This parameter is optional; the default value is <code>null</code> (or empty in JSON).</p><br>
    ///   - [`kms_key_id(impl Into<String>)`](crate::operation::create_stream::builders::CreateStreamFluentBuilder::kms_key_id) / [`set_kms_key_id(Option<String>)`](crate::operation::create_stream::builders::CreateStreamFluentBuilder::set_kms_key_id):<br>required: **false**<br><p>The ID of the Key Management Service (KMS) key that you want Kinesis Video Streams to use to encrypt stream data.</p> <p>If no key ID is specified, the default, Kinesis Video-managed key (<code>Amazon Web Services/kinesisvideo</code>) is used.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html#API_DescribeKey_RequestParameters">DescribeKey</a>.</p><br>
    ///   - [`data_retention_in_hours(i32)`](crate::operation::create_stream::builders::CreateStreamFluentBuilder::data_retention_in_hours) / [`set_data_retention_in_hours(Option<i32>)`](crate::operation::create_stream::builders::CreateStreamFluentBuilder::set_data_retention_in_hours):<br>required: **false**<br><p>The number of hours that you want to retain the data in the stream. Kinesis Video Streams retains the data in a data store that is associated with the stream.</p> <p>The default value is 0, indicating that the stream does not persist data.</p> <p>When the <code>DataRetentionInHours</code> value is 0, consumers can still consume the fragments that remain in the service host buffer, which has a retention time limit of 5 minutes and a retention memory limit of 200 MB. Fragments are removed from the buffer when either limit is reached.</p><br>
    ///   - [`tags(impl Into<String>, impl Into<String>)`](crate::operation::create_stream::builders::CreateStreamFluentBuilder::tags) / [`set_tags(Option<HashMap::<String, String>>)`](crate::operation::create_stream::builders::CreateStreamFluentBuilder::set_tags):<br>required: **false**<br><p>A list of tags to associate with the specified stream. Each tag is a key-value pair (the value is optional).</p><br>
    /// - On success, responds with [`CreateStreamOutput`](crate::operation::create_stream::CreateStreamOutput) with field(s):
    ///   - [`stream_arn(Option<String>)`](crate::operation::create_stream::CreateStreamOutput::stream_arn): <p>The Amazon Resource Name (ARN) of the stream.</p>
    /// - On failure, responds with [`SdkError<CreateStreamError>`](crate::operation::create_stream::CreateStreamError)
    pub fn create_stream(&self) -> crate::operation::create_stream::builders::CreateStreamFluentBuilder {
        crate::operation::create_stream::builders::CreateStreamFluentBuilder::new(self.handle.clone())
    }
}
