// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1beta1/nas_job.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The available types of multi-trial algorithms.
type NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm int32

const (
	// Defaults to `REINFORCEMENT_LEARNING`.
	NasJobSpec_MultiTrialAlgorithmSpec_MULTI_TRIAL_ALGORITHM_UNSPECIFIED NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm = 0
	// The Reinforcement Learning Algorithm for Multi-trial Neural
	// Architecture Search (NAS).
	NasJobSpec_MultiTrialAlgorithmSpec_REINFORCEMENT_LEARNING NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm = 1
	// The Grid Search Algorithm for Multi-trial Neural
	// Architecture Search (NAS).
	NasJobSpec_MultiTrialAlgorithmSpec_GRID_SEARCH NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm = 2
)

// Enum value maps for NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm.
var (
	NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm_name = map[int32]string{
		0: "MULTI_TRIAL_ALGORITHM_UNSPECIFIED",
		1: "REINFORCEMENT_LEARNING",
		2: "GRID_SEARCH",
	}
	NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm_value = map[string]int32{
		"MULTI_TRIAL_ALGORITHM_UNSPECIFIED": 0,
		"REINFORCEMENT_LEARNING":            1,
		"GRID_SEARCH":                       2,
	}
)

func (x NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm) Enum() *NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm {
	p := new(NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm)
	*p = x
	return p
}

func (x NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_nas_job_proto_enumTypes[0].Descriptor()
}

func (NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_nas_job_proto_enumTypes[0]
}

func (x NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm.Descriptor instead.
func (NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescGZIP(), []int{2, 0, 0}
}

// The available types of optimization goals.
type NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType int32

const (
	// Goal Type will default to maximize.
	NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GOAL_TYPE_UNSPECIFIED NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType = 0
	// Maximize the goal metric.
	NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_MAXIMIZE NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType = 1
	// Minimize the goal metric.
	NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_MINIMIZE NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType = 2
)

// Enum value maps for NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType.
var (
	NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType_name = map[int32]string{
		0: "GOAL_TYPE_UNSPECIFIED",
		1: "MAXIMIZE",
		2: "MINIMIZE",
	}
	NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType_value = map[string]int32{
		"GOAL_TYPE_UNSPECIFIED": 0,
		"MAXIMIZE":              1,
		"MINIMIZE":              2,
	}
)

func (x NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType) Enum() *NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType {
	p := new(NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType)
	*p = x
	return p
}

func (x NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_nas_job_proto_enumTypes[1].Descriptor()
}

func (NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_nas_job_proto_enumTypes[1]
}

func (x NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType.Descriptor instead.
func (NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescGZIP(), []int{2, 0, 0, 0}
}

// Describes a NasTrial state.
type NasTrial_State int32

const (
	// The NasTrial state is unspecified.
	NasTrial_STATE_UNSPECIFIED NasTrial_State = 0
	// Indicates that a specific NasTrial has been requested, but it has not yet
	// been suggested by the service.
	NasTrial_REQUESTED NasTrial_State = 1
	// Indicates that the NasTrial has been suggested.
	NasTrial_ACTIVE NasTrial_State = 2
	// Indicates that the NasTrial should stop according to the service.
	NasTrial_STOPPING NasTrial_State = 3
	// Indicates that the NasTrial is completed successfully.
	NasTrial_SUCCEEDED NasTrial_State = 4
	// Indicates that the NasTrial should not be attempted again.
	// The service will set a NasTrial to INFEASIBLE when it's done but missing
	// the final_measurement.
	NasTrial_INFEASIBLE NasTrial_State = 5
)

// Enum value maps for NasTrial_State.
var (
	NasTrial_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "REQUESTED",
		2: "ACTIVE",
		3: "STOPPING",
		4: "SUCCEEDED",
		5: "INFEASIBLE",
	}
	NasTrial_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"REQUESTED":         1,
		"ACTIVE":            2,
		"STOPPING":          3,
		"SUCCEEDED":         4,
		"INFEASIBLE":        5,
	}
)

func (x NasTrial_State) Enum() *NasTrial_State {
	p := new(NasTrial_State)
	*p = x
	return p
}

func (x NasTrial_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (NasTrial_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_nas_job_proto_enumTypes[2].Descriptor()
}

func (NasTrial_State) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_nas_job_proto_enumTypes[2]
}

func (x NasTrial_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use NasTrial_State.Descriptor instead.
func (NasTrial_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescGZIP(), []int{4, 0}
}

// Represents a Neural Architecture Search (NAS) job.
type NasJob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the NasJob.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The display name of the NasJob.
	// The name can be up to 128 characters long and can consist of any UTF-8
	// characters.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The specification of a NasJob.
	NasJobSpec *NasJobSpec `protobuf:"bytes,4,opt,name=nas_job_spec,json=nasJobSpec,proto3" json:"nas_job_spec,omitempty"`
	// Output only. Output of the NasJob.
	NasJobOutput *NasJobOutput `protobuf:"bytes,5,opt,name=nas_job_output,json=nasJobOutput,proto3" json:"nas_job_output,omitempty"`
	// Output only. The detailed state of the job.
	State JobState `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.aiplatform.v1beta1.JobState" json:"state,omitempty"`
	// Output only. Time when the NasJob was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,7,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when the NasJob for the first time entered the
	// `JOB_STATE_RUNNING` state.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time when the NasJob entered any of the following states:
	// `JOB_STATE_SUCCEEDED`, `JOB_STATE_FAILED`, `JOB_STATE_CANCELLED`.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,9,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Time when the NasJob was most recently updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,10,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Only populated when job's state is JOB_STATE_FAILED or
	// JOB_STATE_CANCELLED.
	Error *status.Status `protobuf:"bytes,11,opt,name=error,proto3" json:"error,omitempty"`
	// The labels with user-defined metadata to organize NasJobs.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	//
	// See https://goo.gl/xmQnxf for more information and examples of labels.
	Labels map[string]string `protobuf:"bytes,12,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Customer-managed encryption key options for a NasJob.
	// If this is set, then all resources created by the NasJob
	// will be encrypted with the provided encryption key.
	EncryptionSpec *EncryptionSpec `protobuf:"bytes,13,opt,name=encryption_spec,json=encryptionSpec,proto3" json:"encryption_spec,omitempty"`
	// Optional. Enable a separation of Custom model training
	// and restricted image training for tenant project.
	//
	// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/nas_job.proto.
	EnableRestrictedImageTraining bool `protobuf:"varint,14,opt,name=enable_restricted_image_training,json=enableRestrictedImageTraining,proto3" json:"enable_restricted_image_training,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzs bool `protobuf:"varint,15,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Output only. Reserved for future use.
	SatisfiesPzi bool `protobuf:"varint,16,opt,name=satisfies_pzi,json=satisfiesPzi,proto3" json:"satisfies_pzi,omitempty"`
}

func (x *NasJob) Reset() {
	*x = NasJob{}
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NasJob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NasJob) ProtoMessage() {}

func (x *NasJob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NasJob.ProtoReflect.Descriptor instead.
func (*NasJob) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescGZIP(), []int{0}
}

func (x *NasJob) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NasJob) GetDisplayName() string {
	if x != nil {
		return x.DisplayName
	}
	return ""
}

func (x *NasJob) GetNasJobSpec() *NasJobSpec {
	if x != nil {
		return x.NasJobSpec
	}
	return nil
}

func (x *NasJob) GetNasJobOutput() *NasJobOutput {
	if x != nil {
		return x.NasJobOutput
	}
	return nil
}

func (x *NasJob) GetState() JobState {
	if x != nil {
		return x.State
	}
	return JobState_JOB_STATE_UNSPECIFIED
}

func (x *NasJob) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *NasJob) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *NasJob) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *NasJob) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *NasJob) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

func (x *NasJob) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *NasJob) GetEncryptionSpec() *EncryptionSpec {
	if x != nil {
		return x.EncryptionSpec
	}
	return nil
}

// Deprecated: Marked as deprecated in google/cloud/aiplatform/v1beta1/nas_job.proto.
func (x *NasJob) GetEnableRestrictedImageTraining() bool {
	if x != nil {
		return x.EnableRestrictedImageTraining
	}
	return false
}

func (x *NasJob) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

func (x *NasJob) GetSatisfiesPzi() bool {
	if x != nil {
		return x.SatisfiesPzi
	}
	return false
}

// Represents a NasTrial details along with its parameters. If there is a
// corresponding train NasTrial, the train NasTrial is also returned.
type NasTrialDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Resource name of the NasTrialDetail.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The parameters for the NasJob NasTrial.
	Parameters string `protobuf:"bytes,2,opt,name=parameters,proto3" json:"parameters,omitempty"`
	// The requested search NasTrial.
	SearchTrial *NasTrial `protobuf:"bytes,3,opt,name=search_trial,json=searchTrial,proto3" json:"search_trial,omitempty"`
	// The train NasTrial corresponding to
	// [search_trial][google.cloud.aiplatform.v1beta1.NasTrialDetail.search_trial].
	// Only populated if
	// [search_trial][google.cloud.aiplatform.v1beta1.NasTrialDetail.search_trial]
	// is used for training.
	TrainTrial *NasTrial `protobuf:"bytes,4,opt,name=train_trial,json=trainTrial,proto3" json:"train_trial,omitempty"`
}

func (x *NasTrialDetail) Reset() {
	*x = NasTrialDetail{}
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NasTrialDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NasTrialDetail) ProtoMessage() {}

func (x *NasTrialDetail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NasTrialDetail.ProtoReflect.Descriptor instead.
func (*NasTrialDetail) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescGZIP(), []int{1}
}

func (x *NasTrialDetail) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *NasTrialDetail) GetParameters() string {
	if x != nil {
		return x.Parameters
	}
	return ""
}

func (x *NasTrialDetail) GetSearchTrial() *NasTrial {
	if x != nil {
		return x.SearchTrial
	}
	return nil
}

func (x *NasTrialDetail) GetTrainTrial() *NasTrial {
	if x != nil {
		return x.TrainTrial
	}
	return nil
}

// Represents the spec of a NasJob.
type NasJobSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Neural Architecture Search (NAS) algorithm specification.
	//
	// Types that are assignable to NasAlgorithmSpec:
	//
	//	*NasJobSpec_MultiTrialAlgorithmSpec_
	NasAlgorithmSpec isNasJobSpec_NasAlgorithmSpec `protobuf_oneof:"nas_algorithm_spec"`
	// The ID of the existing NasJob in the same Project and Location
	// which will be used to resume search. search_space_spec and
	// nas_algorithm_spec are obtained from previous NasJob hence should not
	// provide them again for this NasJob.
	ResumeNasJobId string `protobuf:"bytes,3,opt,name=resume_nas_job_id,json=resumeNasJobId,proto3" json:"resume_nas_job_id,omitempty"`
	// It defines the search space for Neural Architecture Search (NAS).
	SearchSpaceSpec string `protobuf:"bytes,1,opt,name=search_space_spec,json=searchSpaceSpec,proto3" json:"search_space_spec,omitempty"`
}

func (x *NasJobSpec) Reset() {
	*x = NasJobSpec{}
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NasJobSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NasJobSpec) ProtoMessage() {}

func (x *NasJobSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NasJobSpec.ProtoReflect.Descriptor instead.
func (*NasJobSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescGZIP(), []int{2}
}

func (m *NasJobSpec) GetNasAlgorithmSpec() isNasJobSpec_NasAlgorithmSpec {
	if m != nil {
		return m.NasAlgorithmSpec
	}
	return nil
}

func (x *NasJobSpec) GetMultiTrialAlgorithmSpec() *NasJobSpec_MultiTrialAlgorithmSpec {
	if x, ok := x.GetNasAlgorithmSpec().(*NasJobSpec_MultiTrialAlgorithmSpec_); ok {
		return x.MultiTrialAlgorithmSpec
	}
	return nil
}

func (x *NasJobSpec) GetResumeNasJobId() string {
	if x != nil {
		return x.ResumeNasJobId
	}
	return ""
}

func (x *NasJobSpec) GetSearchSpaceSpec() string {
	if x != nil {
		return x.SearchSpaceSpec
	}
	return ""
}

type isNasJobSpec_NasAlgorithmSpec interface {
	isNasJobSpec_NasAlgorithmSpec()
}

type NasJobSpec_MultiTrialAlgorithmSpec_ struct {
	// The spec of multi-trial algorithms.
	MultiTrialAlgorithmSpec *NasJobSpec_MultiTrialAlgorithmSpec `protobuf:"bytes,2,opt,name=multi_trial_algorithm_spec,json=multiTrialAlgorithmSpec,proto3,oneof"`
}

func (*NasJobSpec_MultiTrialAlgorithmSpec_) isNasJobSpec_NasAlgorithmSpec() {}

// Represents a uCAIP NasJob output.
type NasJobOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The output of this Neural Architecture Search (NAS) job.
	//
	// Types that are assignable to Output:
	//
	//	*NasJobOutput_MultiTrialJobOutput_
	Output isNasJobOutput_Output `protobuf_oneof:"output"`
}

func (x *NasJobOutput) Reset() {
	*x = NasJobOutput{}
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NasJobOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NasJobOutput) ProtoMessage() {}

func (x *NasJobOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NasJobOutput.ProtoReflect.Descriptor instead.
func (*NasJobOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescGZIP(), []int{3}
}

func (m *NasJobOutput) GetOutput() isNasJobOutput_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (x *NasJobOutput) GetMultiTrialJobOutput() *NasJobOutput_MultiTrialJobOutput {
	if x, ok := x.GetOutput().(*NasJobOutput_MultiTrialJobOutput_); ok {
		return x.MultiTrialJobOutput
	}
	return nil
}

type isNasJobOutput_Output interface {
	isNasJobOutput_Output()
}

type NasJobOutput_MultiTrialJobOutput_ struct {
	// Output only. The output of this multi-trial Neural Architecture Search
	// (NAS) job.
	MultiTrialJobOutput *NasJobOutput_MultiTrialJobOutput `protobuf:"bytes,1,opt,name=multi_trial_job_output,json=multiTrialJobOutput,proto3,oneof"`
}

func (*NasJobOutput_MultiTrialJobOutput_) isNasJobOutput_Output() {}

// Represents a uCAIP NasJob trial.
type NasTrial struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The identifier of the NasTrial assigned by the service.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. The detailed state of the NasTrial.
	State NasTrial_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.aiplatform.v1beta1.NasTrial_State" json:"state,omitempty"`
	// Output only. The final measurement containing the objective value.
	FinalMeasurement *Measurement `protobuf:"bytes,3,opt,name=final_measurement,json=finalMeasurement,proto3" json:"final_measurement,omitempty"`
	// Output only. Time when the NasTrial was started.
	StartTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time when the NasTrial's status changed to `SUCCEEDED` or
	// `INFEASIBLE`.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
}

func (x *NasTrial) Reset() {
	*x = NasTrial{}
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NasTrial) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NasTrial) ProtoMessage() {}

func (x *NasTrial) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NasTrial.ProtoReflect.Descriptor instead.
func (*NasTrial) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescGZIP(), []int{4}
}

func (x *NasTrial) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *NasTrial) GetState() NasTrial_State {
	if x != nil {
		return x.State
	}
	return NasTrial_STATE_UNSPECIFIED
}

func (x *NasTrial) GetFinalMeasurement() *Measurement {
	if x != nil {
		return x.FinalMeasurement
	}
	return nil
}

func (x *NasTrial) GetStartTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StartTime
	}
	return nil
}

func (x *NasTrial) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

// The spec of multi-trial Neural Architecture Search (NAS).
type NasJobSpec_MultiTrialAlgorithmSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The multi-trial Neural Architecture Search (NAS) algorithm
	// type. Defaults to `REINFORCEMENT_LEARNING`.
	MultiTrialAlgorithm NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm `protobuf:"varint,1,opt,name=multi_trial_algorithm,json=multiTrialAlgorithm,proto3,enum=google.cloud.aiplatform.v1beta1.NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm" json:"multi_trial_algorithm,omitempty"`
	// Metric specs for the NAS job.
	// Validation for this field is done at `multi_trial_algorithm_spec` field.
	Metric *NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec `protobuf:"bytes,2,opt,name=metric,proto3" json:"metric,omitempty"`
	// Required. Spec for search trials.
	SearchTrialSpec *NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec `protobuf:"bytes,3,opt,name=search_trial_spec,json=searchTrialSpec,proto3" json:"search_trial_spec,omitempty"`
	// Spec for train trials. Top N [TrainTrialSpec.max_parallel_trial_count]
	// search trials will be trained for every M
	// [TrainTrialSpec.frequency] trials searched.
	TrainTrialSpec *NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec `protobuf:"bytes,4,opt,name=train_trial_spec,json=trainTrialSpec,proto3" json:"train_trial_spec,omitempty"`
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec) Reset() {
	*x = NasJobSpec_MultiTrialAlgorithmSpec{}
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NasJobSpec_MultiTrialAlgorithmSpec) ProtoMessage() {}

func (x *NasJobSpec_MultiTrialAlgorithmSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NasJobSpec_MultiTrialAlgorithmSpec.ProtoReflect.Descriptor instead.
func (*NasJobSpec_MultiTrialAlgorithmSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescGZIP(), []int{2, 0}
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec) GetMultiTrialAlgorithm() NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm {
	if x != nil {
		return x.MultiTrialAlgorithm
	}
	return NasJobSpec_MultiTrialAlgorithmSpec_MULTI_TRIAL_ALGORITHM_UNSPECIFIED
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec) GetMetric() *NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec {
	if x != nil {
		return x.Metric
	}
	return nil
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec) GetSearchTrialSpec() *NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec {
	if x != nil {
		return x.SearchTrialSpec
	}
	return nil
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec) GetTrainTrialSpec() *NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec {
	if x != nil {
		return x.TrainTrialSpec
	}
	return nil
}

// Represents a metric to optimize.
type NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the metric. Must not contain whitespaces.
	MetricId string `protobuf:"bytes,1,opt,name=metric_id,json=metricId,proto3" json:"metric_id,omitempty"`
	// Required. The optimization goal of the metric.
	Goal NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType `protobuf:"varint,2,opt,name=goal,proto3,enum=google.cloud.aiplatform.v1beta1.NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType" json:"goal,omitempty"`
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec) Reset() {
	*x = NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec{}
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec) ProtoMessage() {}

func (x *NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec.ProtoReflect.Descriptor instead.
func (*NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescGZIP(), []int{2, 0, 0}
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec) GetMetricId() string {
	if x != nil {
		return x.MetricId
	}
	return ""
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec) GetGoal() NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType {
	if x != nil {
		return x.Goal
	}
	return NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GOAL_TYPE_UNSPECIFIED
}

// Represent spec for search trials.
type NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The spec of a search trial job. The same spec applies to
	// all search trials.
	SearchTrialJobSpec *CustomJobSpec `protobuf:"bytes,1,opt,name=search_trial_job_spec,json=searchTrialJobSpec,proto3" json:"search_trial_job_spec,omitempty"`
	// Required. The maximum number of Neural Architecture Search (NAS) trials
	// to run.
	MaxTrialCount int32 `protobuf:"varint,2,opt,name=max_trial_count,json=maxTrialCount,proto3" json:"max_trial_count,omitempty"`
	// Required. The maximum number of trials to run in parallel.
	MaxParallelTrialCount int32 `protobuf:"varint,3,opt,name=max_parallel_trial_count,json=maxParallelTrialCount,proto3" json:"max_parallel_trial_count,omitempty"`
	// The number of failed trials that need to be seen before failing
	// the NasJob.
	//
	// If set to 0, Vertex AI decides how many trials must fail
	// before the whole job fails.
	MaxFailedTrialCount int32 `protobuf:"varint,4,opt,name=max_failed_trial_count,json=maxFailedTrialCount,proto3" json:"max_failed_trial_count,omitempty"`
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec) Reset() {
	*x = NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec{}
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec) ProtoMessage() {}

func (x *NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec.ProtoReflect.Descriptor instead.
func (*NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescGZIP(), []int{2, 0, 1}
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec) GetSearchTrialJobSpec() *CustomJobSpec {
	if x != nil {
		return x.SearchTrialJobSpec
	}
	return nil
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec) GetMaxTrialCount() int32 {
	if x != nil {
		return x.MaxTrialCount
	}
	return 0
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec) GetMaxParallelTrialCount() int32 {
	if x != nil {
		return x.MaxParallelTrialCount
	}
	return 0
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec) GetMaxFailedTrialCount() int32 {
	if x != nil {
		return x.MaxFailedTrialCount
	}
	return 0
}

// Represent spec for train trials.
type NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The spec of a train trial job. The same spec applies to
	// all train trials.
	TrainTrialJobSpec *CustomJobSpec `protobuf:"bytes,1,opt,name=train_trial_job_spec,json=trainTrialJobSpec,proto3" json:"train_trial_job_spec,omitempty"`
	// Required. The maximum number of trials to run in parallel.
	MaxParallelTrialCount int32 `protobuf:"varint,2,opt,name=max_parallel_trial_count,json=maxParallelTrialCount,proto3" json:"max_parallel_trial_count,omitempty"`
	// Required. Frequency of search trials to start train stage. Top N
	// [TrainTrialSpec.max_parallel_trial_count]
	// search trials will be trained for every M
	// [TrainTrialSpec.frequency] trials searched.
	Frequency int32 `protobuf:"varint,3,opt,name=frequency,proto3" json:"frequency,omitempty"`
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec) Reset() {
	*x = NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec{}
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec) ProtoMessage() {}

func (x *NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec.ProtoReflect.Descriptor instead.
func (*NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescGZIP(), []int{2, 0, 2}
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec) GetTrainTrialJobSpec() *CustomJobSpec {
	if x != nil {
		return x.TrainTrialJobSpec
	}
	return nil
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec) GetMaxParallelTrialCount() int32 {
	if x != nil {
		return x.MaxParallelTrialCount
	}
	return 0
}

func (x *NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec) GetFrequency() int32 {
	if x != nil {
		return x.Frequency
	}
	return 0
}

// The output of a multi-trial Neural Architecture Search (NAS) jobs.
type NasJobOutput_MultiTrialJobOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. List of NasTrials that were started as part of search stage.
	SearchTrials []*NasTrial `protobuf:"bytes,1,rep,name=search_trials,json=searchTrials,proto3" json:"search_trials,omitempty"`
	// Output only. List of NasTrials that were started as part of train stage.
	TrainTrials []*NasTrial `protobuf:"bytes,2,rep,name=train_trials,json=trainTrials,proto3" json:"train_trials,omitempty"`
}

func (x *NasJobOutput_MultiTrialJobOutput) Reset() {
	*x = NasJobOutput_MultiTrialJobOutput{}
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *NasJobOutput_MultiTrialJobOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*NasJobOutput_MultiTrialJobOutput) ProtoMessage() {}

func (x *NasJobOutput_MultiTrialJobOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use NasJobOutput_MultiTrialJobOutput.ProtoReflect.Descriptor instead.
func (*NasJobOutput_MultiTrialJobOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescGZIP(), []int{3, 0}
}

func (x *NasJobOutput_MultiTrialJobOutput) GetSearchTrials() []*NasTrial {
	if x != nil {
		return x.SearchTrials
	}
	return nil
}

func (x *NasJobOutput_MultiTrialJobOutput) GetTrainTrials() []*NasTrial {
	if x != nil {
		return x.TrainTrials
	}
	return nil
}

var File_google_cloud_aiplatform_v1beta1_nas_job_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x6e, 0x61, 0x73, 0x5f, 0x6a, 0x6f, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x63, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x6a, 0x6f, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x35,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x73, 0x74, 0x75, 0x64, 0x79, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63,
	0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd4, 0x08,
	0x0a, 0x06, 0x4e, 0x61, 0x73, 0x4a, 0x6f, 0x62, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x26, 0x0a, 0x0c, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x64, 0x69,
	0x73, 0x70, 0x6c, 0x61, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x0c, 0x6e, 0x61, 0x73,
	0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2e, 0x4e, 0x61, 0x73, 0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x6e, 0x61, 0x73, 0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x12, 0x58, 0x0a,
	0x0e, 0x6e, 0x61, 0x73, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x61, 0x73, 0x4a, 0x6f, 0x62, 0x4f, 0x75,
	0x74, 0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x6e, 0x61, 0x73, 0x4a, 0x6f,
	0x62, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x44, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4a, 0x6f, 0x62, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x08, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x2d, 0x0a,
	0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x4b, 0x0a, 0x06,
	0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e,
	0x61, 0x73, 0x4a, 0x6f, 0x62, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x58, 0x0a, 0x0f, 0x65, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x0d, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x52, 0x0e, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x70, 0x65, 0x63, 0x12, 0x4e, 0x0a, 0x20, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65,
	0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x08, 0x42, 0x05, 0xe0,
	0x41, 0x01, 0x18, 0x01, 0x52, 0x1d, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x52, 0x65, 0x73, 0x74,
	0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61, 0x69, 0x6e,
	0x69, 0x6e, 0x67, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73,
	0x5f, 0x70, 0x7a, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x12, 0x28, 0x0a,
	0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69, 0x18, 0x10,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73,
	0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x69, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x3a, 0x60, 0xea, 0x41, 0x5d, 0x0a, 0x20, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4e, 0x61, 0x73, 0x4a, 0x6f, 0x62, 0x12, 0x39, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x6e, 0x61, 0x73, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6e, 0x61, 0x73, 0x5f,
	0x6a, 0x6f, 0x62, 0x7d, 0x22, 0xf2, 0x02, 0x0a, 0x0e, 0x4e, 0x61, 0x73, 0x54, 0x72, 0x69, 0x61,
	0x6c, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x1e, 0x0a, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
	0x12, 0x4c, 0x0a, 0x0c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x61, 0x73, 0x54, 0x72, 0x69, 0x61,
	0x6c, 0x52, 0x0b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x12, 0x4a,
	0x0a, 0x0b, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x61, 0x73, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x52, 0x0a,
	0x74, 0x72, 0x61, 0x69, 0x6e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x3a, 0x8c, 0x01, 0xea, 0x41, 0x88,
	0x01, 0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x61, 0x73,
	0x54, 0x72, 0x69, 0x61, 0x6c, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x5c, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6e, 0x61, 0x73, 0x4a, 0x6f, 0x62, 0x73, 0x2f, 0x7b, 0x6e, 0x61,
	0x73, 0x5f, 0x6a, 0x6f, 0x62, 0x7d, 0x2f, 0x6e, 0x61, 0x73, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x2f, 0x7b, 0x6e, 0x61, 0x73, 0x5f, 0x74, 0x72, 0x69, 0x61,
	0x6c, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x7d, 0x22, 0xdc, 0x0c, 0x0a, 0x0a, 0x4e, 0x61,
	0x73, 0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x12, 0x82, 0x01, 0x0a, 0x1a, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74,
	0x68, 0x6d, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x4e, 0x61, 0x73, 0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69,
	0x54, 0x72, 0x69, 0x61, 0x6c, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x53, 0x70,
	0x65, 0x63, 0x48, 0x00, 0x52, 0x17, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x54, 0x72, 0x69, 0x61, 0x6c,
	0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x53, 0x70, 0x65, 0x63, 0x12, 0x29, 0x0a,
	0x11, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x5f, 0x6e, 0x61, 0x73, 0x5f, 0x6a, 0x6f, 0x62, 0x5f,
	0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65,
	0x4e, 0x61, 0x73, 0x4a, 0x6f, 0x62, 0x49, 0x64, 0x12, 0x2a, 0x0a, 0x11, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x5f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x70, 0x61, 0x63, 0x65,
	0x53, 0x70, 0x65, 0x63, 0x1a, 0xdb, 0x0a, 0x0a, 0x17, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x54, 0x72,
	0x69, 0x61, 0x6c, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x8b, 0x01, 0x0a, 0x15, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c,
	0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x4e, 0x61, 0x73, 0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x75,
	0x6c, 0x74, 0x69, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68,
	0x6d, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x54, 0x72, 0x69, 0x61, 0x6c,
	0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x52, 0x13, 0x6d, 0x75, 0x6c, 0x74, 0x69,
	0x54, 0x72, 0x69, 0x61, 0x6c, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x66,
	0x0a, 0x06, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x4e, 0x61, 0x73, 0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x75, 0x6c, 0x74,
	0x69, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x53,
	0x70, 0x65, 0x63, 0x2e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x52, 0x06,
	0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x12, 0x84, 0x01, 0x0a, 0x11, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x61, 0x73, 0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x2e,
	0x4d, 0x75, 0x6c, 0x74, 0x69, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69,
	0x74, 0x68, 0x6d, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x72,
	0x69, 0x61, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x73, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x12, 0x7c, 0x0a,
	0x10, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x73, 0x70, 0x65,
	0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x61, 0x73, 0x4a, 0x6f, 0x62,
	0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x41,
	0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x54, 0x72, 0x61,
	0x69, 0x6e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x52, 0x0e, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x70, 0x65, 0x63, 0x1a, 0xe3, 0x01, 0x0a, 0x0a,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x49, 0x64, 0x12, 0x70, 0x0a, 0x04,
	0x67, 0x6f, 0x61, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x57, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x61, 0x73,
	0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x54, 0x72, 0x69,
	0x61, 0x6c, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x53, 0x70, 0x65, 0x63, 0x2e,
	0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x47, 0x6f, 0x61, 0x6c, 0x54,
	0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x67, 0x6f, 0x61, 0x6c, 0x22, 0x41,
	0x0a, 0x08, 0x47, 0x6f, 0x61, 0x6c, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x47, 0x4f,
	0x41, 0x4c, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x41, 0x58, 0x49, 0x4d, 0x49, 0x5a,
	0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x4d, 0x49, 0x4e, 0x49, 0x4d, 0x49, 0x5a, 0x45, 0x10,
	0x02, 0x1a, 0x99, 0x02, 0x0a, 0x0f, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x72, 0x69, 0x61,
	0x6c, 0x53, 0x70, 0x65, 0x63, 0x12, 0x66, 0x0a, 0x15, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f,
	0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4a, 0x6f, 0x62,
	0x53, 0x70, 0x65, 0x63, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x12, 0x2b, 0x0a,
	0x0f, 0x6d, 0x61, 0x78, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6d, 0x61, 0x78,
	0x54, 0x72, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x3c, 0x0a, 0x18, 0x6d, 0x61,
	0x78, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x15, 0x6d, 0x61, 0x78, 0x50, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x54, 0x72,
	0x69, 0x61, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x33, 0x0a, 0x16, 0x6d, 0x61, 0x78, 0x5f,
	0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x13, 0x6d, 0x61, 0x78, 0x46, 0x61, 0x69,
	0x6c, 0x65, 0x64, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x1a, 0xd7, 0x01,
	0x0a, 0x0e, 0x54, 0x72, 0x61, 0x69, 0x6e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x53, 0x70, 0x65, 0x63,
	0x12, 0x64, 0x0a, 0x14, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f,
	0x6a, 0x6f, 0x62, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4a, 0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x11, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x4a,
	0x6f, 0x62, 0x53, 0x70, 0x65, 0x63, 0x12, 0x3c, 0x0a, 0x18, 0x6d, 0x61, 0x78, 0x5f, 0x70, 0x61,
	0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x15, 0x6d,
	0x61, 0x78, 0x50, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x43,
	0x6f, 0x75, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x09, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x79, 0x22, 0x69, 0x0a, 0x13, 0x4d, 0x75, 0x6c, 0x74, 0x69,
	0x54, 0x72, 0x69, 0x61, 0x6c, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x25,
	0x0a, 0x21, 0x4d, 0x55, 0x4c, 0x54, 0x49, 0x5f, 0x54, 0x52, 0x49, 0x41, 0x4c, 0x5f, 0x41, 0x4c,
	0x47, 0x4f, 0x52, 0x49, 0x54, 0x48, 0x4d, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x45, 0x49, 0x4e, 0x46, 0x4f, 0x52,
	0x43, 0x45, 0x4d, 0x45, 0x4e, 0x54, 0x5f, 0x4c, 0x45, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10,
	0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x47, 0x52, 0x49, 0x44, 0x5f, 0x53, 0x45, 0x41, 0x52, 0x43, 0x48,
	0x10, 0x02, 0x42, 0x14, 0x0a, 0x12, 0x6e, 0x61, 0x73, 0x5f, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69,
	0x74, 0x68, 0x6d, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x22, 0xd7, 0x02, 0x0a, 0x0c, 0x4e, 0x61, 0x73,
	0x4a, 0x6f, 0x62, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x7d, 0x0a, 0x16, 0x6d, 0x75, 0x6c,
	0x74, 0x69, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x5f, 0x6a, 0x6f, 0x62, 0x5f, 0x6f, 0x75, 0x74,
	0x70, 0x75, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x61, 0x73, 0x4a,
	0x6f, 0x62, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x2e, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x54, 0x72,
	0x69, 0x61, 0x6c, 0x4a, 0x6f, 0x62, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x48, 0x00, 0x52, 0x13, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x4a,
	0x6f, 0x62, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x1a, 0xbd, 0x01, 0x0a, 0x13, 0x4d, 0x75, 0x6c,
	0x74, 0x69, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x4a, 0x6f, 0x62, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x12, 0x53, 0x0a, 0x0d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x74, 0x72, 0x69, 0x61, 0x6c,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x61, 0x73, 0x54, 0x72, 0x69,
	0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x54,
	0x72, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x51, 0x0a, 0x0c, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x5f, 0x74,
	0x72, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x61,
	0x73, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x74, 0x72, 0x61,
	0x69, 0x6e, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x42, 0x08, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x22, 0xaf, 0x03, 0x0a, 0x08, 0x4e, 0x61, 0x73, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x12,
	0x13, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x4a, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4e, 0x61, 0x73, 0x54, 0x72, 0x69, 0x61, 0x6c, 0x2e, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x5e, 0x0a, 0x11, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x4d, 0x65,
	0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10,
	0x66, 0x69, 0x6e, 0x61, 0x6c, 0x4d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x12, 0x3e, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65,
	0x12, 0x3a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x22, 0x66, 0x0a, 0x05,
	0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09,
	0x52, 0x45, 0x51, 0x55, 0x45, 0x53, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x4f, 0x50, 0x50,
	0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45, 0x45, 0x44,
	0x45, 0x44, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x4e, 0x46, 0x45, 0x41, 0x53, 0x49, 0x42,
	0x4c, 0x45, 0x10, 0x05, 0x42, 0xe2, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x0b, 0x4e, 0x61,
	0x73, 0x4a, 0x6f, 0x62, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62,
	0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74,
	0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_nas_job_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_aiplatform_v1beta1_nas_job_proto_goTypes = []any{
	(NasJobSpec_MultiTrialAlgorithmSpec_MultiTrialAlgorithm)(0), // 0: google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MultiTrialAlgorithm
	(NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec_GoalType)(0), // 1: google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.GoalType
	(NasTrial_State)(0),    // 2: google.cloud.aiplatform.v1beta1.NasTrial.State
	(*NasJob)(nil),         // 3: google.cloud.aiplatform.v1beta1.NasJob
	(*NasTrialDetail)(nil), // 4: google.cloud.aiplatform.v1beta1.NasTrialDetail
	(*NasJobSpec)(nil),     // 5: google.cloud.aiplatform.v1beta1.NasJobSpec
	(*NasJobOutput)(nil),   // 6: google.cloud.aiplatform.v1beta1.NasJobOutput
	(*NasTrial)(nil),       // 7: google.cloud.aiplatform.v1beta1.NasTrial
	nil,                    // 8: google.cloud.aiplatform.v1beta1.NasJob.LabelsEntry
	(*NasJobSpec_MultiTrialAlgorithmSpec)(nil),                 // 9: google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
	(*NasJobSpec_MultiTrialAlgorithmSpec_MetricSpec)(nil),      // 10: google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
	(*NasJobSpec_MultiTrialAlgorithmSpec_SearchTrialSpec)(nil), // 11: google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
	(*NasJobSpec_MultiTrialAlgorithmSpec_TrainTrialSpec)(nil),  // 12: google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
	(*NasJobOutput_MultiTrialJobOutput)(nil),                   // 13: google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
	(JobState)(0),                                              // 14: google.cloud.aiplatform.v1beta1.JobState
	(*timestamppb.Timestamp)(nil),                              // 15: google.protobuf.Timestamp
	(*status.Status)(nil),                                      // 16: google.rpc.Status
	(*EncryptionSpec)(nil),                                     // 17: google.cloud.aiplatform.v1beta1.EncryptionSpec
	(*Measurement)(nil),                                        // 18: google.cloud.aiplatform.v1beta1.Measurement
	(*CustomJobSpec)(nil),                                      // 19: google.cloud.aiplatform.v1beta1.CustomJobSpec
}
var file_google_cloud_aiplatform_v1beta1_nas_job_proto_depIdxs = []int32{
	5,  // 0: google.cloud.aiplatform.v1beta1.NasJob.nas_job_spec:type_name -> google.cloud.aiplatform.v1beta1.NasJobSpec
	6,  // 1: google.cloud.aiplatform.v1beta1.NasJob.nas_job_output:type_name -> google.cloud.aiplatform.v1beta1.NasJobOutput
	14, // 2: google.cloud.aiplatform.v1beta1.NasJob.state:type_name -> google.cloud.aiplatform.v1beta1.JobState
	15, // 3: google.cloud.aiplatform.v1beta1.NasJob.create_time:type_name -> google.protobuf.Timestamp
	15, // 4: google.cloud.aiplatform.v1beta1.NasJob.start_time:type_name -> google.protobuf.Timestamp
	15, // 5: google.cloud.aiplatform.v1beta1.NasJob.end_time:type_name -> google.protobuf.Timestamp
	15, // 6: google.cloud.aiplatform.v1beta1.NasJob.update_time:type_name -> google.protobuf.Timestamp
	16, // 7: google.cloud.aiplatform.v1beta1.NasJob.error:type_name -> google.rpc.Status
	8,  // 8: google.cloud.aiplatform.v1beta1.NasJob.labels:type_name -> google.cloud.aiplatform.v1beta1.NasJob.LabelsEntry
	17, // 9: google.cloud.aiplatform.v1beta1.NasJob.encryption_spec:type_name -> google.cloud.aiplatform.v1beta1.EncryptionSpec
	7,  // 10: google.cloud.aiplatform.v1beta1.NasTrialDetail.search_trial:type_name -> google.cloud.aiplatform.v1beta1.NasTrial
	7,  // 11: google.cloud.aiplatform.v1beta1.NasTrialDetail.train_trial:type_name -> google.cloud.aiplatform.v1beta1.NasTrial
	9,  // 12: google.cloud.aiplatform.v1beta1.NasJobSpec.multi_trial_algorithm_spec:type_name -> google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec
	13, // 13: google.cloud.aiplatform.v1beta1.NasJobOutput.multi_trial_job_output:type_name -> google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput
	2,  // 14: google.cloud.aiplatform.v1beta1.NasTrial.state:type_name -> google.cloud.aiplatform.v1beta1.NasTrial.State
	18, // 15: google.cloud.aiplatform.v1beta1.NasTrial.final_measurement:type_name -> google.cloud.aiplatform.v1beta1.Measurement
	15, // 16: google.cloud.aiplatform.v1beta1.NasTrial.start_time:type_name -> google.protobuf.Timestamp
	15, // 17: google.cloud.aiplatform.v1beta1.NasTrial.end_time:type_name -> google.protobuf.Timestamp
	0,  // 18: google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.multi_trial_algorithm:type_name -> google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MultiTrialAlgorithm
	10, // 19: google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.metric:type_name -> google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec
	11, // 20: google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.search_trial_spec:type_name -> google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec
	12, // 21: google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.train_trial_spec:type_name -> google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec
	1,  // 22: google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.goal:type_name -> google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.MetricSpec.GoalType
	19, // 23: google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.SearchTrialSpec.search_trial_job_spec:type_name -> google.cloud.aiplatform.v1beta1.CustomJobSpec
	19, // 24: google.cloud.aiplatform.v1beta1.NasJobSpec.MultiTrialAlgorithmSpec.TrainTrialSpec.train_trial_job_spec:type_name -> google.cloud.aiplatform.v1beta1.CustomJobSpec
	7,  // 25: google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput.search_trials:type_name -> google.cloud.aiplatform.v1beta1.NasTrial
	7,  // 26: google.cloud.aiplatform.v1beta1.NasJobOutput.MultiTrialJobOutput.train_trials:type_name -> google.cloud.aiplatform.v1beta1.NasTrial
	27, // [27:27] is the sub-list for method output_type
	27, // [27:27] is the sub-list for method input_type
	27, // [27:27] is the sub-list for extension type_name
	27, // [27:27] is the sub-list for extension extendee
	0,  // [0:27] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_nas_job_proto_init() }
func file_google_cloud_aiplatform_v1beta1_nas_job_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_nas_job_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_custom_job_proto_init()
	file_google_cloud_aiplatform_v1beta1_encryption_spec_proto_init()
	file_google_cloud_aiplatform_v1beta1_job_state_proto_init()
	file_google_cloud_aiplatform_v1beta1_study_proto_init()
	file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[2].OneofWrappers = []any{
		(*NasJobSpec_MultiTrialAlgorithmSpec_)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes[3].OneofWrappers = []any{
		(*NasJobOutput_MultiTrialJobOutput_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_nas_job_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_nas_job_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_nas_job_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_nas_job_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_nas_job_proto = out.File
	file_google_cloud_aiplatform_v1beta1_nas_job_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_nas_job_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_nas_job_proto_depIdxs = nil
}
