```toml
[advisory]
id = "RUSTSEC-2021-0115"
package = "zeroize_derive"
date = "2021-09-24"
url = "https://github.com/iqlusioninc/crates/issues/876"
aliases = ["CVE-2021-45706", "GHSA-c5hx-w945-j4pq"]

[versions]
patched = [">= 1.1.1"]
```

# `#[zeroize(drop)]` doesn't implement `Drop` for `enum`s

Affected versions of this crate did not implement `Drop` when `#[zeroize(drop)]` was used on an `enum`.

This can result in memory not being zeroed out after dropping it, which is exactly what is intended when adding this attribute.

The flaw was corrected in version 1.2 and `#[zeroize(drop)]` on `enum`s now properly implements `Drop`.
