```toml
[advisory]
id = "RUSTSEC-2021-0029"
package = "truetype"
aliases = ["CVE-2021-28030", "GHSA-v7q4-97x4-4qw2"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:N/A:N"
date = "2021-02-17"
url = "https://github.com/bodoni/truetype/issues/11"
categories = ["memory-exposure"]

[versions]
patched = [">= 0.30.1"]
```

# Tape::take_bytes exposes uninitialized memory to a user-provided Read

Affected versions of this crate passed an unininitialized buffer to a
user-provided `Read` instance in `Tape::take_bytes`.

This can result in safe `Read` implementations reading from the uninitialized
buffer leading to undefined behavior.

The flaw was corrected in commit `1f2dc7f37dd` by removing the unsafe block
and zero-initializing the buffer.
