```toml
[advisory]
id = "RUSTSEC-2024-0008"
package = "trillium-client"
date = "2024-01-23"
url = "https://github.com/trillium-rs/trillium/security/advisories/GHSA-9f9p-cp3c-72jf"
keywords = ["http", "request", "splitting"]
aliases = ["GHSA-9f9p-cp3c-72jf", "CVE-2024-23644"]

[versions]
patched = [">= 0.5.4"]
unaffected = []

[affected]
```

# Improper Neutralization of CRLF Sequences in HTTP Headers ('HTTP Request/Response Splitting')

### Summary
Insufficient validation of outbound header values may lead to request splitting or response splitting attacks in scenarios where attackers have sufficient control over outbound headers.

### Details
Outbound `trillium_http::HeaderValue` and `trillium_http::HeaderName` can be constructed infallibly and were not checked for illegal bytes when sending requests. Thus, if an attacker has sufficient control over header values (or names) in a request that they could inject `\r\n` sequences, they could get the client and server out of sync, and then pivot to gain control over other parts of requests or responses. (i.e. exfiltrating data from other requests, SSRF, etc.)

### Patches

#### trillium-client >= 0.5.4:
* If any header name or header value is invalid in the client request headers, awaiting the client Conn returns an `Error::MalformedHeader` prior to any network access.

### Workarounds

trillium client applications should sanitize or validate untrusted input that is included in header values and header names. Carriage return, newline, and null characters are not allowed.

### Impact

This only affects use cases where attackers have control of outbound headers, and can insert "\r\n" sequences. Specifically, if untrusted and unvalidated input is inserted into header names or values.

### Credit

Discovered and reported by [@divergentdave](https://github.com/divergentdave)
