```toml
[advisory]
id = "RUSTSEC-2022-0043"
package = "tower-http"
date = "2022-01-21"
url = "https://github.com/tower-rs/tower-http/pull/204"
categories = ["file-disclosure"]
keywords = ["directory traversal", "http"]
aliases = ["GHSA-qrqq-9c63-xfrg"]

[affected]
os = ["windows"]

[versions]
patched = [">= 0.2.1", ">= 0.1.3, < 0.2.0"]
```

# Improper validation of Windows paths could lead to directory traversal attack

`tower_http::services::fs::ServeDir` didn't correctly validate Windows paths
meaning paths like `/foo/bar/c:/windows/web/screen/img101.png` would be allowed
and respond with the contents of `c:/windows/web/screen/img101.png`. Thus users
could potentially read files anywhere on the filesystem.

This only impacts Windows. Linux and other unix likes are not impacted by this.

See [tower-http#204] for more details.

[tower-http#204]: https://github.com/tower-rs/tower-http/pull/204
