```toml
[advisory]
id = "RUSTSEC-2021-0135"
package = "tower-http"
date = "2021-01-21"
url = "https://github.com/tower-rs/tower-http/pull/204"
categories = ["file-disclosure"]
keywords = ["directory traversal", "http"]
withdrawn = "2022-08-14" # fixing date to 2022-01-21 see rustsec/advisory-db#1165
aliases = ["GHSA-wwh2-r387-g5rm"]

[affected]
os = ["windows"]

[versions]
patched = [">= 0.2.1", ">= 0.1.3, < 0.2.0"]
```

# Improper validation of Windows paths could lead to directory traversal attack

`tower_http::services::fs::ServeDir` didn't correctly validate Windows paths
meaning paths like `/foo/bar/c:/windows/web/screen/img101.png` would be allowed
and respond with the contents of `c:/windows/web/screen/img101.png`. Thus users
could potentially read files anywhere on the filesystem.

This only impacts Windows. Linux and other unix likes are not impacted by this.

See [tower-http#204] for more details.

[tower-http#204]: https://github.com/tower-rs/tower-http/pull/204
