```toml
[advisory]
id = "RUSTSEC-2018-0022"
package = "temporary"
date = "2018-08-22"
url = "https://github.com/stainless-steel/temporary/issues/2"
categories = ["memory-exposure"]
keywords = ["uninitialized-memory"]
aliases = ["GHSA-2jq9-6xx7-3h29"]

[versions]
patched = [">= 0.6.4"]
unaffected = ["< 0.3.0"]
```

# Use of uninitialized memory in temporary

Uninit memory is used as a RNG seed in temporary

The following function is used as a way to get entropy from the system, which does operations on and exposes uninit memory, which is UB.

```rust
fn random_seed(_: &Path, _: &str) -> [u64; 2] {
    use std::mem::uninitialized as rand;
    unsafe { [rand::<u64>() ^ 0x12345678, rand::<u64>() ^ 0x87654321] }
}
```

This has been resolved in the 0.6.4 release.

The crate is not intended to be used outside of a testing environment.

For a general purpose crate to create temporary directories, [`tempfile`](https://crates.io/crates/tempfile) is an alternative for this crate.
