```toml
[advisory]
id = "RUSTSEC-2023-0021"
package = "stb_image"
date = "2023-03-19"
url = "https://github.com/servo/rust-stb-image/pull/102"
categories = ["memory-corruption"]
keywords = ["NULL-pointer-dereference"]
aliases = ["GHSA-ppjr-267j-5p9x"]

[versions]
patched = [">= 0.2.5"]
```

# NULL pointer dereference in `stb_image`

A bug in error handling in the `stb_image` C library could cause a NULL pointer dereference when attempting to load an invalid or unsupported image file.  This is fixed in version 0.2.5 and later of the `stb_image` Rust crate, by patching the C code to correctly handle NULL pointers.

Thank you to GitHub user 0xdd96 for finding and fixing this vulnerability.
