```toml
[advisory]
id = "RUSTSEC-2024-0426"
package = "spl-token-swap"
date = "2024-12-19"
url = "https://github.com/solana-labs/solana-program-library/issues/5243"
references = []
categories = []
keywords = ["align"]
informational = "unsound"

[versions]
patched = []

[affected]
functions = {"spl_token_swap::instruction::unpack" = ["<= 3.0.0"]}
```

# Unsound usages of `u8` type casting 
The library provides a safe public API `unpack` to cast `u8` array to arbitrary types, which can cause to undefined behaviors. The length check of array can only prevent out-of-bound access on the return type. However, it can't prevent misaligned pointer when casting `u8` pointer to a type aligned to larger bytes. For example, if we assign `u16` to `T`, **misaligned raw pointer dereference** could happen and cause to panic. Even if we pass the type aligned to same byte as `u8` (e.g., `bool`), it could construct a illegal type since `bool` can only have 0 or 1 as bit patterns, which is also an undefined behavior. The further exploits of the bug here are still not clear, so we would report this issue as unsound.  

The details of PoC to reproduce undefined behavior are provided in the [issue](https://github.com/solana-labs/solana-program-library/issues/5243).  
