```toml
[advisory]
id = "RUSTSEC-2018-0003"
package = "smallvec"
aliases = ["CVE-2018-20991", "GHSA-rxr4-x558-x7hw"]
cvss = "CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2018-07-19"
keywords = ["memory-corruption"]
url = "https://github.com/servo/rust-smallvec/issues/96"

[versions]
patched = [">= 0.6.3", "^0.3.4", "^0.4.5", "^0.5.1"]
unaffected = ["< 0.3.2"]
```

# Possible double free during unwinding in SmallVec::insert_many

If an iterator passed to `SmallVec::insert_many` panicked in `Iterator::next`,
destructors were run during unwinding while the vector was in an inconsistent
state, possibly causing a double free (a destructor running on two copies of
the same value).

This is fixed in smallvec 0.6.3 by ensuring that the vector's length is not
updated to include moved items until they have been removed from their
original positions.  Items may now be leaked if `Iterator::next` panics, but
they will not be dropped more than once.

Thank you to @Vurich for reporting this bug.
