```toml
[advisory]
id = "RUSTSEC-2019-0002"
package = "slice-deque"
date = "2019-05-07"
aliases = ["CVE-2019-15543", "GHSA-c3m3-c39q-pv23"]
cvss = "CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
related = ["RUSTSEC-2018-0008"]
keywords = ["memory-corruption", "rce"]

url = "https://github.com/gnzlbg/slice_deque/issues/57"

[versions]
patched = [">= 0.2.0"]
```

# Bug in SliceDeque::move_head_unchecked corrupts its memory

Affected versions of this crate entered a corrupted state if
`mem::size_of::<T>() % allocation_granularity() != 0` and a specific allocation
pattern was used: sufficiently shifting the deque elements over the mirrored
page boundary.

This allows an attacker that controls controls both element insertion and
removal to corrupt the deque, such that reading elements from it would read
bytes corresponding to other elements in the deque. (e.g. a read of T could read
some bytes from one value and some bytes from an adjacent one, resulting in a T
whose value representation is not meaningful). This is undefined behavior.
 
The flaw was corrected by using a pair of pointers to track the head and tail of
the deque instead of a pair of indices. This pair of pointers are represented
using a Rust slice.
