```toml
[advisory]
id = "RUSTSEC-2021-0125"
package = "simple_asn1"
date = "2021-11-14"
url = "https://github.com/acw/simple_asn1/issues/27"
categories = ["denial-of-service"]
keywords = ["panic", "string_slice"]
aliases = ["CVE-2021-45711", "GHSA-3m6f-3gfg-4x56", "GHSA-g4h2-4wvh-grc5"]
#aliases = ["CVE-YYYY-NNNN"]
#cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:H/I:H/A:H"

[versions]
patched = [">=0.6.1"]
unaffected = ["<0.6.0"]
```

# Panic on incorrect date input to `simple_asn1`

Version 0.6.0 of the `simple_asn1` crate panics on certain malformed
inputs to its parsing functions, including `from_der` and `der_decode`.
Because this crate is frequently used with inputs from the network, this
should be considered a security vulnerability.

The issue occurs when parsing the old ASN.1 "UTCTime" time format.  If an
attacker provides a UTCTime where the first character is ASCII but the
second character is above 0x7f, a string slice operation in the
`from_der_` function will try to slice into the middle of a UTF-8
character, and cause a panic.

This error was introduced in commit
[`d7d39d709577710e9dc8`](https://github.com/acw/simple_asn1/commit/d7d39d709577710e9dc8833ee57d200eef366db8),
which updated `simple_asn1` to use `time` instead of `chrono` because of
[`RUSTSEC-2020-159`](https://rustsec.org/advisories/RUSTSEC-2020-0159).
Versions of `simple_asn1` before 0.6.0 are not affected by this issue.

The [patch](https://github.com/acw/simple_asn1/pull/28) was applied in
`simple_asn1` version 0.6.1.
