```toml
[advisory]
id = "RUSTSEC-2021-0030"
package = "scratchpad"
aliases = ["CVE-2021-28031", "GHSA-3qm2-rfqw-fmrw"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2021-02-18"
url = "https://github.com/okready/scratchpad/issues/1"
categories = ["memory-corruption"]
keywords = ["memory-safety", "double-free"]

[versions]
patched = [">= 1.3.1"]

[affected]
functions = { "scratchpad::SliceMoveSource::move_elements" = ["< 1.3.1"] }
```

# move_elements can double-free objects on panic

Affected versions of `scratchpad` used `ptr::read` to read elements while
calling a user provided function `f` on them.

Since the pointer read duplicates ownership, a panic inside the user provided
`f` function could cause a double free when unwinding.

The flaw was fixed in commit `891561bea` by removing the unsafe block and using
a plain iterator.
