```toml
[advisory]
id = "RUSTSEC-2019-0024"
package = "rustsec-example-crate"
date = "2019-10-08"
url = "https://github.com/RustSec/advisory-db/issues/158"

[versions]
patched = [">= 1.0.0"]
unaffected = ["< 0.0.1"]
```

# Test advisory with associated example crate

This is a test advisory useful for verifying RustSec tooling and vulnerability
detection pipelines are working correctly. Aside from the fact that it is filed
against an example crate, it is otherwise considered by the Advisory Database
itself to be a normal security advisory.

It's filed against `rustsec-example-crate`, an otherwise completely empty crate
with no functionality or code, which has three releases:

- [v0.0.0] - *unaffected* by this advisory (but *yanked* from crates.io)
- [v0.0.1] - *vulnerable* according to this advisory
- [v1.0.0] - *patched* by this advisory

[v0.0.0]: https://crates.io/crates/rustsec-example-crate/0.0.0
[v0.0.1]: https://crates.io/crates/rustsec-example-crate/0.0.1
[v1.0.0]: https://crates.io/crates/rustsec-example-crate/1.0.0
