```toml
[advisory]
id = "RUSTSEC-2020-0023"
package = "rulinalg"
aliases = ["CVE-2020-35879", "GHSA-q2gj-9r85-p832"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2020-02-11"
url = "https://github.com/AtheMathmo/rulinalg/issues/201"

[affected.functions]
"rulinalg::matrix::RowMut::raw_slice" = [">= 0.4.0"]
"rulinalg::matrix::RowMut::raw_slice_mut" = [">= 0.4.0"]

[versions]
patched = []
unaffected = ["< 0.4.0"]
```

# Lifetime boundary for `raw_slice` and `raw_slice_mut` are incorrect

The affected version of `rulinalg` has incorrect lifetime boundary definitions
for `RowMut::raw_slice` and `RowMut::raw_slice_mut`. They do not conform with
Rust's borrowing rule and allows the user to create multiple mutable references
to the same location. This may result in unexpected calculation result and data
race if both references are used at the same time.
