```toml
[advisory]
id = "RUSTSEC-2024-0432"
package = "rage"
date = "2024-12-18"
url = "https://github.com/str4d/rage/security/advisories/GHSA-4fg7-vxc8-qx5w"
categories = ["code-execution"]
aliases = ["GHSA-4fg7-vxc8-qx5w"]
related = ["GHSA-32gq-x56h-299c"]

[versions]
patched = [
    ">= 0.6.1, < 0.7.0",
    ">= 0.7.2, < 0.8.0",
    ">= 0.8.2, < 0.9.0",
    ">= 0.9.3, < 0.10.0",
    ">= 0.10.1, < 0.11.0",
    ">= 0.11.1",
]
unaffected = ["< 0.6.0"]
```

# Malicious plugin names, recipients, or identities can cause arbitrary binary execution

A plugin name containing a path separator may allow an attacker to execute an arbitrary
binary.

Such a plugin name can be provided to the `rage` CLI through an attacker-controlled
recipient or identity string, or an attacker-controlled plugin name via the `-j` flag.

On UNIX systems, a directory matching `age-plugin-*` needs to exist in the working
directory for the attack to succeed.

The binary is executed with a single flag, either `--age-plugin=recipient-v1` or
`--age-plugin=identity-v1`. The standard input includes the recipient or identity string,
and the random file key (if encrypting) or the header of the file (if decrypting). The
format is constrained by the [age-plugin](https://c2sp.org/age-plugin) protocol.

An equivalent issue was fixed in [the reference Go implementation of age](https://github.com/FiloSottile/age),
see advisory [GHSA-32gq-x56h-299c](https://github.com/FiloSottile/age/security/advisories/GHSA-32gq-x56h-299c).

Thanks to ⬡-49016 for reporting this issue.
