```toml
[advisory]
id = "RUSTSEC-2024-0408"
package = "pprof"
date = "2024-12-04"
url = "https://github.com/tikv/pprof-rs/issues/232"
references = ["https://github.com/tikv/pprof-rs/pull/255"]
categories = []
keywords = ["align", "uninitialized"]
informational = "unsound"

[versions]
patched = [">= 0.14.0"]

[affected]
functions = {"pprof::report::ReportBuilder::build" = ["< 0.14.0"], "pprof::validate" = ["< 0.14.0"]}
```

# Unsound usages of `std::slice::from_raw_parts` 

The library breaks the safety assumptions when using unsafe API `std::slice::from_raw_parts`. First, when using the API in iterator implementation (`TempFdArrayIterator.next`), generic type could be any type, which would create and pass a misaligned pointer to the unsafe API. Second, when validating the address, the code passed the type `c_void`, which could also be any type, leading to potential uninitialized memory exposure.  

Two unsound usages here highlight the necessity for developers to perform type checks before doing type conversion with unsafe API.  

The panic caused by the misalignment causes several downstream applications (e.g., `greptimedb`) to crash when using `pprof::report::ReportBuilder::build`.  

This was patched in 0.14.0.  

The developer also suggested moving to [pprof2](https://crates.io/crates/pprof2).  
