```toml
[advisory]
id = "RUSTSEC-2020-0082"
package = "ordered-float"
aliases = ["CVE-2020-35923", "GHSA-566x-hhrf-qf8m"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H"
date = "2020-12-06"
url = "https://github.com/reem/rust-ordered-float/pull/71"
categories = []
keywords = ["unwind"]

[versions]
patched = ["^1.1.1", ">= 2.0.1"]
unaffected = ["< 0.2.2"]

[affected]
```

# ordered_float:NotNan may contain NaN after panic in assignment operators

After using an assignment operators such as `NotNan::add_assign`, `NotNan::mul_assign`, etc., it was possible for the resulting `NotNan` value to contain a `NaN`.  This could cause undefined behavior in safe code, because the safe `NotNan::cmp` method contains internal unsafe code that assumes the value is never `NaN`.  (It could also cause undefined behavior in third-party unsafe code that makes the same assumption, as well as logic errors in safe code.)

This was mitigated starting in version 0.4.0, by panicking if the assigned value is NaN.  However, in affected versions from 0.4.0 onward, code that uses the `NotNan` value during unwinding, or that continues after catching the panic, could still observe the invalid value and trigger undefined behavior.

The flaw is fully corrected in versions 1.1.1 and 2.0.1, by ensuring that the assignment operators panic without modifying the operand, if the result would be `NaN`.
