```toml
[advisory]
id = "RUSTSEC-2022-0045"
package = "oqs"
date = "2022-07-30"
categories = ["crypto-failure"]
aliases = ["GHSA-hrjv-pf36-jpmr"]

# affected enum variants
# ([affected.functions] needs them to be functions)
# "oqs::kem::Algorithm::SidhP434" = ["*"]
# "oqs::kem::Algorithm::SidhP503" = ["*"]
# "oqs::kem::Algorithm::SidhP610" = ["*"]
# "oqs::kem::Algorithm::SidhP751" = ["*"]
# "oqs::kem::Algorithm::SidhP434Compressed" = ["*"]
# "oqs::kem::Algorithm::SidhP503Compressed" = ["*"]
# "oqs::kem::Algorithm::SidhP610Compressed" = ["*"]
# "oqs::kem::Algorithm::SidhP751Compressed" = ["*"]
# "oqs::kem::Algorithm::SikeP434" = ["*"]
# "oqs::kem::Algorithm::SikeP503" = ["*"]
# "oqs::kem::Algorithm::SikeP610" = ["*"]
# "oqs::kem::Algorithm::SikeP751" = ["*"]
# "oqs::kem::Algorithm::SikeP434Compressed" = ["*"]
# "oqs::kem::Algorithm::SikeP503Compressed" = ["*"]
# "oqs::kem::Algorithm::SikeP610Compressed" = ["*"]
# "oqs::kem::Algorithm::SikeP751Compressed" = ["*"]


[versions]
patched = [">= 0.7.2"]
```

# Post-Quantum Key Encapsulation Mechanism SIKE broken

Wouter Castryck and Thomas Decru presented an efficient key recovery attack on the SIDH protocol.
As a result, the secret key of SIKEp751 can be recovered in a matter of hours.
The SIKE and SIDH schemes will be removed from oqs 0.7.2.

The affected schemes are the `oqs::kem::Algorithm::Sike*` and `oqs::kem::Algorithm::Sidh*` enum variants.

[An efficient key recovery attack on SIDH (preliminary version)](https://eprint.iacr.org/2022/975)
