```toml
[advisory]
id = "RUSTSEC-2023-0008"
package = "openssl-src"
aliases = ["CVE-2022-4203", "GHSA-w67w-mw4j-8qrv"]
categories = ["denial-of-service", "memory-exposure"]
date = "2023-02-07"
url = "https://www.openssl.org/news/secadv/20230207.txt"
[versions]
patched = [">= 300.0.12"]
unaffected = ["< 300.0.0"]
```

# X.509 Name Constraints Read Buffer Overflow

A read buffer overrun can be triggered in X.509 certificate verification,
specifically in name constraint checking. Note that this occurs
after certificate chain signature verification and requires either a
CA to have signed the malicious certificate or for the application to
continue certificate verification despite failure to construct a path
to a trusted issuer.

The read buffer overrun might result in a crash which could lead to
a denial of service attack. In theory it could also result in the disclosure
of private memory contents (such as private keys, or sensitive plaintext)
although we are not aware of any working exploit leading to memory
contents disclosure as of the time of release of this advisory.

In a TLS client, this can be triggered by connecting to a malicious
server. In a TLS server, this can be triggered if the server requests
client authentication and a malicious client connects.
