```toml
[advisory]
id = "RUSTSEC-2023-0007"
package = "openssl-src"
aliases = ["CVE-2022-4304", "GHSA-p52g-cm5j-mjv4"]
categories = ["crypto-failure"]
date = "2023-02-07"
url = "https://www.openssl.org/news/secadv/20230207.txt"
[versions]
patched = [">= 111.25, < 300.0", ">= 300.0.12"]
```

# Timing Oracle in RSA Decryption

A timing based side channel exists in the OpenSSL RSA Decryption implementation
which could be sufficient to recover a plaintext across a network in a
Bleichenbacher style attack. To achieve a successful decryption an attacker
would have to be able to send a very large number of trial messages for
decryption. The vulnerability affects all RSA padding modes: PKCS#1 v1.5,
RSA-OEAP and RSASVE.

For example, in a TLS connection, RSA is commonly used by a client to send an
encrypted pre-master secret to the server. An attacker that had observed a
genuine connection between a client and a server could use this flaw to send
trial messages to the server and record the time taken to process them. After a
sufficiently large number of messages the attacker could recover the pre-master
secret used for the original connection and thus be able to decrypt the
application data sent over that connection.
