```toml
[advisory]
id = "RUSTSEC-2021-0055"
package = "openssl-src"
aliases = ["CVE-2021-3449", "GHSA-83mx-573x-5rw9"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:H"
categories = ["denial-of-service"]
date = "2021-05-01"
url = "https://www.openssl.org/news/secadv/20210325.txt"

[versions]
patched = [">= 111.15"]
```

# NULL pointer deref in signature_algorithms processing

An OpenSSL TLS server may crash if sent a maliciously crafted renegotiation
ClientHello message from a client. If a TLSv1.2 renegotiation ClientHello omits
the signature_algorithms extension (where it was present in the initial
ClientHello), but includes a signature_algorithms_cert extension then a NULL
pointer dereference will result, leading to a crash and a denial of service
attack.

A server is only vulnerable if it has TLSv1.2 and renegotiation enabled (which
is the default configuration). OpenSSL TLS clients are not impacted by this
issue.
